/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.util;

import bdv.util.Affine3DHelpers;
import bdv.viewer.Source;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import java.awt.Dimension;
import java.util.HashMap;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class BigWarpUtils {
    public static void initTransform(ViewerPanel viewer) {
        Dimension dim = viewer.getDisplay().getSize();
        SynchronizedViewerState state = viewer.state();
        AffineTransform3D viewerTransform = BigWarpUtils.initTransform(dim.width, dim.height, false, (ViewerState)state);
        viewer.setCurrentViewerTransform(viewerTransform);
    }

    public static void ensurePositiveZ(AffineTransform3D xfm) {
        xfm.set(Math.abs(xfm.get(2, 2)), 2, 2);
    }

    public static void ensurePositiveDeterminant(AffineTransform3D xfm) {
        if (BigWarpUtils.det(xfm) < 0.0) {
            BigWarpUtils.flipX(xfm);
        }
    }

    public static double det(AffineTransform3D xfm) {
        return LinAlgHelpers.det3x3((double)xfm.get(0, 0), (double)xfm.get(0, 1), (double)xfm.get(0, 2), (double)xfm.get(1, 0), (double)xfm.get(1, 1), (double)xfm.get(1, 2), (double)xfm.get(2, 0), (double)xfm.get(2, 1), (double)xfm.get(2, 2));
    }

    public static double dotXy(AffineTransform3D xfm) {
        return xfm.get(0, 0) * xfm.get(0, 1) + xfm.get(1, 0) * xfm.get(1, 1) + xfm.get(2, 0) * xfm.get(2, 1);
    }

    public static void flipX(AffineTransform3D xfm) {
        for (int i = 0; i < 4; ++i) {
            xfm.set(-xfm.get(0, i), 0, i);
        }
    }

    public static void permuteXY(AffineTransform3D xfm) {
        double tmp = 0.0;
        for (int i = 0; i < 4; ++i) {
            tmp = xfm.get(1, i);
            xfm.set(xfm.get(0, i), 1, i);
            xfm.set(tmp, 0, i);
        }
    }

    public static AffineTransform3D initTransform(int viewerWidth, int viewerHeight, boolean zoomedIn, ViewerState state) {
        int timepoint;
        int cX = viewerWidth / 2;
        int cY = viewerHeight / 2;
        Source source = state.getCurrentSource().getSpimSource();
        if (!source.isPresent(timepoint = state.getCurrentTimepoint())) {
            return new AffineTransform3D();
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(timepoint, 0, sourceTransform);
        RandomAccessibleInterval sourceInterval = source.getSource(timepoint, 0);
        double sX0 = sourceInterval.min(0);
        double sX1 = sourceInterval.max(0);
        double sY0 = sourceInterval.min(1);
        double sY1 = sourceInterval.max(1);
        double sX = (sX0 + sX1 + 1.0) / 2.0;
        double sY = (sY0 + sY1 + 1.0) / 2.0;
        double[][] m = new double[3][4];
        double[] qSource = new double[4];
        double[] qViewer = new double[4];
        Affine3DHelpers.extractApproximateRotationAffine((AffineTransform3D)sourceTransform, (double[])qSource, (int)2);
        LinAlgHelpers.quaternionInvert((double[])qSource, (double[])qViewer);
        LinAlgHelpers.quaternionToR((double[])qViewer, (double[][])m);
        double[] centerSource = new double[]{sX, sY, 0.0};
        double[] centerGlobal = new double[3];
        double[] translation = new double[3];
        sourceTransform.apply(centerSource, centerGlobal);
        LinAlgHelpers.quaternionApply((double[])qViewer, (double[])centerGlobal, (double[])translation);
        LinAlgHelpers.scale((double[])translation, (double)-1.0, (double[])translation);
        LinAlgHelpers.setCol((int)3, (double[])translation, (double[][])m);
        AffineTransform3D viewerTransform = new AffineTransform3D();
        viewerTransform.set(m);
        double[] pSource = new double[]{sX1 + 0.5, sY1 + 0.5, 0.0};
        double[] pGlobal = new double[3];
        double[] pScreen = new double[3];
        sourceTransform.apply(pSource, pGlobal);
        viewerTransform.apply(pGlobal, pScreen);
        double scaleX = (double)cX / pScreen[0];
        double scaleY = (double)cY / pScreen[1];
        double scale = zoomedIn ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
        viewerTransform.scale(scale);
        viewerTransform.set(viewerTransform.get(0, 3) + (double)cX, 0, 3);
        viewerTransform.set(viewerTransform.get(1, 3) + (double)cY, 1, 3);
        return viewerTransform;
    }

    public static double quaternionAngle(double[] q1, double[] q2) {
        double dot = 0.0;
        for (int i = 0; i < 4; ++i) {
            dot += q1[i] * q2[i];
        }
        return Math.acos(2.0 * dot * dot - 1.0);
    }

    public static void normalize(double[] x) {
        int i;
        double magSqr = 0.0;
        for (i = 0; i < x.length; ++i) {
            magSqr += x[i] * x[i];
        }
        i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] / magSqr;
        }
    }

    public static HashMap<String, String> parseMacroArguments(String input) {
        return BigWarpUtils.parseMacroArguments(input, "=", "[", "]");
    }

    public static HashMap<String, String> parseMacroArguments(String input, String keyDelim, String startDelim, String endDelim) {
        HashMap<String, String> output = new HashMap<String, String>();
        String arguments = input.trim();
        boolean done = false;
        while (!done) {
            int i = arguments.indexOf(keyDelim);
            String key = arguments.substring(0, i);
            output.put(key, BigWarpUtils.parse(arguments, startDelim, endDelim));
            i = arguments.indexOf(endDelim);
            if (i < 0 || i + 1 > arguments.length()) {
                done = true;
            }
            if ((arguments = arguments.substring(i + 1).trim()).length() == 0) {
                done = true;
                continue;
            }
            arguments = arguments.substring(1).trim();
        }
        return output;
    }

    public static String parse(String arg, String start, String end) {
        int startIdx = arg.indexOf(start) + 1;
        int endIdx = arg.indexOf(end);
        if (startIdx < 0 || endIdx < 0) {
            return null;
        }
        return arg.substring(startIdx, endIdx);
    }

    public static AffineGet toAffine3D(AffineGet affine) {
        int i;
        if (affine.numSourceDimensions() == 3) {
            return affine;
        }
        AffineTransform3D out = new AffineTransform3D();
        int N = affine.numSourceDimensions();
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                out.set(affine.get(i, j), i, j);
            }
        }
        for (i = 0; i < N; ++i) {
            out.set(affine.get(i, N + 1), i, 3);
        }
        return out;
    }
}

