/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.BSplineModel;
import bunwarpj.Mask;
import bunwarpj.MiscTools;
import bunwarpj.PointAction;
import bunwarpj.PointHandler;
import bunwarpj.PointToolbar;
import bunwarpj.ProgressBar;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;

public class MainDialog
extends GenericDialog {
    public static int FAST_MODE = 0;
    public static int ACCURATE_MODE = 1;
    public static int MONO_MODE = 2;
    public static String[] sMinScaleDeformationChoices = new String[]{"Very Coarse", "Coarse", "Fine", "Very Fine"};
    public static String[] sMaxScaleDeformationChoices = new String[]{"Very Coarse", "Coarse", "Fine", "Very Fine", "Super Fine"};
    private static final long serialVersionUID = 8828022405402308341L;
    private ImagePlus[] imageList = null;
    private ImageCanvas sourceIc = null;
    private ImageCanvas targetIc = null;
    private ImagePlus sourceImp = null;
    private ImagePlus targetImp = null;
    private ImageProcessor originalSourceIP = null;
    private ImageProcessor originalTargetIP = null;
    private BSplineModel source = null;
    private BSplineModel target = null;
    private Mask sourceMsk = null;
    private Mask targetMsk = null;
    private double[][] sourceAffineMatrix = null;
    private double[][] targetAffineMatrix = null;
    private PointHandler sourcePh = null;
    private PointHandler targetPh = null;
    private boolean clearMask = false;
    private PointToolbar tb = new PointToolbar(Toolbar.getInstance(), this);
    private boolean finalActionLaunched = false;
    private boolean stopRegistration = false;
    private int sourceChoiceIndex = 0;
    private int targetChoiceIndex = 1;
    private int min_scale_deformation = 0;
    private int max_scale_deformation = 2;
    private int mode = ACCURATE_MODE;
    private int maxImageSubsamplingFactor = 0;
    private double divWeight = 0.0;
    private double curlWeight = 0.0;
    private double landmarkWeight = 0.0;
    private double imageWeight = 1.0;
    private double consistencyWeight = 10.0;
    private boolean richOutput = false;
    private boolean saveTransformation = false;
    private int min_scale_image = 0;
    private int imagePyramidDepth = 3;
    private double stopThreshold = 0.01;
    private boolean bIsReverse = true;
    private boolean bMacro = false;
    String macroArgs = null;
    private Roi previousSourceRoi;
    private Roi previousTargetRoi;
    private Choice sourceChoice = null;
    private Choice targetChoice = null;
    private Choice minScaleChoice = null;
    private Choice maxScaleChoice = null;
    private Choice modeChoice = null;
    private TextField resamplingTextField = null;
    private Scrollbar resamplingSlider = null;
    private TextField consistencyWeightTextField = null;

    public MainDialog(Frame parentWindow, ImagePlus[] imageList, int mode, int maxImageSubsamplingFactor, int min_scale_deformation, int max_scale_deformation, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, boolean richOutput, boolean saveTransformation) {
        super("bUnwarpJ", null);
        this.setModal(false);
        this.imageList = imageList;
        this.mode = mode;
        this.maxImageSubsamplingFactor = maxImageSubsamplingFactor;
        this.min_scale_deformation = min_scale_deformation;
        this.max_scale_deformation = max_scale_deformation;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.richOutput = richOutput;
        this.saveTransformation = saveTransformation;
        String[] titles = new String[imageList.length];
        for (int i = 0; i < titles.length; ++i) {
            titles[i] = imageList[i].getTitle();
        }
        this.addChoice("Source_Image", titles, titles[this.sourceChoiceIndex]);
        this.sourceChoice = (Choice)super.getChoices().lastElement();
        this.addChoice("Target_Image", titles, titles[this.targetChoiceIndex]);
        this.targetChoice = (Choice)super.getChoices().lastElement();
        String[] sRegistrationModes = new String[]{"Fast", "Accurate", "Mono"};
        this.addChoice("Registration Mode", sRegistrationModes, sRegistrationModes[this.mode]);
        this.modeChoice = (Choice)super.getChoices().lastElement();
        this.addSlider("Image_Subsample_Factor", 0.0, 7.0, this.maxImageSubsamplingFactor);
        this.resamplingSlider = (Scrollbar)super.getSliders().lastElement();
        this.resamplingSlider.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                MainDialog.this.maxImageSubsamplingFactor = Integer.parseInt(MainDialog.this.resamplingTextField.getText());
                MainDialog.this.source.setSubsamplingFactor((int)Math.pow(2.0, MainDialog.this.maxImageSubsamplingFactor));
                MainDialog.this.target.setSubsamplingFactor((int)Math.pow(2.0, MainDialog.this.maxImageSubsamplingFactor));
            }
        });
        this.resamplingTextField = (TextField)super.getNumericFields().lastElement();
        this.resamplingTextField.setEnabled(false);
        this.addMessage("------ Advanced Options ------");
        this.addChoice("Initial_Deformation :", sMinScaleDeformationChoices, sMinScaleDeformationChoices[this.min_scale_deformation]);
        this.minScaleChoice = (Choice)super.getChoices().lastElement();
        this.addChoice("Final_Deformation :", sMaxScaleDeformationChoices, sMaxScaleDeformationChoices[this.max_scale_deformation]);
        this.maxScaleChoice = (Choice)super.getChoices().lastElement();
        this.addNumericField("Divergence_Weight :", this.divWeight, 1);
        this.addNumericField("Curl_Weight :", this.curlWeight, 1);
        this.addNumericField("Landmark_Weight :", this.landmarkWeight, 1);
        this.addNumericField("Image_Weight :", this.imageWeight, 1);
        this.addNumericField("Consistency_Weight :", this.consistencyWeight, 1);
        this.consistencyWeightTextField = (TextField)super.getNumericFields().lastElement();
        if (this.mode == MONO_MODE) {
            this.bIsReverse = false;
            this.consistencyWeightTextField.setEnabled(false);
        }
        this.addNumericField("Stop_Threshold :", this.stopThreshold, 2);
        this.addCheckbox(" Verbose ", this.richOutput);
        this.addCheckbox(" Save_Transformations ", this.saveTransformation);
        boolean bl = this.bMacro = Macro.getOptions() != null;
        if (this.bMacro) {
            this.macroArgs = Macro.getOptions();
        }
        this.createSourceImage(this.bIsReverse);
        this.createTargetImage();
        this.loadPointRoiAsLandmarks();
        this.setSecondaryPointHandlers();
    }

    public void setSourceMask(String sFileName) {
        this.sourceMsk.readFile(sFileName);
    }

    public void setSourceAffineMatrix(double[][] affineMatrix) {
        this.sourceAffineMatrix = affineMatrix;
    }

    public Mask getSourceMask() {
        return this.sourceMsk;
    }

    public Mask getTargetMask() {
        return this.targetMsk;
    }

    public synchronized void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (this.wasOKed() || this.wasCanceled()) {
            ((Object)((Object)this)).notify();
        }
    }

    public synchronized void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        ((Object)((Object)this)).notify();
    }

    public synchronized void showDialog() {
        super.showDialog();
        if (Macro.getOptions() != null) {
            return;
        }
        try {
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Dialog " + this.getTitle() + " was interrupted."));
        }
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        Object o = e.getSource();
        if (!(o instanceof Choice)) {
            return;
        }
        Choice originChoice = (Choice)o;
        if (originChoice == this.sourceChoice) {
            int newChoiceIndex = originChoice.getSelectedIndex();
            if (this.sourceChoiceIndex != newChoiceIndex) {
                if (this.targetChoiceIndex != newChoiceIndex) {
                    this.sourceChoiceIndex = newChoiceIndex;
                    this.ungrayImage(this.sourcePh.getPointAction());
                    this.cancelSource();
                    this.createSourceImage(this.bIsReverse);
                    this.ungrayImage(this.targetPh.getPointAction());
                    this.targetPh.removePoints();
                    this.targetImp.setRoi(this.previousTargetRoi);
                    this.loadPointRoiAsLandmarks();
                    this.setSecondaryPointHandlers();
                } else {
                    this.targetChoiceIndex = this.sourceChoiceIndex;
                    this.sourceChoiceIndex = newChoiceIndex;
                    this.targetChoice.select(this.targetChoiceIndex);
                    this.permuteImages(this.bIsReverse);
                }
            }
        } else if (originChoice == this.targetChoice) {
            int newChoiceIndex = originChoice.getSelectedIndex();
            if (this.targetChoiceIndex != newChoiceIndex) {
                if (this.sourceChoiceIndex != newChoiceIndex) {
                    this.targetChoiceIndex = newChoiceIndex;
                    this.ungrayImage(this.targetPh.getPointAction());
                    this.cancelTarget();
                    this.createTargetImage();
                    this.ungrayImage(this.sourcePh.getPointAction());
                    this.sourcePh.removePoints();
                    this.sourceImp.setRoi(this.previousSourceRoi);
                    this.loadPointRoiAsLandmarks();
                    this.setSecondaryPointHandlers();
                } else {
                    this.sourceChoiceIndex = this.targetChoiceIndex;
                    this.targetChoiceIndex = newChoiceIndex;
                    this.sourceChoice.select(this.sourceChoiceIndex);
                    this.permuteImages(this.bIsReverse);
                }
            }
        } else if (originChoice == this.modeChoice) {
            int accurate_mode = originChoice.getSelectedIndex();
            if (accurate_mode == MONO_MODE) {
                this.consistencyWeightTextField.setEnabled(false);
            } else {
                this.consistencyWeightTextField.setEnabled(true);
            }
        } else if (originChoice == this.minScaleChoice) {
            int new_min_scale_deformation = originChoice.getSelectedIndex();
            int new_max_scale_deformation = this.max_scale_deformation;
            if (this.max_scale_deformation < new_min_scale_deformation) {
                new_max_scale_deformation = new_min_scale_deformation;
            }
            if (new_min_scale_deformation != this.min_scale_deformation || new_max_scale_deformation != this.max_scale_deformation) {
                this.min_scale_deformation = new_min_scale_deformation;
                this.max_scale_deformation = new_max_scale_deformation;
                this.computeImagePyramidDepth();
                this.restartModelThreads(this.bIsReverse);
            }
            this.minScaleChoice.select(this.min_scale_deformation);
            this.maxScaleChoice.select(this.max_scale_deformation);
        } else if (originChoice == this.maxScaleChoice) {
            int new_max_scale_deformation = originChoice.getSelectedIndex();
            int new_min_scale_deformation = this.min_scale_deformation;
            if (new_max_scale_deformation < this.min_scale_deformation) {
                new_min_scale_deformation = new_max_scale_deformation;
            }
            if (new_max_scale_deformation != this.max_scale_deformation || new_min_scale_deformation != this.min_scale_deformation) {
                this.min_scale_deformation = new_min_scale_deformation;
                this.max_scale_deformation = new_max_scale_deformation;
                this.computeImagePyramidDepth();
                this.restartModelThreads(this.bIsReverse);
            }
            this.maxScaleChoice.select(this.max_scale_deformation);
            this.minScaleChoice.select(this.min_scale_deformation);
        }
    }

    public void applyTransformationToSource(int intervals, double[][] cx, double[][] cy) {
        MiscTools.applyTransformationToSourceMT(this.sourceImp, this.targetImp, this.source, intervals, cx, cy);
        this.cancelSource();
        this.targetPh.removePoints();
        this.createSourceImage(false);
        this.setSecondaryPointHandlers();
    }

    public void applyRawTransformationToSource(double[][] transformation_x, double[][] transformation_y) {
        MiscTools.applyRawTransformationToSource(this.sourceImp, this.targetImp, this.source, transformation_x, transformation_y);
        this.cancelSource();
        this.targetPh.removePoints();
        this.createSourceImage(false);
        this.setSecondaryPointHandlers();
    }

    public void freeMemory() {
        this.imageList = null;
        this.sourceIc = null;
        this.targetIc = null;
        this.sourceImp = null;
        this.targetImp = null;
        this.source = null;
        this.target = null;
        this.sourcePh = null;
        this.targetPh = null;
        this.tb = null;
        Runtime.getRuntime().gc();
    }

    public void grayImage(PointHandler ph) {
        if (ph == this.sourcePh) {
            int Xdim = this.source.getWidth();
            int Ydim = this.source.getHeight();
            double[] source_data = new double[Xdim * Ydim];
            MiscTools.extractImage(this.sourceImp.getProcessor(), source_data);
            FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
            float[] fp_array = (float[])fp.getPixels();
            int ij = 0;
            for (int i = 0; i < Ydim; ++i) {
                int i_offset = i * Xdim;
                int j = 0;
                while (j < Xdim) {
                    fp_array[j + i_offset] = this.sourceMsk.getValue(j, i) ? (float)source_data[ij] : (float)(0.5 * source_data[ij]);
                    ++j;
                    ++ij;
                }
            }
            fp.resetMinAndMax();
            this.sourceImp.setProcessor(this.sourceImp.getTitle(), (ImageProcessor)fp);
            this.sourceImp.updateAndDraw();
        } else {
            int Xdim = this.target.getWidth();
            int Ydim = this.target.getHeight();
            double[] source_data = new double[Xdim * Ydim];
            MiscTools.extractImage(this.targetImp.getProcessor(), source_data);
            FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
            float[] fp_array = (float[])fp.getPixels();
            int ij = 0;
            for (int i = 0; i < Ydim; ++i) {
                int i_offset = i * Xdim;
                int j = 0;
                while (j < Xdim) {
                    fp_array[j + i_offset] = this.targetMsk.getValue(j, i) ? (float)source_data[ij] : (float)(0.5 * source_data[ij]);
                    ++j;
                    ++ij;
                }
            }
            fp.resetMinAndMax();
            this.targetImp.setProcessor(this.targetImp.getTitle(), (ImageProcessor)fp);
            this.targetImp.updateAndDraw();
        }
    }

    public boolean isFinalActionLaunched() {
        return this.finalActionLaunched;
    }

    public boolean isClearMaskSet() {
        return this.clearMask;
    }

    public boolean isSaveTransformationSet() {
        return this.saveTransformation;
    }

    public void setSaveTransformation(boolean b) {
        this.saveTransformation = b;
    }

    public boolean isStopRegistrationSet() {
        return this.stopRegistration;
    }

    public void joinThreads() {
        try {
            this.source.getThread().join();
            this.target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception" + e));
        }
    }

    public void restoreAll() {
        this.ungrayImage(this.sourcePh.getPointAction());
        this.ungrayImage(this.targetPh.getPointAction());
        this.cancelSource();
        this.cancelTarget();
        this.tb.restorePreviousToolbar();
        if (null != Toolbar.getInstance()) {
            Toolbar.getInstance().repaint();
        }
        ProgressBar.resetProgressBar();
        Runtime.getRuntime().gc();
    }

    public void setClearMask(boolean val) {
        this.clearMask = val;
    }

    public void setStopRegistration() {
        this.stopRegistration = true;
    }

    public double[][] getSourceAffineMatrix() {
        return this.sourceAffineMatrix;
    }

    public double[][] getTargetAffineMatrix() {
        return this.targetAffineMatrix;
    }

    public void ungrayImage(PointAction pa) {
        if (this.sourcePh != null && pa == this.sourcePh.getPointAction()) {
            if (this.sourceImp != null && this.sourceImp.getProcessor() != null) {
                this.sourceImp.setProcessor(this.sourceImp.getTitle(), this.originalSourceIP);
                this.sourceImp.updateImage();
            }
        } else if (this.targetImp != null && this.targetImp.getProcessor() != null) {
            this.targetImp.setProcessor(this.targetImp.getTitle(), this.originalTargetIP);
            this.targetImp.updateImage();
        }
    }

    private void cancelSource() {
        this.sourcePh.killListeners();
        this.sourcePh = null;
        this.sourceIc = null;
        this.sourceImp.killRoi();
        this.sourceImp.setRoi(this.previousSourceRoi);
        this.sourceImp = null;
        this.source = null;
        this.sourceMsk = null;
        Runtime.getRuntime().gc();
    }

    private void cancelTarget() {
        this.targetPh.killListeners();
        this.targetPh = null;
        this.targetIc = null;
        this.targetImp.killRoi();
        this.targetImp.setRoi(this.previousTargetRoi);
        this.targetImp = null;
        this.target = null;
        this.targetMsk = null;
        Runtime.getRuntime().gc();
    }

    private void computeImagePyramidDepth() {
        this.imagePyramidDepth = this.max_scale_deformation - this.min_scale_deformation + 1;
    }

    private void createSourceImage(boolean bIsReverse) {
        if (this.bMacro) {
            int i;
            String macroOptions = Macro.getOptions();
            Choice thisChoice = this.sourceChoice;
            String item = thisChoice.getSelectedItem();
            item = Macro.getValue((String)macroOptions, (String)"Source_Image", (String)item);
            for (i = 0; i < this.imageList.length; ++i) {
                if (!this.imageList[i].getTitle().equals(item)) continue;
                this.sourceChoiceIndex = i;
                break;
            }
            this.maxImageSubsamplingFactor = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"Image_Subsample_Factor", (String)String.valueOf(this.maxImageSubsamplingFactor)));
            item = this.minScaleChoice.getSelectedItem();
            item = Macro.getValue((String)macroOptions, (String)"Initial_Deformation", (String)item);
            for (i = 0; i < sMinScaleDeformationChoices.length; ++i) {
                if (!sMinScaleDeformationChoices[i].equals(item)) continue;
                this.min_scale_deformation = i;
                break;
            }
            item = this.maxScaleChoice.getSelectedItem();
            item = Macro.getValue((String)macroOptions, (String)"Final_Deformation", (String)item);
            for (i = 0; i < sMaxScaleDeformationChoices.length; ++i) {
                if (!sMaxScaleDeformationChoices[i].equals(item)) continue;
                this.max_scale_deformation = i;
                break;
            }
        }
        this.sourceImp = this.imageList[this.sourceChoiceIndex];
        this.originalSourceIP = this.sourceImp.getImageStackSize() > 1 ? this.sourceImp.getImageStack().getProcessor(1) : this.sourceImp.getProcessor();
        this.source = new BSplineModel(this.sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.computeImagePyramidDepth();
        this.source.setPyramidDepth(this.imagePyramidDepth + this.min_scale_image);
        this.sourceIc = null == this.sourceImp.getWindow() ? null : this.sourceImp.getWindow().getCanvas();
        this.sourceMsk = this.sourceImp.getImageStackSize() == 1 ? new Mask(this.sourceImp.getProcessor(), false) : new Mask(this.sourceImp.getImageStack().getProcessor(2), true);
        this.sourcePh = new PointHandler(this.sourceImp, this.tb, this.sourceMsk, this);
        this.tb.setSource(this.sourceImp, this.sourcePh);
    }

    private void createTargetImage() {
        if (this.bMacro) {
            int i;
            String macroOptions = Macro.getOptions();
            Choice thisChoice = this.targetChoice;
            String item = thisChoice.getSelectedItem();
            item = Macro.getValue((String)macroOptions, (String)"Target_Image", (String)item);
            for (i = 0; i < this.imageList.length; ++i) {
                if (!this.imageList[i].getTitle().equals(item)) continue;
                this.targetChoiceIndex = i;
                break;
            }
            this.maxImageSubsamplingFactor = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"Image_Subsample_Factor", (String)String.valueOf(this.maxImageSubsamplingFactor)));
            item = this.minScaleChoice.getSelectedItem();
            item = Macro.getValue((String)macroOptions, (String)"Initial_Deformation", (String)item);
            for (i = 0; i < sMinScaleDeformationChoices.length; ++i) {
                if (!sMinScaleDeformationChoices[i].equals(item)) continue;
                this.min_scale_deformation = i;
                break;
            }
            item = this.maxScaleChoice.getSelectedItem();
            item = Macro.getValue((String)macroOptions, (String)"Final_Deformation", (String)item);
            for (i = 0; i < sMaxScaleDeformationChoices.length; ++i) {
                if (!sMaxScaleDeformationChoices[i].equals(item)) continue;
                this.max_scale_deformation = i;
                break;
            }
        }
        this.targetImp = this.imageList[this.targetChoiceIndex];
        this.originalTargetIP = this.targetImp.getImageStackSize() > 1 ? this.targetImp.getImageStack().getProcessor(1) : this.targetImp.getProcessor();
        this.target = new BSplineModel(this.targetImp.getProcessor(), true, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.computeImagePyramidDepth();
        this.target.setPyramidDepth(this.imagePyramidDepth + this.min_scale_image);
        this.targetIc = null == this.targetImp.getWindow() ? null : this.targetImp.getWindow().getCanvas();
        this.targetMsk = this.targetImp.getImageStackSize() == 1 ? new Mask(this.targetImp.getProcessor(), false) : new Mask(this.targetImp.getImageStack().getProcessor(2), true);
        this.targetPh = new PointHandler(this.targetImp, this.tb, this.targetMsk, this);
        this.tb.setTarget(this.targetImp, this.targetPh);
    }

    private void loadPointRoiAsLandmarks() {
        Roi roiSource = this.previousSourceRoi = this.sourceImp.getRoi();
        Roi roiTarget = this.previousTargetRoi = this.targetImp.getRoi();
        if (roiSource instanceof PointRoi && roiTarget instanceof PointRoi) {
            PointRoi prTarget;
            int[] xTarget;
            PointRoi prSource = (PointRoi)roiSource;
            int[] xSource = prSource.getXCoordinates();
            int numOfPoints = xSource.length;
            if (numOfPoints != (xTarget = (prTarget = (PointRoi)roiTarget).getXCoordinates()).length) {
                return;
            }
            int[] ySource = prSource.getYCoordinates();
            int[] yTarget = prTarget.getYCoordinates();
            Rectangle recSource = prSource.getBounds();
            int originXSource = recSource.x;
            int originYSource = recSource.y;
            Rectangle recTarget = prTarget.getBounds();
            int originXTarget = recTarget.x;
            int originYTarget = recTarget.y;
            for (int i = 0; i < numOfPoints; ++i) {
                this.sourcePh.addPoint(xSource[i] + originXSource, ySource[i] + originYSource);
                this.targetPh.addPoint(xTarget[i] + originXTarget, yTarget[i] + originYTarget);
            }
            this.sourceImp.setRoi((Roi)this.sourcePh);
            this.targetImp.setRoi((Roi)this.targetPh);
        }
    }

    private void permuteImages(boolean bIsReverse) {
        int j;
        int i;
        ImageCanvas swapIc = this.sourceIc;
        this.sourceIc = this.targetIc;
        this.targetIc = swapIc;
        ImagePlus swapImp = this.sourceImp;
        this.sourceImp = this.targetImp;
        this.targetImp = swapImp;
        ImageProcessor swapIP = this.originalSourceIP;
        this.originalSourceIP = this.originalTargetIP;
        this.originalTargetIP = swapIP;
        Mask swapMsk = this.sourceMsk;
        this.sourceMsk = this.targetMsk;
        this.targetMsk = swapMsk;
        PointHandler swapPh = this.sourcePh;
        this.sourcePh = this.targetPh;
        this.targetPh = swapPh;
        this.setSecondaryPointHandlers();
        double[][] swapMatrix = null;
        Roi swapRoi = this.previousSourceRoi;
        this.previousSourceRoi = this.previousTargetRoi;
        this.previousTargetRoi = swapRoi;
        if (this.sourceAffineMatrix != null) {
            swapMatrix = new double[2][3];
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 3; ++j) {
                if (this.sourceAffineMatrix != null) {
                    swapMatrix[i][j] = this.sourceAffineMatrix[i][j];
                }
                if (this.targetAffineMatrix == null) continue;
                this.sourceAffineMatrix[i][j] = this.targetAffineMatrix[i][j];
            }
        }
        if (swapMatrix != null) {
            if (this.targetAffineMatrix == null) {
                this.targetAffineMatrix = new double[2][3];
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.targetAffineMatrix[i][j] = swapMatrix[i][j];
                }
            }
        }
        this.tb.setSource(this.sourceImp, this.sourcePh);
        this.tb.setTarget(this.targetImp, this.targetPh);
        this.source = new BSplineModel(this.sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.source.setPyramidDepth(this.imagePyramidDepth + this.min_scale_image);
        this.target = new BSplineModel(this.targetImp.getProcessor(), true, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.target.setPyramidDepth(this.imagePyramidDepth + this.min_scale_image);
    }

    private void restartModelThreads(boolean bIsReverse) {
        this.stopSourceThread();
        this.stopTargetThread();
        this.source = null;
        this.target = null;
        Runtime.getRuntime().gc();
        this.source = new BSplineModel(this.sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.source.setPyramidDepth(this.imagePyramidDepth + this.min_scale_image);
        this.target = new BSplineModel(this.targetImp.getProcessor(), true, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.target.setPyramidDepth(this.imagePyramidDepth + this.min_scale_image);
    }

    private void setSecondaryPointHandlers() {
        this.sourcePh.setSecondaryPointHandler(this.targetImp, this.targetPh);
        this.targetPh.setSecondaryPointHandler(this.sourceImp, this.sourcePh);
    }

    private void stopSourceThread() {
        if (this.source.getThread() == null) {
            return;
        }
        while (this.source.getThread().isAlive()) {
            this.source.getThread().interrupt();
        }
    }

    private void stopTargetThread() {
        if (this.target.getThread() == null) {
            return;
        }
        while (this.target.getThread().isAlive()) {
            this.target.getThread().interrupt();
        }
    }

    public PointHandler getSourcePh() {
        return this.sourcePh;
    }

    public PointHandler getTargetPh() {
        return this.targetPh;
    }

    public Mask getSourceMsk() {
        return this.sourceMsk;
    }

    public Mask getTargetMsk() {
        return this.targetMsk;
    }

    public void setFinalActionLaunched(boolean b) {
        this.finalActionLaunched = b;
    }

    public void setToolbarAllUp() {
        this.tb.setAllUp();
    }

    public void repaintToolbar() {
        this.tb.repaint();
    }

    public BSplineModel getTarget() {
        return this.target;
    }

    public ImageProcessor getOriginalSourceIP() {
        return this.originalSourceIP;
    }

    public ImageProcessor getOriginalTargetIP() {
        return this.originalTargetIP;
    }

    public BSplineModel getSource() {
        return this.source;
    }

    public boolean isMacroCall() {
        return this.bMacro;
    }

    public String getMacroArgs() {
        return this.macroArgs;
    }

    public ImagePlus getSourceImp() {
        return this.sourceImp;
    }

    public ImagePlus getTargetImp() {
        return this.targetImp;
    }
}

