/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.MainDialog;
import bunwarpj.PointHandler;
import bunwarpj.PointToolbar;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class PointAction
extends ImageCanvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -8141177836023328859L;
    public static final int ADD_CROSS = 0;
    public static final int MOVE_CROSS = 1;
    public static final int REMOVE_CROSS = 2;
    public static final int MASK = 3;
    public static final int INVERTMASK = 4;
    public static final int FILE = 5;
    public static final int STOP = 7;
    public static final int MAGNIFIER = 11;
    private ImagePlus mainImp = null;
    private ImagePlus secondaryImp = null;
    private PointHandler mainPh = null;
    private PointHandler secondaryPh = null;
    private PointToolbar tb = null;
    private MainDialog dialog = null;
    private long mouseDownTime;

    public PointAction(ImagePlus imp, PointHandler ph, PointToolbar tb, MainDialog dialog) {
        super(imp);
        this.mainImp = imp;
        this.mainPh = ph;
        this.tb = tb;
        this.dialog = dialog;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.tb.getCurrentTool() == 3 || this.tb.getCurrentTool() == 4) {
            return;
        }
        Point p = this.mainPh.getPoint();
        if (p == null) {
            return;
        }
        int x = p.x;
        int y = p.y;
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                this.mainPh.removePoint();
                this.secondaryPh.removePoint();
                this.updateAndDraw();
                break;
            }
            case 40: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x), this.mainImp.getWindow().getCanvas().screenY(y + (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())));
                this.mainImp.setRoi((Roi)this.mainPh);
                break;
            }
            case 37: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x - (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())), this.mainImp.getWindow().getCanvas().screenY(y));
                this.mainImp.setRoi((Roi)this.mainPh);
                break;
            }
            case 39: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x + (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())), this.mainImp.getWindow().getCanvas().screenY(y));
                this.mainImp.setRoi((Roi)this.mainPh);
                break;
            }
            case 9: {
                this.mainPh.nextPoint();
                this.secondaryPh.nextPoint();
                this.updateAndDraw();
                break;
            }
            case 38: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x), this.mainImp.getWindow().getCanvas().screenY(y - (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())));
                this.mainImp.setRoi((Roi)this.mainPh);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.tb.getCurrentTool() == 1) {
            this.mainPh.movePoint(x, y);
            this.updateAndDraw();
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        WindowManager.setCurrentWindow((ImageWindow)this.mainImp.getWindow());
        this.mainImp.getWindow().toFront();
        this.updateAndDraw();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        IJ.showStatus((String)"");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setControl();
        int x = this.mainImp.getWindow().getCanvas().offScreenX(e.getX());
        int y = this.mainImp.getWindow().getCanvas().offScreenY(e.getY());
        IJ.showStatus((String)(this.mainImp.getLocationAsString(x, y) + this.getValueAsString(x, y)));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.dialog.isFinalActionLaunched()) {
            return;
        }
        int x = e.getX();
        int xp = 0;
        int y = e.getY();
        int yp = 0;
        int currentPoint = 0;
        boolean doubleClick = System.currentTimeMillis() - this.mouseDownTime <= 250L;
        this.mouseDownTime = System.currentTimeMillis();
        switch (this.tb.getCurrentTool()) {
            case 0: {
                xp = this.mainImp.getWindow().getCanvas().offScreenX(x);
                yp = this.mainImp.getWindow().getCanvas().offScreenY(y);
                this.mainPh.addPoint(xp, yp);
                xp = this.positionX(this.mainImp, this.secondaryImp, this.mainImp.getWindow().getCanvas().offScreenX(x));
                yp = this.positionY(this.mainImp, this.secondaryImp, this.mainImp.getWindow().getCanvas().offScreenY(y));
                this.secondaryPh.addPoint(xp, yp);
                this.updateAndDraw();
                break;
            }
            case 1: {
                currentPoint = this.mainPh.findClosest(x, y);
                this.secondaryPh.setCurrentPoint(currentPoint);
                this.updateAndDraw();
                break;
            }
            case 2: {
                currentPoint = this.mainPh.findClosest(x, y);
                this.mainPh.removePoint(currentPoint);
                this.secondaryPh.removePoint(currentPoint);
                this.updateAndDraw();
                break;
            }
            case 3: 
            case 4: {
                if (this.mainPh.canAddMaskPoints()) {
                    if (!doubleClick) {
                        if (this.dialog.isClearMaskSet()) {
                            this.mainPh.clearMask();
                            this.dialog.setClearMask(false);
                            this.dialog.ungrayImage(this);
                        }
                        x = this.positionX(this.mainImp, this.secondaryImp, this.mainImp.getWindow().getCanvas().offScreenX(x));
                        y = this.positionY(this.mainImp, this.secondaryImp, this.mainImp.getWindow().getCanvas().offScreenY(y));
                        this.mainPh.addMaskPoint(x, y);
                    } else {
                        this.mainPh.closeMask(this.tb.getCurrentTool());
                    }
                    this.updateAndDraw();
                    break;
                }
                IJ.error((String)"A mask cannot be manually assigned since the mask was already in the stack");
                break;
            }
            case 11: {
                int flags = e.getModifiers();
                if ((flags & 0xE) != 0) {
                    this.mainImp.getWindow().getCanvas().zoomOut(x, y);
                    break;
                }
                this.mainImp.getWindow().getCanvas().zoomIn(x, y);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setSecondaryPointHandler(ImagePlus secondaryImp, PointHandler secondaryPh) {
        this.secondaryImp = secondaryImp;
        this.secondaryPh = secondaryPh;
        if (this.secondaryImp == null) {
            IJ.log((String)"Error: set secondary image as null!");
        }
        if (this.secondaryPh == null) {
            IJ.log((String)"Error: set secondray point handler as null!");
        }
    }

    private String getValueAsString(int x, int y) {
        Calibration cal = this.mainImp.getCalibration();
        int[] v = this.mainImp.getPixel(x, y);
        int mainImptype = this.mainImp.getType();
        if (mainImptype == 0 || mainImptype == 1) {
            double cValue = cal.getCValue(v[0]);
            if (cValue == (double)v[0]) {
                return ", value=" + v[0];
            }
            return ", value=" + IJ.d2s((double)cValue) + " (" + v[0] + ")";
        }
        if (mainImptype == 2) {
            return ", value=" + Float.intBitsToFloat(v[0]);
        }
        if (mainImptype == 3) {
            return ", index=" + v[3] + ", value=" + v[0] + "," + v[1] + "," + v[2];
        }
        if (mainImptype == 4) {
            return ", value=" + v[0] + "," + v[1] + "," + v[2];
        }
        return "";
    }

    private int positionX(ImagePlus imp1, ImagePlus imp2, int x) {
        return x * imp2.getWidth() / imp1.getWidth();
    }

    private int positionY(ImagePlus imp1, ImagePlus imp2, int y) {
        return y * imp2.getHeight() / imp1.getHeight();
    }

    private void setControl() {
        switch (this.tb.getCurrentTool()) {
            case 0: {
                this.mainImp.getWindow().getCanvas().setCursor(crosshairCursor);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                this.mainImp.getWindow().getCanvas().setCursor(defaultCursor);
            }
        }
    }

    private void updateAndDraw() {
        if (this.mainImp != null) {
            this.mainImp.setRoi((Roi)this.mainPh);
        }
        if (this.secondaryImp != null) {
            this.secondaryImp.setRoi((Roi)this.secondaryPh);
        }
    }
}

