/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.plugin.PlugIn;
import ij.plugin.filter.GaussianBlur;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.util.Vector;

public class Retinex_
implements PlugIn {
    int levelValue = 0;
    int scaleValue = 0;
    int scaleDivValue = 0;
    int alpha = 128;
    int offset = 0;
    int scale = 0;
    int nscales = 0;
    int scales_mode = 0;
    float cvar = 0.0f;
    float gain = 1.0f;
    int N;
    float sigma;
    double B;
    double[] b = new double[4];
    float dynamicValue = 0.0f;
    public static final int RETINEX_UNIFORM = 0;
    public static final int RETINEX_LOW = 1;
    public static final int RETINEX_HIGH = 2;
    public static final int MAX_RETINEX_SCALES = 8;
    public static final int MIN_GAUSSIAN_SCALE = 16;
    public static final int MAX_GAUSSIAN_SCALE = 250;
    float[] RetinexScales = new float[8];
    float mean = 0.0f;
    float var = 0.0f;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (null == imp) {
            return;
        }
        int stackSize = imp.getStackSize();
        if (imp.getBitDepth() != 24) {
            IJ.showMessage((String)"Only RGB images are supported.");
            return;
        }
        GenericDialog gd = new GenericDialog("Retinex params", (Frame)IJ.getInstance());
        String[] level = new String[]{"Uniform", "Low", "High"};
        gd.addChoice("Level:", level, "Uniform");
        gd.addSlider("Scale:", 16.0, 250.0, 240.0);
        gd.addSlider("Scale_division:", 1.0, 8.0, 3.0);
        gd.addSlider("Dynamic:", 0.05, 4.0, 1.2);
        if (stackSize > 1) {
            gd.addCheckbox("Stack", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.levelValue = gd.getNextChoiceIndex();
        Vector sliderValues = gd.getSliders();
        this.scaleValue = (int)gd.getNextNumber();
        this.scaleDivValue = (int)gd.getNextNumber();
        this.dynamicValue = (float)gd.getNextNumber();
        boolean doIstack = false;
        if (stackSize > 1) {
            doIstack = gd.getNextBoolean();
        }
        Object[] result = null;
        if (doIstack) {
            for (int j = 1; j <= stackSize; ++j) {
                imp.setSlice(j);
                result = this.exec(imp, this.scaleValue, this.scaleDivValue, this.levelValue, this.dynamicValue);
                if (null == result) continue;
                ImagePlus scaled = (ImagePlus)result[1];
                scaled.show();
            }
            imp.setSlice(1);
            IJ.run((ImagePlus)imp, (String)"Images to Stack", (String)"name=Stack_Retinex title=Retinex_");
        } else {
            result = this.exec(imp, this.scaleValue, this.scaleDivValue, this.levelValue, this.dynamicValue);
        }
        if (null != result) {
            ImagePlus scaled = (ImagePlus)result[1];
            scaled.show();
        }
    }

    public Object[] exec(ImagePlus imp, int scale, int scaleDiv, int level, float dynamic) {
        int i;
        int offset;
        IJ.showStatus((String)("Performing Retinex...Scale:" + scale + "  Scale Div:" + scaleDiv + "  Dynamic:" + dynamic));
        IJ.showProgress((double)0.0);
        ImageProcessor ip = imp.getProcessor();
        this.scale = scale;
        this.nscales = scaleDiv;
        this.scales_mode = level;
        this.cvar = dynamic;
        int width = ip.getWidth();
        int height = ip.getHeight();
        int[] inputPixels = new int[3 * height * width];
        for (int row = 0; row < height; ++row) {
            offset = row * width;
            for (int col = 0; col < width; ++col) {
                i = (offset + col) * 3;
                int c = ip.get(col, row);
                inputPixels[i] = c & 0xFF;
                inputPixels[i + 1] = (c & 0xFF00) >> 8;
                inputPixels[i + 2] = (c & 0xFF0000) >> 16;
            }
        }
        IJ.showProgress((double)0.2);
        try {
            inputPixels = this.MSRCR(inputPixels, width, height, 3);
            int[] output = new int[height * width];
            for (int row = 0; row < height; ++row) {
                offset = row * width;
                for (int col = 0; col < width; ++col) {
                    i = offset + col;
                    int i3 = i * 3;
                    output[i] = ((inputPixels[i3 + 2] & 0xFF) << 16) + ((inputPixels[i3 + 1] & 0xFF) << 8) + (inputPixels[i3] & 0xFF);
                }
            }
            ImagePlus imProc = NewImage.createRGBImage((String)"Retinex_", (int)width, (int)height, (int)1, (int)1);
            ImageProcessor imProcP = imProc.getProcessor();
            imProcP.setPixels((Object)output);
            IJ.showProgress((double)1.0);
            return new Object[]{"Retinex_" + imp.getTitle(), imProc};
        }
        catch (Exception e) {
            IJ.log((String)("Error: " + e.getMessage()));
            return null;
        }
    }

    float clip(float val, int minv, int maxv) {
        val = val < (float)minv ? (float)minv : val;
        return val > (float)maxv ? (float)maxv : val;
    }

    int[] MSRCR(int[] src, int width, int height, int bytes) {
        int i;
        float progress = 0.2f;
        int size = width * height * bytes;
        float[] dst = new float[size];
        int channelsize = width * height;
        float[] in = new float[channelsize];
        float[] out = new float[channelsize];
        float[][] BGR = new float[3][channelsize];
        this.RetinexScales = this.retinex_scales_distribution(this.RetinexScales, this.nscales, this.scales_mode, this.scale);
        float weight = 1.0f / (float)this.nscales;
        ImagePlus[] imBGR = new ImagePlus[3];
        ImageProcessor[] imProcBGR = new ImageProcessor[3];
        GaussianBlur blurImage = new GaussianBlur();
        int pos = 0;
        for (int channel = 0; channel < 3; ++channel) {
            IJ.showProgress((double)(progress += 0.2f));
            i = 0;
            pos = channel;
            while (i < channelsize) {
                in[i] = (float)((double)src[pos] + 1.0);
                BGR[channel][i] = in[i];
                ++i;
                pos += bytes;
            }
            imBGR[channel] = NewImage.createFloatImage((String)("" + channel), (int)width, (int)height, (int)1, (int)1);
            imProcBGR[channel] = imBGR[channel].getProcessor();
            imProcBGR[channel].setPixels((Object)BGR[channel]);
            for (int scale = 0; scale < this.nscales; ++scale) {
                blurImage = new GaussianBlur();
                blurImage.blur(imProcBGR[channel], (double)this.RetinexScales[scale] * 2.5);
                out = (float[])imProcBGR[channel].getPixelsCopy();
                i = 0;
                pos = channel;
                while (i < channelsize) {
                    int n = pos;
                    dst[n] = dst[n] + weight * (float)(Math.log((float)src[pos] + 1.0f) - Math.log(out[i]));
                    ++i;
                    pos += bytes;
                }
            }
        }
        float[] psrc = new float[size];
        float[] pdst = new float[size];
        for (i = 0; i < size; ++i) {
            psrc[i] = src[i];
            pdst[i] = dst[i];
        }
        for (i = 0; i < size; i += bytes) {
            float logl = (float)Math.log(psrc[i] + psrc[i + 1] + psrc[i + 2] + 3.0f);
            pdst[i] = this.gain * ((float)(Math.log((float)this.alpha * (psrc[i] + 1.0f)) - (double)logl) * pdst[i]) + (float)this.offset;
            pdst[i + 1] = this.gain * ((float)(Math.log((float)this.alpha * (psrc[i + 1] + 1.0f)) - (double)logl) * pdst[i + 1]) + (float)this.offset;
            pdst[i + 2] = this.gain * ((float)(Math.log((float)this.alpha * (psrc[i + 2] + 1.0f)) - (double)logl) * pdst[i + 2]) + (float)this.offset;
        }
        this.compute_mean_var(pdst, size, bytes);
        float mini = this.mean - this.cvar * this.var;
        float maxi = this.mean + this.cvar * this.var;
        float range = maxi - mini;
        if (range == 0.0f) {
            range = 1.0f;
        }
        int[] result = new int[size];
        for (i = 0; i < size; i += bytes) {
            for (int j = 0; j < 3; ++j) {
                float c = 255.0f * (pdst[i + j] - mini) / range;
                psrc[i + j] = this.clip(c, 0, 255);
                result[i + j] = (int)psrc[i + j];
            }
        }
        return result;
    }

    void compute_mean_var(float[] src, int size, int bytes) {
        float vsquared = 0.0f;
        this.mean = 0.0f;
        for (int i = 0; i < size; i += bytes) {
            for (int j = 0; j < 3; ++j) {
                this.mean += src[i + j];
                vsquared += src[i + j] * src[i + j];
            }
        }
        this.mean /= (float)size;
        this.var = (vsquared /= (float)size) - this.mean * this.mean;
        this.var = (float)Math.sqrt(this.var);
    }

    float[] retinex_scales_distribution(float[] scales, int nscales, int mode, int s) {
        if (nscales == 1) {
            scales[0] = (float)s / 2.0f;
        } else if (nscales == 2) {
            scales[0] = (float)s / 2.0f;
            scales[1] = s;
        } else {
            float size_step = (float)s / (float)nscales;
            switch (mode) {
                case 0: {
                    for (int i = 0; i < nscales; ++i) {
                        scales[i] = 2.0f + (float)i * size_step;
                    }
                    break;
                }
                case 1: {
                    size_step = (float)Math.log((float)s - 2.0f) / (float)nscales;
                    for (int i = 0; i < nscales; ++i) {
                        scales[i] = 2.0f + (float)Math.pow(10.0, (double)((float)i * size_step) / Math.log(10.0));
                    }
                    break;
                }
                case 2: {
                    size_step = (float)Math.log((float)s - 2.0f) / (float)nscales;
                    for (int i = 0; i < nscales; ++i) {
                        scales[i] = (float)s - (float)Math.pow(10.0, (double)((float)i * size_step) / Math.log(10.0));
                    }
                    break;
                }
            }
        }
        return scales;
    }
}

