/*
 * Decompiled with CFR 0.152.
 */
package video2;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.plugin.PlugIn;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import video2.WritableVirtualStack;

public class New_Video
implements PlugIn {
    public static final int DEF_WIDTH = 512;
    public static final int DEF_HEIGHT = 512;

    public void run(String arg) {
        String dir;
        int h;
        GenericDialog gd = new GenericDialog("New Video");
        gd.addNumericField("Width", 512.0, 0);
        gd.addNumericField("Height", 512.0, 0);
        Panel p = new Panel(new FlowLayout());
        Button b = new Button("Select dir");
        p.add(b);
        gd.addPanel(p);
        gd.addStringField("Directory", "", 30);
        final TextField tf = (TextField)gd.getStringFields().get(0);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooser dc = new DirectoryChooser("Select an empty directory for video frames");
                String dir = dc.getDirectory();
                if (dir != null) {
                    tf.setText(new File(dir).getAbsolutePath());
                }
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int w = (int)gd.getNextNumber();
        final WritableVirtualStack stack = New_Video.createNewVideoStack(w, h = (int)gd.getNextNumber(), dir = gd.getNextString());
        if (stack == null) {
            return;
        }
        final ImagePlus imp = new ImagePlus("Video stack", (ImageStack)stack);
        imp.show();
        ImagePlus.addImageListener((ImageListener)new ImageListener(){

            public void imageOpened(ImagePlus image) {
            }

            public void imageUpdated(ImagePlus image) {
                if (imp == image) {
                    imp.changes = false;
                }
            }

            public void imageClosed(ImagePlus image) {
                if (imp == image) {
                    stack.setPixels(imp.getProcessor().getPixels(), imp.getCurrentSlice());
                    System.out.println("Saving indices file");
                    stack.saveIndicesFile();
                }
            }
        });
    }

    public static WritableVirtualStack createNewVideoStack(int w, int h, String dir) {
        File folder = new File(dir);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.list().length != 0) {
            IJ.error((String)"Empty directory required");
            return null;
        }
        WritableVirtualStack stack = new WritableVirtualStack(dir, w, h);
        stack.addSlice("");
        return stack;
    }
}

