/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.MacroInstaller;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.ColorModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.ServiceMediator;
import org.imagearchive.lsm.toolbox.gui.AboutDialog;
import org.imagearchive.lsm.toolbox.gui.BatchDialog;
import org.imagearchive.lsm.toolbox.gui.CPDragAndDrop;
import org.imagearchive.lsm.toolbox.gui.GUIButton;
import org.imagearchive.lsm.toolbox.gui.GUIMenuItem;
import org.imagearchive.lsm.toolbox.gui.ImageFocusListener;
import org.imagearchive.lsm.toolbox.gui.InfoFrame;
import org.imagearchive.lsm.toolbox.gui.SelectImageDialog;
import org.imagearchive.lsm.toolbox.info.CZLSMInfoExtended;
import org.imagearchive.lsm.toolbox.info.scaninfo.Recording;

public class ControlPanelFrame
extends JFrame {
    public InfoFrame infoFrame;
    private JPanel pan;
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final GUIButton openLSMButton = new GUIButton(" Open LSM ", "images/fileopen.png", "Opens a LSM image, image stack or a batch file");
    private final GUIButton closeWindowsButton = new GUIButton(" Close all Windows ", "images/fileclose.png", "Closes all opened Image Windows");
    private final GUIButton exitButton = new GUIButton(" Exit ", "images/exit.png", "Exits the LSM Toolbox");
    private final GUIButton showInfoButton = new GUIButton(" Show Infos ", "images/info.png", "Brings the infos panel to front");
    private final GUIButton browseButton = new GUIButton(" Browse ", "images/browse.png", "Browse Hypervolume, needs HyperVolume_Browser");
    private final GUIButton fmButton = new GUIButton(" Fuse/Merge images", "images/blend.png", "Fuses or merges lsm images, needs LSM_Fusion and/or LSM_Merge");
    private final GUIButton applyStampButton = new GUIButton(" Apply stamps ", "images/display.png", "Apply stamps to each image of a stack");
    private final GUIMenuItem applyTStampItem = new GUIMenuItem(" Apply t-stamp ", "images/tstamp.png", "Apply timestamp to each image of a time series stack");
    private final GUIMenuItem applyZStampItem = new GUIMenuItem(" Apply z-stamp ", "images/zstamp.png", "Apply z-stamp to each image of a z series stack");
    private final GUIMenuItem applyLStampItem = new GUIMenuItem(" Apply l-stamp ", "images/lstamp.png", "Apply lambda-stamp to each image of a spectral series");
    private final GUIButton editPaletteButton = new GUIButton(" Edit Palette ", "images/palette.png", "Edit Palette, needs Lut_Panel");
    private final GUIButton batchConvertButton = new GUIButton(" Batch convert ", "images/batch.png", "Converts LSM files to other file formats");
    private final GUIButton helpButton = new GUIButton(" Help ", "images/help.png", "About, Help and Licensing");
    private final GUIButton macroButton = new GUIButton(" Install M&Ms ", "images/macro.png", "Install Magic Montage Macros ");
    private final JToggleButton rbButton = new JToggleButton();
    private final String title = " LSM Toolbox ";
    private final JLabel titleLabel = new JLabel("", 0);
    private final JPopupMenu stampsPM = new JPopupMenu();
    private final JPopupMenu hyperVolumePM = new JPopupMenu();
    private final JPopupMenu fmPM = new JPopupMenu();
    private final JMenuItem hyperVolumeItem = new JMenuItem("Browse with HyperVolumeBrowser");
    private final JMenuItem image5DItem = new JMenuItem("Browse with Image5D");
    private final JMenuItem fuseItem = new JMenuItem("Fuse images");
    private final JMenuItem mergeItem = new JMenuItem("Merge images");
    public String[] LSMinfoText = new String[22];
    public long timestamps_count;
    private final Dimension ScreenDimension = Toolkit.getDefaultToolkit().getScreenSize();
    private final int ScreenX = (int)this.ScreenDimension.getWidth();
    private final int ScreenY = (int)this.ScreenDimension.getHeight();
    private int baseFrameXlocation = 0;
    private int baseFrameYlocation = 0;
    private int selectedToolBarButtonID = -1;
    private final MasterModel masterModel;

    public ControlPanelFrame(MasterModel masterModel) throws HeadlessException {
        this.masterModel = masterModel;
        ServiceMediator.registerControlPanelFrame(this);
    }

    public void initializeGUI() {
        this.setTitle("LSM Toolbox " + MasterModel.VERSION);
        this.setResizable(false);
        this.addExitListener(this.exitButton, this);
        this.addShowHideInfolistener(this.showInfoButton, this);
        this.addOpenListener(this.openLSMButton, this);
        this.addCloseWinListener(this.closeWindowsButton, this);
        this.addStampsListener(this.applyStampButton, this);
        this.addApplyZStampListener(this.applyZStampItem, this);
        this.addApplyTStampListener(this.applyTStampItem, this);
        this.addApplyLambdaStampListener(this.applyLStampItem, this);
        this.addLUTListener(this.editPaletteButton, this);
        this.addBatchConvertListener(this.batchConvertButton, this);
        this.addHelpListener(this.helpButton, this);
        this.addMacroButtonListener(this.macroButton, this);
        this.addHyperVolumeBrowseListener(this.hyperVolumeItem, this);
        this.addImage5DListener(this.image5DItem, this);
        this.addBrowseListener(this.browseButton, this);
        this.addFuseListener(this.fuseItem, this);
        this.addMergeListener(this.mergeItem, this);
        this.addFMListener(this.fmButton, this);
        this.pan = new JPanel();
        this.pan.setForeground(SystemColor.window);
        this.pan.setLayout(this.gridBagLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        this.titleLabel.setText(" LSM Toolbox  ver " + MasterModel.VERSION);
        this.pan.add((Component)this.titleLabel, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.openLSMButton, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.showInfoButton, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.macroButton, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.applyStampButton, constraints);
        this.stampsPM.add(this.applyZStampItem);
        this.stampsPM.add(this.applyTStampItem);
        this.stampsPM.add(this.applyLStampItem);
        if (this.isPluginInstalled("HyperVolume_Browser") || this.isImage5DInstalled()) {
            ++constraints.gridy;
            this.pan.add((Component)this.browseButton, constraints);
            this.hyperVolumePM.add(this.hyperVolumeItem);
            this.hyperVolumePM.add(this.image5DItem);
            if (!this.isPluginInstalled("HyperVolume_Browser")) {
                this.hyperVolumeItem.setEnabled(false);
            }
            if (!this.isImage5DInstalled()) {
                this.image5DItem.setEnabled(false);
            }
        }
        if (this.isPluginInstalled("LSM_Fusion") || this.isPluginInstalled("LSM_Merge")) {
            ++constraints.gridy;
            this.pan.add((Component)this.fmButton, constraints);
            this.fmPM.add(this.fuseItem);
            this.fmPM.add(this.mergeItem);
            if (!this.isPluginInstalled("LSM_Fusion")) {
                this.fuseItem.setEnabled(false);
            }
            if (!this.isPluginInstalled("LSM_Merge")) {
                this.mergeItem.setEnabled(false);
            }
        }
        if (this.isPluginInstalled("Lut_Panel")) {
            ++constraints.gridy;
            this.pan.add((Component)this.editPaletteButton, constraints);
        }
        ++constraints.gridy;
        this.pan.add((Component)this.closeWindowsButton, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.batchConvertButton, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.helpButton, constraints);
        ++constraints.gridy;
        this.pan.add((Component)this.exitButton, constraints);
        this.getContentPane().add(this.pan);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ControlPanelFrame.this.dispose();
            }
        });
        this.initInfoFrame();
        new CPDragAndDrop(this);
        this.invalidate();
        this.pack();
        this.baseFrameXlocation = this.ScreenX - this.getWidth();
        this.baseFrameYlocation = this.ScreenY / 2 - this.getHeight();
        this.setLocation(this.baseFrameXlocation, this.baseFrameYlocation);
        this.setVisible(true);
    }

    private void closeFrames() {
        this.infoFrame.dispose();
        this.dispose();
    }

    public void initInfoFrame() {
        this.infoFrame = new InfoFrame();
    }

    private void addExitListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowManager.closeAllWindows();
                ControlPanelFrame.this.closeFrames();
            }
        });
    }

    private void addBrowseListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                if (!ControlPanelFrame.this.hyperVolumePM.isShowing()) {
                    ControlPanelFrame.this.hyperVolumePM.show(c, 0, 2 + c.getHeight());
                } else {
                    ControlPanelFrame.this.hyperVolumePM.setVisible(false);
                }
            }
        });
    }

    private void addOpenListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Reader reader = ServiceMediator.getReader();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IJ.showStatus((String)"Loading image");
                            ImagePlus imp = reader.open("", true);
                            IJ.showStatus((String)"Image loaded");
                            if (imp == null) {
                                return;
                            }
                            imp.setPosition(1, 1, 1);
                            imp.show();
                        }
                        catch (OutOfMemoryError e) {
                            IJ.outOfMemory((String)"Could not load lsm image.");
                        }
                    }
                });
            }
        });
    }

    private void addBatchConvertListener(JButton button, final JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new BatchDialog((Object)parent, ControlPanelFrame.this.masterModel).setVisible(true);
            }
        });
    }

    private void addHelpListener(JButton button, final JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog(parent, ControlPanelFrame.this.masterModel).setVisible(true);
            }
        });
    }

    private void addMacroButtonListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MacroInstaller().install(ControlPanelFrame.this.masterModel.getMagicMontaqe());
            }
        });
    }

    private void addCloseWinListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowManager.closeAllWindows();
                ControlPanelFrame.this.setLSMinfoText(new String[22]);
                ControlPanelFrame.this.infoFrame.getDetailsFrame().dispose();
                ControlPanelFrame.this.infoFrame.dispose();
                ControlPanelFrame.this.showInfoButton.setEnabled(false);
            }
        });
    }

    private void addShowHideInfolistener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ControlPanelFrame.this.infoFrame.isShowing()) {
                    ControlPanelFrame.this.infoFrame.setVisible(true);
                } else {
                    ControlPanelFrame.this.infoFrame.setVisible(false);
                }
            }
        });
    }

    private void addStampsListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                if (!ControlPanelFrame.this.stampsPM.isShowing()) {
                    ControlPanelFrame.this.stampsPM.show(c, 0, 2 + c.getHeight());
                } else {
                    ControlPanelFrame.this.stampsPM.setVisible(false);
                }
            }
        });
    }

    private void addFMListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                if (!ControlPanelFrame.this.fmPM.isShowing()) {
                    ControlPanelFrame.this.fmPM.show(c, 0, 2 + c.getHeight());
                } else {
                    ControlPanelFrame.this.fmPM.setVisible(false);
                }
            }
        });
    }

    private void addApplyZStampListener(JMenuItem item, final JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectImageDialog id = new SelectImageDialog(parent, "Select an lsm image to apply Z stamps to", false, MasterModel.DEPTH);
                int returnVal = id.showDialog();
                if (returnVal == 0) {
                    int[] imageVals = id.getSelected();
                    if (imageVals == null & imageVals.length > 0) {
                        JOptionPane.showMessageDialog(parent, "No image has been selected", "Error", 0);
                        return;
                    }
                    String[] choices = new String[]{"Dump to textfile", "Apply to image"};
                    GenericDialog gd = new GenericDialog(" Z stamps");
                    gd.addChoice("Stamps destination : ", choices, "Apply to image");
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    String choice = gd.getNextChoice();
                    Reader reader = ServiceMediator.getReader();
                    for (int i = 0; i < imageVals.length; ++i) {
                        ImagePlus imp = WindowManager.getImage((int)imageVals[i]);
                        reader.updateMetadata(imp);
                        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
                        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
                        Recording r = cz.scanInfo.recordings.get(0);
                        double planeSpacing = (Double)r.records.get("PLANE_SPACING");
                        if (choice.equals("Dump to textfile")) {
                            String twstr = new String("");
                            double ps = 0.0;
                            int k = 1;
                            while ((long)i <= cz.DimensionZ) {
                                String s = IJ.d2s((double)ps, (int)2) + " " + MasterModel.micrometer;
                                ps += planeSpacing;
                                twstr = twstr + s + "\n";
                                ++k;
                            }
                            new TextWindow("Z-stamps", "Z-stamps", twstr, 200, 400);
                            continue;
                        }
                        ControlPanelFrame.this.applyZSTAMP(imp, (LSMFileInfo)imp.getOriginalFileInfo());
                    }
                }
            }
        });
    }

    private void addApplyTStampListener(JMenuItem item, final JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectImageDialog id = new SelectImageDialog(parent, "Select an lsm image to apply time stamps to", false, MasterModel.TIME);
                int returnVal = id.showDialog();
                if (returnVal == 0) {
                    int[] imageVals = id.getSelected();
                    if (imageVals == null & imageVals.length > 0) {
                        JOptionPane.showMessageDialog(parent, "No image has been selected", "Error", 0);
                        return;
                    }
                    String[] choices = new String[]{"Dump to textfile", "Apply to image"};
                    GenericDialog gd = new GenericDialog("Time stamps");
                    gd.addChoice("Stamps destination : ", choices, "Apply to image");
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    String choice = gd.getNextChoice();
                    Reader reader = ServiceMediator.getReader();
                    for (int i = 0; i < imageVals.length; ++i) {
                        ImagePlus imp = WindowManager.getImage((int)imageVals[i]);
                        reader.updateMetadata(imp);
                        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
                        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
                        if (choice.equals("Dump to textfile")) {
                            String twstr = new String("");
                            int k = 0;
                            while ((long)k < cz.timeStamps.NumberTimeStamps) {
                                twstr = twstr + Double.toString(cz.timeStamps.TimeStamps[k]) + "\n";
                                ++k;
                            }
                            new TextWindow("Timestamps", "Timestamps", twstr, 200, 400);
                            continue;
                        }
                        ControlPanelFrame.this.applyTSTAMP(imp, (LSMFileInfo)imp.getOriginalFileInfo());
                    }
                }
            }
        });
    }

    private void addApplyLambdaStampListener(JMenuItem item, final JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectImageDialog id = new SelectImageDialog(parent, "Select an lsm image to apply lambda stamps to", false, MasterModel.CHANNEL);
                int returnVal = id.showDialog();
                if (returnVal == 0) {
                    int[] imageVals = id.getSelected();
                    if (imageVals == null & imageVals.length > 0) {
                        JOptionPane.showMessageDialog(parent, "No image has been selected", "Error", 0);
                        return;
                    }
                    String[] choices = new String[]{"Dump to textfile", "Apply to image"};
                    GenericDialog gd = new GenericDialog("Lambdastamps");
                    gd.addChoice("Stamps destination : ", choices, "Apply to image");
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    String choice = gd.getNextChoice();
                    Reader reader = ServiceMediator.getReader();
                    for (int i = 0; i < imageVals.length; ++i) {
                        ImagePlus imp = WindowManager.getImage((int)imageVals[i]);
                        reader.updateMetadata(imp);
                        LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
                        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
                        if (cz.SpectralScan != 1) {
                            IJ.error((String)"Image not issued from spectral scan. Lambda stamp obsolete!");
                            return;
                        }
                        if (choice.equals("Dump to textfile")) {
                            String twstr = new String("");
                            int k = 0;
                            while ((long)k < cz.channelWavelength.Channels) {
                                twstr = twstr + Double.toString(cz.channelWavelength.LambdaStamps[k]) + "\n";
                                ++k;
                            }
                            new TextWindow("Lambdastamps", "Lambdastamps", twstr, 200, 400);
                            continue;
                        }
                        ControlPanelFrame.this.applyLSTAMP(imp, (LSMFileInfo)imp.getOriginalFileInfo());
                    }
                }
            }
        });
    }

    private void addImage5DListener(JMenuItem item, final JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectImageDialog id = new SelectImageDialog(parent, "Select an image to open with Image5D", false);
                int returnVal = id.showDialog();
                if (returnVal == 0) {
                    final int[] imageVals = id.getSelected();
                    if (imageVals == null & imageVals.length > 0) {
                        JOptionPane.showMessageDialog(parent, "No image has been selected", "Error", 0);
                        return;
                    }
                    final Reader reader = ServiceMediator.getReader();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (int i = 0; i < imageVals.length; ++i) {
                                    ImagePlus imp = WindowManager.getImage((int)imageVals[i]);
                                    reader.updateMetadata(imp);
                                    LSMFileInfo openLSM = (LSMFileInfo)imp.getOriginalFileInfo();
                                    CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)openLSM.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
                                    Class<?> i5Dc = null;
                                    if (imp == null || imp.getStackSize() == 0) {
                                        IJ.error((String)"Could not open file.");
                                        return;
                                    }
                                    try {
                                        i5Dc = Class.forName("i5d.Image5D");
                                    }
                                    catch (ClassNotFoundException e1) {
                                        try {
                                            i5Dc = Class.forName("Image5D");
                                        }
                                        catch (ClassNotFoundException e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                    Constructor<?> i5Dcon = null;
                                    Object o = null;
                                    try {
                                        i5Dcon = i5Dc.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                                        o = i5Dcon.newInstance(openLSM.fileName, new Integer(imp.getType()), new Integer(imp.getWidth()), new Integer(imp.getHeight()), new Integer((int)cz.DimensionChannels), new Integer((int)cz.DimensionZ), new Integer((int)cz.DimensionTime), new Boolean(false));
                                        Method i5DsetCurrentPosition = o.getClass().getMethod("setCurrentPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                                        Method i5DsetPixels = o.getClass().getMethod("setPixels", Object.class);
                                        Method i5DsetCalibration = o.getClass().getMethod("setCalibration", Calibration.class);
                                        Method i5Dshow = o.getClass().getMethod("show", new Class[0]);
                                        Method i5DgetWindow = o.getClass().getMethod("getWindow", new Class[0]);
                                        Method i5DsetChannelColorModel = o.getClass().getMethod("setChannelColorModel", Integer.TYPE, ColorModel.class);
                                        Method i5DsetFileInfo = o.getClass().getMethod("setFileInfo", FileInfo.class);
                                        int position = 1;
                                        int t = 0;
                                        while ((long)t < cz.DimensionTime) {
                                            int z = 0;
                                            while ((long)z < cz.DimensionZ) {
                                                int c = 0;
                                                while ((long)c < cz.DimensionChannels) {
                                                    i5DsetCurrentPosition.invoke(o, new Integer(0), new Integer(0), new Integer(c), new Integer(z), new Integer(t));
                                                    imp.setSlice(position++);
                                                    i5DsetPixels.invoke(o, imp.getProcessor().getPixels());
                                                    ++c;
                                                }
                                                ++z;
                                            }
                                            int c = 0;
                                            while ((long)c < cz.DimensionChannels) {
                                                i5DsetChannelColorModel.invoke(o, new Integer(c + 1), imp.getProcessor().getColorModel());
                                                ++c;
                                            }
                                            ++t;
                                        }
                                        i5DsetCalibration.invoke(o, imp.getCalibration().copy());
                                        i5DsetFileInfo.invoke(o, (LSMFileInfo)imp.getOriginalFileInfo());
                                        i5Dshow.invoke(o, new Object[0]);
                                        ((ImageWindow)i5DgetWindow.invoke(o, new Object[0])).addWindowFocusListener((WindowFocusListener)new ImageFocusListener());
                                        ServiceMediator.getInfoFrame().updateInfoFrame();
                                        ServiceMediator.getDetailsFrame().updateTreeAndLabels();
                                        continue;
                                    }
                                    catch (IllegalArgumentException ex) {
                                        ex.printStackTrace();
                                        continue;
                                    }
                                    catch (InstantiationException ex) {
                                        ex.printStackTrace();
                                        continue;
                                    }
                                    catch (IllegalAccessException ex) {
                                        ex.printStackTrace();
                                        continue;
                                    }
                                    catch (InvocationTargetException ex) {
                                        ex.printStackTrace();
                                        continue;
                                    }
                                    catch (SecurityException ex) {
                                        ex.printStackTrace();
                                        continue;
                                    }
                                    catch (NoSuchMethodException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            catch (OutOfMemoryError e) {
                                IJ.outOfMemory((String)"Could not load lsm image.");
                            }
                        }
                    });
                }
            }
        });
    }

    private void addHyperVolumeBrowseListener(JMenuItem item, final JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectImageDialog id = new SelectImageDialog(parent, "Select one or more channels to open with HyperVolume_Browser", true);
                int returnVal = id.showDialog();
                if (returnVal == 0) {
                    int[] imageVals = id.getSelected();
                    if (imageVals == null & imageVals.length > 0) {
                        JOptionPane.showMessageDialog(parent, "No image has been selected", "Error", 0);
                        return;
                    }
                    Reader reader = ServiceMediator.getReader();
                    for (int i = 0; i < imageVals.length; ++i) {
                        ImagePlus imp = WindowManager.getImage((int)imageVals[i]);
                        reader.updateMetadata(imp);
                        FileInfo fi = imp.getOriginalFileInfo();
                        if (fi == null || !(fi instanceof LSMFileInfo)) continue;
                        LSMFileInfo lsm = (LSMFileInfo)fi;
                        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)lsm.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
                        long depth = cz.DimensionZ;
                        IJ.selectWindow((int)imageVals[i]);
                        IJ.runPlugIn((String)"HyperVolume_Browser", (String)("3rd=z depth=" + depth + " 4th=t"));
                    }
                }
            }
        });
    }

    private void addLUTListener(JButton button, JFrame parent) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IJ.runPlugIn((String)"Lut_Panel", (String)"");
            }
        });
    }

    private void addFuseListener(JMenuItem item, JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IJ.runPlugIn((String)"LSM_Fusion", (String)"");
            }
        });
    }

    private void addMergeListener(JMenuItem item, JFrame parent) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IJ.runPlugIn((String)"LSM_Merge", (String)"");
            }
        });
    }

    public void setLSMinfoText(String[] str) {
        this.LSMinfoText = str;
    }

    public void applyZSTAMP(ImagePlus imp, LSMFileInfo lfi) {
        int x = 2;
        int y = 40;
        double ps = 0.0;
        ImageStack stack = imp.getStack();
        Font font = new Font("SansSerif", 0, 20);
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
        }
        Color c = Toolbar.getForegroundColor();
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)lfi.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        if (cz.DimensionZ != 1L) {
            Recording r = cz.scanInfo.recordings.get(0);
            double planeSpacing = (Double)r.records.get("PLANE_SPACING");
            int stackPosition = 1;
            int i = 1;
            while ((long)i <= cz.DimensionTime) {
                ps = 0.0;
                int j = 1;
                while ((long)j <= cz.DimensionZ) {
                    int k = 1;
                    while ((long)k <= cz.DimensionChannels) {
                        if (stackPosition <= imp.getStackSize()) {
                            IJ.showStatus((String)("MinMax: " + j + "/" + cz.DimensionZ));
                            String s = IJ.d2s((double)ps, (int)2) + " " + MasterModel.micrometer;
                            ip = stack.getProcessor(stackPosition++);
                            ip.setFont(font);
                            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                            ip.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - hsb[2]));
                            ip.moveTo(x, y);
                            ip.drawString(s);
                        }
                        ++k;
                    }
                    ps += planeSpacing;
                    ++j;
                }
                ++i;
            }
        }
        imp.updateAndRepaintWindow();
    }

    public void applyTSTAMP(ImagePlus imp, LSMFileInfo lfi) {
        int x = 2;
        int y = 20;
        ImageStack stack = imp.getStack();
        Font font = new Font("SansSerif", 0, 20);
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
        }
        Color c = Toolbar.getForegroundColor();
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)lfi.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        if (cz.DimensionTime > 1L) {
            int stackPosition = 1;
            int i = 1;
            while ((long)i <= cz.DimensionTime) {
                int j = 1;
                while ((long)j <= cz.DimensionZ) {
                    int k = 1;
                    while ((long)k <= cz.DimensionChannels) {
                        if (stackPosition <= imp.getStackSize()) {
                            IJ.showStatus((String)("MinMax: " + stackPosition + "/" + cz.timeStamps.NumberTimeStamps));
                            String s = IJ.d2s((double)cz.timeStamps.TimeStamps[i - 1], (int)2) + " s";
                            ip = stack.getProcessor(stackPosition++);
                            ip.setFont(font);
                            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                            ip.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - hsb[2]));
                            ip.moveTo(x, y);
                            ip.drawString(s);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        imp.updateAndRepaintWindow();
    }

    public void applyLSTAMP(ImagePlus imp, LSMFileInfo lfi) {
        int x = 2;
        int y = 60;
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
        }
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)lfi.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
        ImageStack stack = imp.getStack();
        Font font = new Font("SansSerif", 0, 20);
        Color c = Toolbar.getForegroundColor();
        if (cz.DimensionChannels > 1L && cz.SpectralScan == 1) {
            int stackPosition = 1;
            int i = 1;
            while ((long)i <= cz.DimensionTime) {
                int j = 1;
                while ((long)j <= cz.DimensionZ) {
                    int k = 1;
                    while ((long)k <= cz.DimensionChannels) {
                        if (stackPosition <= imp.getStackSize()) {
                            double channelWaveLength = cz.channelWavelength.LambdaStamps[k - 1];
                            String s = IJ.d2s((double)(channelWaveLength * 1.0E9), (int)2) + " nm";
                            ip = stack.getProcessor(stackPosition++);
                            ip.setFont(font);
                            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                            ip.setColor(Color.getHSBColor(255.0f, 255.0f, 255.0f - hsb[2]));
                            ip.moveTo(x, y);
                            ip.drawString(s);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        imp.updateAndRepaintWindow();
    }

    public boolean isPluginInstalled(String className) {
        boolean found = false;
        try {
            Class.forName(className);
            found = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return found;
    }

    public boolean isImage5DInstalled() {
        boolean installed = false;
        try {
            Class.forName("Image5DWindow");
            installed = true;
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName("i5d.gui.Image5DWindow");
                installed = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return installed;
    }

    public boolean isValidImage5D() {
        boolean installed = false;
        try {
            Class.forName("Image5DWindow");
            installed = true;
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName("i5d.gui.Image5DWindow");
                installed = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return installed;
    }

    public int getSelectedToolBarButtonID() {
        return this.selectedToolBarButtonID;
    }

    public void resetToolbar() {
        this.rbButton.setSelected(true);
        this.selectedToolBarButtonID = -1;
    }
}

