/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.analyzeSkeleton;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import sc.fiji.analyzeSkeleton.Edge;
import sc.fiji.analyzeSkeleton.Graph;
import sc.fiji.analyzeSkeleton.Point;
import sc.fiji.analyzeSkeleton.SkeletonResult;
import sc.fiji.analyzeSkeleton.Vertex;

public class AnalyzeSkeleton_
implements PlugInFilter,
DialogListener {
    private static final String PRUNE_MODE_INDEX_KEY = "sc.fiji.analyzeSkeleton.pruneModeIndex";
    private static final String PRUNE_ENDS_KEY = "sc.fiji.analyzeSkeleton.pruneEnds";
    private static final String CALCULATE_PATH_KEY = "sc.fiji.analyzeSkeleton.shortestPath";
    private static final String VERBOSE_KEY = "sc.fiji.analyzeSkeleton.showDetailedInfo";
    private static final String DISPLAY_SKELETONS_KEY = "sc.fiji.analyzeSkeleton.displayLabeledSkeletons";
    private static final int DEFAULT_PRUNE_MODE_INDEX = 0;
    private static final boolean DEFAULT_PRUNE_ENDS = false;
    private static final boolean DEFAULT_CALCULATE_SHORTEST_PATH = false;
    private static final boolean DEFAULT_VERBOSE = false;
    private static final boolean DEFAULT_PROTECT_ROI = false;
    private static final boolean DEFAULT_DISPLAY_SKELETONS = false;
    private static final String HELP_URL = "http://fiji.sc/wiki/index.php/AnalyzeSkeleton";
    public static byte END_POINT = (byte)30;
    public static byte JUNCTION = (byte)70;
    public static byte SLAB = (byte)127;
    public static byte SHORTEST_PATH = (byte)96;
    private GenericDialog settingsDialog;
    private ImagePlus imRef = null;
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private ImageStack inputImage = null;
    private boolean[][][] visited = null;
    private int totalNumberOfEndPoints = 0;
    private int totalNumberOfJunctionVoxels = 0;
    private int totalNumberOfSlabs = 0;
    private double shortestPath = 0.0;
    private ArrayList<Double> shortestPathList;
    private ArrayList<Point>[] shortestPathPoints = null;
    private int spx = 0;
    private int spy = 0;
    private int spz = 0;
    private double[][] spStartPosition;
    private ImageStack shortPathImage = null;
    ImageStack labeledSkeletons = null;
    private int[] numberOfBranches = null;
    private int[] numberOfEndPoints = null;
    private int[] numberOfJunctionVoxels = null;
    private int[] numberOfSlabs = null;
    private int[] numberOfJunctions = null;
    private int[] numberOfTriplePoints = null;
    private int[] numberOfQuadruplePoints = null;
    private ArrayList<Point>[] endPointsTree = null;
    private ArrayList<Point>[] junctionVoxelTree = null;
    private ArrayList<Point>[] startingSlabTree = null;
    private double[] averageBranchLength = null;
    private double[] maximumBranchLength = null;
    private ArrayList<Point> listOfEndPoints = null;
    private ArrayList<Point> listOfJunctionVoxels = null;
    private ArrayList<Point> listOfSlabVoxels = null;
    private ArrayList<Point> listOfStartingSlabVoxels = null;
    private ArrayList<ArrayList<Point>>[] listOfSingleJunctions = null;
    private Vertex[][] junctionVertex = null;
    private ImageStack taggedImage = null;
    private Point auxPoint = null;
    private int numOfTrees = 0;
    private boolean bPruneCycles = true;
    public static boolean pruneEnds = false;
    public static boolean protectRoi = false;
    public static boolean calculateShortestPath = false;
    private Graph[] graph = null;
    private ArrayList<Point> slabList = null;
    private Vertex auxFinalVertex = null;
    public static final String[] pruneCyclesModes = new String[]{"none", "shortest branch", "lowest intensity voxel", "lowest intensity branch"};
    public static final int NONE = 0;
    public static final int SHORTEST_BRANCH = 1;
    public static final int LOWEST_INTENSITY_VOXEL = 2;
    public static final int LOWEST_INTENSITY_BRANCH = 3;
    private ImageStack originalImage = null;
    public static int pruneIndex = 0;
    private int x_offset = 1;
    private int y_offset = 1;
    private int z_offset = 1;
    public static boolean verbose = false;
    protected boolean silent = false;
    private static final boolean debug = false;
    public static boolean displaySkeletons = false;

    public int setup(String arg, ImagePlus imp) {
        this.imRef = imp;
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        return 1;
    }

    public void run(ImageProcessor ip) {
        this.loadDialogSettings();
        this.createSettingsDialog();
        this.settingsDialog.showDialog();
        if (this.settingsDialog.wasCanceled()) {
            return;
        }
        this.setSettingsFromDialog();
        this.saveDialogSettings();
        ImagePlus origIP = null;
        switch (pruneIndex) {
            case 0: {
                this.bPruneCycles = false;
                break;
            }
            case 1: {
                this.bPruneCycles = true;
                break;
            }
            case 2: 
            case 3: {
                int[] ids = WindowManager.getIDList();
                if (ids == null || ids.length < 1) {
                    IJ.showMessage((String)"You should have at least one image open.");
                    return;
                }
                String[] titles = new String[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
                }
                GenericDialog gd2 = new GenericDialog("Image selection");
                gd2.addMessage("Select original grayscale image:");
                String current = WindowManager.getCurrentImage().getTitle();
                gd2.addChoice("original_image", titles, current);
                gd2.showDialog();
                if (gd2.wasCanceled()) {
                    return;
                }
                origIP = WindowManager.getImage((int)ids[gd2.getNextChoiceIndex()]);
                this.bPruneCycles = true;
                break;
            }
        }
        this.run(pruneIndex, pruneEnds, calculateShortestPath, origIP, false, verbose, protectRoi ? this.imRef.getRoi() : null);
        if (displaySkeletons) {
            ImagePlus labeledSkeletons = new ImagePlus(this.imRef.getShortTitle() + "-labeled-skeletons", this.labeledSkeletons.duplicate());
            IJ.run((ImagePlus)labeledSkeletons, (String)"Fire", null);
            labeledSkeletons.show();
        }
        this.showResults();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (this.imRef.getRoi() == null && null != gd && null != gd.getCheckboxes()) {
            Checkbox roiOption = (Checkbox)gd.getCheckboxes().elementAt(1);
            roiOption.setEnabled(false);
            if (Recorder.record) {
                roiOption.setState(false);
            }
        }
        return true;
    }

    public SkeletonResult run(int pruneIndex, boolean pruneEnds, boolean shortPath, ImagePlus origIP, boolean silent, boolean verbose) {
        return this.run(pruneIndex, pruneEnds, shortPath, origIP, silent, verbose, null);
    }

    public SkeletonResult run(int pruneIndex, boolean pruneEnds, boolean shortPath, ImagePlus origIP, boolean silent, boolean verbose, Roi roi) {
        AnalyzeSkeleton_.pruneIndex = pruneIndex;
        this.silent = silent;
        AnalyzeSkeleton_.pruneEnds = pruneEnds;
        calculateShortestPath = shortPath;
        AnalyzeSkeleton_.verbose = verbose;
        switch (pruneIndex) {
            case 0: {
                this.bPruneCycles = false;
                break;
            }
            case 1: {
                this.bPruneCycles = true;
                break;
            }
            case 2: 
            case 3: {
                this.calculateNeighborhoodOffsets(origIP.getCalibration());
                this.originalImage = origIP.getStack();
                this.bPruneCycles = true;
                break;
            }
        }
        this.width = this.imRef.getWidth();
        this.height = this.imRef.getHeight();
        this.depth = this.imRef.getStackSize();
        this.inputImage = this.imRef.getStack();
        this.resetVisited();
        this.processSkeleton(this.inputImage);
        if (pruneEnds) {
            this.pruneEndBranches(this.inputImage, this.taggedImage, roi);
        }
        if (this.bPruneCycles && this.pruneCycles(this.inputImage, this.originalImage, AnalyzeSkeleton_.pruneIndex)) {
            this.resetVisited();
            this.bPruneCycles = false;
            this.processSkeleton(this.inputImage);
        }
        this.calculateTripleAndQuadruplePoints();
        if (shortPath) {
            int i;
            this.shortPathImage = new ImageStack(this.width, this.height, this.inputImage.getColorModel());
            for (i = 1; i <= this.inputImage.getSize(); ++i) {
                this.shortPathImage.addSlice(this.inputImage.getSliceLabel(i), this.inputImage.getProcessor(i).duplicate());
            }
            this.shortestPathList = new ArrayList();
            this.shortestPathPoints = new ArrayList[this.numOfTrees];
            this.spStartPosition = new double[this.numOfTrees][3];
            for (i = 0; i < this.numOfTrees; ++i) {
                this.shortestPathPoints[i] = new ArrayList();
                this.shortestPath = this.warshallAlgorithm(this.graph[i], this.shortestPathPoints[i]);
                this.shortestPathList.add(this.shortestPath);
                this.spStartPosition[i][0] = (double)this.spx * this.imRef.getCalibration().pixelWidth;
                this.spStartPosition[i][1] = (double)this.spy * this.imRef.getCalibration().pixelHeight;
                this.spStartPosition[i][2] = (double)this.spz * this.imRef.getCalibration().pixelDepth;
            }
            if (!silent) {
                ImagePlus shortIP = new ImagePlus("Longest shortest paths", this.shortPathImage);
                shortIP.show();
                shortIP.setCalibration(this.imRef.getCalibration());
                IJ.run((ImagePlus)shortIP, (String)"Fire", null);
                shortIP.resetDisplayRange();
                shortIP.updateAndDraw();
            }
        }
        return this.assembleResults();
    }

    public SkeletonResult run(int pruneIndex, double thresholdLength, boolean shortPath, ImagePlus origIP, boolean silent, boolean verbose) {
        AnalyzeSkeleton_.pruneIndex = pruneIndex;
        this.silent = silent;
        pruneEnds = true;
        calculateShortestPath = shortPath;
        AnalyzeSkeleton_.verbose = verbose;
        switch (pruneIndex) {
            case 0: {
                this.bPruneCycles = false;
                break;
            }
            case 1: {
                this.bPruneCycles = true;
                break;
            }
            case 2: 
            case 3: {
                this.calculateNeighborhoodOffsets(origIP.getCalibration());
                this.originalImage = origIP.getStack();
                this.bPruneCycles = true;
                break;
            }
        }
        this.width = this.imRef.getWidth();
        this.height = this.imRef.getHeight();
        this.depth = this.imRef.getStackSize();
        this.inputImage = this.imRef.getStack();
        this.resetVisited();
        this.processSkeleton(this.inputImage);
        this.pruneEndBranches(this.inputImage, this.taggedImage, thresholdLength);
        if (this.bPruneCycles && this.pruneCycles(this.inputImage, this.originalImage, AnalyzeSkeleton_.pruneIndex)) {
            this.resetVisited();
            this.bPruneCycles = false;
            this.processSkeleton(this.inputImage);
        }
        this.calculateTripleAndQuadruplePoints();
        if (shortPath) {
            int i;
            this.shortPathImage = new ImageStack(this.width, this.height, this.inputImage.getColorModel());
            for (i = 1; i <= this.inputImage.getSize(); ++i) {
                this.shortPathImage.addSlice(this.inputImage.getSliceLabel(i), this.inputImage.getProcessor(i).duplicate());
            }
            this.shortestPathList = new ArrayList();
            this.shortestPathPoints = new ArrayList[this.numOfTrees];
            this.spStartPosition = new double[this.numOfTrees][3];
            for (i = 0; i < this.numOfTrees; ++i) {
                this.shortestPathPoints[i] = new ArrayList();
                this.shortestPath = this.warshallAlgorithm(this.graph[i], this.shortestPathPoints[i]);
                this.shortestPathList.add(this.shortestPath);
                this.spStartPosition[i][0] = (double)this.spx * this.imRef.getCalibration().pixelWidth;
                this.spStartPosition[i][1] = (double)this.spy * this.imRef.getCalibration().pixelHeight;
                this.spStartPosition[i][2] = (double)this.spz * this.imRef.getCalibration().pixelDepth;
            }
            if (!silent) {
                ImagePlus shortIP = new ImagePlus("Longest shortest paths", this.shortPathImage.duplicate());
                shortIP.show();
                shortIP.setCalibration(this.imRef.getCalibration());
                IJ.run((ImagePlus)shortIP, (String)"Fire", null);
                shortIP.resetDisplayRange();
                shortIP.updateAndDraw();
            }
        }
        return this.assembleResults();
    }

    public Graph[] getGraphs() {
        return this.graph;
    }

    public ArrayList<Point>[] getShortestPathPoints() {
        return this.shortestPathPoints;
    }

    public ArrayList<Point>[] getEndPointsTree() {
        return this.endPointsTree;
    }

    public ArrayList<Point> getEndPoints() {
        return this.listOfEndPoints;
    }

    public SkeletonResult run() {
        return this.run(0, false, false, null, true, false);
    }

    private void pruneEndBranches(ImageStack stack, ImageStack taggedImage, Roi roi) {
        for (int t = 0; t < this.numOfTrees; ++t) {
            Graph g = this.graph[t];
            ArrayList<Vertex> vertices = g.getVertices();
            ListIterator<Vertex> vit = vertices.listIterator();
            while (vit.hasNext()) {
                Vertex v = vit.next();
                if (v.getBranches().size() != 1 || !this.isEndPoint(v.getPoints().get(0), roi)) continue;
                ArrayList<Point> points = v.getPoints();
                int nPoints = points.size();
                block2: for (int i = 0; i < nPoints; ++i) {
                    Point p = points.get(i);
                    this.setPixel(stack, p.x, p.y, p.z, (byte)0);
                    this.setPixel(taggedImage, p.x, p.y, p.z, (byte)0);
                    int n = t;
                    this.numberOfEndPoints[n] = this.numberOfEndPoints[n] - 1;
                    --this.totalNumberOfEndPoints;
                    ListIterator<Point> pit = this.listOfEndPoints.listIterator();
                    while (pit.hasNext()) {
                        Point ep = (Point)pit.next();
                        if (!ep.equals(p)) continue;
                        pit.remove();
                        continue block2;
                    }
                }
                Edge branch = v.getBranches().get(0);
                points = branch.getSlabs();
                int nSlabs = points.size();
                block4: for (int i = 0; i < nSlabs; ++i) {
                    Point p = points.get(i);
                    this.setPixel(stack, p.x, p.y, p.z, (byte)0);
                    this.setPixel(taggedImage, p.x, p.y, p.z, (byte)0);
                    int n = t;
                    this.numberOfSlabs[n] = this.numberOfSlabs[n] - 1;
                    --this.totalNumberOfSlabs;
                    ListIterator<Point> pit = this.listOfSlabVoxels.listIterator();
                    while (pit.hasNext()) {
                        Point ep = (Point)pit.next();
                        if (!ep.equals(p)) continue;
                        pit.remove();
                        continue block4;
                    }
                }
                ArrayList<Edge> gEdges = this.graph[t].getEdges();
                ListIterator<Edge> git = gEdges.listIterator();
                while (git.hasNext()) {
                    Edge e = (Edge)git.next();
                    if (!e.equals(branch)) continue;
                    git.remove();
                    break;
                }
                Vertex opp = branch.getOppositeVertex(v);
                ArrayList<Edge> oppBranches = opp.getBranches();
                ListIterator<Edge> oppIt = oppBranches.listIterator();
                while (oppIt.hasNext()) {
                    Edge oppBranch = (Edge)oppIt.next();
                    if (!oppBranch.equals(branch)) continue;
                    oppIt.remove();
                    break;
                }
                v.getBranches().remove(0);
                vit.remove();
            }
        }
    }

    private void pruneEndBranches(ImageStack stack, ImageStack taggedImage, double length) {
        for (int t = 0; t < this.numOfTrees; ++t) {
            Graph g = this.graph[t];
            ArrayList<Vertex> vertices = g.getVertices();
            ListIterator<Vertex> vit = vertices.listIterator();
            while (vit.hasNext()) {
                Vertex v = vit.next();
                if (v.getBranches().size() != 1 || !(v.getBranches().get(0).getLength() <= length)) continue;
                ArrayList<Point> points = v.getPoints();
                int nPoints = points.size();
                block2: for (int i = 0; i < nPoints; ++i) {
                    Point p = points.get(i);
                    this.setPixel(stack, p.x, p.y, p.z, (byte)0);
                    this.setPixel(taggedImage, p.x, p.y, p.z, (byte)0);
                    int n = t;
                    this.numberOfEndPoints[n] = this.numberOfEndPoints[n] - 1;
                    --this.totalNumberOfEndPoints;
                    ListIterator<Point> pit = this.listOfEndPoints.listIterator();
                    while (pit.hasNext()) {
                        Point ep = (Point)pit.next();
                        if (!ep.equals(p)) continue;
                        pit.remove();
                        continue block2;
                    }
                }
                Edge branch = v.getBranches().get(0);
                points = branch.getSlabs();
                int nSlabs = points.size();
                block4: for (int i = 0; i < nSlabs; ++i) {
                    Point p = points.get(i);
                    this.setPixel(stack, p.x, p.y, p.z, (byte)0);
                    this.setPixel(taggedImage, p.x, p.y, p.z, (byte)0);
                    int n = t;
                    this.numberOfSlabs[n] = this.numberOfSlabs[n] - 1;
                    --this.totalNumberOfSlabs;
                    ListIterator<Point> pit = this.listOfSlabVoxels.listIterator();
                    while (pit.hasNext()) {
                        Point ep = (Point)pit.next();
                        if (!ep.equals(p)) continue;
                        pit.remove();
                        continue block4;
                    }
                }
                ArrayList<Edge> gEdges = this.graph[t].getEdges();
                ListIterator<Edge> git = gEdges.listIterator();
                while (git.hasNext()) {
                    Edge e = (Edge)git.next();
                    if (!e.equals(branch)) continue;
                    git.remove();
                    break;
                }
                Vertex opp = branch.getOppositeVertex(v);
                ArrayList<Edge> oppBranches = opp.getBranches();
                ListIterator<Edge> oppIt = oppBranches.listIterator();
                while (oppIt.hasNext()) {
                    Edge oppBranch = (Edge)oppIt.next();
                    if (!oppBranch.equals(branch)) continue;
                    oppIt.remove();
                    break;
                }
                v.getBranches().remove(0);
                vit.remove();
            }
        }
    }

    private void calculateNeighborhoodOffsets(Calibration calibration) {
        double max = calibration.pixelDepth;
        if (calibration.pixelHeight > max) {
            max = calibration.pixelHeight;
        }
        if (calibration.pixelWidth > max) {
            max = calibration.pixelWidth;
        }
        this.x_offset = (int)Math.round(max / calibration.pixelWidth) > 1 ? (int)Math.round(max / calibration.pixelWidth) : 1;
        this.y_offset = (int)Math.round(max / calibration.pixelHeight) > 1 ? (int)Math.round(max / calibration.pixelHeight) : 1;
        this.z_offset = (int)Math.round(max / calibration.pixelDepth) > 1 ? (int)Math.round(max / calibration.pixelDepth) : 1;
    }

    public void processSkeleton(ImageStack inputImage2) {
        this.listOfEndPoints = new ArrayList();
        this.listOfJunctionVoxels = new ArrayList();
        this.listOfSlabVoxels = new ArrayList();
        this.listOfStartingSlabVoxels = new ArrayList();
        this.totalNumberOfEndPoints = 0;
        this.totalNumberOfJunctionVoxels = 0;
        this.totalNumberOfSlabs = 0;
        this.taggedImage = this.tagImage(inputImage2);
        if (!this.bPruneCycles && !this.silent) {
            this.displayTagImage(this.taggedImage);
        }
        this.labeledSkeletons = this.markTrees(this.taggedImage);
        if (this.numOfTrees == 0) {
            return;
        }
        this.initializeTrees();
        if (this.numOfTrees > 1) {
            this.divideVoxelsByTrees(this.labeledSkeletons);
        }
        if (this.numOfTrees == 1) {
            this.endPointsTree[0] = this.listOfEndPoints;
            this.numberOfEndPoints[0] = this.listOfEndPoints.size();
            this.junctionVoxelTree[0] = this.listOfJunctionVoxels;
            this.numberOfJunctionVoxels[0] = this.listOfJunctionVoxels.size();
            this.startingSlabTree[0] = this.listOfStartingSlabVoxels;
        }
        this.groupJunctions(this.labeledSkeletons);
        this.resetVisited();
        for (int i = 0; i < this.numOfTrees; ++i) {
            this.visitSkeleton(this.taggedImage, this.labeledSkeletons, i + 1);
        }
    }

    private boolean pruneCycles(ImageStack inputImage, ImageStack originalImage, int pruningMode) {
        boolean pruned = false;
        for (int iTree = 0; iTree < this.numOfTrees; ++iTree) {
            if (this.startingSlabTree[iTree].size() == 1) {
                this.setPixel(inputImage, this.startingSlabTree[iTree].get(0), (byte)0);
                pruned = true;
                continue;
            }
            ArrayList<Edge> backEdges = this.graph[iTree].depthFirstSearch();
            if (backEdges.size() <= 0) continue;
            for (Edge e : backEdges) {
                Vertex backtrackVertex;
                ArrayList<Edge> loopEdges = new ArrayList<Edge>();
                loopEdges.add(e);
                Edge minEdge = e;
                Vertex finalLoopVertex = e.getV1().getVisitOrder() < e.getV2().getVisitOrder() ? e.getV1() : e.getV2();
                Vertex vertex = backtrackVertex = e.getV1().getVisitOrder() < e.getV2().getVisitOrder() ? e.getV2() : e.getV1();
                while (!finalLoopVertex.equals(backtrackVertex)) {
                    Edge pre = backtrackVertex.getPredecessor();
                    if (pruningMode == 1 && pre.getSlabs().size() < minEdge.getSlabs().size()) {
                        minEdge = pre;
                    }
                    loopEdges.add(pre);
                    backtrackVertex = pre.getV1().equals(backtrackVertex) ? pre.getV2() : pre.getV1();
                }
                if (pruningMode == 1) {
                    Point removeCoords = null;
                    removeCoords = minEdge.getSlabs().size() > 0 ? minEdge.getSlabs().get(minEdge.getSlabs().size() / 2) : minEdge.getV1().getPoints().get(0);
                    this.setPixel(inputImage, removeCoords, (byte)0);
                    continue;
                }
                if (pruningMode == 2) {
                    this.removeLowestIntensityVoxel(loopEdges, inputImage, originalImage);
                    continue;
                }
                if (pruningMode != 3) continue;
                this.cutLowestIntensityBranch(loopEdges, inputImage, originalImage);
            }
            pruned = true;
        }
        return pruned;
    }

    private void removeLowestIntensityVoxel(ArrayList<Edge> loopEdges, ImageStack inputImage2, ImageStack originalGrayImage) {
        Point lowestIntensityVoxel = null;
        double lowestIntensityValue = Double.MAX_VALUE;
        for (Edge e : loopEdges) {
            for (Point p : e.getSlabs()) {
                double avg = AnalyzeSkeleton_.getAverageNeighborhoodValue(originalGrayImage, p, this.x_offset, this.y_offset, this.z_offset);
                if (!(avg < lowestIntensityValue)) continue;
                lowestIntensityValue = avg;
                lowestIntensityVoxel = p;
            }
        }
        this.setPixel(inputImage2, lowestIntensityVoxel, (byte)0);
    }

    private void cutLowestIntensityBranch(ArrayList<Edge> loopEdges, ImageStack inputImage2, ImageStack originalGrayImage) {
        Edge lowestIntensityEdge = null;
        double lowestIntensityValue = Double.MAX_VALUE;
        Point cutPoint = null;
        for (Edge e : loopEdges) {
            double min_val = Double.MAX_VALUE;
            Point darkestPoint = null;
            double edgeIntensity = 0.0;
            double n_vox = 0.0;
            for (Point p : e.getSlabs()) {
                double avg = AnalyzeSkeleton_.getAverageNeighborhoodValue(originalGrayImage, p, this.x_offset, this.y_offset, this.z_offset);
                if (avg < min_val) {
                    min_val = avg;
                    darkestPoint = p;
                }
                edgeIntensity += avg;
                n_vox += 1.0;
            }
            for (Point p : e.getV1().getPoints()) {
                edgeIntensity += AnalyzeSkeleton_.getAverageNeighborhoodValue(originalGrayImage, p, this.x_offset, this.y_offset, this.z_offset);
                n_vox += 1.0;
            }
            for (Point p : e.getV2().getPoints()) {
                edgeIntensity += AnalyzeSkeleton_.getAverageNeighborhoodValue(originalGrayImage, p, this.x_offset, this.y_offset, this.z_offset);
                n_vox += 1.0;
            }
            if (n_vox != 0.0) {
                edgeIntensity /= n_vox;
            }
            if (!(edgeIntensity < lowestIntensityValue)) continue;
            lowestIntensityEdge = e;
            lowestIntensityValue = edgeIntensity;
            cutPoint = darkestPoint;
        }
        Point removeCoords = null;
        if (lowestIntensityEdge.getSlabs().size() > 0) {
            removeCoords = cutPoint;
        } else {
            IJ.error((String)("Lowest intensity branch without slabs?!: vertex " + lowestIntensityEdge.getV1().getPoints().get(0)));
            removeCoords = lowestIntensityEdge.getV1().getPoints().get(0);
        }
        this.setPixel(inputImage2, removeCoords, (byte)0);
    }

    void displayTagImage(ImageStack taggedImage) {
        int slices = this.imRef.getNSlices();
        int frames = this.imRef.getNFrames();
        int channels = this.imRef.getNChannels();
        ImagePlus tagIP = IJ.createHyperStack((String)"Tagged skeleton", (int)this.width, (int)this.height, (int)channels, (int)slices, (int)frames, (int)this.imRef.getBitDepth());
        tagIP.setStack(taggedImage.duplicate(), channels, slices, frames);
        tagIP.show();
        tagIP.setCalibration(this.imRef.getCalibration());
        IJ.run((ImagePlus)tagIP, (String)"Fire", null);
        tagIP.resetDisplayRange();
        tagIP.updateAndDraw();
    }

    private void divideVoxelsByTrees(ImageStack treeIS) {
        Point p;
        int i;
        for (i = 0; i < this.totalNumberOfEndPoints; ++i) {
            p = this.listOfEndPoints.get(i);
            this.endPointsTree[(int)this.getFloatPixel(treeIS, p) - 1].add(p);
        }
        for (i = 0; i < this.totalNumberOfJunctionVoxels; ++i) {
            p = this.listOfJunctionVoxels.get(i);
            this.junctionVoxelTree[(int)this.getFloatPixel(treeIS, p) - 1].add(p);
        }
        for (i = 0; i < this.listOfStartingSlabVoxels.size(); ++i) {
            p = this.listOfStartingSlabVoxels.get(i);
            this.startingSlabTree[(int)this.getFloatPixel(treeIS, p) - 1].add(p);
        }
        for (int iTree = 0; iTree < this.numOfTrees; ++iTree) {
            this.numberOfEndPoints[iTree] = this.endPointsTree[iTree].size();
            this.numberOfJunctionVoxels[iTree] = this.junctionVoxelTree[iTree].size();
        }
    }

    private void initializeTrees() {
        this.numberOfBranches = new int[this.numOfTrees];
        this.numberOfEndPoints = new int[this.numOfTrees];
        this.numberOfJunctionVoxels = new int[this.numOfTrees];
        this.numberOfJunctions = new int[this.numOfTrees];
        this.numberOfSlabs = new int[this.numOfTrees];
        this.numberOfTriplePoints = new int[this.numOfTrees];
        this.numberOfQuadruplePoints = new int[this.numOfTrees];
        this.averageBranchLength = new double[this.numOfTrees];
        this.maximumBranchLength = new double[this.numOfTrees];
        this.endPointsTree = new ArrayList[this.numOfTrees];
        this.junctionVoxelTree = new ArrayList[this.numOfTrees];
        this.startingSlabTree = new ArrayList[this.numOfTrees];
        this.listOfSingleJunctions = new ArrayList[this.numOfTrees];
        this.graph = new Graph[this.numOfTrees];
        for (int i = 0; i < this.numOfTrees; ++i) {
            this.endPointsTree[i] = new ArrayList();
            this.junctionVoxelTree[i] = new ArrayList();
            this.startingSlabTree[i] = new ArrayList();
            this.listOfSingleJunctions[i] = new ArrayList();
        }
        this.junctionVertex = new Vertex[this.numOfTrees][];
    }

    private void showResults() {
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(true);
        String[] head = new String[]{"Skeleton", "# Branches", "# Junctions", "# End-point voxels", "# Junction voxels", "# Slab voxels", "Average Branch Length", "# Triple points", "# Quadruple points", "Maximum Branch Length", "Longest Shortest Path", "spx", "spy", "spz"};
        for (int i = 0; i < this.numOfTrees; ++i) {
            rt.incrementCounter();
            rt.addValue(head[1], (double)this.numberOfBranches[i]);
            rt.addValue(head[2], (double)this.numberOfJunctions[i]);
            rt.addValue(head[3], (double)this.numberOfEndPoints[i]);
            rt.addValue(head[4], (double)this.numberOfJunctionVoxels[i]);
            rt.addValue(head[5], (double)this.numberOfSlabs[i]);
            rt.addValue(head[6], this.averageBranchLength[i]);
            rt.addValue(head[7], (double)this.numberOfTriplePoints[i]);
            rt.addValue(head[8], (double)this.numberOfQuadruplePoints[i]);
            rt.addValue(head[9], this.maximumBranchLength[i]);
            if (null != this.shortestPathList) {
                rt.addValue(head[10], this.shortestPathList.get(i).doubleValue());
                rt.addValue(head[11], this.spStartPosition[i][0]);
                rt.addValue(head[12], this.spStartPosition[i][1]);
                rt.addValue(head[13], this.spStartPosition[i][2]);
            }
            if (0 != i % 100) continue;
            rt.show("Results");
        }
        rt.show("Results");
        if (verbose) {
            ResultsTable extra_rt = new ResultsTable();
            rt.showRowNumbers(true);
            String[] extra_head = new String[]{"Branch", "Skeleton ID", "Branch length", "V1 x", "V1 y", "V1 z", "V2 x", "V2 y", "V2 z", "Euclidean distance", "running average length", "average intensity (inner 3rd)", "average intensity"};
            Comparator<Edge> comp = new Comparator<Edge>(){

                @Override
                public int compare(Edge o1, Edge o2) {
                    double diff = o1.getLength() - o2.getLength();
                    if (diff < 0.0) {
                        return 1;
                    }
                    if (diff == 0.0) {
                        return 0;
                    }
                    return -1;
                }

                @Override
                public boolean equals(Object o) {
                    return false;
                }
            };
            for (int i = 0; i < this.numOfTrees; ++i) {
                ArrayList<Edge> listEdges = this.graph[i].getEdges();
                Collections.sort(listEdges, comp);
                for (Edge e : listEdges) {
                    extra_rt.incrementCounter();
                    extra_rt.addValue(extra_head[1], (double)(i + 1));
                    extra_rt.addValue(extra_head[2], e.getLength());
                    extra_rt.addValue(extra_head[3], (double)e.getV1().getPoints().get((int)0).x * this.imRef.getCalibration().pixelWidth);
                    extra_rt.addValue(extra_head[4], (double)e.getV1().getPoints().get((int)0).y * this.imRef.getCalibration().pixelHeight);
                    extra_rt.addValue(extra_head[5], (double)e.getV1().getPoints().get((int)0).z * this.imRef.getCalibration().pixelDepth);
                    extra_rt.addValue(extra_head[6], (double)e.getV2().getPoints().get((int)0).x * this.imRef.getCalibration().pixelWidth);
                    extra_rt.addValue(extra_head[7], (double)e.getV2().getPoints().get((int)0).y * this.imRef.getCalibration().pixelHeight);
                    extra_rt.addValue(extra_head[8], (double)e.getV2().getPoints().get((int)0).z * this.imRef.getCalibration().pixelDepth);
                    extra_rt.addValue(extra_head[9], this.calculateDistance(e.getV1().getPoints().get(0), e.getV2().getPoints().get(0)));
                    extra_rt.addValue(extra_head[10], e.getLength_ra());
                    extra_rt.addValue(extra_head[11], e.getColor3rd());
                    extra_rt.addValue(extra_head[12], e.getColor());
                }
            }
            extra_rt.show("Branch information");
        }
    }

    public ImageStack getResultImage(boolean longestShortestPath) {
        if (longestShortestPath) {
            return this.shortPathImage;
        }
        return this.taggedImage;
    }

    protected SkeletonResult assembleResults() {
        SkeletonResult result = new SkeletonResult(this.numOfTrees);
        result.setBranches(this.numberOfBranches);
        result.setJunctions(this.numberOfJunctions);
        result.setEndPoints(this.numberOfEndPoints);
        result.setJunctionVoxels(this.numberOfJunctionVoxels);
        result.setSlabs(this.numberOfSlabs);
        result.setAverageBranchLength(this.averageBranchLength);
        result.setTriples(this.numberOfTriplePoints);
        result.setQuadruples(this.numberOfQuadruplePoints);
        result.setMaximumBranchLength(this.maximumBranchLength);
        result.setListOfEndPoints(this.listOfEndPoints);
        result.setListOfJunctionVoxels(this.listOfJunctionVoxels);
        result.setListOfSlabVoxels(this.listOfSlabVoxels);
        result.setListOfStartingSlabVoxels(this.listOfStartingSlabVoxels);
        result.setShortestPathList(this.shortestPathList);
        result.setSpStartPosition(this.spStartPosition);
        result.setGraph(this.graph);
        result.calculateNumberOfVoxels();
        return result;
    }

    private void visitSkeleton(ImageStack taggedImage, ImageStack treeImage, int currentTree) {
        double length;
        int i;
        int iTree = currentTree - 1;
        this.graph[iTree] = new Graph();
        for (int i2 = 0; i2 < this.junctionVertex[iTree].length; ++i2) {
            this.graph[iTree].addVertex(this.junctionVertex[iTree][i2]);
        }
        double branchLength = 0.0;
        this.maximumBranchLength[iTree] = 0.0;
        this.numberOfSlabs[iTree] = 0;
        for (i = 0; i < this.numberOfEndPoints[iTree]; ++i) {
            Point aux;
            Point endPointCoord = this.endPointsTree[iTree].get(i);
            if (this.isVisited(endPointCoord)) continue;
            Vertex v1 = new Vertex();
            v1.addPoint(endPointCoord);
            this.graph[iTree].addVertex(v1);
            if (i == 0) {
                this.graph[iTree].setRoot(v1);
            }
            this.slabList = new ArrayList();
            double[] properties = this.visitBranch(endPointCoord, iTree);
            length = properties[0];
            double color3rd = properties[1];
            double color = properties[2];
            double length_ra = properties[3];
            if (length == 0.0) {
                aux = this.getVisitedJunctionNeighbor(endPointCoord, v1);
                if (null == aux) continue;
                this.auxFinalVertex = this.findPointVertex(this.junctionVertex[iTree], aux);
                length += this.calculateDistance(endPointCoord, aux);
                this.graph[iTree].addVertex(this.auxFinalVertex);
                this.graph[iTree].addEdge(new Edge(v1, this.auxFinalVertex, this.slabList, length += this.calculateDistance(this.auxFinalVertex.getPoints().get(0), endPointCoord), color3rd, color, length_ra));
                int n = iTree;
                this.numberOfBranches[n] = this.numberOfBranches[n] + 1;
                branchLength += length;
                continue;
            }
            if (this.isSlab(this.auxPoint)) {
                aux = this.auxPoint;
                this.auxPoint = this.getVisitedJunctionNeighbor(this.auxPoint, v1);
                this.auxFinalVertex = this.findPointVertex(this.junctionVertex[iTree], this.auxPoint);
                if (this.auxPoint == null) {
                    this.auxFinalVertex = v1;
                    this.auxPoint = aux;
                }
                length += this.calculateDistance(this.auxPoint, aux);
                length += this.calculateDistance(this.auxFinalVertex.getPoints().get(0), this.auxPoint);
            }
            this.graph[iTree].addVertex(this.auxFinalVertex);
            this.graph[iTree].addEdge(new Edge(v1, this.auxFinalVertex, this.slabList, length, color3rd, color, length_ra));
            int n = iTree;
            this.numberOfBranches[n] = this.numberOfBranches[n] + 1;
            branchLength += length;
            if (!(length > this.maximumBranchLength[iTree])) continue;
            this.maximumBranchLength[iTree] = length;
        }
        if (this.numberOfEndPoints[iTree] == 0 && this.junctionVoxelTree[iTree].size() > 0) {
            this.graph[iTree].setRoot(this.junctionVertex[iTree][0]);
        }
        for (i = 0; i < this.junctionVertex[iTree].length; ++i) {
            for (int j = 0; j < this.junctionVertex[iTree][i].getPoints().size(); ++j) {
                Point junctionCoord = this.junctionVertex[iTree][i].getPoints().get(j);
                this.setVisited(junctionCoord, true);
                Point nextPoint = this.getNextUnvisitedVoxel(junctionCoord);
                while (nextPoint != null) {
                    if (!this.isJunction(nextPoint)) {
                        this.slabList = new ArrayList();
                        this.slabList.add(nextPoint);
                        int n = iTree;
                        this.numberOfSlabs[n] = this.numberOfSlabs[n] + 1;
                        length = this.calculateDistance(junctionCoord, nextPoint);
                        this.auxPoint = null;
                        double[] properties = this.visitBranch(nextPoint, iTree);
                        double color3rd = properties[1];
                        double color = properties[2];
                        double length_ra = properties[3];
                        if ((length += properties[0]) != 0.0) {
                            if (this.auxPoint == null) {
                                this.auxPoint = nextPoint;
                            }
                            int n2 = iTree;
                            this.numberOfBranches[n2] = this.numberOfBranches[n2] + 1;
                            Vertex initialVertex = null;
                            for (int k = 0; k < this.junctionVertex[iTree].length; ++k) {
                                if (!this.junctionVertex[iTree][k].isVertexPoint(junctionCoord)) continue;
                                initialVertex = this.junctionVertex[iTree][k];
                                break;
                            }
                            if (this.isSlab(this.auxPoint)) {
                                Point aux = this.auxPoint;
                                this.auxPoint = this.getVisitedJunctionNeighbor(this.auxPoint, initialVertex);
                                this.auxFinalVertex = this.findPointVertex(this.junctionVertex[iTree], this.auxPoint);
                                if (this.auxPoint == null) {
                                    this.auxFinalVertex = initialVertex;
                                    this.auxPoint = aux;
                                }
                                length += this.calculateDistance(this.auxPoint, aux);
                            }
                            if (length > this.maximumBranchLength[iTree]) {
                                this.maximumBranchLength[iTree] = length;
                            }
                            this.graph[iTree].addEdge(new Edge(initialVertex, this.auxFinalVertex, this.slabList, length += this.calculateDistance(initialVertex.getPoints().get(0), junctionCoord), color3rd, color, length_ra));
                            branchLength += length;
                            if (length > this.maximumBranchLength[iTree]) {
                                this.maximumBranchLength[iTree] = length;
                            }
                        }
                    } else {
                        this.setVisited(nextPoint, true);
                    }
                    nextPoint = this.getNextUnvisitedVoxel(junctionCoord);
                }
            }
        }
        if (this.startingSlabTree[iTree].size() == 1) {
            Point startCoord = this.startingSlabTree[iTree].get(0);
            Vertex v1 = new Vertex();
            v1.addPoint(startCoord);
            this.graph[iTree].addVertex(v1);
            this.slabList = new ArrayList();
            this.slabList.add(startCoord);
            int n = iTree;
            this.numberOfSlabs[n] = this.numberOfSlabs[n] + 1;
            double[] properties = this.visitBranch(startCoord, iTree);
            double length2 = properties[0];
            double color3rd = properties[1];
            double color = properties[2];
            double length_ra = properties[3];
            if (length2 != 0.0) {
                int n3 = iTree;
                this.numberOfBranches[n3] = this.numberOfBranches[n3] + 1;
                branchLength += length2;
                if (length2 > this.maximumBranchLength[iTree]) {
                    this.maximumBranchLength[iTree] = length2;
                }
            }
            this.graph[iTree].addEdge(new Edge(v1, v1, this.slabList, length2, color3rd, color, length_ra));
        }
        if (this.numberOfBranches[iTree] == 0) {
            return;
        }
        this.averageBranchLength[iTree] = branchLength / (double)this.numberOfBranches[iTree];
    }

    private ImageStack markTrees(ImageStack taggedImage) {
        int length;
        int i;
        ImageStack outputImage = new ImageStack(this.width, this.height);
        for (int z = 0; z < this.depth; ++z) {
            outputImage.addSlice(taggedImage.getSliceLabel(z + 1), (ImageProcessor)new FloatProcessor(this.width, this.height));
        }
        this.numOfTrees = 0;
        int color = 0;
        for (i = 0; i < this.totalNumberOfEndPoints; ++i) {
            Point endPointCoord = this.listOfEndPoints.get(i);
            if (this.isVisited(endPointCoord)) continue;
            if (++color == Integer.MAX_VALUE) {
                IJ.error((String)"More than 2147483646 skeletons in the image. AnalyzeSkeleton can only process up to 2147483646");
                return null;
            }
            int numOfVoxelsInTree = this.visitTree(endPointCoord, outputImage, color);
            ++this.numOfTrees;
        }
        for (i = 0; i < this.totalNumberOfJunctionVoxels; ++i) {
            Point junctionCoord = this.listOfJunctionVoxels.get(i);
            if (this.isVisited(junctionCoord)) continue;
            if (++color == Integer.MAX_VALUE) {
                IJ.error((String)"More than 2147483646 skeletons in the image. AnalyzeSkeleton can only process up to 2147483646");
                return null;
            }
            length = this.visitTree(junctionCoord, outputImage, color);
            if (length == 0) {
                --color;
                continue;
            }
            ++this.numOfTrees;
        }
        for (i = 0; i < this.listOfSlabVoxels.size(); ++i) {
            Point p = this.listOfSlabVoxels.get(i);
            if (this.isVisited(p)) continue;
            this.listOfStartingSlabVoxels.add(p);
            if (++color == Integer.MAX_VALUE) {
                IJ.error((String)"More than 2147483646 skeletons in the image. AnalyzeSkeleton can only process up to 2147483646");
                return null;
            }
            length = this.visitTree(p, outputImage, color);
            if (length == 0) {
                --color;
                continue;
            }
            ++this.numOfTrees;
        }
        this.resetVisited();
        return outputImage;
    }

    private int visitTree(Point startingPoint, ImageStack outputImage, int color) {
        int numOfVoxels = 0;
        if (this.isVisited(startingPoint)) {
            return 0;
        }
        this.setPixel(outputImage, startingPoint.x, startingPoint.y, startingPoint.z, color);
        this.setVisited(startingPoint, true);
        ArrayList<Point> toRevisit = new ArrayList<Point>();
        if (this.isJunction(startingPoint)) {
            toRevisit.add(startingPoint);
        }
        Point nextPoint = this.getNextUnvisitedVoxel(startingPoint);
        while (nextPoint != null || toRevisit.size() != 0) {
            if (nextPoint != null) {
                if (this.isVisited(nextPoint)) continue;
                ++numOfVoxels;
                this.setPixel(outputImage, nextPoint.x, nextPoint.y, nextPoint.z, color);
                this.setVisited(nextPoint, true);
                if (this.isJunction(nextPoint)) {
                    toRevisit.add(nextPoint);
                }
                nextPoint = this.getNextUnvisitedVoxel(nextPoint);
                continue;
            }
            nextPoint = (Point)toRevisit.get(0);
            if ((nextPoint = this.getNextUnvisitedVoxel(nextPoint)) != null) continue;
            toRevisit.remove(0);
        }
        return numOfVoxels;
    }

    private double visitBranch(Point startingPoint) {
        double length = 0.0;
        this.setVisited(startingPoint, true);
        Point nextPoint = this.getNextUnvisitedVoxel(startingPoint);
        if (nextPoint == null) {
            return 0.0;
        }
        Point previousPoint = startingPoint;
        while (nextPoint != null && this.isSlab(nextPoint)) {
            length += this.calculateDistance(previousPoint, nextPoint);
            this.setVisited(nextPoint, true);
            previousPoint = nextPoint;
            nextPoint = this.getNextUnvisitedVoxel(previousPoint);
        }
        if (nextPoint != null) {
            length += this.calculateDistance(previousPoint, nextPoint);
            this.setVisited(nextPoint, true);
        }
        this.auxPoint = previousPoint;
        return length;
    }

    private double[] visitBranch(Point startingPoint, int iTree) {
        double length = 0.0;
        double intensity = 0.0;
        double intensity3rd = 0.0;
        double length_ra = 0.0;
        double[] ret = new double[4];
        ArrayList<Point> pointHistory = new ArrayList<Point>(0);
        pointHistory.add(0, startingPoint);
        this.setVisited(startingPoint, true);
        Point nextPoint = this.getNextUnvisitedVoxel(startingPoint);
        if (nextPoint == null) {
            return ret;
        }
        Point previousPoint = startingPoint;
        while (nextPoint != null && this.isSlab(nextPoint)) {
            int n = iTree;
            this.numberOfSlabs[n] = this.numberOfSlabs[n] + 1;
            this.slabList.add(nextPoint);
            length += this.calculateDistance(previousPoint, nextPoint);
            pointHistory.add(0, nextPoint);
            length_ra += this.calculateDistance(pointHistory);
            this.setVisited(nextPoint, true);
            previousPoint = nextPoint;
            nextPoint = this.getNextUnvisitedVoxel(previousPoint);
        }
        if (nextPoint != null) {
            length += this.calculateDistance(previousPoint, nextPoint);
            pointHistory.add(0, nextPoint);
            length_ra += this.calculateDistance(pointHistory);
            this.setVisited(nextPoint, true);
            if (this.isEndPoint(nextPoint)) {
                this.auxFinalVertex = new Vertex();
                this.auxFinalVertex.addPoint(nextPoint);
            } else if (this.isJunction(nextPoint)) {
                this.auxFinalVertex = this.findPointVertex(this.junctionVertex[iTree], nextPoint);
                length += this.calculateDistance(this.auxFinalVertex.getPoints().get(0), nextPoint);
                length_ra += this.calculateDistance(this.auxFinalVertex.getPoints().get(0), nextPoint);
            }
            this.auxPoint = nextPoint;
        } else {
            this.auxPoint = previousPoint;
        }
        int size = pointHistory.size();
        int start = (int)((double)size / 3.0);
        int end = (int)((double)(2 * size) / 3.0);
        for (int i = 0; i < size; ++i) {
            int value = this.getPixel(this.inputImage, (Point)pointHistory.get(i));
            if (value < 0) {
                value += 256;
            }
            intensity += (double)value;
            if (i < start || i >= end) continue;
            intensity3rd += (double)value;
        }
        ret[0] = length;
        ret[1] = intensity3rd /= (double)(end - start);
        ret[2] = intensity /= (double)size;
        ret[3] = length_ra;
        return ret;
    }

    public Vertex findPointVertex(Vertex[] vertex, Point p) {
        int j = 0;
        for (j = 0; j < vertex.length; ++j) {
            if (!vertex[j].isVertexPoint(p)) continue;
            return vertex[j];
        }
        return null;
    }

    public double calculateDistance(Point point1, Point point2) {
        double dx = (double)(point1.x - point2.x) * this.imRef.getCalibration().pixelWidth;
        double dy = (double)(point1.y - point2.y) * this.imRef.getCalibration().pixelHeight;
        double dz = (double)(point1.z - point2.z) * this.imRef.getCalibration().pixelDepth;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private double calculateDistance(List<Point> Points) {
        int indexOfLast = Points.size() - 1;
        if (indexOfLast < 1) {
            return 0.0;
        }
        int poi = 5;
        if (indexOfLast < 5) {
            poi = indexOfLast;
        }
        return this.calculateDistance(Points.get(poi), Points.get(0)) / (double)poi;
    }

    private void groupJunctions(ImageStack treeIS) {
        int iTree;
        this.resetVisited();
        for (iTree = 0; iTree < this.numOfTrees; ++iTree) {
            for (int i = 0; i < this.numberOfJunctionVoxels[iTree]; ++i) {
                Point pi = this.junctionVoxelTree[iTree].get(i);
                if (this.isVisited(pi)) continue;
                this.fusionNeighborJunction(pi, this.listOfSingleJunctions[iTree]);
            }
        }
        for (iTree = 0; iTree < this.numOfTrees; ++iTree) {
            this.numberOfJunctions[iTree] = this.listOfSingleJunctions[iTree].size();
            this.junctionVertex[iTree] = new Vertex[this.listOfSingleJunctions[iTree].size()];
            for (int j = 0; j < this.listOfSingleJunctions[iTree].size(); ++j) {
                ArrayList<Point> list = this.listOfSingleJunctions[iTree].get(j);
                this.junctionVertex[iTree][j] = new Vertex();
                for (Point p : list) {
                    this.junctionVertex[iTree][j].addPoint(p);
                }
            }
        }
        this.resetVisited();
    }

    private void resetVisited() {
        this.visited = null;
        this.visited = new boolean[this.width][this.height][this.depth];
    }

    private void fusionNeighborJunction(Point startingPoint, ArrayList<ArrayList<Point>> singleJunctionsList) {
        ArrayList<Point> newGroup = new ArrayList<Point>();
        newGroup.add(startingPoint);
        this.setVisited(startingPoint, true);
        ArrayList<Point> toRevisit = new ArrayList<Point>();
        toRevisit.add(startingPoint);
        Point nextPoint = this.getNextUnvisitedJunctionVoxel(startingPoint);
        while (nextPoint != null || toRevisit.size() != 0) {
            if (nextPoint != null && !this.isVisited(nextPoint)) {
                newGroup.add(nextPoint);
                this.setVisited(nextPoint, true);
                toRevisit.add(nextPoint);
                nextPoint = this.getNextUnvisitedJunctionVoxel(nextPoint);
                continue;
            }
            nextPoint = (Point)toRevisit.get(0);
            if ((nextPoint = this.getNextUnvisitedJunctionVoxel(nextPoint)) != null) continue;
            toRevisit.remove(0);
        }
        singleJunctionsList.add(newGroup);
    }

    boolean checkNeighborGroups(ArrayList<Point> g1, ArrayList<Point> g2) {
        for (int i = 0; i < g1.size(); ++i) {
            Point pi = g1.get(i);
            for (int j = 0; j < g2.size(); ++j) {
                Point pj = g2.get(j);
                if (!this.isNeighbor(pi, pj)) continue;
                return true;
            }
        }
        return false;
    }

    private void calculateTripleAndQuadruplePoints() {
        for (int iTree = 0; iTree < this.numOfTrees; ++iTree) {
            for (int i = 0; i < this.numberOfJunctions[iTree]; ++i) {
                ArrayList<Point> groupOfJunctions = this.listOfSingleJunctions[iTree].get(i);
                int nBranch = 0;
                for (int j = 0; j < groupOfJunctions.size(); ++j) {
                    Point pj = groupOfJunctions.get(j);
                    byte[] neighborhood = this.getNeighborhood(this.taggedImage, pj.x, pj.y, pj.z);
                    for (int k = 0; k < 27; ++k) {
                        if (neighborhood[k] != SLAB && neighborhood[k] != END_POINT) continue;
                        ++nBranch;
                    }
                }
                if (nBranch == 3) {
                    int n = iTree;
                    this.numberOfTriplePoints[n] = this.numberOfTriplePoints[n] + 1;
                    continue;
                }
                if (nBranch != 4) continue;
                int n = iTree;
                this.numberOfQuadruplePoints[n] = this.numberOfQuadruplePoints[n] + 1;
            }
        }
    }

    private boolean isNeighbor(Point point1, Point point2) {
        return Math.sqrt(Math.pow(point1.x - point2.x, 2.0) + Math.pow(point1.y - point2.y, 2.0) + Math.pow(point1.z - point2.z, 2.0)) <= Math.sqrt(3.0);
    }

    private boolean isSlab(Point point) {
        return AnalyzeSkeleton_.getPixel(this.taggedImage, point.x, point.y, point.z) == SLAB;
    }

    private boolean isJunction(Point point) {
        return AnalyzeSkeleton_.getPixel(this.taggedImage, point.x, point.y, point.z) == JUNCTION;
    }

    private boolean isEndPoint(Point point) {
        return AnalyzeSkeleton_.getPixel(this.taggedImage, point.x, point.y, point.z) == END_POINT;
    }

    private boolean isEndPoint(Point point, Roi roi) {
        boolean endPoint = this.isEndPoint(point);
        if (endPoint && roi != null) {
            boolean roiContainsZ = roi.getPosition() == 0 ? true : roi.getPosition() == point.z;
            endPoint = !roi.contains(point.x, point.y) || !roiContainsZ;
        }
        return endPoint;
    }

    private boolean isJunction(int x, int y, int z) {
        return AnalyzeSkeleton_.getPixel(this.taggedImage, x, y, z) == JUNCTION;
    }

    private Point getNextUnvisitedVoxel(Point point) {
        Point unvisitedNeighbor = null;
        for (int x = -1; x < 2; ++x) {
            block1: for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && y == 0 && z == 0 || AnalyzeSkeleton_.getPixel(this.inputImage, point.x + x, point.y + y, point.z + z) == 0 || this.isVisited(point.x + x, point.y + y, point.z + z)) continue;
                    unvisitedNeighbor = new Point(point.x + x, point.y + y, point.z + z);
                    continue block1;
                }
            }
        }
        return unvisitedNeighbor;
    }

    private Point getNextUnvisitedJunctionVoxel(Point point) {
        Point unvisitedNeighbor = null;
        for (int x = -1; x < 2; ++x) {
            block1: for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && y == 0 && z == 0 || AnalyzeSkeleton_.getPixel(this.inputImage, point.x + x, point.y + y, point.z + z) == 0 || this.isVisited(point.x + x, point.y + y, point.z + z) || !this.isJunction(point.x + x, point.y + y, point.z + z)) continue;
                    unvisitedNeighbor = new Point(point.x + x, point.y + y, point.z + z);
                    continue block1;
                }
            }
        }
        return unvisitedNeighbor;
    }

    private Point getVisitedJunctionNeighbor(Point point, Vertex exclude) {
        Point finalNeighbor = null;
        for (int x = -1; x < 2; ++x) {
            block1: for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    Point neighbor;
                    if (x == 0 && y == 0 && z == 0 || this.getPixel(this.inputImage, neighbor = new Point(point.x + x, point.y + y, point.z + z)) == 0 || !this.isVisited(neighbor) || !this.isJunction(neighbor) || exclude.getPoints().contains(neighbor)) continue;
                    finalNeighbor = neighbor;
                    continue block1;
                }
            }
        }
        return finalNeighbor;
    }

    private boolean isVisited(Point point) {
        return this.isVisited(point.x, point.y, point.z);
    }

    private boolean isVisited(int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            return this.visited[x][y][z];
        }
        return true;
    }

    private void setVisited(int x, int y, int z, boolean b) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            this.visited[x][y][z] = b;
        }
    }

    private void setVisited(Point point, boolean b) {
        int x = point.x;
        int y = point.y;
        int z = point.z;
        this.setVisited(x, y, z, b);
    }

    private ImageStack tagImage(ImageStack inputImage2) {
        ImageStack outputImage = new ImageStack(this.width, this.height, inputImage2.getColorModel());
        for (int z = 0; z < this.depth; ++z) {
            outputImage.addSlice(inputImage2.getSliceLabel(z + 1), (ImageProcessor)new ByteProcessor(this.width, this.height));
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (AnalyzeSkeleton_.getPixel(inputImage2, x, y, z) == 0) continue;
                    int numOfNeighbors = this.getNumberOfNeighbors(inputImage2, x, y, z);
                    if (numOfNeighbors < 2) {
                        this.setPixel(outputImage, x, y, z, END_POINT);
                        ++this.totalNumberOfEndPoints;
                        Point endPoint = new Point(x, y, z);
                        this.listOfEndPoints.add(endPoint);
                        continue;
                    }
                    if (numOfNeighbors > 2) {
                        this.setPixel(outputImage, x, y, z, JUNCTION);
                        Point junction = new Point(x, y, z);
                        this.listOfJunctionVoxels.add(junction);
                        ++this.totalNumberOfJunctionVoxels;
                        continue;
                    }
                    this.setPixel(outputImage, x, y, z, SLAB);
                    Point slab = new Point(x, y, z);
                    this.listOfSlabVoxels.add(slab);
                    ++this.totalNumberOfSlabs;
                }
            }
        }
        return outputImage;
    }

    private int getNumberOfNeighbors(ImageStack image, int x, int y, int z) {
        int n = 0;
        byte[] neighborhood = this.getNeighborhood(image, x, y, z);
        for (int i = 0; i < 27; ++i) {
            if (neighborhood[i] == 0) continue;
            ++n;
        }
        return n - 1;
    }

    private double getAverageNeighborhoodValue(ImageStack image, Point p) {
        byte[] neighborhood = this.getNeighborhood(image, p);
        double avg = 0.0;
        for (int i = 0; i < neighborhood.length; ++i) {
            avg += (double)(neighborhood[i] & 0xFF);
        }
        if (neighborhood.length > 0) {
            return avg / (double)neighborhood.length;
        }
        return 0.0;
    }

    public static double getAverageNeighborhoodValue(ImageStack image, Point p, int x_offset, int y_offset, int z_offset) {
        byte[] neighborhood = AnalyzeSkeleton_.getNeighborhood(image, p, x_offset, y_offset, z_offset);
        double avg = 0.0;
        for (int i = 0; i < neighborhood.length; ++i) {
            avg += (double)(neighborhood[i] & 0xFF);
        }
        if (neighborhood.length > 0) {
            return avg / (double)neighborhood.length;
        }
        return 0.0;
    }

    public static byte[] getNeighborhood(ImageStack image, Point p, int x_offset, int y_offset, int z_offset) {
        byte[] neighborhood = new byte[(2 * x_offset + 1) * (2 * y_offset + 1) * (2 * z_offset + 1)];
        int l = 0;
        for (int k = p.z - z_offset; k <= p.z + z_offset; ++k) {
            for (int j = p.y - y_offset; j <= p.y + y_offset; ++j) {
                int i = p.x - x_offset;
                while (i <= p.x + x_offset) {
                    neighborhood[l] = AnalyzeSkeleton_.getPixel(image, i, j, k);
                    ++i;
                    ++l;
                }
            }
        }
        return neighborhood;
    }

    private byte[] getNeighborhood(ImageStack image, Point p) {
        return this.getNeighborhood(image, p.x, p.y, p.z);
    }

    private byte[] getNeighborhood(ImageStack image, int x, int y, int z) {
        byte[] neighborhood = new byte[]{AnalyzeSkeleton_.getPixel(image, x - 1, y - 1, z - 1), AnalyzeSkeleton_.getPixel(image, x, y - 1, z - 1), AnalyzeSkeleton_.getPixel(image, x + 1, y - 1, z - 1), AnalyzeSkeleton_.getPixel(image, x - 1, y, z - 1), AnalyzeSkeleton_.getPixel(image, x, y, z - 1), AnalyzeSkeleton_.getPixel(image, x + 1, y, z - 1), AnalyzeSkeleton_.getPixel(image, x - 1, y + 1, z - 1), AnalyzeSkeleton_.getPixel(image, x, y + 1, z - 1), AnalyzeSkeleton_.getPixel(image, x + 1, y + 1, z - 1), AnalyzeSkeleton_.getPixel(image, x - 1, y - 1, z), AnalyzeSkeleton_.getPixel(image, x, y - 1, z), AnalyzeSkeleton_.getPixel(image, x + 1, y - 1, z), AnalyzeSkeleton_.getPixel(image, x - 1, y, z), AnalyzeSkeleton_.getPixel(image, x, y, z), AnalyzeSkeleton_.getPixel(image, x + 1, y, z), AnalyzeSkeleton_.getPixel(image, x - 1, y + 1, z), AnalyzeSkeleton_.getPixel(image, x, y + 1, z), AnalyzeSkeleton_.getPixel(image, x + 1, y + 1, z), AnalyzeSkeleton_.getPixel(image, x - 1, y - 1, z + 1), AnalyzeSkeleton_.getPixel(image, x, y - 1, z + 1), AnalyzeSkeleton_.getPixel(image, x + 1, y - 1, z + 1), AnalyzeSkeleton_.getPixel(image, x - 1, y, z + 1), AnalyzeSkeleton_.getPixel(image, x, y, z + 1), AnalyzeSkeleton_.getPixel(image, x + 1, y, z + 1), AnalyzeSkeleton_.getPixel(image, x - 1, y + 1, z + 1), AnalyzeSkeleton_.getPixel(image, x, y + 1, z + 1), AnalyzeSkeleton_.getPixel(image, x + 1, y + 1, z + 1)};
        return neighborhood;
    }

    public static byte getPixel(ImageStack image, int x, int y, int z) {
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = image.getSize();
        if (x >= 0 && x < width && y >= 0 && y < height && z >= 0 && z < depth) {
            return ((byte[])image.getPixels(z + 1))[x + y * width];
        }
        return 0;
    }

    private float getFloatPixel(ImageStack image, int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            return ((float[])image.getPixels(z + 1))[x + y * this.width];
        }
        return 0.0f;
    }

    private float getFloatPixel(ImageStack image, Point point) {
        return this.getFloatPixel(image, point.x, point.y, point.z);
    }

    private byte getPixel(ImageStack image, Point point) {
        return AnalyzeSkeleton_.getPixel(image, point.x, point.y, point.z);
    }

    private void setPixel(ImageStack image, Point p, byte value) {
        if (p.x >= 0 && p.x < this.width && p.y >= 0 && p.y < this.height && p.z >= 0 && p.z < this.depth) {
            ((byte[])image.getPixels((int)(p.z + 1)))[p.x + p.y * this.width] = value;
        }
    }

    private void setPixel(ImageStack image, int x, int y, int z, byte value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            ((byte[])image.getPixels((int)(z + 1)))[x + y * this.width] = value;
        }
    }

    private void setPixel(ImageStack image, int x, int y, int z, float value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            ((float[])image.getPixels((int)(z + 1)))[x + y * this.width] = value;
        }
    }

    void showAbout() {
        IJ.showMessage((String)"About AnalyzeSkeleton...", (String)"This plug-in filter analyzes a 2D/3D image skeleton.\n");
    }

    private double warshallAlgorithm(Graph graph, ArrayList<Point> shortestPathPoints) {
        Vertex v1 = null;
        Vertex v2 = null;
        int row = 0;
        int column = 0;
        double maxPath = 0.0;
        int a = 0;
        int b = 0;
        ArrayList<Edge> edgeList = graph.getEdges();
        ArrayList<Vertex> vertexList = graph.getVertices();
        if (vertexList.size() == 1) {
            shortestPathPoints.add(vertexList.get(0).getPoints().get(0));
            this.spx = vertexList.get((int)0).getPoints().get((int)0).x;
            this.spy = vertexList.get((int)0).getPoints().get((int)0).y;
            this.spz = vertexList.get((int)0).getPoints().get((int)0).z;
            return 0.0;
        }
        double[][] adjacencyMatrix = new double[vertexList.size()][vertexList.size()];
        int[][] predecessorMatrix = new int[vertexList.size()][vertexList.size()];
        for (int i = 0; i < vertexList.size(); ++i) {
            for (int j = 0; j < vertexList.size(); ++j) {
                adjacencyMatrix[i][j] = Double.POSITIVE_INFINITY;
                predecessorMatrix[i][j] = -1;
            }
        }
        for (Edge edge : edgeList) {
            v1 = edge.getV1();
            v2 = edge.getV2();
            row = vertexList.indexOf(v1);
            if (row == -1) {
                IJ.log((String)("Vertex " + v1.getPoints().get(0) + " not found in the list of vertices!"));
                continue;
            }
            column = vertexList.indexOf(v2);
            if (column == -1) {
                IJ.log((String)("Vertex " + v2.getPoints().get(0) + " not found in the list of vertices!"));
                continue;
            }
            adjacencyMatrix[row][row] = 0.0;
            adjacencyMatrix[column][column] = 0.0;
            adjacencyMatrix[row][column] = edge.getLength();
            adjacencyMatrix[column][row] = edge.getLength();
            predecessorMatrix[row][row] = -1;
            predecessorMatrix[column][column] = -1;
            predecessorMatrix[row][column] = row;
            predecessorMatrix[column][row] = column;
        }
        for (int k = 0; k < vertexList.size(); ++k) {
            for (int i = 0; i < vertexList.size(); ++i) {
                for (int j = 0; j < vertexList.size(); ++j) {
                    if (!(adjacencyMatrix[i][k] + adjacencyMatrix[k][j] < adjacencyMatrix[i][j])) continue;
                    adjacencyMatrix[i][j] = adjacencyMatrix[i][k] + adjacencyMatrix[k][j];
                    predecessorMatrix[i][j] = predecessorMatrix[k][j];
                }
            }
        }
        for (int i = 0; i < vertexList.size(); ++i) {
            for (int j = 0; j < vertexList.size(); ++j) {
                if (!(adjacencyMatrix[i][j] > maxPath) || adjacencyMatrix[i][j] == Double.POSITIVE_INFINITY) continue;
                maxPath = adjacencyMatrix[i][j];
                a = i;
                b = j;
            }
        }
        this.reconstructPath(predecessorMatrix, a, b, edgeList, vertexList, shortestPathPoints);
        return maxPath;
    }

    private void reconstructPath(int[][] predecessorMatrix, int startIndex, int endIndex, ArrayList<Edge> edgeList, ArrayList<Vertex> vertexList, ArrayList<Point> shortestPathPoints) {
        int b = endIndex;
        int a = startIndex;
        while (b != a) {
            Object p2;
            Vertex predecessor = vertexList.get(predecessorMatrix[a][b]);
            Vertex endvertex = vertexList.get(b);
            ArrayList<Edge> sp_edgeslist = new ArrayList<Edge>();
            Double lengthtest = Double.POSITIVE_INFINITY;
            Edge shortestedge = null;
            for (Edge edge : edgeList) {
                if ((edge.getV1() != predecessor || edge.getV2() != endvertex) && (edge.getV1() != endvertex || edge.getV2() != predecessor)) continue;
                sp_edgeslist.add(edge);
            }
            for (Edge edge : sp_edgeslist) {
                if (!(edge.getLength() < lengthtest)) continue;
                shortestedge = edge;
                lengthtest = edge.getLength();
            }
            Vertex v1 = shortestedge.getV2() != predecessor ? shortestedge.getV2() : shortestedge.getV1();
            for (Object p2 : v1.getPoints()) {
                if (shortestPathPoints.contains(p2)) continue;
                shortestPathPoints.add((Point)p2);
            }
            ArrayList<Point> arrayList = shortestedge.getSlabs();
            if (shortestedge.getV2() != predecessor) {
                Collections.reverse(arrayList);
            }
            p2 = arrayList.iterator();
            while (p2.hasNext()) {
                Point p3 = (Point)p2.next();
                shortestPathPoints.add(p3);
                this.setPixel(this.shortPathImage, p3.x, p3.y, p3.z, SHORTEST_PATH);
            }
            Vertex v2 = shortestedge.getV2() != predecessor ? shortestedge.getV1() : shortestedge.getV2();
            for (Point p4 : v2.getPoints()) {
                if (shortestPathPoints.contains(p4)) continue;
                shortestPathPoints.add(p4);
            }
            b = predecessorMatrix[a][b];
        }
        if (shortestPathPoints.size() != 0) {
            this.spx = shortestPathPoints.get((int)0).x;
            this.spy = shortestPathPoints.get((int)0).y;
            this.spz = shortestPathPoints.get((int)0).z;
        }
    }

    public ImageStack getLabeledSkeletons() {
        return this.labeledSkeletons;
    }

    private void createSettingsDialog() {
        this.settingsDialog = new GenericDialog("Analyze Skeleton");
        Font headerFont = new Font("SansSerif", 1, 12);
        this.settingsDialog.setInsets(0, 0, 0);
        this.settingsDialog.addMessage("Elimination of Loops:", headerFont);
        this.settingsDialog.addChoice("Prune cycle method: ", pruneCyclesModes, pruneCyclesModes[pruneIndex]);
        this.settingsDialog.setInsets(20, 0, -15);
        this.settingsDialog.addMessage("Elimination of End-points:", headerFont);
        this.settingsDialog.addCheckbox("Prune ends", pruneEnds);
        this.settingsDialog.addCheckbox("Exclude ROI from pruning", protectRoi);
        this.settingsDialog.setInsets(20, 0, 0);
        this.settingsDialog.addMessage("Results and Output:", headerFont);
        this.settingsDialog.addCheckbox("Calculate largest shortest path", calculateShortestPath);
        this.settingsDialog.addCheckbox("Show detailed info", verbose);
        this.settingsDialog.addCheckbox("Display labeled skeletons", displaySkeletons);
        this.settingsDialog.addHelp(HELP_URL);
        this.dialogItemChanged(this.settingsDialog, null);
    }

    private void loadDialogSettings() {
        String index = Prefs.get((String)PRUNE_MODE_INDEX_KEY, (String)String.valueOf(0));
        pruneIndex = Integer.parseInt(index);
        pruneEnds = Prefs.get((String)PRUNE_ENDS_KEY, (boolean)false);
        calculateShortestPath = Prefs.get((String)CALCULATE_PATH_KEY, (boolean)false);
        verbose = Prefs.get((String)VERBOSE_KEY, (boolean)false);
        displaySkeletons = Prefs.get((String)DISPLAY_SKELETONS_KEY, (boolean)false);
    }

    private void saveDialogSettings() {
        Prefs.set((String)PRUNE_MODE_INDEX_KEY, (String)String.valueOf(pruneIndex));
        Prefs.set((String)PRUNE_ENDS_KEY, (boolean)pruneEnds);
        Prefs.set((String)CALCULATE_PATH_KEY, (boolean)calculateShortestPath);
        Prefs.set((String)VERBOSE_KEY, (boolean)verbose);
        Prefs.set((String)DISPLAY_SKELETONS_KEY, (boolean)displaySkeletons);
    }

    private void setSettingsFromDialog() {
        pruneIndex = this.settingsDialog.getNextChoiceIndex();
        pruneEnds = this.settingsDialog.getNextBoolean();
        protectRoi = this.settingsDialog.getNextBoolean();
        calculateShortestPath = this.settingsDialog.getNextBoolean();
        verbose = this.settingsDialog.getNextBoolean();
        displaySkeletons = this.settingsDialog.getNextBoolean();
    }
}

