/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import ij.IJ;
import java.util.ArrayList;
import java.util.PriorityQueue;
import levelsets.algorithm.BandElement;
import levelsets.algorithm.BandElementCache;
import levelsets.algorithm.Coordinate;
import levelsets.algorithm.DeferredByteArray3D;
import levelsets.algorithm.DeferredDoubleArray3D;
import levelsets.algorithm.DeferredObjectArray3D;
import levelsets.algorithm.StagedAlgorithm;
import levelsets.filter.GreyValueErosion;
import levelsets.filter.MorphologicalOperator;
import levelsets.ij.ImageContainer;
import levelsets.ij.ImageProgressContainer;
import levelsets.ij.StateContainer;

public class FastMarching
implements StagedAlgorithm {
    private DeferredByteArray3D map = null;
    private DeferredDoubleArray3D arrival = null;
    private DeferredDoubleArray3D distances = null;
    private DeferredObjectArray3D<BandElement> elementLUT = null;
    private ArrayList<Coordinate> seeds = null;
    private int seed_greyvalue = 0;
    private ImageContainer source = null;
    private ImageContainer img = null;
    private double[][][] gradients = null;
    private ImageProgressContainer progress = null;
    private PriorityQueue<BandElement> heap = null;
    private static final double ALPHA = 0.005;
    private double lastFreezeTime = 0.0;
    private double max_distance = 0.0;
    private boolean halt = false;
    private boolean needInit = true;
    private boolean invalid = false;
    private BandElementCache elem_cache = null;
    private static final int ELEMENT_CACHE_SIZE = 1000;
    final int[] pixel = new int[4];
    public static final byte FAR = 0;
    public static final byte BAND = 1;
    public static final byte ALIVE = 2;
    private static double DEF_DISTANCE_THRESHOLD = 0.5;
    private static int DEF_GREYVALUE_THRESHOLD = 50;
    private static final double DISTANCE_STOP = 1000.0;
    private static final double EXTREME_GROWTH = 1000.0;
    private static final int[] ALIVE_PIXEL = new int[]{0, 255, 0, 0};
    private static final int[] BAND_PIXEL = new int[]{255, 0, 0, 0};
    private final double DISTANCE_THRESHOLD;
    private final int GREYVALUE_THRESHOLD;
    private boolean apply_grey_value_erosion = true;
    private int steps = 0;

    public FastMarching(ImageContainer image, ImageProgressContainer img_progress, StateContainer seedContainer, boolean halt, int grey_thresh, double dist_thresh) {
        this(image, img_progress, seedContainer, halt, grey_thresh, dist_thresh, true);
    }

    public FastMarching(ImageContainer image, ImageProgressContainer img_progress, StateContainer seedContainer, boolean halt, int grey_thresh, double dist_thresh, boolean apply_grey_value_erosion) {
        this.halt = halt;
        this.source = image;
        this.progress = img_progress;
        this.seeds = seedContainer.getForFastMarching();
        this.apply_grey_value_erosion = apply_grey_value_erosion;
        this.needInit = true;
        this.GREYVALUE_THRESHOLD = grey_thresh;
        this.DISTANCE_THRESHOLD = dist_thresh;
    }

    public static final int getGreyThreshold() {
        return DEF_GREYVALUE_THRESHOLD;
    }

    public static final double getDistanceThreshold() {
        return DEF_DISTANCE_THRESHOLD;
    }

    private final boolean init() {
        this.map = new DeferredByteArray3D(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, 0);
        this.arrival = new DeferredDoubleArray3D(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, 0.0);
        this.distances = new DeferredDoubleArray3D(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, 0.0);
        this.elementLUT = new DeferredObjectArray3D<Object>(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, null);
        this.heap = new PriorityQueue(1000);
        this.elem_cache = new BandElementCache(1000);
        this.img = this.source.deepCopy();
        if (this.seeds == null) {
            this.invalid = true;
        } else if (this.seeds.size() == 0) {
            this.invalid = true;
        }
        if (this.invalid) {
            throw new IllegalArgumentException("Fast Marching needs seed points but didn't find any! Did you specify an area?");
        }
        for (int i = 0; i < this.seeds.size(); ++i) {
            Coordinate seed = this.seeds.get(i);
            this.seed_greyvalue += this.probeSeedGreyValue(seed.getX(), seed.getY(), seed.getZ());
            BandElement start = this.elem_cache.getRecycledBandElement(seed.getX(), seed.getY(), seed.getZ(), 0.0);
            this.elementLUT.set(seed.getX(), seed.getY(), seed.getZ(), start);
            this.map.set(seed.getX(), seed.getY(), seed.getZ(), (byte)1);
            this.heap.add(start);
        }
        this.seed_greyvalue /= this.seeds.size();
        IJ.log((String)("Seed mean greyvalue = " + this.seed_greyvalue));
        this.seeds = null;
        this.gradients = this.source.calculateGradients();
        if (this.apply_grey_value_erosion) {
            if (this.img.getImageCount() > 100) {
                int partsize = this.img.getImageCount() / 2;
                int offset = 0;
                this.img.applyFilter(new GreyValueErosion(MorphologicalOperator.getTrueMask(5, 5)), 0, partsize - 1);
                this.img.applyFilter(new GreyValueErosion(MorphologicalOperator.getTrueMask(5, 5)), 0, partsize - 1);
                this.img.applyFilter(new GreyValueErosion(MorphologicalOperator.getTrueMask(5, 5)), offset += partsize, offset + partsize - 1);
            } else {
                this.img.applyFilter(new GreyValueErosion(MorphologicalOperator.getTrueMask(5, 5)));
            }
        }
        IJ.log((String)"Fast Marching done init");
        this.visualize(true);
        return true;
    }

    private final void freeze(BandElement elem) {
        int freezeX = elem.getX();
        int freezeY = elem.getY();
        int freezeZ = elem.getZ();
        this.map.set(freezeX, freezeY, freezeZ, (byte)2);
        this.elementLUT.set(freezeX, freezeY, freezeZ, null);
        double dist = this.distances.get(freezeX, freezeY, freezeZ);
        if (dist > 1000.0) {
            System.out.println("Stopped - max distance exceeded");
            this.heap.clear();
            return;
        }
        if (dist < this.max_distance * this.DISTANCE_THRESHOLD || dist < this.max_distance - 30.0) {
            this.arrival.set(freezeX, freezeY, freezeZ, Double.MAX_VALUE);
            this.distances.set(freezeX, freezeY, freezeZ, Double.MAX_VALUE);
        } else {
            this.arrival.set(freezeX, freezeY, freezeZ, elem.getValue());
            if (this.max_distance < this.distances.get(freezeX, freezeY, freezeZ)) {
                this.max_distance = this.distances.get(freezeX, freezeY, freezeZ);
            }
            if (freezeX > 0) {
                this.update(freezeX - 1, freezeY, freezeZ);
            }
            if (freezeX + 1 < this.map.getXLength()) {
                this.update(freezeX + 1, freezeY, freezeZ);
            }
            if (freezeY > 0) {
                this.update(freezeX, freezeY - 1, freezeZ);
            }
            if (freezeY + 1 < this.map.getYLength()) {
                this.update(freezeX, freezeY + 1, freezeZ);
            }
            if (freezeZ > 0) {
                this.update(freezeX, freezeY, freezeZ - 1);
            }
            if (freezeZ + 1 < this.map.getZLength()) {
                this.update(freezeX, freezeY, freezeZ + 1);
            }
            if (this.arrival.get(freezeX, freezeY, freezeZ) > this.lastFreezeTime + 1000.0) {
                IJ.log((String)"Fast marching stopped - extreme growth");
                IJ.log((String)("Last -> " + this.lastFreezeTime));
                IJ.log((String)("Now -> " + this.arrival.get(freezeX, freezeY, freezeZ)));
                this.heap.clear();
                this.elementLUT = null;
            } else {
                this.lastFreezeTime = this.arrival.get(freezeX, freezeY, freezeZ);
            }
        }
    }

    private final void update(int x, int y, int z) {
        byte cell_state = this.map.get(x, y, z);
        if (cell_state == 2) {
            return;
        }
        double time = this.calculateArrivalTime(x, y, z);
        double dist = this.calculateDistance(x, y, z);
        if (cell_state == 1) {
            BandElement elem = this.elementLUT.get(x, y, z);
            this.heap.remove(elem);
            elem.setValue(time);
            this.heap.offer(elem);
            this.distances.set(x, y, z, dist);
        } else if (cell_state == 0) {
            BandElement elem = this.elem_cache.getRecycledBandElement(x, y, z, time);
            this.heap.offer(elem);
            this.map.set(x, y, z, (byte)1);
            this.elementLUT.set(x, y, z, elem);
            this.distances.set(x, y, z, dist);
        }
    }

    @Override
    public final boolean step(int granularity) {
        if (this.invalid) {
            return false;
        }
        if (this.needInit) {
            this.needInit = false;
            if (!this.init()) {
                return false;
            }
        }
        if (this.heap.isEmpty()) {
            this.postProcessStatemap();
            this.visualize(false);
            this.cleanup();
            return false;
        }
        for (int i = 0; i < granularity; ++i) {
            BandElement next = this.heap.poll();
            this.freeze(next);
            this.elem_cache.recycleBandElement(next);
            if (!this.heap.isEmpty()) continue;
            this.postProcessStatemap();
            this.visualize(false);
            this.cleanup();
            return false;
        }
        this.steps += granularity;
        IJ.log((String)("Steps done : " + this.steps));
        this.visualize(false);
        return true;
    }

    public final DeferredByteArray3D getStateMap() {
        return this.map;
    }

    public final StateContainer getStateContainer() {
        if (this.invalid) {
            return null;
        }
        StateContainer sc_fm = new StateContainer();
        sc_fm.setFastMarching(this.map, this.seed_greyvalue);
        return sc_fm;
    }

    public int getSeedGreyValue() {
        return this.seed_greyvalue;
    }

    private final double calculateArrivalTime(int x, int y, int z) {
        double discriminant;
        double dist = Double.MAX_VALUE;
        double xB = x > 0 && this.map.get(x - 1, y, z) == 2 ? this.arrival.get(x - 1, y, z) : Double.MAX_VALUE;
        double xF = x + 1 < this.map.getXLength() && this.map.get(x + 1, y, z) == 2 ? this.arrival.get(x + 1, y, z) : Double.MAX_VALUE;
        double yB = y > 0 && this.map.get(x, y - 1, z) == 2 ? this.arrival.get(x, y - 1, z) : Double.MAX_VALUE;
        double yF = y + 1 < this.map.getYLength() && this.map.get(x, y + 1, z) == 2 ? this.arrival.get(x, y + 1, z) : Double.MAX_VALUE;
        double zB = z > 0 && this.map.get(x, y, z - 1) == 2 ? this.arrival.get(x, y, z - 1) : Double.MAX_VALUE;
        double zF = z + 1 < this.map.getZLength() && this.map.get(x, y, z + 1) == 2 ? this.arrival.get(x, y, z + 1) : Double.MAX_VALUE;
        double xVal = xB < xF ? xB : xF;
        double yVal = yB < yF ? yB : yF;
        double zVal = zB < zF ? zB : zF;
        int quadCoeff = 0;
        if (xVal < Double.MAX_VALUE) {
            ++quadCoeff;
        }
        if (yVal < Double.MAX_VALUE) {
            ++quadCoeff;
        }
        if (zVal < Double.MAX_VALUE) {
            ++quadCoeff;
        }
        double speed = this.getSpeedTerm(x, y, z);
        if (quadCoeff == 1) {
            if (xVal < Double.MAX_VALUE) {
                return xVal + 1.0 / speed;
            }
            if (yVal < Double.MAX_VALUE) {
                return yVal + 1.0 / speed;
            }
            return zVal + 1.0 / speed;
        }
        boolean numSol = false;
        double solution = 0.0;
        double linCoeff = 0.0;
        double abs = -1.0 / (speed * speed);
        if (xVal < Double.MAX_VALUE) {
            linCoeff -= 2.0 * xVal;
            abs += xVal * xVal;
        }
        if (yVal < Double.MAX_VALUE) {
            linCoeff -= 2.0 * yVal;
            abs += yVal * yVal;
        }
        if (zVal < Double.MAX_VALUE) {
            linCoeff -= 2.0 * zVal;
            abs += zVal * zVal;
        }
        if ((discriminant = linCoeff * linCoeff - (double)(4 * quadCoeff) * abs) > 0.0) {
            double rootDiscriminant = Math.sqrt(discriminant);
            solution = (-linCoeff + rootDiscriminant) / (double)(2 * quadCoeff);
        } else {
            IJ.log((String)("OUCH !!! # solutions = 0 (at " + x + ", " + y + ")"));
            IJ.log((String)("quad. coefficient = " + quadCoeff));
            IJ.log((String)("lin. coefficient = " + linCoeff));
            IJ.log((String)("absolute term = " + abs));
            IJ.log((String)("xVal = " + xVal));
            IJ.log((String)("yVal = " + yVal));
            IJ.log((String)("Speedterm = " + speed));
            IJ.log((String)("xB, xF, yB, yF = " + xB + ", " + xF + ", " + yB + ", " + yF));
            IJ.log((String)"**********************************");
            System.exit(0);
        }
        return solution;
    }

    private final double calculateDistance(int x, int y, int z) {
        double xB = x > 0 && this.map.get(x - 1, y, z) == 2 ? this.distances.get(x - 1, y, z) : Double.MAX_VALUE;
        double xF = x + 1 < this.map.getXLength() && this.map.get(x + 1, y, z) == 2 ? this.distances.get(x + 1, y, z) : Double.MAX_VALUE;
        double yB = y > 0 && this.map.get(x, y - 1, z) == 2 ? this.distances.get(x, y - 1, z) : Double.MAX_VALUE;
        double yF = y + 1 < this.map.getYLength() && this.map.get(x, y + 1, z) == 2 ? this.distances.get(x, y + 1, z) : Double.MAX_VALUE;
        double zB = z > 0 && this.map.get(x, y, z - 1) == 2 ? this.distances.get(x, y, z - 1) : Double.MAX_VALUE;
        double zF = z + 1 < this.map.getZLength() && this.map.get(x, y, z + 1) == 2 ? this.distances.get(x, y, z + 1) : Double.MAX_VALUE;
        double xVal = xB < xF ? xB : xF;
        double yVal = yB < yF ? yB : yF;
        double zVal = zB < zF ? zB : zF;
        double dist = Math.min(Math.min(xVal, yVal), zVal);
        return dist + 1.0;
    }

    private final double getSpeedTerm(int x, int y, int z) {
        int greyval = this.img.getPixel(x, y, z);
        int greyval_penalty = Math.abs(greyval - this.seed_greyvalue);
        if (greyval_penalty < this.GREYVALUE_THRESHOLD) {
            greyval_penalty = 1;
        }
        return Math.pow(Math.E, -0.005 * (this.gradients[x][y][z] * this.gradients[x][y][z] + (double)(greyval_penalty * greyval_penalty)));
    }

    private final void visualize(boolean set_output) {
        if (this.progress == null) {
            return;
        }
        int px_alive = 0;
        int px_band = 0;
        int px_far = 0;
        ImageProgressContainer output = this.progress;
        if (set_output) {
            this.progress.duplicateImages(this.img);
        }
        this.progress.showProgressStep();
        byte cell_state = 0;
        for (int z = 0; z < this.map.getZLength(); ++z) {
            for (int x = 0; x < this.map.getXLength(); ++x) {
                for (int y = 0; y < this.map.getYLength(); ++y) {
                    cell_state = this.map.get(x, y, z);
                    if (cell_state == 2) {
                        output.setPixel(x, y, z, ALIVE_PIXEL);
                        ++px_alive;
                        continue;
                    }
                    if (cell_state == 1) {
                        output.setPixel(x, y, z, BAND_PIXEL);
                        ++px_band;
                        continue;
                    }
                    ++px_far;
                }
            }
        }
        IJ.log((String)("FastMarching iteration: Found pixels " + px_alive + " ALIVE, " + px_band + " BAND," + px_far + " FAR"));
        this.progress.showProgressStep();
    }

    private final void cleanup() {
        this.arrival = null;
        this.gradients = null;
        this.elementLUT = null;
        this.source = null;
        this.img = null;
        this.heap = null;
        this.elem_cache = null;
    }

    private final int probeSeedGreyValue(int x, int y, int z) {
        int value = this.source.getPixel(x, y, z);
        int count = 1;
        if (x > 0) {
            value += this.source.getPixel(x - 1, y, z);
            ++count;
        }
        if (x < this.img.getWidth() - 1) {
            value += this.source.getPixel(x + 1, y, z);
            ++count;
        }
        if (y > 0) {
            value += this.source.getPixel(x, y - 1, z);
            ++count;
        }
        if (y < this.img.getHeight() - 1) {
            value += this.source.getPixel(x, y + 1, z);
            ++count;
        }
        return value / count;
    }

    private final void postProcessStatemap() {
        IJ.log((String)"Postprocessing Statemap...");
        DeferredByteArray3D processed_map = new DeferredByteArray3D(this.map.getXLength(), this.map.getYLength(), this.map.getZLength(), this.map.getTileSize(), 0);
        for (int i = 0; i < this.map.getXLength(); ++i) {
            for (int j = 0; j < this.map.getYLength(); ++j) {
                for (int k = 0; k < this.map.getZLength(); ++k) {
                    if (this.map.get(i, j, k) != 2) continue;
                    if ((i > 0 && this.map.get(i - 1, j, k) == 2 || i == 0) && (i + 1 < this.map.getXLength() && this.map.get(i + 1, j, k) == 2 || i + 1 == this.map.getXLength()) && (j > 0 && this.map.get(i, j - 1, k) == 2 || j == 0) && (j + 1 < this.map.getYLength() && this.map.get(i, j + 1, k) == 2 || j + 1 == this.map.getYLength()) && (k > 0 && this.map.get(i, j, k - 1) == 2 || k == 0) && (k + 1 < this.map.getZLength() && this.map.get(i, j, k + 1) == 2 || k + 1 == this.map.getZLength())) {
                        processed_map.set(i, j, k, (byte)2);
                        continue;
                    }
                    processed_map.set(i, j, k, (byte)1);
                }
            }
        }
        this.map = processed_map;
    }
}

