/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.renjin.compiler.ByteCodeUtil;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class ConstantGeneratingVisitor
extends SexpVisitor<Void>
implements Opcodes {
    private MethodVisitor mv;

    public ConstantGeneratingVisitor(MethodVisitor mv) {
        this.mv = mv;
    }

    @Override
    public void visit(DoubleVector vector2) {
        if (vector2.length() != 1) {
            throw new UnsupportedOperationException("only double vectors of length 1 are implemented");
        }
        this.mv.visitTypeInsn(187, "org/renjin/sexp/DoubleArrayVector");
        this.mv.visitInsn(89);
        this.mv.visitInsn(4);
        this.mv.visitIntInsn(188, 7);
        this.mv.visitInsn(89);
        this.mv.visitInsn(3);
        this.mv.visitLdcInsn((Object)vector2.getElementAsDouble(0));
        this.mv.visitInsn(82);
        this.mv.visitMethodInsn(183, "org/renjin/sexp/DoubleArrayVector", "<init>", "([D)V");
    }

    @Override
    public void visit(ComplexVector vector2) {
        this.mv.visitTypeInsn(187, "org/renjin/sexp/ComplexVector");
        this.mv.visitInsn(89);
        ByteCodeUtil.pushInt(this.mv, vector2.length());
        this.mv.visitTypeInsn(189, "org/apache/commons/math/complex/Complex");
        for (int i = 0; i != vector2.length(); ++i) {
            this.mv.visitInsn(89);
            ByteCodeUtil.pushInt(this.mv, i);
            this.mv.visitTypeInsn(187, "org/apache/commons/math/complex/Complex");
            this.mv.visitInsn(89);
            this.pushDouble(vector2.getElementAsComplex(i).getReal());
            this.pushDouble(vector2.getElementAsComplex(i).getImaginary());
            this.mv.visitMethodInsn(183, "org/apache/commons/math/complex/Complex", "<init>", "(DD)V");
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(183, "org/renjin/sexp/ComplexVector", "<init>", "([Lorg/apache/commons/math/complex/Complex;)V");
    }

    private void pushDouble(double x) {
        if (x == 0.0) {
            this.mv.visitInsn(14);
        } else if (x == 1.0) {
            this.mv.visitInsn(15);
        } else {
            this.mv.visitLdcInsn((Object)x);
        }
    }

    @Override
    public void visit(IntVector vector2) {
        this.mv.visitTypeInsn(187, "org/renjin/sexp/IntArrayVector");
        this.mv.visitInsn(89);
        this.pushIntArray(vector2);
        this.mv.visitMethodInsn(183, "org/renjin/sexp/IntArrayVector", "<init>", "([I)V");
    }

    private void pushIntArray(Vector vector2) {
        ByteCodeUtil.pushInt(this.mv, vector2.length());
        this.mv.visitIntInsn(188, 10);
        for (int i = 0; i != vector2.length(); ++i) {
            this.mv.visitInsn(89);
            ByteCodeUtil.pushInt(this.mv, i);
            this.mv.visitLdcInsn((Object)vector2.getElementAsInt(i));
            this.mv.visitInsn(79);
        }
    }

    @Override
    public void visit(StringVector vector2) {
        this.mv.visitTypeInsn(187, "org/renjin/sexp/StringArrayVector");
        this.mv.visitInsn(89);
        ByteCodeUtil.pushInt(this.mv, vector2.length());
        this.mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i != vector2.length(); ++i) {
            if (vector2.isElementNA(i)) continue;
            this.mv.visitInsn(89);
            ByteCodeUtil.pushInt(this.mv, i);
            this.mv.visitLdcInsn((Object)vector2.getElementAsString(i));
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(183, "org/renjin/sexp/StringArrayVector", "<init>", "([Ljava/lang/String;)V");
    }

    @Override
    public void visit(Null nullExpression) {
        this.mv.visitFieldInsn(178, "org/renjin/sexp/Null", "INSTANCE", "Lorg/renjin/sexp/Null;");
    }

    @Override
    public void visit(Symbol symbol2) {
        if (symbol2 == Symbol.UNBOUND_VALUE) {
            this.mv.visitFieldInsn(178, "org/renjin/sexp/Symbol", "UNBOUND_VALUE", "Lorg/renjin/sexp/Symbol;");
        } else if (symbol2 == Symbol.MISSING_ARG) {
            this.mv.visitFieldInsn(178, "org/renjin/sexp/Symbol", "MISSING_ARG", "Lorg/renjin/sexp/Symbol;");
        } else {
            this.mv.visitLdcInsn((Object)symbol2.getPrintName());
            this.mv.visitMethodInsn(184, "org/renjin/sexp/Symbol", "get", "(Ljava/lang/String;)Lorg/renjin/sexp/Symbol;");
        }
    }

    @Override
    public void visit(PairList.Node node) {
        this.mv.visitTypeInsn(187, "org/renjin/sexp/PairList$Node");
        this.mv.visitInsn(89);
        node.getRawTag().accept(this);
        node.getValue().accept(this);
        node.getNext().accept(this);
        this.mv.visitMethodInsn(183, "org/renjin/sexp/PairList$Node", "<init>", "(Lorg/renjin/sexp/SEXP;Lorg/renjin/sexp/SEXP;Lorg/renjin/sexp/PairList;)V");
    }

    @Override
    public void visit(FunctionCall call2) {
        this.mv.visitTypeInsn(187, "org/renjin/sexp/FunctionCall");
        this.mv.visitInsn(89);
        call2.getFunction().accept(this);
        call2.getArguments().accept(this);
        this.mv.visitMethodInsn(183, "org/renjin/sexp/FunctionCall", "<init>", "(Lorg/renjin/sexp/SEXP;Lorg/renjin/sexp/PairList;)V");
    }

    @Override
    public void visit(BuiltinFunction builtin) {
        this.mv.visitLdcInsn((Object)builtin.getName());
        this.mv.visitMethodInsn(184, "org/renjin/Primitives", "getBuiltin", "(Ljava/lang/String;)Lorg/renjin/sexp/SEXP;");
    }

    @Override
    public void visit(LogicalVector vector2) {
        if (vector2.length() == 1) {
            if (vector2.getElementAsRawLogical(0) == 1) {
                this.mv.visitFieldInsn(178, "org/renjin/sexp/LogicalVector", "TRUE", "Lorg/renjin/sexp/LogicalVector;");
            } else if (vector2.getElementAsRawLogical(0) == 0) {
                this.mv.visitFieldInsn(178, "org/renjin/sexp/LogicalVector", "FALSE", "Lorg/renjin/sexp/LogicalVector;");
            } else {
                this.mv.visitFieldInsn(178, "org/renjin/sexp/LogicalVector", "NA_VECTOR", "Lorg/renjin/sexp/LogicalVector;");
            }
        } else {
            this.mv.visitTypeInsn(187, "org/renjin/sexp/LogicalVector");
            this.mv.visitInsn(89);
            this.pushIntArray(vector2);
            this.mv.visitMethodInsn(183, "org/renjin/sexp/IntArrayVector", "<init>", "([I)V");
        }
    }

    @Override
    protected void unhandled(SEXP exp2) {
        throw new UnsupportedOperationException("Constant generation nyi for " + exp2);
    }
}

