/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.codegen.DeferredVectorBuilder;
import org.renjin.invoke.codegen.scalars.ScalarType;
import org.renjin.invoke.codegen.scalars.ScalarTypes;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.sexp.Null;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class RecycleLoopBuilder {
    private JCodeModel codeModel;
    private JBlock parent;
    private PrimitiveModel primitive;
    private JvmMethod overload;
    private final JExpression contextVar;
    private List<RecycledArgument> recycledArguments = Lists.newArrayList();
    private Map<JvmMethod.Argument, JExpression> argumentMap = Maps.newHashMap();
    private JClass vectorType;
    private JVar cycleCount;
    private JVar cycleIndex;
    private ScalarType resultType;
    private JVar builder;

    public RecycleLoopBuilder(JCodeModel codeModel, JBlock parent2, JExpression contextVar, PrimitiveModel primitive2, JvmMethod overload, Map<JvmMethod.Argument, JExpression> argumentMap) {
        this.codeModel = codeModel;
        this.parent = parent2;
        this.contextVar = contextVar;
        this.primitive = primitive2;
        this.overload = overload;
        this.vectorType = codeModel.ref(Vector.class);
        this.resultType = ScalarTypes.get(overload.getReturnType());
        for (JvmMethod.Argument argument : overload.getAllArguments()) {
            if (argument.isRecycle()) {
                RecycledArgument recycledArgument = new RecycledArgument(argument, argumentMap.get(argument));
                this.recycledArguments.add(recycledArgument);
                this.argumentMap.put(argument, recycledArgument.getCurrentElement());
                continue;
            }
            this.argumentMap.put(argument, argumentMap.get(argument));
        }
    }

    public void build() {
        this.computeResultLength();
        this.initializeBuilder();
        this.loop();
        this.copyAttributes();
        this.parent._return(this.buildResult());
    }

    private void computeResultLength() {
        this.cycleCount = this.parent.decl(this.codeModel._ref(Integer.TYPE), "cycles", JExpr.lit((int)0));
        for (RecycledArgument arg : this.recycledArguments) {
            this.parent._if(arg.length.eq(JExpr.lit((int)0)))._then()._return(this.emptyResult());
            this.parent._if(arg.length.gt((JExpression)this.cycleCount))._then().assign((JAssignmentTarget)this.cycleCount, (JExpression)arg.length);
        }
        if (this.overload.isDeferrable()) {
            DeferredVectorBuilder deferred = new DeferredVectorBuilder(this.codeModel, this.contextVar, this.primitive, this.overload);
            deferred.buildClass();
            deferred.maybeReturn(this.parent, (JExpression)this.cycleCount, this.deferredArgumentList());
        }
    }

    private List<JExpression> deferredArgumentList() {
        for (JvmMethod.Argument arg : this.overload.getAllArguments()) {
            if (arg.isRecycle()) continue;
            throw new UnsupportedOperationException("All arguments of a deferred vector must be @Recycle");
        }
        ArrayList list2 = Lists.newArrayList();
        for (RecycledArgument arg : this.recycledArguments) {
            list2.add(arg.vector);
        }
        return list2;
    }

    private JExpression nullInstance() {
        return this.codeModel.ref(Null.class).staticRef("INSTANCE");
    }

    private JExpression emptyResult() {
        return this.codeModel.ref(this.resultType.getVectorType()).staticRef("EMPTY");
    }

    private void initializeBuilder() {
        JClass builderClass = this.codeModel.ref(this.resultType.getBuilderClass());
        this.builder = this.parent.decl((JType)builderClass, "builder", (JExpression)JExpr._new((JClass)builderClass).arg((JExpression)this.cycleCount));
    }

    private void loop() {
        JForLoop loop = this.parent._for();
        this.cycleIndex = loop.init((JType)this.codeModel.INT, "i", JExpr.lit((int)0));
        loop.test(this.cycleIndex.ne((JExpression)this.cycleCount));
        loop.update(this.cycleIndex.incr());
        this.calculateResult(loop.body());
        this.incrementCounters(loop.body());
    }

    private void calculateResult(JBlock loopBody) {
        if (!this.overload.isPassNA()) {
            JConditional ifNA = loopBody._if(this.isCurrentElementNA());
            ifNA._then().add(this.assignNA());
            ifNA._else().add(this.assignCycleResult());
        } else {
            loopBody.add(this.assignCycleResult());
        }
    }

    private void incrementCounters(JBlock loopBody) {
        for (RecycledArgument arg : this.recycledArguments) {
            loopBody.assignPlus((JAssignmentTarget)arg.currentElementIndex, JExpr.lit((int)1));
            loopBody._if(arg.currentElementIndex.eq((JExpression)arg.length))._then().assign((JAssignmentTarget)arg.currentElementIndex, JExpr.lit((int)0));
        }
    }

    private JExpression isCurrentElementNA() {
        if (this.recycledArguments.isEmpty()) {
            throw new IllegalStateException(this.overload.getName() + " is marked as @DataParallel, but has no parallel arguments");
        }
        JExpression condition = null;
        for (RecycledArgument arg : this.recycledArguments) {
            if (condition == null) {
                condition = arg.isCurrentElementNA();
                continue;
            }
            condition = condition.cor(arg.isCurrentElementNA());
        }
        return condition;
    }

    private JStatement assignCycleResult() {
        return this.builder.invoke("set").arg((JExpression)this.cycleIndex).arg((JExpression)this.computeCycleResult());
    }

    private JStatement assignNA() {
        return this.builder.invoke("setNA").arg((JExpression)this.cycleIndex);
    }

    private JInvocation computeCycleResult() {
        JInvocation invocation = this.codeModel.ref(this.overload.getDeclaringClass()).staticInvoke(this.overload.getName());
        for (JvmMethod.Argument arg : this.overload.getAllArguments()) {
            if (!this.argumentMap.containsKey(arg)) {
                throw new AssertionError((Object)(arg.getName() + " not present in argumentMap"));
            }
            invocation.arg(this.argumentMap.get(arg));
        }
        return invocation;
    }

    private void copyAttributes() {
        if (this.overload.getPreserveAttributesStyle() != PreserveAttributeStyle.NONE) {
            for (RecycledArgument arg : Lists.reverse(this.recycledArguments)) {
                this.parent._if(arg.length.eq((JExpression)this.cycleCount))._then().add(this.copyAttributesFrom(arg));
            }
        }
    }

    private JStatement copyAttributesFrom(RecycledArgument arg) {
        switch (this.overload.getPreserveAttributesStyle()) {
            case ALL: {
                return this.builder.invoke("copyAttributesFrom").arg((JExpression)arg.vector);
            }
            case SPECIAL: {
                return this.builder.invoke("copySomeAttributesFrom").arg((JExpression)arg.vector).arg(this.symbol("DIM")).arg(this.symbol("DIMNAMES")).arg(this.symbol("NAMES"));
            }
        }
        throw new IllegalArgumentException("preserve attribute style: " + (Object)((Object)this.overload.getPreserveAttributesStyle()));
    }

    private JExpression symbol(String name) {
        return this.codeModel.ref(Symbols.class).staticRef(name);
    }

    private JExpression buildResult() {
        return this.builder.invoke("build");
    }

    private class RecycledArgument {
        private JvmMethod.Argument formal;
        private ScalarType scalarType;
        private JExpression sexp;
        private JVar vector;
        private JVar length;
        private JVar currentElementIndex;

        public RecycledArgument(JvmMethod.Argument argument, JExpression parameter) {
            this.formal = argument;
            this.scalarType = ScalarTypes.get(this.formal.getClazz());
            this.sexp = parameter;
            this.vector = RecycleLoopBuilder.this.parent.decl((JType)RecycleLoopBuilder.this.codeModel.ref(Vector.class), "vector" + this.formal.getIndex(), (JExpression)JExpr.cast((JType)RecycleLoopBuilder.this.codeModel.ref(Vector.class), (JExpression)this.sexp));
            this.length = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(Integer.TYPE), "length" + this.formal.getIndex(), (JExpression)this.vector.invoke("length"));
            this.currentElementIndex = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(Integer.TYPE), "currentElementIndex" + this.formal.getIndex(), JExpr.lit((int)0));
        }

        public JType getVectorType() {
            return RecycleLoopBuilder.this.codeModel.ref(this.scalarType.getVectorType());
        }

        public JExpression isCurrentElementNA() {
            return this.vector.invoke("isElementNA").arg((JExpression)this.currentElementIndex);
        }

        public JExpression getCurrentElement() {
            return this.vector.invoke(this.scalarType.getAccessorMethod()).arg((JExpression)this.currentElementIndex);
        }
    }
}

