/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class Biorad_Reader
extends ImagePlus
implements PlugIn {
    private final int NOTE_SIZE = 96;
    private BufferedInputStream f;
    private String directory;
    private String fileName;
    private String notes = "";
    private int lutOffset = -1;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open Biorad...", arg);
        this.directory = od.getDirectory();
        this.fileName = od.getFileName();
        if (this.fileName == null) {
            return;
        }
        IJ.showStatus((String)("Opening: " + this.directory + this.fileName));
        FileInfo fi = null;
        try {
            fi = this.getHeaderInfo();
        }
        catch (Exception e) {
            IJ.showStatus((String)"");
            IJ.showMessage((String)"BioradReader", (String)("" + e));
            return;
        }
        if (fi != null) {
            if (this.fileName.toLowerCase().endsWith(".gz") && IJ.getVersion().compareTo("1.38s") < 0) {
                IJ.error((String)"ImageJ 1.38s or later required to open gzipped Biorad PIC files");
                return;
            }
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            if (IJ.debugMode) {
                IJ.log((String)("imp=" + imp));
            }
            if (imp == null) {
                return;
            }
            this.setStack(this.fileName, imp.getStack());
            this.setFileInfo(fi);
            if (IJ.debugMode) {
                IJ.log((String)("FileInfo=" + fi));
            }
            try {
                int pixelLength = 1;
                switch (fi.fileType) {
                    case 0: {
                        pixelLength = 1;
                        break;
                    }
                    case 2: {
                        pixelLength = 2;
                    }
                }
                Calibration BioRadCal = this.getBioRadCalibration(fi.width, fi.height, fi.nImages, pixelLength);
                this.setCalibration(BioRadCal);
            }
            catch (Exception e) {
                IJ.showStatus((String)"");
                String msg = e.getMessage();
                if (e == null) {
                    msg = "" + e;
                }
                if (msg.indexOf("EOF") == -1) {
                    IJ.showMessage((String)"BioradReader", (String)msg);
                }
                return;
            }
            boolean hasLut = false;
            if (this.lutOffset != -1) {
                try {
                    hasLut = this.getLut(fi);
                }
                catch (Exception e) {
                    IJ.showStatus((String)"");
                    IJ.showMessage((String)"BioradReader", (String)("Can't read LUT from file because " + e));
                    hasLut = false;
                }
            }
            if (hasLut) {
                IndexColorModel cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
                this.getProcessor().setColorModel((ColorModel)cm);
                this.getStack().setColorModel((ColorModel)cm);
            }
            if (!this.notes.equals("")) {
                this.setProperty("Info", this.notes);
            }
            if (IJ.debugMode) {
                IJ.log((String)("arg=|" + arg + "|"));
            }
            if (arg.equals("")) {
                this.show();
            }
        }
        if (IJ.debugMode) {
            IJ.log((String)"done");
        }
    }

    int getByte() throws IOException {
        int b = this.f.read();
        if (b == -1) {
            throw new IOException("unexpected EOF");
        }
        return b;
    }

    int getShort() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        return (b1 << 8) + b0;
    }

    int getInt() throws IOException {
        int b0 = this.getShort();
        int b1 = this.getShort();
        return (b1 << 16) + b0;
    }

    void openFile() throws IOException {
        this.f = this.fileName.toLowerCase().endsWith(".pic.gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.directory + this.fileName))) : new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
    }

    FileInfo getHeaderInfo() throws IOException {
        this.openFile();
        int width = this.getShort();
        int height = this.getShort();
        int nImages = this.getShort();
        this.f.skip(8L);
        int byte_format = this.getShort();
        this.f.skip(38L);
        int magicNumber = this.getShort();
        this.f.close();
        String notBioradPicFile = "This does not seem to be a Biorad Pic File";
        if (magicNumber != 12345) {
            throw new IOException(notBioradPicFile);
        }
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.fileName = this.fileName;
        fi.directory = this.directory;
        fi.width = width;
        fi.height = height;
        fi.nImages = nImages;
        fi.offset = 76;
        switch (byte_format) {
            case 1: {
                fi.fileType = 0;
                break;
            }
            case 0: {
                fi.fileType = 2;
                fi.intelByteOrder = true;
            }
        }
        if (IJ.debugMode) {
            IJ.log((String)("fileType (0,2)=" + fi.fileType));
        }
        return fi;
    }

    Calibration getBioRadCalibration(int width, int height, int nImages, int pixelLength) throws IOException {
        int NoteFlag;
        Calibration BioRadCal = new Calibration();
        String NoteContent = new String();
        byte[] TempByte = new byte[80];
        byte[] RawNote = new byte[80];
        double ScaleZ = 0.0;
        double framesPerSecond = 0.0;
        double frameInterval = 0.0;
        boolean xyt = false;
        int Offset = 76 + height * width * nImages * pixelLength;
        this.openFile();
        this.f.skip(Offset);
        if (IJ.debugMode) {
            IJ.log((String)"getBioRadCalibration");
        }
        do {
            this.f.skip(2L);
            NoteFlag = this.getInt();
            this.f.skip(4L);
            int NoteType = this.getShort();
            this.f.skip(4L);
            this.f.read(RawNote);
            for (int i = 0; i < 80; ++i) {
                int ch = RawNote[i];
                TempByte[i] = ch >= 32 && ch <= 126 ? ch : 32;
            }
            String Note = new String(TempByte);
            this.notes = this.notes + Note + "\n";
            if (NoteType != 1) {
                NoteContent = this.getField(Note, 1);
                if (NoteContent.indexOf("AXIS_2") >= 0) {
                    double ScaleX;
                    BioRadCal.pixelWidth = ScaleX = this.s2d(this.getField(Note, 4));
                    BioRadCal.setUnit(this.getField(Note, 5));
                } else if (NoteContent.indexOf("AXIS_3") >= 0) {
                    double ScaleY;
                    BioRadCal.pixelHeight = ScaleY = this.s2d(this.getField(Note, 4));
                    BioRadCal.setUnit(this.getField(Note, 5));
                } else if (NoteContent.indexOf("AXIS_4") >= 0) {
                    BioRadCal.pixelDepth = ScaleZ = this.s2d(this.getField(Note, 4));
                    if (this.getField(Note, 5).indexOf("Seconds") >= 0) {
                        xyt = true;
                    }
                } else if (NoteContent.indexOf("INFO_FRAME_RATE") >= 0) {
                    framesPerSecond = this.s2d(this.getField(Note, 3));
                    BioRadCal.frameInterval = frameInterval = 1.0 / framesPerSecond;
                }
            }
            if (IJ.debugMode) {
                IJ.log((String)("Offset =" + Offset));
            }
            Offset += 96;
        } while (NoteFlag != 0 & this.f.available() >= 96);
        if (IJ.debugMode) {
            IJ.log((String)"lut?");
        }
        this.lutOffset = Offset;
        if (xyt) {
            BioRadCal.pixelDepth = frameInterval;
        }
        this.f.close();
        if (IJ.debugMode) {
            IJ.log((String)("BioRadCal" + BioRadCal));
        }
        return BioRadCal;
    }

    boolean getLut(FileInfo fi) throws IOException {
        this.openFile();
        this.f.skip(this.lutOffset);
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        boolean hasLut = false;
        if (this.f.available() >= 768) {
            hasLut = true;
            this.f.read(fi.reds);
            this.f.read(fi.greens);
            this.f.read(fi.blues);
        }
        this.f.close();
        return hasLut;
    }

    String getField(String str, int fieldIndex) {
        int delimiter = 32;
        int startIndex = 0;
        for (int i = 1; i < fieldIndex; ++i) {
            startIndex = str.indexOf(delimiter, startIndex) + 1;
        }
        int endIndex = str.indexOf(delimiter, startIndex + 1);
        if (endIndex == -1) {
            endIndex = str.length();
        }
        if (startIndex >= 0 && endIndex >= 0) {
            return str.substring(startIndex, endIndex);
        }
        return "";
    }

    double s2d(String s) {
        return Tools.parseDouble((String)s);
    }
}

