/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Two_Point_Correlation
implements PlugInFilter {
    ImagePlus image;
    byte[] pixels;
    float[] convolved;
    int w;
    int h;

    final int get(int i, int j) {
        if (i < 0 || j < 0 || i >= this.w || j >= this.h) {
            return 0;
        }
        return this.pixels[i + this.w * j] & 0xFF;
    }

    final float getConvolved(float x, float y) {
        int i = (int)Math.floor(x);
        int j = (int)Math.floor(y);
        if (i < -this.w + 1 || i >= this.w - 1 || j < -this.h + 1 || j >= this.h - 1) {
            return 0.0f;
        }
        float dx = x - (float)i;
        float dy = y - (float)j;
        float v00 = this.convolved[this.w - 1 + i + (this.h - 1 + j) * 2 * this.w];
        float v10 = this.convolved[this.w + i + (this.h - 1 + j) * 2 * this.w];
        float v01 = this.convolved[this.w - 1 + i + (this.h + j) * 2 * this.w];
        float v11 = this.convolved[this.w + i + (this.h + j) * 2 * this.w];
        float w00 = Float.MIN_VALUE + (1.0f - dx) * (1.0f - dx) + (1.0f - dy) * (1.0f - dy);
        float w10 = Float.MIN_VALUE + dx * dx + (1.0f - dy) * (1.0f - dy);
        float w01 = Float.MIN_VALUE + (1.0f - dx) * (1.0f - dx) + dy * dy;
        float w11 = Float.MIN_VALUE + dx * dx + dy * dy;
        return (v00 * w00 + v10 * w10 + v01 * w01 + v11 * w11) / (w00 + w10 + w01 + w11);
    }

    static int max(int i, int j) {
        return i > j ? i : j;
    }

    static int min(int i, int j) {
        return i < j ? i : j;
    }

    void getConvolvedNaive() {
        for (int y = -this.h + 1; y < this.h; ++y) {
            for (int x = -this.w + 1; x < this.w; ++x) {
                int total = 0;
                int index = this.w - 1 + x + (this.h - 1 + y) * 2 * this.w;
                for (int i = Two_Point_Correlation.min(0, -x); x + i < this.w && i < this.w; ++i) {
                    for (int j = Two_Point_Correlation.min(0, -y); y + j < this.h && j < this.h; ++j) {
                        int n = index;
                        this.convolved[n] = this.convolved[n] + (float)(this.get(i, j) * this.get(x + i, y + j));
                        ++total;
                    }
                }
                int n = index;
                this.convolved[n] = this.convolved[n] / ((float)total * 255.0f * 255.0f);
                IJ.showProgress((int)(index + 0), (int)(4 * this.w * (this.h - 1)));
            }
        }
    }

    void getConvolved() {
        int nroot;
        for (nroot = 2; nroot < this.w || nroot < this.h; nroot *= 2) {
        }
        int n = (nroot *= 2) * nroot;
        double[][] data = new double[n][2];
        double[][] data2 = new double[n][2];
        for (int j = 0; j < this.h; ++j) {
            for (int i = 0; i < this.w; ++i) {
                int index = i + this.w * j;
                data[index + this.w * j][0] = this.pixels[index];
                data2[this.w - i - 1 + 2 * this.w * (this.h - j - 1)][0] = this.pixels[index];
            }
        }
        IJ.showProgress((double)0.0);
        double[][] inv = FFT.fft(data);
        IJ.showProgress((double)0.3);
        double[][] inv2 = FFT.fft(data2);
        IJ.showProgress((double)0.6);
        double[][] iconv = FFT.multiply(inv, inv2);
        IJ.showProgress((double)0.7);
        double[][] conv = FFT.ifft(iconv);
        IJ.showProgress((double)0.9);
        for (int i = 0; i < this.convolved.length; ++i) {
            this.convolved[i] = (float)conv[i][0] / 255.0f / 255.0f;
        }
        IJ.showProgress((double)1.0);
    }

    public void run(ImageProcessor ip) {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        GenericDialog gd = new GenericDialog("Two Point Correlation");
        gd.addNumericField("min_radius", 0.0, 1);
        gd.addNumericField("max_radius", Math.sqrt(this.w * this.w + this.h * this.h), 1);
        gd.addNumericField("radius_step", 0.3, 1);
        gd.addCheckbox("invert", false);
        gd.addCheckbox("normalize", false);
        gd.addCheckbox("naive computation (slow)", false);
        gd.addCheckbox("show convolved image", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double min_radius = gd.getNextNumber();
        double max_radius = gd.getNextNumber();
        double radius_step = gd.getNextNumber();
        boolean invert = gd.getNextBoolean();
        boolean normalize = gd.getNextBoolean();
        boolean naive = gd.getNextBoolean();
        boolean show = gd.getNextBoolean();
        this.pixels = (byte[])this.image.getProcessor().getPixels();
        if (invert) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = (byte)(255 - (this.pixels[i] & 0xFF));
            }
        }
        this.convolved = new float[4 * this.w * this.h];
        if (naive) {
            this.getConvolvedNaive();
        } else {
            this.getConvolved();
        }
        if (show) {
            new ImagePlus("convolved", (ImageProcessor)new FloatProcessor(2 * this.w, 2 * this.h, this.convolved, null)).show();
        }
        int n = (int)((max_radius - min_radius) / radius_step) + 1;
        float[] r = new float[n];
        float[] v = new float[n];
        float max_value = -3.4028235E38f;
        float min_value = -max_value;
        for (int i = 0; i < n; ++i) {
            float r2 = (float)(min_radius + (double)i * (max_radius - min_radius) / (double)n);
            int div = (int)(1.0 + Math.PI * 2 * (double)r2);
            float sum = 0.0f;
            for (int angle = 0; angle < div; ++angle) {
                float a = (float)(Math.PI * 2 * (double)angle / (double)div);
                sum += this.getConvolved((float)((double)r2 * Math.cos(a)), (float)((double)r2 * Math.sin(a)));
            }
            r[i] = r2;
            v[i] = sum / (float)div;
            if (max_value < v[i]) {
                max_value = v[i];
                continue;
            }
            if (!(min_value > v[i])) continue;
            min_value = v[i];
        }
        if (normalize) {
            float factor = this.getConvolved(0.0f, 0.0f);
            int i = 0;
            while (i < r.length) {
                int n2 = i++;
                v[n2] = v[n2] / factor;
            }
            min_value /= factor;
            max_value /= factor;
        }
        Plot plot = new Plot("Two Point Correlation", "radius", "S2(radius)", r, v);
        plot.setLimits(0.0, max_radius, (double)min_value, (double)max_value);
        plot.draw();
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 129;
    }
}

