/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import client.ArchiveClient;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.applet.Applet;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import landmarks.NamePoints;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import landmarks.PointsDialog;

public class Name_Points
extends NamePoints
implements PlugIn {
    public void run(String arguments) {
        boolean foundExistingPointsFile;
        boolean promptForTemplate = IJ.altKeyDown();
        String macroOptions = Macro.getOptions();
        String templateParameter = null;
        if (macroOptions != null) {
            templateParameter = Macro.getValue((String)macroOptions, (String)"template", null);
            String actionParameter = Macro.getValue((String)macroOptions, (String)"action", null);
            if (actionParameter != null) {
                if (actionParameter.equals("finetunetofile")) {
                    this.batchFineTuning = true;
                    String inputImageParameter = Macro.getValue((String)macroOptions, (String)"inputimage", null);
                    if (inputImageParameter == null) {
                        IJ.error((String)"You must supply an 'inputimage' parameter when using the macro action 'finetunetofile'");
                        return;
                    }
                    String templateImageParameter = Macro.getValue((String)macroOptions, (String)"templateimage", null);
                    if (templateImageParameter == null) {
                        IJ.error((String)"You must supply an 'templateimage' parameter when using the macro action 'finetunetofile'");
                        return;
                    }
                    String outputPointsFileParameter = Macro.getValue((String)macroOptions, (String)"outputpointsfile", null);
                    if (outputPointsFileParameter == null) {
                        IJ.error((String)"You must supply an 'outputpointsfile' parameter when using the macro action 'finetunetofile'");
                        return;
                    }
                    this.batchFineTune(templateImageParameter, inputImageParameter, outputPointsFileParameter);
                    return;
                }
                IJ.error((String)("Unknown macro action '" + actionParameter + "'"));
                return;
            }
        }
        File templateImageFile = null;
        if (this.templateImageFilename != null && this.templateImageFilename.length() > 0) {
            templateImageFile = new File(this.templateImageFilename);
        }
        if (promptForTemplate) {
            String openTitle = "Select template image file...";
            OpenDialog od = templateImageFile == null ? new OpenDialog(openTitle, null) : new OpenDialog(openTitle, templateImageFile.getParent(), templateImageFile.getName());
            if (od.getFileName() != null) {
                this.templateImageFilename = od.getDirectory() + od.getFileName();
                this.useTemplate(this.templateImageFilename);
                this.setDefaultTemplate(this.templateImageFilename);
            }
        } else if (this.templateImageFilename != null && this.templateImageFilename.length() > 0) {
            if (templateImageFile.exists()) {
                this.useTemplate(this.templateImageFilename);
            } else {
                IJ.error((String)("The default template file ('" + this.templateImageFilename + "') did not exist."));
            }
        }
        Applet applet = IJ.getApplet();
        if (applet != null) {
            this.archiveClient = new ArchiveClient(applet);
        }
        if (this.archiveClient != null) {
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            parameters.put("method", "channel-tags");
            parameters.put("md5sum", this.archiveClient.getValue("md5sum"));
            ArrayList tsv_results = this.archiveClient.synchronousRequest(parameters, null);
            int tags = Integer.parseInt(((String[])tsv_results.get(0))[1]);
            int nc82_channel = -1;
            for (int i = 0; i < tags; ++i) {
                String[] row = (String[])tsv_results.get(i);
                if (!"nc82".equals(row[1])) continue;
                nc82_channel = Integer.parseInt(row[0]);
                break;
            }
            if (nc82_channel < 0) {
                this.imp = IJ.getImage();
                if (this.imp == null) {
                    IJ.error((String)"There's no image to annotate.");
                    return;
                }
            } else {
                String lookFor = "Ch" + (nc82_channel + 1);
                int[] wList = WindowManager.getIDList();
                if (wList == null) {
                    IJ.error((String)"NamePoints: no images have been loaded");
                    return;
                }
                for (int i = 0; i < wList.length; ++i) {
                    ImagePlus tmpImp = WindowManager.getImage((int)wList[i]);
                    String title = tmpImp != null ? tmpImp.getTitle() : "";
                    int indexOfChannel = title.indexOf(lookFor);
                    if (indexOfChannel >= 0) continue;
                    tmpImp.close();
                }
                this.imp = IJ.getImage();
                if (this.imp == null) {
                    IJ.error((String)"There's no image to annotate.");
                    return;
                }
            }
        } else {
            this.imp = IJ.getImage();
            if (this.imp == null) {
                IJ.error((String)"There's no image to annotate.");
                return;
            }
        }
        Calibration c = this.imp.getCalibration();
        this.x_spacing = c.pixelWidth;
        this.y_spacing = c.pixelHeight;
        this.z_spacing = c.pixelDepth;
        this.canvas = this.imp.getCanvas();
        if (applet == null && !(foundExistingPointsFile = this.loadAtStart())) {
            this.points = new NamedPointSet();
            if (templateImageFile != null && templateImageFile.exists()) {
                try {
                    this.templatePoints = NamedPointSet.forImage((String)this.templateImageFilename);
                }
                catch (NamedPointSet.PointsFileException e) {
                    IJ.error((String)("Couldn't load points file for template image.  The error was: " + (Object)((Object)e)));
                }
            }
            if (this.templatePoints == null) {
                this.points.addNewPoint();
            } else {
                String[] templatePointNames;
                for (String name : templatePointNames = this.templatePoints.getPointNames()) {
                    this.points.add(new NamedPointWorld(name));
                }
            }
        }
        boolean loadedTemplate = false;
        if (templateParameter != null && this.useTemplate(templateParameter)) {
            loadedTemplate = true;
        }
        this.dialog = new PointsDialog("Marking up: " + this.imp.getTitle(), this.archiveClient, loadedTemplate ? templateParameter : null, (NamePoints)this);
    }
}

