/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import distance.Correlation;
import distance.Euclidean;
import distance.MutualInformation;
import distance.Thresholded;
import distance.TwoValues;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Choice;
import java.awt.Frame;
import java.util.ArrayList;
import vib.FastMatrix;
import vib.RigidRegistration;
import vib.TransformedImage;
import vib.VIB;

public class RigidRegistration_
extends RigidRegistration
implements PlugInFilter {
    ImagePlus image;
    GenericDialog gd;

    public void run(ImageProcessor ip) {
        this.verbose = true;
        this.gd = new GenericDialog("Registration Parameters");
        this.gd.addMessage("Transforming: " + this.image.getTitle());
        this.gd.addStringField("initialTransform", "", 30);
        this.gd.addNumericField("n initial positions to try", 1.0, 0);
        int level = 0;
        while (this.image.getWidth() >> level > 20) {
            ++level;
        }
        this.gd.addNumericField("tolerance", 1.0, 3);
        this.gd.addNumericField("level", (double)level, 0);
        this.gd.addNumericField("stopLevel", (double)(level > 2 ? 2 : level), 0);
        this.gd.addStringField("materialCenterAndBBox", "", 30);
        this.gd.addCheckbox("noOptimization", false);
        this.gd.addCheckbox("showTransformed", false);
        this.gd.addCheckbox("showDifferenceImage", false);
        this.gd.addCheckbox("Fast but inaccurate", false);
        int[] wIDs = WindowManager.getIDList();
        if (wIDs == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] titles = new String[wIDs.length];
        for (int i = 0; i < wIDs.length; ++i) {
            titles[i] = WindowManager.getImage((int)wIDs[i]).getTitle();
        }
        ArrayList<ImagePlus> otherImages = new ArrayList<ImagePlus>();
        boolean isLabels = AmiraParameters.isAmiraLabelfield((ImagePlus)this.image);
        if (isLabels) {
            AmiraParameters params = new AmiraParameters(this.image);
            this.materials1 = params.getMaterialList();
            this.gd.addChoice("material", this.materials1, this.materials1[0]);
            AmiraParameters.addAmiraLabelsList((GenericDialog)this.gd, (String)"Template");
            this.gd.addChoice("templateMaterial", this.materials1, this.materials1[0]);
            this.getMaterials2();
        } else {
            this.gd.addChoice("Template", titles, WindowManager.getCurrentImage().getTitle());
            String[] methods = new String[]{"Euclidean", "MutualInfo", "Threshold55", "Threshold155", "Correlation"};
            this.gd.addChoice("measure", methods, "Euclidean");
            this.gd.addMessage("Also transform these images:");
            for (int i = 0; i < wIDs.length; ++i) {
                ImagePlus imp = WindowManager.getImage((int)wIDs[i]);
                if (imp.getWidth() != this.image.getWidth() || imp.getHeight() != this.image.getHeight() || imp.getStackSize() != this.image.getStackSize()) continue;
                otherImages.add(imp);
                this.gd.addCheckbox(imp.getTitle(), false);
            }
        }
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        String initial = this.gd.getNextString();
        int nInitialPositions = (int)this.gd.getNextNumber();
        double tolerance = this.gd.getNextNumber();
        level = (int)this.gd.getNextNumber();
        int stopLevel = (int)this.gd.getNextNumber();
        String materialBBox = this.gd.getNextString();
        boolean noOptimization = this.gd.getNextBoolean();
        boolean showTransformed = this.gd.getNextBoolean();
        boolean showDifferenceImage = this.gd.getNextBoolean();
        boolean fastButInaccurate = this.gd.getNextBoolean();
        int mat1 = isLabels ? this.gd.getNextChoiceIndex() : -1;
        ImagePlus templ = WindowManager.getImage((String)this.gd.getNextChoice());
        int mat2 = isLabels ? this.gd.getNextChoiceIndex() : -1;
        TransformedImage trans = new TransformedImage(templ, this.image);
        ArrayList alsoTransform = new ArrayList();
        int templType = templ.getType();
        int imageType = this.image.getType();
        int templBitDepth = templ.getBitDepth();
        int imageBitDepth = this.image.getBitDepth();
        ImageStack templStack = templ.getStack();
        ImageStack imageStack = this.image.getStack();
        if (templBitDepth != imageBitDepth) {
            IJ.error((String)"Images must both be of the same bit depth");
            return;
        }
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        if (templBitDepth != 8) {
            if (templBitDepth == 16) {
                float[] valuesRange = trans.getValuesRange();
                minValue = valuesRange[0];
                maxValue = valuesRange[1];
            } else {
                IJ.error((String)("Unsupported bit depth: " + templBitDepth));
                return;
            }
        }
        if (isLabels) {
            trans.measure = new TwoValues(mat1, mat2);
            if (this.verbose) {
                VIB.println((String)("working on materials " + mat1 + " " + mat2));
            }
        } else {
            int measureIndex = this.gd.getNextChoiceIndex();
            if (measureIndex == 1) {
                if (templBitDepth == 8) {
                    trans.measure = new MutualInformation();
                } else if (templBitDepth == 16) {
                    trans.measure = new MutualInformation(minValue, maxValue, 256);
                }
            } else {
                trans.measure = measureIndex == 2 ? new Thresholded(55) : (measureIndex == 3 ? new Thresholded(155) : (measureIndex == 4 ? new Correlation() : new Euclidean()));
            }
            for (int i = 0; i < otherImages.size(); ++i) {
                if (!this.gd.getNextBoolean()) continue;
                alsoTransform.add(otherImages.get(i));
            }
        }
        FastMatrix matrix = this.rigidRegistration(trans, materialBBox, initial, mat1, mat2, noOptimization, level, stopLevel, tolerance, nInitialPositions, showTransformed, showDifferenceImage, fastButInaccurate, alsoTransform);
        if (!Interpreter.isBatchMode() && this.verbose) {
            WindowManager.setWindow((Frame)new TextWindow("Matrix", matrix.toStringForAmira(), 550, 150));
        }
        lastResult = matrix;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 135;
    }

    void getMaterials2() {
        Choice templateChoice = (Choice)this.gd.getChoices().get(1);
        int index = templateChoice.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        String template = templateChoice.getItem(index);
        ImagePlus t = WindowManager.getImage((String)template);
        AmiraParameters params = new AmiraParameters(t);
        this.materials2 = params.getMaterialList();
        Choice mat2 = (Choice)this.gd.getChoices().get(2);
        String chosen = mat2 == null ? null : mat2.getItem(mat2.getSelectedIndex());
        mat2.removeAll();
        int selectedIndex = 0;
        for (int i = 0; i < this.materials2.length; ++i) {
            mat2.addItem(this.materials2[i]);
            if (chosen == null || !this.materials2[i].equals(chosen)) continue;
            selectedIndex = i;
        }
        if (chosen == null) {
            this.adjustMaterial(false);
        } else {
            mat2.select(selectedIndex);
        }
    }

    void adjustMaterial(boolean fromTemplate) {
        Choice c1 = (Choice)this.gd.getChoices().get(0);
        Choice c2 = (Choice)this.gd.getChoices().get(2);
        if (fromTemplate) {
            Choice c3 = c1;
            c1 = c2;
            c2 = c3;
        }
        int index = c1.getSelectedIndex();
        String chosen = c1.getItem(index);
        for (int i = 0; i < c2.getItemCount(); ++i) {
            if (!chosen.equals(c2.getItem(i))) continue;
            c2.select(i);
            return;
        }
        if (c2.getSelectedIndex() < 0) {
            c2.select(0);
        }
    }
}

