/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apposed.appose.SharedMemory;

public class NDArray
implements AutoCloseable {
    private final SharedMemory shm;
    private final DType dType;
    private final Shape shape;

    public NDArray(DType dType, Shape shape, SharedMemory shm) {
        this.dType = dType;
        this.shape = shape;
        this.shm = shm == null ? SharedMemory.create(shape.numElements() * (long)dType.bytesPerElement()) : shm;
    }

    public NDArray(DType dType, Shape shape) {
        this(dType, shape, null);
    }

    public DType dType() {
        return this.dType;
    }

    public Shape shape() {
        return this.shape;
    }

    public SharedMemory shm() {
        return this.shm;
    }

    public ByteBuffer buffer() {
        long length = this.shape.numElements() * (long)this.dType.bytesPerElement();
        return this.shm.buf(0L, length);
    }

    @Override
    public void close() {
        this.shm.close();
    }

    public String toString() {
        return "NDArray(dType=" + (Object)((Object)this.dType) + ", shape=" + this.shape + ", shm=" + this.shm + ")";
    }

    public static class Shape {
        private final Order order;
        private final int[] shape;

        public Shape(Order order, int ... shape) {
            this.order = order;
            this.shape = shape;
        }

        public int get(int d) {
            return this.shape[d];
        }

        public int length() {
            return this.shape.length;
        }

        public Order order() {
            return this.order;
        }

        public long numElements() {
            long n = 1L;
            for (int s : this.shape) {
                n *= (long)s;
            }
            return n;
        }

        public int[] toIntArray() {
            return this.shape;
        }

        public int[] toIntArray(Order order) {
            if (order.equals((Object)this.order)) {
                return this.shape;
            }
            int[] iShape = new int[this.shape.length];
            Arrays.setAll(iShape, i -> this.shape[this.shape.length - i - 1]);
            return iShape;
        }

        public long[] toLongArray() {
            return this.toLongArray(this.order);
        }

        public long[] toLongArray(Order order) {
            long[] lShape = new long[this.shape.length];
            if (order.equals((Object)this.order)) {
                Arrays.setAll(lShape, i -> this.shape[i]);
            } else {
                Arrays.setAll(lShape, i -> this.shape[this.shape.length - i - 1]);
            }
            return lShape;
        }

        public Shape to(Order order) {
            return order.equals((Object)this.order) ? this : new Shape(order, this.toIntArray(order));
        }

        public String toString() {
            return "Shape{order=" + (Object)((Object)this.order) + ", shape=" + Arrays.toString(this.shape) + '}';
        }

        public static enum Order {
            C_ORDER,
            F_ORDER;

        }
    }

    public static enum DType {
        INT8("int8", 1),
        INT16("int16", 2),
        INT32("int32", 4),
        INT64("int64", 8),
        UINT8("uint8", 1),
        UINT16("uint16", 2),
        UINT32("uint32", 4),
        UINT64("uint64", 8),
        FLOAT32("float32", 4),
        FLOAT64("float64", 8),
        COMPLEX64("complex64", 8),
        COMPLEX128("complex128", 16),
        BOOL("bool", 1);

        private final String label;
        private final int bytesPerElement;

        private DType(String label, int bytesPerElement) {
            this.label = label;
            this.bytesPerElement = bytesPerElement;
        }

        public int bytesPerElement() {
            return this.bytesPerElement;
        }

        public String label() {
            return this.label;
        }

        public static DType fromLabel(String label) throws IllegalArgumentException {
            return DType.valueOf(label.toUpperCase());
        }
    }
}

