/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.io.ArrayFile;
import edu.mines.jtk.io.ArrayInputStream;
import edu.mines.jtk.io.ArrayOutputStream;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Stopwatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;

public class ArrayFileBench {
    public static void main(String[] args) {
        ArrayFileBench.benchEndian();
        ArrayFileBench.benchStream();
    }

    private static void benchStream() {
        try {
            boolean[] b;
            for (boolean buffered : b = new boolean[]{false, true}) {
                File file = File.createTempFile("junk", "dat");
                file.deleteOnExit();
                ArrayFileBench.benchStream(file, buffered);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void benchStream(File file, boolean buffered) throws IOException {
        long nr;
        System.out.println("buffered=" + buffered);
        Stopwatch sw = new Stopwatch();
        int nh = 60;
        int na = 1000;
        int[] h = ArrayMath.randint(nh);
        float[] a = ArrayMath.randfloat(na);
        double maxtime = 60.0;
        double mbytes = 4.0E-6 * (double)(nh + na);
        FileOutputStream fos = new FileOutputStream(file);
        ArrayOutputStream aos = buffered ? new ArrayOutputStream(new BufferedOutputStream(fos)) : new ArrayOutputStream(fos);
        sw.restart();
        long nw = 0L;
        double s = 0.0;
        while (sw.time() < maxtime) {
            s += (double)ArrayMath.sum(a);
            aos.writeInts(h);
            aos.writeFloats(a);
            ++nw;
        }
        aos.close();
        sw.stop();
        long rate = (int)(mbytes * (double)nw / sw.time());
        System.out.println("ArrayOutputStream: sum=" + s + " nw=" + nw + " rate=" + rate);
        FileInputStream fis = new FileInputStream(file);
        ArrayInputStream ais = buffered ? new ArrayInputStream(new BufferedInputStream(fis)) : new ArrayInputStream(fis);
        sw.restart();
        s = 0.0;
        for (nr = 0L; nr < nw; ++nr) {
            ais.readInts(h);
            ais.readFloats(a);
            s += (double)ArrayMath.sum(a);
        }
        ais.close();
        sw.stop();
        rate = (int)(mbytes * (double)nr / sw.time());
        System.out.println(" ArrayInputStream: sum=" + s + " nr=" + nr + " rate=" + rate);
    }

    private static void benchEndian() {
        ArrayFileBench.benchBigEndian();
        ArrayFileBench.benchLittleEndian();
    }

    private static void benchBigEndian() {
        ArrayFileBench.bench(ByteOrder.BIG_ENDIAN);
    }

    private static void benchLittleEndian() {
        ArrayFileBench.bench(ByteOrder.LITTLE_ENDIAN);
    }

    private static void bench(ByteOrder order) {
        System.out.println("order=" + order);
        int n = 1000000;
        try {
            File file = File.createTempFile("junk", "dat");
            file.deleteOnExit();
            ArrayFile af = new ArrayFile(file, "rw", order, order);
            ArrayFileBench.benchFloat(af, n);
            ArrayFileBench.benchDouble(af, n);
            af.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void benchFloat(ArrayFile af, int n) throws IOException {
        float[] a = ArrayMath.randfloat(n);
        float[] b = ArrayMath.zerofloat(n);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int nio = 0;
        while (sw.time() < 5.0) {
            af.seek(0L);
            af.writeFloats(a);
            af.seek(0L);
            af.readFloats(b);
            ++nio;
        }
        sw.stop();
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            throw new RuntimeException(" float: i/o failure");
        }
        double time = sw.time();
        double rate = 8.0E-6 * (double)nio * (double)n / time;
        System.out.println(" float: rate=" + rate + " MB/s");
    }

    private static void benchDouble(ArrayFile af, int n) throws IOException {
        double[] a = ArrayMath.randdouble(n);
        double[] b = ArrayMath.zerodouble(n);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int nio = 0;
        while (sw.time() < 5.0) {
            af.seek(0L);
            af.writeDoubles(a);
            af.seek(0L);
            af.readDoubles(b);
            ++nio;
        }
        sw.stop();
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            throw new RuntimeException("double: i/o failure");
        }
        double time = sw.time();
        double rate = 1.6E-5 * (double)nio * (double)n / time;
        System.out.println("double: rate=" + rate + " MB/s");
    }
}

