/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.EigenTensors2;
import edu.mines.jtk.dsp.LocalSmoothingFilter;
import edu.mines.jtk.dsp.Tensors2;
import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalSmoothingFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LocalSmoothingFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSpd2() {
        int n1 = 5;
        int n2 = 6;
        LocalSmoothingFilter lsf = new LocalSmoothingFilter(1.0E-6, 1000);
        lsf.setPreconditioner(true);
        for (int iter = 0; iter < 10; ++iter) {
            float[][] s = ArrayMath.randfloat(n1, n2);
            float[][] x = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
            float[][] y = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
            float[][] dx = ArrayMath.zerofloat(n1, n2);
            float[][] dy = ArrayMath.zerofloat(n1, n2);
            RandomTensors2 d = new RandomTensors2(n1, n2);
            float c = 10.0f * s[n2 / 2][n1 / 2];
            lsf.apply(d, c, s, x, dx);
            lsf.apply(d, c, s, y, dy);
            float xdx = LocalSmoothingFilterTest.dot(x, dx);
            float ydy = LocalSmoothingFilterTest.dot(y, dy);
            float ydx = LocalSmoothingFilterTest.dot(y, dx);
            float xdy = LocalSmoothingFilterTest.dot(x, dy);
            LocalSmoothingFilterTest.assertTrue((xdx >= 0.0f ? 1 : 0) != 0);
            LocalSmoothingFilterTest.assertTrue((ydy >= 0.0f ? 1 : 0) != 0);
            LocalSmoothingFilterTest.assertEquals((double)xdy, (double)ydx, (double)1.0E-4);
        }
    }

    private static float dot(float[][] x, float[][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static float dot(float[][][] x, float[][][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static class IdentityTensors3
    implements Tensors3 {
        private IdentityTensors3() {
        }

        @Override
        public void getTensor(int i1, int i2, int i3, float[] a) {
            a[0] = 1.0f;
            a[1] = 0.0f;
            a[2] = 0.0f;
            a[3] = 1.0f;
            a[4] = 0.0f;
            a[5] = 1.0f;
        }
    }

    private static class IdentityTensors2
    implements Tensors2 {
        private IdentityTensors2() {
        }

        @Override
        public void getTensor(int i1, int i2, float[] a) {
            a[0] = 1.0f;
            a[1] = 0.0f;
            a[2] = 1.0f;
        }
    }

    private static class RandomTensors2
    extends EigenTensors2 {
        RandomTensors2(int n1, int n2) {
            super(n1, n2);
            Random r = new Random();
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float a = (float)Math.PI * 2 * r.nextFloat();
                    float u1 = ArrayMath.cos(a);
                    float u2 = ArrayMath.sin(a);
                    float du = 1.0E-4f + 9.0E-4f * r.nextFloat();
                    float dv = 1.0E-4f + 0.9999f * r.nextFloat();
                    this.setEigenvectorU(i1, i2, u1, u2);
                    this.setEigenvalues(i1, i2, du, dv);
                }
            }
        }
    }
}

