/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.snippet;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.scijava.script.ScriptLanguage;
import org.scijava.search.SearchResult;

public class SnippetSearchResult
implements SearchResult {
    private final ScriptLanguage language;
    private final String snippet;
    private final Map<String, String> props;

    public SnippetSearchResult(ScriptLanguage language, String snippet) {
        this.language = language;
        this.snippet = snippet;
        this.props = new LinkedHashMap<String, String>();
        this.props.put("Language", language.getLanguageName());
        this.props.put("Nicknames", this.s(language.getNames()));
        this.props.put("Extensions", this.s(language.getExtensions()));
        this.props.put("Engine Name", language.getEngineName());
        this.props.put("Engine Version", language.getEngineVersion());
        this.props.put("MIME Types", this.s(language.getMimeTypes()));
    }

    public ScriptLanguage language() {
        return this.language;
    }

    public String snippet() {
        return this.snippet;
    }

    @Override
    public String name() {
        return this.language.getLanguageName() + ": " + this.snippet;
    }

    @Override
    public String iconPath() {
        return "/icons/search/code.png";
    }

    @Override
    public Map<String, String> properties() {
        return this.props;
    }

    private String s(List<String> names) {
        if (names == null || names.isEmpty()) {
            return "<None>";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(names.get(i));
        }
        return sb.toString();
    }
}

