/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;

public class Colocalisation_Test
implements PlugIn {
    static boolean headingsSet2;
    private static int index1;
    private static int index2;
    private ImagePlus imp1;
    private ImagePlus imp2;
    private ImagePlus impmask;
    private ImagePlus imp3;
    private ImageProcessor ipmask;
    private int indexRoi = (int)Prefs.get((String)"Rand_indexRoi.int", (double)0.0);
    private int indexRand = (int)Prefs.get((String)"Rand_indexRand.int", (double)0.0);
    private boolean useROI;
    private boolean useMask;
    private Roi roi;
    private Roi roi1;
    private Roi roi2;
    private static boolean randZ;
    private static boolean ignoreZeroZero;
    private static boolean smooth;
    private static boolean keep;
    private static boolean currentSlice;
    private static boolean useManPSF;
    private static boolean showR;
    private static double psf;
    private static int manPSF;
    private static int iterations;
    private static double ch2Lambda;
    private static double NA;
    private static double pixelSize;
    DecimalFormat df3 = new DecimalFormat("##0.000");
    DecimalFormat df2 = new DecimalFormat("##0.00");
    DecimalFormat df1 = new DecimalFormat("##0.0");
    DecimalFormat df0 = new DecimalFormat("##0");
    String[] chooseRand = new String[]{"Fay (x,y,z translation)", "Costes approximation (smoothed noise)", "van Steensel (x translation)"};
    private int width;
    private int height;
    private int rwidth;
    private int rheight;
    private int xOffset;
    private int yOffset;
    private int mask;
    String randMethod = "Fay";
    private long startTime;
    private long endTime;
    StringBuffer rVals = new StringBuffer();
    boolean Costes = false;
    boolean Fay = false;
    boolean vanS = false;
    boolean rBlocks = false;
    protected static TextWindow textWindow;

    public void run(String arg) {
        this.startTime = System.currentTimeMillis();
        if (this.showDialog()) {
            this.correlate(this.imp1, this.imp2, this.imp3);
        }
    }

    public boolean showDialog() {
        int[] wList;
        block24: {
            block23: {
                wList = WindowManager.getIDList();
                if (wList == null) {
                    IJ.noImage();
                    return false;
                }
                String[] titles = new String[wList.length];
                String[] chooseROI = new String[wList.length + 3];
                chooseROI[0] = "None";
                chooseROI[1] = "ROI in channel 1 ";
                chooseROI[2] = "ROI in channel 2";
                if (this.indexRoi > wList.length + 3) {
                    this.indexRoi = 0;
                }
                for (int i = 0; i < wList.length; ++i) {
                    ImagePlus imp = WindowManager.getImage((int)wList[i]);
                    if (imp != null) {
                        titles[i] = imp.getTitle();
                        chooseROI[i + 3] = imp.getTitle();
                        continue;
                    }
                    titles[i] = "";
                }
                if (index1 >= titles.length) {
                    index1 = 0;
                }
                if (index2 >= titles.length) {
                    index2 = 0;
                }
                GenericDialog gd = new GenericDialog("Colocalisation Test");
                gd.addChoice("Channel_1", titles, titles[index1]);
                gd.addChoice("Channel_2", titles, titles[index2]);
                gd.addChoice("ROI or Mask", chooseROI, chooseROI[this.indexRoi]);
                gd.addChoice("Randomization method", this.chooseRand, this.chooseRand[this.indexRand]);
                gd.addCheckbox("Current_slice only (Ch1)", currentSlice);
                gd.addCheckbox("Keep_example randomized image", keep);
                gd.addCheckbox("Show_all_R_values from Ch1 vs  Ch2(rand)", showR);
                gd.addMessage("See: http://uhnresearch.ca/wcif/imagej");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return false;
                }
                index1 = gd.getNextChoiceIndex();
                index2 = gd.getNextChoiceIndex();
                this.indexRoi = gd.getNextChoiceIndex();
                this.indexRand = gd.getNextChoiceIndex();
                ignoreZeroZero = true;
                currentSlice = gd.getNextBoolean();
                keep = gd.getNextBoolean();
                showR = gd.getNextBoolean();
                String title1 = titles[index1];
                String title2 = titles[index2];
                this.imp1 = WindowManager.getImage((int)wList[index1]);
                this.imp2 = WindowManager.getImage((int)wList[index2]);
                if (this.imp1.getType() == 4) break block23;
                if (this.imp2.getType() != 4) break block24;
            }
            IJ.showMessage((String)"Colocalisation Test", (String)"Both images must be grayscale.");
            return false;
        }
        this.useMask = false;
        if (this.indexRoi >= 3) {
            this.imp3 = WindowManager.getImage((int)(this.indexRoi - 2));
            this.useMask = true;
        } else {
            this.imp3 = WindowManager.getImage((int)wList[index2]);
        }
        Calibration cal = this.imp2.getCalibration();
        pixelSize = cal.pixelWidth;
        if (this.indexRand == 0) {
            this.Fay = true;
            this.randMethod = "Fay";
        }
        if (this.indexRand == 1) {
            this.Costes = true;
            this.randMethod = "Costes X, Y";
        }
        if (this.indexRand == 2) {
            this.vanS = true;
            this.randMethod = "van Steensel";
        }
        boolean matchWidth = false;
        boolean matchHeight = false;
        boolean matchSlice = false;
        if (this.imp1.getWidth() == this.imp2.getWidth() && this.imp1.getWidth() == this.imp3.getWidth()) {
            matchWidth = true;
        }
        if (this.imp1.getHeight() == this.imp2.getHeight() && this.imp1.getHeight() == this.imp3.getHeight()) {
            matchHeight = true;
        }
        if (this.imp1.getStackSize() == this.imp2.getStackSize() && this.imp1.getStackSize() == this.imp3.getStackSize()) {
            matchSlice = true;
        }
        if (!(matchWidth && matchHeight && matchSlice)) {
            IJ.showMessage((String)"Image mismatch", (String)"Images do not match. Exiting");
            return false;
        }
        if (this.Costes || this.rBlocks) {
            GenericDialog gd2 = new GenericDialog("PSF details");
            gd2.addCheckbox("Randomize pixels in z-axis", randZ);
            gd2.addNumericField("Pixel Size (\u00b5m)", pixelSize, 3);
            gd2.addNumericField("Channel_2_wavelength (nm)", ch2Lambda, 0);
            gd2.addNumericField("NA of objective", NA, 2);
            gd2.addNumericField("Iterations", (double)iterations, 0);
            gd2.addMessage("");
            gd2.addCheckbox("Use_manual_PSF", useManPSF);
            gd2.addNumericField("PSF_radius in pixels", (double)manPSF, 0);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return false;
            }
            randZ = gd2.getNextBoolean();
            if (randZ) {
                this.randMethod = this.randMethod + ", Z";
            }
            pixelSize = gd2.getNextNumber();
            ch2Lambda = gd2.getNextNumber();
            NA = gd2.getNextNumber();
            iterations = (int)gd2.getNextNumber();
            useManPSF = gd2.getNextBoolean();
            manPSF = (int)gd2.getNextNumber();
            psf = 0.61 * ch2Lambda / NA;
            psf /= pixelSize * 1000.0;
            if (useManPSF) {
                psf = manPSF;
            }
        }
        return true;
    }

    public void correlate(ImagePlus imp1, ImagePlus imp2, ImagePlus imp3) {
        int ch2;
        int ch1;
        String Ch1fileName = imp1.getTitle();
        String Ch2fileName = imp2.getTitle();
        ImageStack img1 = imp1.getStack();
        ImageStack img2 = imp2.getStack();
        ImageStack img3 = imp3.getStack();
        int width = imp1.getWidth();
        int height = imp1.getHeight();
        String fileName = Ch1fileName + " and " + Ch2fileName;
        ImageProcessor ip1 = imp1.getProcessor();
        ImageProcessor ip2 = imp2.getProcessor();
        ImageProcessor ip3 = null;
        if (this.useMask) {
            ip3 = imp3.getProcessor();
        }
        ImageStack stackRand = new ImageStack(this.rwidth, this.rheight);
        ImageProcessor ipRand = img2.getProcessor(1);
        int currentSliceNo = imp1.getCurrentSlice();
        if (currentSlice) {
            fileName = fileName + ". slice: " + currentSliceNo;
        }
        double pearsons1 = 0.0;
        double pearsons2 = 0.0;
        double pearsons3 = 0.0;
        double r2 = 1.0;
        double r = 1.0;
        double ch1Max = 0.0;
        double ch1Min = ip1.getMax();
        double ch2Max = 0.0;
        double ch2Min = ip1.getMax();
        int nslices = imp1.getStackSize();
        double sumX = 0.0;
        double sumXY = 0.0;
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumY = 0.0;
        double sumXtotal = 0.0;
        double sumYtotal = 0.0;
        double colocX = 0.0;
        double colocY = 0.0;
        int N = 0;
        int N2 = 0;
        double r2min = 1.0;
        double r2max = -1.0;
        sumX = 0.0;
        sumXY = 0.0;
        sumXX = 0.0;
        sumYY = 0.0;
        sumY = 0.0;
        boolean i = true;
        double coloc2M1 = 0.0;
        double coloc2M2 = 0.0;
        int colocCount = 0;
        boolean colocCount1 = false;
        boolean colocCount2 = false;
        double r2sd = 0.0;
        double sumr2sqrd = 0.0;
        double sumr2 = 0.0;
        double ICQ2mean = 0.0;
        double sumICQ2sqrd = 0.0;
        double sumICQ2 = 0.0;
        double ICQobs = 0.0;
        int countICQ = 0;
        int Nr = 0;
        int Ng = 0;
        ImageStatistics stats = imp2.getStatistics();
        if (imp2.getType() == 1) {
            stats.nBins = 65536;
        }
        int[] histogram = new int[stats.nBins];
        this.useROI = this.indexRoi == 1 || this.indexRoi == 2;
        ip1 = imp1.getProcessor();
        ip2 = imp2.getProcessor();
        ip3 = imp2.getProcessor();
        if (this.useMask) {
            ip3 = imp3.getProcessor();
        }
        this.roi1 = imp1.getRoi();
        this.roi2 = imp2.getRoi();
        Rectangle rect = ip1.getRoi();
        if (this.indexRoi == 1) {
            if (this.roi1 == null) {
                this.useROI = false;
            } else {
                this.ipmask = imp1.getMask();
                rect = ip1.getRoi();
            }
        }
        if (this.indexRoi == 2) {
            if (this.roi2 == null) {
                this.useROI = false;
            } else {
                this.ipmask = imp2.getMask();
                rect = ip2.getRoi();
            }
        }
        if (!this.useROI) {
            this.xOffset = 0;
            this.yOffset = 0;
            this.rwidth = width;
            this.rheight = height;
        } else {
            this.xOffset = rect.x;
            this.yOffset = rect.y;
            this.rwidth = rect.width;
            this.rheight = rect.height;
        }
        boolean g1 = false;
        boolean g2 = false;
        int histCount = 0;
        for (int s = 1; s <= nslices; ++s) {
            if (currentSlice) {
                nslices = s = currentSliceNo;
            }
            ip1 = img1.getProcessor(s);
            ip2 = img2.getProcessor(s);
            ip3 = img3.getProcessor(s);
            for (int y = 0; y < this.rheight; ++y) {
                IJ.showStatus((String)"Calculating r for original images. Press 'Esc' to abort");
                if (IJ.escapePressed()) {
                    IJ.beep();
                    return;
                }
                for (int x = 0; x < this.rwidth; ++x) {
                    this.mask = (int)ip3.getPixelValue(x, y);
                    if (this.indexRoi == 0) {
                        this.mask = 1;
                    }
                    if (this.useROI && this.ipmask != null) {
                        this.mask = (int)this.ipmask.getPixelValue(x, y);
                    }
                    if (this.mask == 0) continue;
                    ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                    ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset);
                    if (ch1Max < (double)ch1) {
                        ch1Max = ch1;
                    }
                    if (ch1Min > (double)ch1) {
                        ch1Min = ch1;
                    }
                    if (ch2Max < (double)ch2) {
                        ch2Max = ch2;
                    }
                    if (ch2Min > (double)ch2) {
                        ch2Min = ch2;
                    }
                    ++N;
                    if (ch1 + ch2 != 0) {
                        ++N2;
                    }
                    sumXtotal += (double)ch1;
                    sumYtotal += (double)ch2;
                    if (ch2 > 0) {
                        colocX += (double)ch1;
                    }
                    if (ch1 > 0) {
                        colocY += (double)ch2;
                    }
                    sumX += (double)ch1;
                    sumXY += (double)(ch1 * ch2);
                    sumXX += (double)(ch1 * ch1);
                    sumYY += (double)(ch2 * ch2);
                    sumY += (double)ch2;
                    if (ch1 > 0) {
                        ++Nr;
                    }
                    if (ch2 > 0) {
                        ++Ng;
                    }
                    histCount = histogram[ch2];
                    histogram[ch2] = ++histCount;
                }
            }
        }
        if (ignoreZeroZero) {
            N = N2;
        }
        double ch1Mean = sumX / (double)N;
        double ch2Mean = sumY / (double)N;
        pearsons1 = sumXY - sumX * sumY / (double)N;
        pearsons2 = sumXX - sumX * sumX / (double)N;
        pearsons3 = sumYY - sumY * sumY / (double)N;
        r = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
        double colocM1 = colocX / sumXtotal;
        double colocM2 = colocY / sumYtotal;
        int countAll = 0;
        int countPos = 0;
        double PDMobs = 0.0;
        double PDM = 0.0;
        int countAll2 = 0;
        for (int s = 1; s <= nslices; ++s) {
            if (currentSlice) {
                nslices = s = currentSliceNo;
            }
            ip1 = img1.getProcessor(s);
            ip2 = img2.getProcessor(s);
            ip3 = img3.getProcessor(s);
            for (int y = 0; y <= this.rheight; ++y) {
                IJ.showStatus((String)"Calculating r for original images. Press 'Esc' to abort");
                if (IJ.escapePressed()) {
                    IJ.beep();
                    return;
                }
                for (int x = 0; x <= this.rwidth; ++x) {
                    this.mask = (int)ip3.getPixelValue(x, y);
                    if (this.indexRoi == 0) {
                        this.mask = 1;
                    }
                    if (this.useROI && this.ipmask != null) {
                        this.mask = (int)this.ipmask.getPixelValue(x, y);
                    }
                    if (this.mask == 0 || (ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset)) + (ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset)) == 0) continue;
                    PDMobs = ((double)ch1 - ch1Mean) * ((double)ch2 - ch2Mean);
                    if (PDMobs > 0.0) {
                        ++countPos;
                    }
                    ++countAll2;
                }
            }
        }
        ICQobs = (double)countPos / (double)countAll2 - 0.5;
        boolean ch3found = false;
        int rx = 0;
        int ry = 0;
        boolean rz = false;
        GaussianBlur gb = new GaussianBlur();
        double r2mean = 0.0;
        int slicesDone = 0;
        boolean xCount = false;
        int xOffset2 = -15;
        int yOffset2 = -10;
        int zOffset2 = 0;
        int startSlice = 1;
        if (this.Costes) {
            xOffset2 = 0;
            yOffset2 = 0;
        }
        if (this.Fay) {
            iterations = 25;
        }
        if (nslices >= 2 && this.Fay) {
            zOffset2 = -1;
        }
        if (this.Fay && nslices >= 2) {
            startSlice = 2;
            nslices -= 2;
            iterations = 75;
        }
        if (this.vanS) {
            xOffset2 = -21;
            startSlice = 1;
            iterations = 41;
        }
        int blockNumberX = (int)((double)width / (psf * 2.0));
        int blockNumberY = (int)((double)height / (psf * 2.0));
        ByteProcessor blockIndex = new ByteProcessor(blockNumberX, blockNumberY);
        double[] vSx = new double[41];
        double[] vSr = new double[41];
        int ch4 = 0;
        int[] zUsed = new int[nslices];
        boolean blockCount = false;
        boolean rBlock = true;
        for (int c = 1; c <= iterations; ++c) {
            stackRand = new ImageStack(this.rwidth, this.rheight);
            if (this.Fay) {
                if (c == 26 || c == 51) {
                    ++zOffset2;
                    xOffset2 = -15;
                    yOffset2 = -10;
                }
                if (xOffset2 < 10) {
                    xOffset2 += 5;
                } else {
                    xOffset2 = -15;
                    yOffset2 += 5;
                }
            }
            if (this.vanS) {
                ++xOffset2;
            }
            for (int s = startSlice; s <= nslices; ++s) {
                ipRand = new ShortProcessor(this.rwidth, this.rheight);
                ++slicesDone;
                if (currentSlice) {
                    nslices = s = currentSliceNo;
                }
                IJ.showStatus((String)("Iteration " + c + "/" + iterations + "  Slice: " + s + "/" + nslices + " 'Esc' to abort"));
                if (IJ.escapePressed()) {
                    IJ.beep();
                    return;
                }
                ip1 = img1.getProcessor(s);
                ip2 = img2.getProcessor(s + zOffset2);
                ip3 = img3.getProcessor(s);
                for (int y = 0; y < this.rheight; ++y) {
                    for (int x = 0; x <= this.rwidth; ++x) {
                        this.mask = 1;
                        if (this.useMask) {
                            this.mask = (int)ip3.getPixelValue(x, y);
                        }
                        if (this.useROI && this.ipmask != null) {
                            this.mask = (int)this.ipmask.getPixelValue(x, y);
                        }
                        if (this.indexRoi == 0) {
                            this.mask = 1;
                        }
                        if (this.mask == 0) continue;
                        ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                        ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset);
                        int ch3 = 0;
                        if (ignoreZeroZero) {
                            if (this.Fay) {
                                ch3 = ip2.getPixel(x + this.xOffset + xOffset2, y + this.yOffset + yOffset2);
                                ipRand.putPixel(x, y, ch3);
                            }
                            if (this.vanS) {
                                ch3 = ip2.getPixel(x + this.xOffset + xOffset2, y + this.yOffset);
                                ipRand.putPixel(x, y, ch3);
                            }
                            if (this.Costes && !randZ || this.Costes && nslices < 2) {
                                ch4 = 1;
                                while (ch4 != 0 || this.mask == 0) {
                                    rx = (int)(Math.random() * (double)width);
                                    ry = (int)(Math.random() * (double)height);
                                    if (this.useMask) {
                                        this.mask = (int)ip3.getPixelValue(rx, ry);
                                    }
                                    if (this.useROI && this.ipmask != null) {
                                        this.mask = (int)this.ipmask.getPixelValue(rx, ry);
                                    }
                                    ch4 = ipRand.getPixel(rx, ry);
                                }
                                ipRand.putPixel(rx, ry, ch2);
                            }
                            if (this.Costes && randZ && nslices > 1 && ch2 != 0) {
                                ch3 = (int)(Math.random() * (ch2Max - ch2Min) + ch2Min);
                                ipRand.putPixel(x, y, ch3);
                            }
                        }
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                        return;
                    }
                }
                if (this.Costes) {
                    gb.blur(ipRand, psf);
                }
                stackRand.addSlice("Correlation Plot", ipRand);
            }
            sumXX = 0.0;
            sumX = 0.0;
            sumXY = 0.0;
            sumYY = 0.0;
            sumY = 0.0;
            N = 0;
            N2 = 0;
            int s2 = 0;
            sumXtotal = 0.0;
            sumYtotal = 0.0;
            colocX = 0.0;
            colocY = 0.0;
            double ICQrand = 0.0;
            int countPos2 = 0;
            countAll = 0;
            if (IJ.escapePressed()) {
                IJ.beep();
                return;
            }
            for (int s = startSlice; s <= nslices; ++s) {
                s2 = s;
                if (this.Fay && nslices >= 2) {
                    --s2;
                }
                if (currentSlice) {
                    nslices = s = currentSliceNo;
                    s2 = 1;
                }
                ip1 = img1.getProcessor(s);
                ip2 = stackRand.getProcessor(s2);
                for (int y = 0; y < this.rheight; ++y) {
                    for (int x = 0; x < this.rwidth; ++x) {
                        this.mask = 1;
                        if (this.useROI && this.ipmask != null) {
                            this.mask = (int)this.ipmask.getPixelValue(x, y);
                        }
                        if (this.mask == 0) continue;
                        ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                        ch2 = ip2.getPixel(x, y);
                        if (ch1Max < (double)ch1) {
                            ch1Max = ch1;
                        }
                        if (ch1Min > (double)ch1) {
                            ch1Min = ch1;
                        }
                        if (ch2Max < (double)ch2) {
                            ch2Max = ch2;
                        }
                        if (ch2Min > (double)ch2) {
                            ch2Min = ch2;
                        }
                        ++N;
                        sumXtotal += (double)ch1;
                        sumYtotal += (double)ch2;
                        if (ch2 > 0) {
                            colocX += (double)ch1;
                        }
                        if (ch1 > 0) {
                            colocY += (double)ch2;
                        }
                        if (ch1 + ch2 != 0) {
                            ++N2;
                        }
                        sumX += (double)ch1;
                        sumXY += (double)(ch1 * ch2);
                        sumXX += (double)(ch1 * ch1);
                        sumYY += (double)(ch2 * ch2);
                        sumY += (double)ch2;
                        if (ch1 + ch2 == 0) continue;
                        PDM = ((double)ch1 - ch1Mean) * ((double)ch2 - ch2Mean);
                        if (PDM > 0.0) {
                            ++countPos2;
                        }
                        ++countAll;
                    }
                }
            }
            if (ignoreZeroZero) {
                N = N2;
            }
            double ICQ2 = (double)countPos2 / (double)countAll - 0.5;
            ICQ2mean += ICQ2;
            if (ICQobs > ICQ2) {
                ++countICQ;
            }
            pearsons1 = sumXY - sumX * sumY / (double)N;
            pearsons2 = sumXX - sumX * sumX / (double)N;
            pearsons3 = sumYY - sumY * sumY / (double)N;
            r2 = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
            if (this.vanS) {
                vSx[c - 1] = xOffset2;
                vSr[c - 1] = r2;
            }
            if (r2 < r2min) {
                r2min = r2;
            }
            if (r2 > r2max) {
                r2max = r2;
            }
            this.rVals.append(r2 + "\n");
            r2mean += r2;
            if (r > r2) {
                ++colocCount;
            }
            sumr2sqrd += r2 * r2;
            sumr2 += r2;
            sumICQ2sqrd += ICQ2 * ICQ2;
            sumICQ2 += ICQ2;
        }
        r2sd = Math.sqrt(((double)iterations * sumr2sqrd - sumr2 * sumr2) / (double)(iterations * (iterations - 1)));
        double ICQ2sd = Math.sqrt(((double)iterations * sumICQ2sqrd - sumICQ2 * sumICQ2) / (double)(iterations * (iterations - 1)));
        double Zscore = (r - (r2mean /= (double)iterations)) / r2sd;
        double ZscoreICQ = (ICQobs - (ICQ2mean /= (double)iterations)) / ICQ2sd;
        String icqPercentile = "<50%";
        String Percentile = "" + (iterations - colocCount) + "/" + iterations;
        double fx = 0.5 * (1.0 + Colocalisation_Test.erf(r - r2mean) / (Math.sqrt(2.0) * r2sd));
        if (fx >= 1.0) {
            fx = 1.0;
        }
        if (fx <= 0.0) {
            fx = 0.0;
        }
        String Percentile2 = IJ.d2s((double)fx, (int)3) + "";
        if (keep) {
            new ImagePlus("Example random image", stackRand).show();
        }
        double percColoc = (double)colocCount / (double)iterations * 100.0;
        double percICQ = (double)countICQ / (double)iterations * 100.0;
        String Headings2 = "Image\tR(obs)\tR(rand) mean\u00b1sd\tP-value\tR(rand)>R(obs)\tIterations \tRandomisation\tPSF width\n";
        String strPSF = "na";
        if (this.Costes || this.rBlocks) {
            strPSF = this.df3.format(psf * pixelSize * 2.0) + " \u00b5m (" + this.df0.format(psf * 2.0) + " pix.)";
        }
        String str = fileName + "\t" + this.df3.format(r) + "\t" + this.df3.format(r2mean) + "\u00b1" + this.df3.format(r2sd) + "\t" + Percentile2 + "\t" + Percentile + "\t" + this.df0.format(iterations) + "\t" + this.randMethod + "\t" + strPSF;
        if (textWindow == null) {
            textWindow = new TextWindow("Results", Headings2, str, 400, 250);
            textWindow.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent arg0) {
                    textWindow = null;
                }
            });
        } else {
            textWindow.getTextPanel().setColumnHeadings(Headings2);
            textWindow.getTextPanel().appendLine(str);
        }
        IJ.selectWindow((String)"Results");
        if (showR) {
            new TextWindow("Random R values", "R(rand)", this.rVals.toString(), 300, 400);
        }
        if (this.vanS) {
            PlotWindow plot = new PlotWindow("CCF", "x-translation", "Pearsons", vSx, vSr);
            plot.draw();
        }
        Prefs.set((String)"Rand_ignore.boolean", (boolean)ignoreZeroZero);
        Prefs.set((String)"Rand_keep.boolean", (boolean)keep);
        Prefs.set((String)"Rand_manPSF.int", (int)manPSF);
        Prefs.set((String)"Rand_smooth.boolean", (boolean)smooth);
        if (this.Costes) {
            Prefs.set((String)"Rand_iterations.int", (int)iterations);
        }
        Prefs.set((String)"Rand_ch2L.double", (double)ch2Lambda);
        Prefs.set((String)"Rand_NA.double", (double)NA);
        Prefs.set((String)"Rand_pixelSize.double", (double)pixelSize);
        Prefs.set((String)"Rand_currentSlice.boolean", (boolean)currentSlice);
        Prefs.set((String)"Rand_useManPSF.boolean", (boolean)useManPSF);
        Prefs.set((String)"Rand_showR.boolean", (boolean)showR);
        Prefs.set((String)"Rand_indexRoi.int", (int)this.indexRoi);
        Prefs.set((String)"Rand_indexRand.int", (int)this.indexRand);
        Prefs.set((String)"Rand_randZ.boolean", (boolean)randZ);
        long elapsedTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        String units = "secs";
        if (elapsedTime > 90L) {
            elapsedTime /= 60L;
            units = "mins";
        }
        IJ.showStatus((String)("Done.  " + elapsedTime + " " + units));
    }

    public static double erf(double z) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
        double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        if (z >= 0.0) {
            return ans;
        }
        return -ans;
    }

    static {
        index1 = 0;
        index2 = 1;
        randZ = Prefs.get((String)"Rand_randZ.boolean", (boolean)false);
        ignoreZeroZero = Prefs.get((String)"Rand_ignore.boolean", (boolean)true);
        smooth = Prefs.get((String)"Rand_smooth.boolean", (boolean)true);
        keep = Prefs.get((String)"Rand_keep.boolean", (boolean)false);
        currentSlice = Prefs.get((String)"Rand_currentSlice.boolean", (boolean)true);
        useManPSF = Prefs.get((String)"Rand_useManPSF.boolean", (boolean)false);
        showR = Prefs.get((String)"Rand_showR.boolean", (boolean)false);
        psf = 0.0;
        manPSF = (int)Prefs.get((String)"Rand_manPSF.int", (double)10.0);
        iterations = (int)Prefs.get((String)"Rand_iterations.int", (double)0.0);
        ch2Lambda = Prefs.get((String)"Rand_ch2L.double", (double)520.0);
        NA = Prefs.get((String)"Rand_NA.double", (double)1.4);
        pixelSize = Prefs.get((String)"Rand_pixelSize.double", (double)0.1);
    }
}

