/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.gadgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.ImageStatistics;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.InputCheck;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.MaskFactory;

public class DataContainer<T extends RealType<T>> {
    private double meanCh1;
    private double meanCh2;
    private double minCh1;
    private double maxCh1;
    private double minCh2;
    private double maxCh2;
    private double integralCh1;
    private double integralCh2;
    private RandomAccessibleInterval<T> sourceImage1;
    private RandomAccessibleInterval<T> sourceImage2;
    private String sourceImage1Name;
    private String sourceImage2Name;
    public String jobName;
    private RandomAccessibleInterval<BitType> mask;
    protected MaskType maskType;
    private int maskHash;
    private int ch1;
    private int ch2;
    protected long[] maskBBSize = null;
    protected long[] maskBBOffset = null;
    InputCheck<T> inputCheck = null;
    AutoThresholdRegression<T> autoThreshold = null;
    List<Algorithm<T>> algorithms = new ArrayList<Algorithm<T>>();

    public DataContainer(RandomAccessibleInterval<T> src1, RandomAccessibleInterval<T> src2, int ch1, int ch2, String name1, String name2) {
        this.sourceImage1 = src1;
        this.sourceImage2 = src2;
        this.sourceImage1Name = name1;
        this.sourceImage2Name = name2;
        long[] dims = new long[src1.numDimensions()];
        src1.dimensions(dims);
        this.mask = MaskFactory.createMask(dims, true);
        this.ch1 = ch1;
        this.ch2 = ch2;
        this.maskBBOffset = new long[this.mask.numDimensions()];
        Arrays.fill(this.maskBBOffset, 0L);
        this.maskBBSize = new long[this.mask.numDimensions()];
        this.mask.dimensions(this.maskBBSize);
        this.maskType = MaskType.None;
        this.maskHash = this.mask.hashCode();
        this.jobName = "Colocalization_of_" + this.sourceImage1Name + "_versus_" + this.sourceImage2Name + "_" + this.maskHash;
        this.calculateStatistics();
    }

    public DataContainer(RandomAccessibleInterval<T> src1, RandomAccessibleInterval<T> src2, int ch1, int ch2, String name1, String name2, RandomAccessibleInterval<T> mask, long[] offset, long[] size) throws MissingPreconditionException {
        this.sourceImage1 = src1;
        this.sourceImage2 = src2;
        this.ch1 = ch1;
        this.ch2 = ch2;
        this.sourceImage1Name = name1;
        this.sourceImage2Name = name2;
        int numDims = src1.numDimensions();
        this.maskBBOffset = new long[numDims];
        this.maskBBSize = new long[numDims];
        long[] dim = new long[numDims];
        src1.dimensions(dim);
        this.mask = MaskFactory.createMask((long[])dim.clone(), mask);
        this.maskType = MaskType.Irregular;
        this.adjustRoiOffset(offset, this.maskBBOffset, dim);
        this.adjustRoiSize(size, this.maskBBSize, dim, this.maskBBOffset);
        this.maskHash = mask.hashCode();
        this.jobName = "Colocalization_of_" + this.sourceImage1Name + "_versus_" + this.sourceImage2Name + "_" + this.maskHash;
        this.calculateStatistics();
    }

    public DataContainer(RandomAccessibleInterval<T> src1, RandomAccessibleInterval<T> src2, int ch1, int ch2, String name1, String name2, long[] offset, long[] size) throws MissingPreconditionException {
        this.sourceImage1 = src1;
        this.sourceImage2 = src2;
        this.sourceImage1Name = name1;
        this.sourceImage2Name = name2;
        int numDims = src1.numDimensions();
        long[] dim = new long[numDims];
        src1.dimensions(dim);
        long[] roiOffset = new long[numDims];
        long[] roiSize = new long[numDims];
        this.adjustRoiOffset(offset, roiOffset, dim);
        this.adjustRoiSize(size, roiSize, dim, roiOffset);
        this.mask = MaskFactory.createMask(dim, roiOffset, roiSize);
        this.maskBBOffset = (long[])roiOffset.clone();
        this.maskBBSize = (long[])roiSize.clone();
        this.maskType = MaskType.Regular;
        this.ch1 = ch1;
        this.ch2 = ch2;
        this.maskHash = this.mask.hashCode();
        this.jobName = "Colocalization_of_" + this.sourceImage1Name + "_versus_" + this.sourceImage2Name + "_" + this.maskHash;
        this.calculateStatistics();
    }

    protected void calculateStatistics() {
        this.meanCh1 = ImageStatistics.getImageMean(this.sourceImage1, this.mask);
        this.meanCh2 = ImageStatistics.getImageMean(this.sourceImage2, this.mask);
        this.minCh1 = ((RealType)ImageStatistics.getImageMin(this.sourceImage1, this.mask)).getRealDouble();
        this.minCh2 = ((RealType)ImageStatistics.getImageMin(this.sourceImage2, this.mask)).getRealDouble();
        this.maxCh1 = ((RealType)ImageStatistics.getImageMax(this.sourceImage1, this.mask)).getRealDouble();
        this.maxCh2 = ((RealType)ImageStatistics.getImageMax(this.sourceImage2, this.mask)).getRealDouble();
        this.integralCh1 = ImageStatistics.getImageIntegral(this.sourceImage1, this.mask);
        this.integralCh2 = ImageStatistics.getImageIntegral(this.sourceImage2, this.mask);
    }

    protected void adjustRoiOffset(long[] oldOffset, long[] newOffset, long[] dimensions) throws MissingPreconditionException {
        for (int i = 0; i < newOffset.length; ++i) {
            if (i < oldOffset.length) {
                if (oldOffset[i] > dimensions[i]) {
                    throw new MissingPreconditionException("Dimension " + i + " of ROI offset is larger than image dimension.");
                }
                newOffset[i] = oldOffset[i];
                continue;
            }
            newOffset[i] = 0L;
        }
    }

    protected void adjustRoiSize(long[] oldSize, long[] newSize, long[] dimensions, long[] offset) throws MissingPreconditionException {
        for (int i = 0; i < newSize.length; ++i) {
            if (i < oldSize.length) {
                if (oldSize[i] > dimensions[i] - offset[i]) {
                    throw new MissingPreconditionException("Dimension " + i + " of ROI size is larger than what fits in.");
                }
                newSize[i] = oldSize[i];
                continue;
            }
            newSize[i] = dimensions[i] - offset[i];
        }
    }

    public RandomAccessibleInterval<T> getSourceImage1() {
        return this.sourceImage1;
    }

    public RandomAccessibleInterval<T> getSourceImage2() {
        return this.sourceImage2;
    }

    public String getSourceImage1Name() {
        return "Ch1_" + this.sourceImage1Name;
    }

    public String getSourceImage2Name() {
        return "Ch2_" + this.sourceImage2Name;
    }

    public String getSourceCh1Name() {
        return this.sourceImage1Name;
    }

    public String getSourceCh2Name() {
        return this.sourceImage2Name;
    }

    public String getJobName() {
        return this.jobName;
    }

    public RandomAccessibleInterval<BitType> getMask() {
        return this.mask;
    }

    public long[] getMaskBBOffset() {
        return (long[])this.maskBBOffset.clone();
    }

    public long[] getMaskBBSize() {
        return (long[])this.maskBBSize.clone();
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    public int getMaskID() {
        return this.maskHash;
    }

    public int getCh1() {
        return this.ch1;
    }

    public int getCh2() {
        return this.ch2;
    }

    public double getMeanCh1() {
        return this.meanCh1;
    }

    public double getMeanCh2() {
        return this.meanCh2;
    }

    public double getMinCh1() {
        return this.minCh1;
    }

    public double getMaxCh1() {
        return this.maxCh1;
    }

    public double getMinCh2() {
        return this.minCh2;
    }

    public double getMaxCh2() {
        return this.maxCh2;
    }

    public double getIntegralCh1() {
        return this.integralCh1;
    }

    public double getIntegralCh2() {
        return this.integralCh2;
    }

    public InputCheck<T> getInputCheck() {
        return this.inputCheck;
    }

    public Algorithm<T> setInputCheck(InputCheck<T> inputCheck) {
        this.inputCheck = inputCheck;
        return inputCheck;
    }

    public AutoThresholdRegression<T> getAutoThreshold() {
        return this.autoThreshold;
    }

    public Algorithm<T> setAutoThreshold(AutoThresholdRegression<T> autoThreshold) {
        this.autoThreshold = autoThreshold;
        return autoThreshold;
    }

    public static enum MaskType {
        Regular("ROI"),
        Irregular("mask image"),
        None("none");

        private final String label;

        private MaskType(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }
    }
}

