/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;

public class ScaledPolarToTranslatedCartesianTransform2D
implements InvertibleRealTransform {
    private final double tx;
    private final double ty;
    private final double sr;
    private final double st;
    private final InverseRealTransform inverse;

    private static double x(double r, double t) {
        return r * Math.cos(t);
    }

    private static double y(double r, double t) {
        return r * Math.sin(t);
    }

    private static double r(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private static double t(double x, double y) {
        return Math.atan2(y, x);
    }

    public ScaledPolarToTranslatedCartesianTransform2D(double tx, double ty, double sr, double st) {
        this.tx = tx;
        this.ty = ty;
        this.sr = sr;
        this.st = st;
        this.inverse = new InverseRealTransform(this);
    }

    @Override
    public int numSourceDimensions() {
        return 2;
    }

    @Override
    public int numTargetDimensions() {
        return 2;
    }

    @Override
    public void apply(double[] source, double[] target) {
        double r = source[0] / this.sr;
        double t = source[1] / this.st;
        target[0] = ScaledPolarToTranslatedCartesianTransform2D.x(r, t) + this.tx;
        target[1] = ScaledPolarToTranslatedCartesianTransform2D.y(r, t) + this.ty;
    }

    @Override
    public void apply(float[] source, float[] target) {
        double r = (double)source[0] / this.sr;
        double t = (double)source[1] / this.st;
        target[0] = (float)(ScaledPolarToTranslatedCartesianTransform2D.x(r, t) + this.tx);
        target[1] = (float)(ScaledPolarToTranslatedCartesianTransform2D.y(r, t) + this.ty);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        double r = source.getDoublePosition(0) / this.sr;
        double t = source.getDoublePosition(1) / this.st;
        target.setPosition(ScaledPolarToTranslatedCartesianTransform2D.x(r, t) + this.tx, 0);
        target.setPosition(ScaledPolarToTranslatedCartesianTransform2D.y(r, t) + this.ty, 1);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        double x = target[0] - this.tx;
        double y = target[1] - this.ty;
        source[0] = ScaledPolarToTranslatedCartesianTransform2D.r(x, y) * this.sr;
        source[1] = ScaledPolarToTranslatedCartesianTransform2D.t(x, y) * this.st;
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        double x = (double)target[0] - this.tx;
        double y = (double)target[1] - this.ty;
        source[0] = (float)(ScaledPolarToTranslatedCartesianTransform2D.r(x, y) * this.sr);
        source[1] = (float)(ScaledPolarToTranslatedCartesianTransform2D.t(x, y) * this.st);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        double x = target.getDoublePosition(0) - this.tx;
        double y = target.getDoublePosition(1) - this.ty;
        source.setPosition(ScaledPolarToTranslatedCartesianTransform2D.r(x, y) * this.sr, 0);
        source.setPosition(ScaledPolarToTranslatedCartesianTransform2D.t(x, y) * this.st, 1);
    }

    @Override
    public InvertibleRealTransform inverse() {
        return this.inverse;
    }

    @Override
    public ScaledPolarToTranslatedCartesianTransform2D copy() {
        return new ScaledPolarToTranslatedCartesianTransform2D(this.tx, this.ty, this.sr, this.st);
    }
}

