/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Link;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.SharedGroup;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SharedGroupState;

public class LinkState
extends LeafState {
    private int sharedGroup;
    private SymbolTableData sharedGroupSymbol;

    public LinkState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            SharedGroup sg = ((Link)this.node).getSharedGroup();
            this.sharedGroup = control.getSymbolTable().addReference(sg);
            this.sharedGroupSymbol = control.getSymbolTable().getSymbol(this.sharedGroup);
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        if (this.sharedGroupSymbol.nodeState == null) {
            out.writeInt(-1);
            SharedGroup sg = ((Link)this.node).getSharedGroup();
            this.control.writeSharedGroup(out, sg, this.sharedGroupSymbol);
        } else {
            out.writeInt(this.sharedGroupSymbol.nodeID);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.sharedGroup = in.readInt();
        if (this.sharedGroup == -1) {
            this.sharedGroup = this.control.readSharedGroup(in);
        }
    }

    @Override
    public void buildGraph() {
        this.sharedGroupSymbol = this.control.getSymbolTable().getSymbol(this.sharedGroup);
        ((SharedGroupState)this.sharedGroupSymbol.nodeState).buildGraph();
        ((Link)this.node).setSharedGroup((SharedGroup)this.sharedGroupSymbol.j3dNode);
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Link();
    }
}

