/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class SegmentTrackerFactory
implements SpotTrackerFactory {
    protected String errorMessage;

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public boolean marshall(Map<String, Object> settings, Element element) {
        boolean ok = true;
        StringBuilder str = new StringBuilder();
        Element gapClosingElement = new Element("GapClosing");
        ok &= IOUtils.writeAttribute(settings, gapClosingElement, "ALLOW_GAP_CLOSING", Boolean.class, str);
        ok &= IOUtils.writeAttribute(settings, gapClosingElement, "GAP_CLOSING_MAX_DISTANCE", Double.class, str);
        ok &= IOUtils.writeAttribute(settings, gapClosingElement, "MAX_FRAME_GAP", Integer.class, str);
        Map gcfpm = (Map)settings.get("GAP_CLOSING_FEATURE_PENALTIES");
        Element gcfpElement = new Element("FeaturePenalties");
        IOUtils.marshallMap(gcfpm, gcfpElement);
        gapClosingElement.addContent((Content)gcfpElement);
        element.addContent((Content)gapClosingElement);
        Element trackSplittingElement = new Element("TrackSplitting");
        ok &= IOUtils.writeAttribute(settings, trackSplittingElement, "ALLOW_TRACK_SPLITTING", Boolean.class, str);
        ok &= IOUtils.writeAttribute(settings, trackSplittingElement, "SPLITTING_MAX_DISTANCE", Double.class, str);
        Map tsfpm = (Map)settings.get("SPLITTING_FEATURE_PENALTIES");
        Element tsfpElement = new Element("FeaturePenalties");
        IOUtils.marshallMap(tsfpm, tsfpElement);
        trackSplittingElement.addContent((Content)tsfpElement);
        element.addContent((Content)trackSplittingElement);
        Element trackMergingElement = new Element("TrackMerging");
        ok &= IOUtils.writeAttribute(settings, trackMergingElement, "ALLOW_TRACK_MERGING", Boolean.class, str);
        ok &= IOUtils.writeAttribute(settings, trackMergingElement, "MERGING_MAX_DISTANCE", Double.class, str);
        Map tmfpm = (Map)settings.get("MERGING_FEATURE_PENALTIES");
        Element tmfpElement = new Element("FeaturePenalties");
        IOUtils.marshallMap(tmfpm, tmfpElement);
        trackMergingElement.addContent((Content)tmfpElement);
        element.addContent((Content)trackMergingElement);
        ok &= IOUtils.writeAttribute(settings, element, "CUTOFF_PERCENTILE", Double.class, str);
        ok &= IOUtils.writeAttribute(settings, element, "ALTERNATIVE_LINKING_COST_FACTOR", Double.class, str);
        return ok &= IOUtils.writeAttribute(settings, element, "BLOCKING_VALUE", Double.class, str);
    }

    public boolean unmarshallSegment(Element element, Map<String, Object> settings, StringBuilder errorHolder) {
        settings.clear();
        boolean ok = true;
        Element gapClosingElement = element.getChild("GapClosing");
        if (null == gapClosingElement) {
            errorHolder.append("Could not find the GapClosing element in XML.\n");
            ok = false;
        } else {
            ok &= IOUtils.readBooleanAttribute(gapClosingElement, settings, "ALLOW_GAP_CLOSING", errorHolder);
            ok &= IOUtils.readIntegerAttribute(gapClosingElement, settings, "MAX_FRAME_GAP", errorHolder);
            ok &= IOUtils.readDoubleAttribute(gapClosingElement, settings, "GAP_CLOSING_MAX_DISTANCE", errorHolder);
            HashMap<String, Double> gcfpm = new HashMap<String, Double>();
            Element gcfpElement = gapClosingElement.getChild("FeaturePenalties");
            if (null != gcfpElement) {
                ok &= IOUtils.unmarshallMap(gcfpElement, gcfpm, errorHolder);
            }
            settings.put("GAP_CLOSING_FEATURE_PENALTIES", gcfpm);
        }
        Element trackSplittingElement = element.getChild("TrackSplitting");
        if (null == trackSplittingElement) {
            errorHolder.append("Could not found the TrackSplitting element in XML.\n");
            ok = false;
        } else {
            ok &= IOUtils.readBooleanAttribute(trackSplittingElement, settings, "ALLOW_TRACK_SPLITTING", errorHolder);
            ok &= IOUtils.readDoubleAttribute(trackSplittingElement, settings, "SPLITTING_MAX_DISTANCE", errorHolder);
            HashMap<String, Double> tsfpm = new HashMap<String, Double>();
            Element tsfpElement = trackSplittingElement.getChild("FeaturePenalties");
            if (null != tsfpElement) {
                ok &= IOUtils.unmarshallMap(tsfpElement, tsfpm, errorHolder);
            }
            settings.put("SPLITTING_FEATURE_PENALTIES", tsfpm);
        }
        Element trackMergingElement = element.getChild("TrackMerging");
        if (null == trackMergingElement) {
            errorHolder.append("Could not found the TrackMerging element in XML.\n");
            ok = false;
        } else {
            ok &= IOUtils.readBooleanAttribute(trackMergingElement, settings, "ALLOW_TRACK_MERGING", errorHolder);
            ok &= IOUtils.readDoubleAttribute(trackMergingElement, settings, "MERGING_MAX_DISTANCE", errorHolder);
            HashMap<String, Double> tmfpm = new HashMap<String, Double>();
            Element tmfpElement = trackMergingElement.getChild("FeaturePenalties");
            if (null != tmfpElement) {
                ok &= IOUtils.unmarshallMap(tmfpElement, tmfpm, errorHolder);
            }
            settings.put("MERGING_FEATURE_PENALTIES", tmfpm);
        }
        ok &= IOUtils.readDoubleAttribute(element, settings, "CUTOFF_PERCENTILE", errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, settings, "ALTERNATIVE_LINKING_COST_FACTOR", errorHolder);
        return ok &= IOUtils.readDoubleAttribute(element, settings, "BLOCKING_VALUE", errorHolder);
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> settings) {
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = this.unmarshallSegment(element, settings, errorHolder);
        if (!this.checkSettingsValidity(settings)) {
            ok = false;
            errorHolder.append(this.errorMessage);
        }
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public String toString(Map<String, Object> sm) {
        if (!this.checkSettingsValidity(sm)) {
            return this.errorMessage;
        }
        StringBuilder str = new StringBuilder();
        if (((Boolean)sm.get("ALLOW_GAP_CLOSING")).booleanValue()) {
            str.append("  Gap-closing conditions:\n");
            str.append(String.format("    - max distance: %.1f\n", (Double)sm.get("GAP_CLOSING_MAX_DISTANCE")));
            str.append(String.format("    - max frame gap: %d\n", (Integer)sm.get("MAX_FRAME_GAP")));
            str.append(LAPUtils.echoFeaturePenalties((Map)sm.get("GAP_CLOSING_FEATURE_PENALTIES")));
        } else {
            str.append("  Gap-closing not allowed.\n");
        }
        if (((Boolean)sm.get("ALLOW_TRACK_SPLITTING")).booleanValue()) {
            str.append("  Track splitting conditions:\n");
            str.append(String.format("    - max distance: %.1f\n", (Double)sm.get("SPLITTING_MAX_DISTANCE")));
            str.append(LAPUtils.echoFeaturePenalties((Map)sm.get("SPLITTING_FEATURE_PENALTIES")));
        } else {
            str.append("  Track splitting not allowed.\n");
        }
        if (((Boolean)sm.get("ALLOW_TRACK_MERGING")).booleanValue()) {
            str.append("  Track merging conditions:\n");
            str.append(String.format("    - max distance: %.1f\n", (Double)sm.get("MERGING_MAX_DISTANCE")));
            str.append(LAPUtils.echoFeaturePenalties((Map)sm.get("MERGING_FEATURE_PENALTIES")));
        } else {
            str.append("  Track merging not allowed.\n");
        }
        return str.toString();
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        return LAPUtils.getDefaultSegmentSettingsMap();
    }

    @Override
    public boolean checkSettingsValidity(Map<String, Object> settings) {
        if (null == settings) {
            this.errorMessage = "Settings map is null.\n";
            return false;
        }
        StringBuilder str = new StringBuilder();
        boolean ok = LAPUtils.checkSettingsValidity(settings, str, false);
        if (!ok) {
            this.errorMessage = str.toString();
        }
        return ok;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

