/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.CostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.DefaultCostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.ResizableDoubleArray;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.SparseCostMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JaqamanLinkingCostMatrixCreator<K extends Comparable<K>, J extends Comparable<J>>
implements CostMatrixCreator<K, J> {
    private static final String BASE_ERROR_MSG = "[JaqamanLinkingCostMatrixCreator] ";
    private final Iterable<K> sources;
    private final Iterable<J> targets;
    private final CostFunction<K, J> costFunction;
    private SparseCostMatrix scm;
    private long processingTime;
    private String errorMessage;
    private final double costThreshold;
    private List<K> sourceList;
    private List<J> targetList;
    private double alternativeCost;
    private final double alternativeCostFactor;
    private final double percentile;

    public JaqamanLinkingCostMatrixCreator(Iterable<K> sources, Iterable<J> targets, CostFunction<K, J> costFunction, double costThreshold, double alternativeCostFactor, double percentile) {
        this.sources = sources;
        this.targets = targets;
        this.costFunction = costFunction;
        this.costThreshold = costThreshold;
        this.alternativeCostFactor = alternativeCostFactor;
        this.percentile = percentile;
    }

    public boolean checkInput() {
        if (null == this.sources || !this.sources.iterator().hasNext()) {
            this.errorMessage = "[JaqamanLinkingCostMatrixCreator] The source list is empty or null.";
            return false;
        }
        if (null == this.targets || !this.targets.iterator().hasNext()) {
            this.errorMessage = "[JaqamanLinkingCostMatrixCreator] The target list is empty or null.";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        ArrayList<Comparable> accSources = new ArrayList<Comparable>();
        ArrayList<Comparable> accTargets = new ArrayList<Comparable>();
        ResizableDoubleArray costs = new ResizableDoubleArray();
        for (Comparable source : this.sources) {
            for (Comparable target : this.targets) {
                double cost = this.costFunction.linkingCost(source, target);
                if (!(cost < this.costThreshold)) continue;
                accSources.add(source);
                accTargets.add(target);
                costs.add(cost);
            }
        }
        costs.trimToSize();
        if (accSources.isEmpty() || accTargets.isEmpty()) {
            this.sourceList = Collections.emptyList();
            this.targetList = Collections.emptyList();
            this.alternativeCost = Double.NaN;
            this.scm = null;
        } else {
            DefaultCostMatrixCreator cmCreator = new DefaultCostMatrixCreator(accSources, accTargets, costs.data, this.alternativeCostFactor, this.percentile);
            if (!cmCreator.checkInput() || !cmCreator.process()) {
                this.errorMessage = cmCreator.getErrorMessage();
                return false;
            }
            this.scm = cmCreator.getResult();
            this.sourceList = cmCreator.getSourceList();
            this.targetList = cmCreator.getTargetList();
            this.alternativeCost = cmCreator.computeAlternativeCosts();
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SparseCostMatrix getResult() {
        return this.scm;
    }

    @Override
    public List<K> getSourceList() {
        return this.sourceList;
    }

    @Override
    public List<J> getTargetList() {
        return this.targetList;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public double getAlternativeCostForSource(K source) {
        return this.alternativeCost;
    }

    @Override
    public double getAlternativeCostForTarget(J target) {
        return this.alternativeCost;
    }
}

