/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.util.mxBase64;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.util.TMUtils;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.imagej.ImgPlus;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class SpotIconGrabber<T extends RealType<T>> {
    private final ImgPlus<T> img;

    public SpotIconGrabber(ImgPlus<T> img) {
        this.img = img;
    }

    public String getImageString(Spot spot, double radiusFactor) {
        double[] calibration = TMUtils.getSpatialCalibration(this.img);
        double radius = spot.getFeature("RADIUS") * radiusFactor;
        long x = Math.round((spot.getFeature("POSITION_X") - radius) / calibration[0]);
        long y = Math.round((spot.getFeature("POSITION_Y") - radius) / calibration[1]);
        long width = Math.max(1L, Math.round(2.0 * radius / calibration[0]));
        long height = Math.max(1L, Math.round(2.0 * radius / calibration[1]));
        long slice = 0L;
        if (this.img.numDimensions() > 2) {
            slice = Math.round(spot.getFeature("POSITION_Z") / calibration[2]);
            if (slice < 0L) {
                slice = 0L;
            }
            if (slice >= this.img.dimension(2)) {
                slice = this.img.dimension(2) - 1L;
            }
        }
        Img<T> crop = this.grabImage(x, y, slice, width, height);
        ImagePlus imp = ImageJFunctions.wrap(crop, (String)crop.toString());
        ImageProcessor ip = imp.getProcessor();
        ip.resetMinAndMax();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedImage lImg = ip.getBufferedImage();
        try {
            ImageIO.write((RenderedImage)lImg, "png", bos);
            return mxBase64.encodeToString((byte[])bos.toByteArray(), (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public final Img<T> grabImage(long x, long y, long slice, long width, long height) {
        Img crop = this.img.factory().create(new long[]{width, height});
        RealType zeroType = (RealType)((RealType)this.img.firstElement()).createVariable();
        zeroType.setZero();
        OutOfBoundsConstantValueFactory oobf = new OutOfBoundsConstantValueFactory((Object)zeroType);
        OutOfBounds sourceCursor = Views.extend(this.img, (OutOfBoundsFactory)oobf).randomAccess();
        RandomAccess targetCursor = crop.randomAccess();
        if (this.img.numDimensions() > 2) {
            sourceCursor.setPosition(slice, 2);
        }
        int i = 0;
        while ((long)i < width) {
            sourceCursor.setPosition((long)i + x, 0);
            targetCursor.setPosition(i, 0);
            int j = 0;
            while ((long)j < height) {
                sourceCursor.setPosition((long)j + y, 1);
                targetCursor.setPosition(j, 1);
                ((RealType)targetCursor.get()).set((Type)sourceCursor.get());
                ++j;
            }
            ++i;
        }
        return crop;
    }

    public final Img<T> grabImage(long x, long y, long slice, long width, long height, long depth) {
        long[] minsize = new long[]{x, y, slice - depth / 2L, width, height, depth};
        FinalInterval interval = Intervals.createMinSize((long[])minsize);
        Img crop = this.img.factory().create((Dimensions)interval);
        IntervalView view = Views.zeroMin((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendZero(this.img), (Interval)interval));
        RandomAccess sourceRA = view.randomAccess((Interval)view);
        Cursor targetCursor = crop.localizingCursor();
        while (targetCursor.hasNext()) {
            targetCursor.fwd();
            sourceRA.setPosition((Localizable)targetCursor);
            ((RealType)targetCursor.get()).set((Type)sourceRA.get());
        }
        return crop;
    }
}

