/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;

public class VJVoxelLoc {
    public int ix;
    public int iy;
    public int iz;
    public float x;
    public float y;
    public float z;
    public float dx;
    public float dy;
    public float dz;
    public float tlf;
    public float blf;
    public float trf;
    public float brf;
    public float tlb;
    public float blb;
    public float trb;
    public float brb;
    public boolean hasWeights = false;

    public VJVoxelLoc() {
    }

    public VJVoxelLoc(float x, float y, float z) {
        this.init(x, y, z);
    }

    public VJVoxelLoc(float[] vs, VJMatrix m) {
        float[] tv = m.mul(vs);
        this.init(tv[0], tv[1], tv[2]);
    }

    public VJVoxelLoc(float x, float y, float z, VJMatrix m) {
        float[] v = new float[]{x, y, z, 1.0f};
        float[] tv = m.mul(v);
        this.init(tv[0], tv[1], tv[2]);
    }

    public VJVoxelLoc(float[] v) {
        this.init(v[0], v[1], v[2]);
    }

    private void init(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.ix = (int)this.x;
        this.iy = (int)this.y;
        this.iz = (int)this.z;
    }

    public float getx() {
        return this.x;
    }

    public float gety() {
        return this.y;
    }

    public float getz() {
        return this.z;
    }

    public int getnnx() {
        return Math.round(this.x);
    }

    public int getnny() {
        return Math.round(this.y);
    }

    public int getnnz() {
        return Math.round(this.z);
    }

    public void setz(float z) {
        this.z = z;
        this.iz = (int)z;
    }

    public void setx(int x) {
        this.x = x;
        this.ix = x;
    }

    public void sety(int y) {
        this.y = y;
        this.iy = y;
    }

    public void setz(int z) {
        this.z = z;
        this.iz = z;
    }

    public void getWeights() {
        if (this.hasWeights) {
            return;
        }
        this.hasWeights = true;
        this.dx = this.x - (float)this.ix;
        this.dy = this.y - (float)this.iy;
        this.dz = this.z - (float)this.iz;
        this.tlf = (1.0f - this.dx) * (1.0f - this.dy) * (1.0f - this.dz);
        this.blf = (1.0f - this.dx) * this.dy * (1.0f - this.dz);
        this.trf = this.dx * (1.0f - this.dy) * (1.0f - this.dz);
        this.brf = this.dx * this.dy * (1.0f - this.dz);
        this.brb = this.dx * this.dy * this.dz;
        this.trb = this.dx * (1.0f - this.dy) * this.dz;
        this.blb = (1.0f - this.dx) * this.dy * this.dz;
        this.tlb = (1.0f - this.dx) * (1.0f - this.dy) * this.dz;
    }

    public void move(float[] dos) {
        this.x += dos[0];
        this.y += dos[1];
        this.z += dos[2];
        this.ix = (int)this.x;
        this.iy = (int)this.y;
        this.iz = (int)this.z;
        this.hasWeights = false;
    }

    public void move(double dx, double dy, double dz) {
        this.x = (float)((double)this.x + dx);
        this.y = (float)((double)this.y + dy);
        this.z = (float)((double)this.z + dz);
        this.ix = (int)this.x;
        this.iy = (int)this.y;
        this.iz = (int)this.z;
        this.hasWeights = false;
    }

    public String toString() {
        String s = "VJVoxelLoc: " + this.x + "," + this.y + "," + this.z + ": (voxel) " + this.ix + "," + this.iy + "," + this.iz + ": (wghts) " + this.tlf + "," + this.blf + "," + this.trf + "," + this.brf + "," + this.tlb + "," + this.blb + "," + this.trb + "," + this.brb + ",";
        return s;
    }
}

