/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.scijava.Context;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptREPL;
import org.scijava.script.ScriptService;

public class VarsPane
extends JPanel {
    private final ScriptREPL repl;
    private final JComboBox langBox;
    private final VarsTableModel varsTableModel;

    public VarsPane(Context context, final ScriptREPL repl) {
        this.repl = repl;
        this.setLayout(new BorderLayout());
        ScriptService scriptService = (ScriptService)context.service(ScriptService.class);
        List langList = scriptService.getLanguages();
        ScriptLanguage[] langs = langList.toArray(new ScriptLanguage[0]);
        this.langBox = new JComboBox<ScriptLanguage>(langs);
        this.langBox.setMaximumRowCount(25);
        this.langBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptLanguage lang = (ScriptLanguage)VarsPane.this.langBox.getSelectedItem();
                if (lang == repl.getInterpreter().getLanguage()) {
                    return;
                }
                try {
                    repl.lang(lang.getLanguageName());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                VarsPane.this.update();
            }
        });
        this.add((Component)this.langBox, "North");
        this.varsTableModel = new VarsTableModel();
        JTable varsTable = new JTable(this.varsTableModel);
        varsTable.getColumnModel().getColumn(0).setMinWidth(120);
        varsTable.getColumnModel().getColumn(0).setMaxWidth(120);
        varsTable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.add((Component)new JScrollPane(varsTable), "Center");
        varsTable.setAutoResizeMode(1);
        final JCheckBox showTypes = new JCheckBox("Show variable types");
        showTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarsPane.this.varsTableModel.setShowTypes(showTypes.isSelected());
            }
        });
        this.add((Component)showTypes, "South");
        this.update();
    }

    public void update() {
        this.langBox.setSelectedItem(this.repl.getInterpreter().getLanguage());
        this.varsTableModel.update();
    }

    private class VarsTableModel
    extends AbstractTableModel {
        private final ArrayList<String> varNames = new ArrayList();
        private boolean showTypes;

        private VarsTableModel() {
        }

        public void update() {
            this.varNames.clear();
            try {
                this.varNames.addAll(VarsPane.this.repl.getInterpreter().getBindings().keySet());
                Collections.sort(this.varNames);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.fireTableDataChanged();
        }

        public void setShowTypes(boolean showTypes) {
            this.showTypes = showTypes;
            VarsPane.this.update();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            throw this.invalidColumnException(columnIndex);
        }

        @Override
        public int getRowCount() {
            return VarsPane.this.repl.getInterpreter().getBindings().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.varNames.size()) {
                return null;
            }
            String varName = this.varNames.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return varName;
                }
                case 1: {
                    return this.value(varName);
                }
            }
            throw this.invalidColumnException(columnIndex);
        }

        private String value(String varName) {
            String type;
            Object value = VarsPane.this.repl.getInterpreter().getBindings().get(varName);
            if (value == null) {
                return "<null>";
            }
            String vs = value.toString();
            return vs.startsWith(type = value.getClass().getName()) || !this.showTypes ? vs : vs + " [" + type + "]";
        }

        private ArrayIndexOutOfBoundsException invalidColumnException(int columnIndex) {
            return new ArrayIndexOutOfBoundsException("Invalid column index: " + columnIndex);
        }
    }
}

