/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;

public class Class2JarFilesMap
extends HashMap<String, ArrayList<String>> {
    protected final File imagejRoot;

    public Class2JarFilesMap(File imagejRoot) {
        this.imagejRoot = imagejRoot;
        this.addDirectory("plugins");
        this.addDirectory("jars");
    }

    private void addDirectory(String directory) {
        File dir = new File(this.imagejRoot, directory);
        if (!dir.isDirectory()) {
            return;
        }
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            String path = directory + "/" + list[i];
            if (list[i].endsWith(".jar")) {
                try {
                    this.addJar(path);
                }
                catch (IOException e) {
                    UpdaterUserInterface.get().log("Warning: could not open " + path);
                }
                continue;
            }
            this.addDirectory(path);
        }
    }

    private void addJar(String jar) throws IOException {
        try {
            JarFile file = new JarFile(new File(this.imagejRoot, jar));
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class")) continue;
                this.addClass(UpdaterUtil.stripSuffix(name, ".class").replace('/', '.'), jar);
            }
            file.close();
        }
        catch (ZipException e) {
            UpdaterUserInterface.get().log("Warning: could not open " + jar);
        }
    }

    private boolean ignore(String name, String jar) {
        String base = jar.substring(jar.lastIndexOf(47) + 1);
        if (base.startsWith("batik") || base.startsWith("xml-apis") || base.startsWith("loci_tools")) {
            return name.startsWith("org.xml.") || name.startsWith("org.w3c.") || name.startsWith("javax.xml.") || name.startsWith("org.mozilla.javascript.") || name.startsWith("org.apache.xml.serializer.");
        }
        if (base.startsWith("jython") || base.startsWith("jruby.jar")) {
            return name.startsWith("com.sun.jna.") || name.startsWith("jline.");
        }
        if (base.startsWith("ij.jar")) {
            return name.startsWith("javax.script.");
        }
        return false;
    }

    private void addClass(String className, String jar) {
        if (this.ignore(className, jar)) {
            return;
        }
        if (this.containsKey(className)) {
            List jarList = (List)this.get(className);
            jarList.add(jar);
        } else {
            ArrayList<String> jarList = new ArrayList<String>(1);
            jarList.add(jar);
            this.put(className, jarList);
        }
    }

    public static void printJarsForClass(Class2JarFilesMap map, String className, boolean oneLine) {
        String indent = "    ";
        List classes = (List)map.get(className);
        if (!oneLine) {
            System.out.print("    ");
        }
        boolean firstTime = true;
        for (String jarFile : classes) {
            if (firstTime) {
                firstTime = false;
            } else {
                System.out.print(oneLine ? ", " : "\n    ");
            }
            System.out.print(jarFile);
        }
        System.out.println();
    }
}

