/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.extremafinder;

import mpicbg.imglib.Factory;
import mpicbg.imglib.algorithm.extremafinder.RegionalExtremaFinder;
import mpicbg.imglib.algorithm.extremafinder.RegionalExtremaFinder2D;
import mpicbg.imglib.algorithm.extremafinder.RegionalExtremaFinder3D;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class RegionalExtremaFactory<T extends RealType<T>>
implements Factory {
    private Image<T> image;
    private String errorMessage;

    public RegionalExtremaFactory(Image<T> img) {
        this.image = img;
    }

    public RegionalExtremaFinder<T> createRegionalMaximaFinder(boolean findMaxima) {
        switch (this.image.getNumDimensions()) {
            case 1: {
                this.errorMessage = "1D is not implemented yet.";
                throw new IllegalArgumentException(this.errorMessage);
            }
            case 2: {
                return new RegionalExtremaFinder2D<T>(this.image, findMaxima);
            }
            case 3: {
                return new RegionalExtremaFinder3D<T>(this.image, findMaxima);
            }
        }
        this.errorMessage = "Dimensionality of " + this.image.getNumDimensions() + " is not implemented yet.";
        throw new IllegalArgumentException(this.errorMessage);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void printProperties() {
        System.out.println(this.getClass().getCanonicalName() + ": ");
        this.image.getContainerFactory().printProperties();
    }

    @Override
    public void setParameters(String configuration) {
    }
}

