/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import java.util.ArrayList;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.function.SubtractNormReal;
import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.algorithm.math.ImageCalculator;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.algorithm.math.NormalizeImageMinMax;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

public class ScaleSpace<A extends Type<A>, B extends RealType<B>>
implements OutputAlgorithm<B>,
MultiThreaded,
Benchmark {
    final Image<A> image;
    final ImageFactory<B> processFactory;
    final Converter<A, B> converter;
    ContainerFactory scaleSpaceContainerFactory;
    ArrayList<DifferenceOfGaussianPeak<B>> peaks;
    Image<B> scaleSpace;
    double initialSigma;
    double scale;
    double imageSigma;
    int minImageSize;
    int stepsPerOctave;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public ScaleSpace(Image<A> image, ImageFactory<B> processFactory, Converter<A, B> converter, double initialSigma) {
        this.setNumThreads();
        this.image = image;
        this.processFactory = processFactory;
        this.converter = converter;
        this.scaleSpaceContainerFactory = processFactory.getContainerFactory();
        this.initialSigma = initialSigma;
        this.scale = 1.0;
        this.imageSigma = 0.5;
        this.minImageSize = 16;
        this.stepsPerOctave = 7;
    }

    @Override
    public Image<B> getResult() {
        return this.scaleSpace;
    }

    public ArrayList<DifferenceOfGaussianPeak<B>> getPeaks() {
        return this.peaks;
    }

    public void setMinImageSize(int minImageSize) {
        this.minImageSize = minImageSize;
    }

    public int getMinImageSize() {
        return this.minImageSize;
    }

    @Override
    public boolean process() {
        Image<B> input;
        long startTime = System.currentTimeMillis();
        if (this.initialSigma < 1.0) {
            input = this.upSample(this.image, this.processFactory, this.converter);
            this.imageSigma *= 2.0;
            this.initialSigma *= 2.0;
            this.scale = 2.0;
        } else {
            input = this.convert(this.image, this.processFactory, this.converter);
        }
        if (input == null) {
            this.errorMessage = "Error creating input image: " + this.errorMessage;
            return false;
        }
        if (!this.normImageMinMax(input)) {
            input.close();
            return false;
        }
        double[] sigma = this.getSigmas(input, this.initialSigma, this.minImageSize, this.stepsPerOctave);
        double[] sigmaInc = this.getIncrementalSigmas(sigma, this.imageSigma);
        double norm = this.getNormalizationFactor(this.stepsPerOctave);
        this.scaleSpace = this.computeScaleSpace(input, sigmaInc, norm, this.scaleSpaceContainerFactory);
        if (this.scaleSpace == null) {
            this.errorMessage = "Cannot compute scale space: " + this.errorMessage;
            input.close();
            return false;
        }
        DifferenceOfGaussianReal<B, B> dog = new DifferenceOfGaussianReal<B, B>(this.scaleSpace, this.scaleSpace.getImageFactory(), null, 0.0, 0.0, (double)0.03f, 0.0);
        this.peaks = dog.findPeaks(this.scaleSpace);
        SubpixelLocalization<B> spl = new SubpixelLocalization<B>(this.scaleSpace, this.peaks);
        spl.setNumThreads(this.getNumThreads());
        if (!spl.checkInput() || !spl.process()) {
            this.errorMessage = "Cannot compute subpixel localization: " + spl.getErrorMessage();
            this.scaleSpace.close();
            return false;
        }
        for (DifferenceOfGaussianPeak<B> peak : this.peaks) {
            double size = peak.getSubPixelPosition(this.scaleSpace.getNumDimensions() - 1) + 0.5f;
            size = this.initialSigma * Math.pow(2.0, size / (double)this.stepsPerOctave);
            peak.setPixelLocation((int)Math.round(size), this.scaleSpace.getNumDimensions() - 1);
            peak.setSubPixelLocationOffset((float)size - (float)((int)Math.round(size)), this.scaleSpace.getNumDimensions() - 1);
            if (this.scale == 1.0) continue;
            for (int d = 0; d < this.scaleSpace.getNumDimensions(); ++d) {
                float sizeHalf = peak.getSubPixelPosition(d) / 2.0f;
                int pixelLocation = Util.round(sizeHalf);
                peak.setPixelLocation(pixelLocation, d);
                peak.setSubPixelLocationOffset(sizeHalf - (float)pixelLocation, d);
            }
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected Image<B> computeScaleSpace(Image<B> image, double[] sigma, double norm, ContainerFactory factory) {
        int[] dimensions = new int[image.getNumDimensions() + 1];
        image.getDimensions(dimensions);
        dimensions[image.getNumDimensions()] = sigma.length - 1;
        Image<B> scaleSpace = new ImageFactory<B>(image.createType(), factory).createImage(dimensions, "Scalespace of " + image.getName());
        Image gauss1 = null;
        Image gauss2 = null;
        GaussianConvolutionReal<B> gauss = new GaussianConvolutionReal<B>(image, new OutOfBoundsStrategyMirrorFactory(), sigma[0]);
        gauss.setNumThreads(this.getNumThreads());
        if (!gauss.checkInput() || !gauss.process()) {
            this.errorMessage = "Cannot compute inital gaussian convolution: " + gauss.getErrorMessage();
            scaleSpace.close();
            return null;
        }
        gauss1 = gauss.getResult();
        for (int s = 1; s < sigma.length; ++s) {
            gauss.setImage(gauss1);
            gauss.setSigma(sigma[s]);
            if (!gauss.checkInput() || !gauss.process()) {
                this.errorMessage = "Cannot compute gaussian convolution with sigma=" + sigma[s] + " : " + gauss.getErrorMessage();
                scaleSpace.close();
                return null;
            }
            gauss2 = gauss.getResult();
            SubtractNormReal function = new SubtractNormReal(norm);
            ImageCalculator imageCalc = new ImageCalculator(gauss2, gauss1, gauss1, function);
            imageCalc.setNumThreads(this.getNumThreads());
            if (!imageCalc.checkInput() || !imageCalc.process()) {
                this.errorMessage = "Cannot subtract images: " + imageCalc.getErrorMessage();
                scaleSpace.close();
                gauss1.close();
                gauss2.close();
                return null;
            }
            LocalizableCursor cursorIn = gauss1.createLocalizableCursor();
            LocalizableByDimCursor<B> cursorOut = scaleSpace.createLocalizableByDimCursor();
            int[] position = cursorOut.getPosition();
            position[scaleSpace.getNumDimensions() - 1] = s - 1;
            while (cursorIn.hasNext()) {
                cursorIn.fwd();
                cursorIn.getPosition(position);
                cursorOut.moveTo(position);
                ((RealType)cursorOut.getType()).set(cursorIn.getType());
            }
            cursorIn.close();
            cursorOut.close();
            gauss1.close();
            gauss1 = gauss2;
            gauss2 = null;
        }
        gauss1.close();
        return scaleSpace;
    }

    protected double getNormalizationFactor(int stepsPerOctave) {
        double K = Math.pow(2.0, 1.0 / (double)stepsPerOctave);
        double K_MIN1_INV = 1.0 / (K - 1.0);
        return K_MIN1_INV;
    }

    protected double[] getIncrementalSigmas(double[] sigma, double imageSigma) {
        double[] sigmaInc = new double[sigma.length];
        sigmaInc[0] = Math.sqrt(sigma[0] * sigma[0] - imageSigma * imageSigma);
        for (int i = 1; i < sigma.length; ++i) {
            sigmaInc[i] = Math.sqrt(sigma[i] * sigma[i] - sigma[i - 1] * sigma[i - 1]);
        }
        return sigmaInc;
    }

    protected double[] getSigmas(Image<?> img, double initialSigma, int minImageSize, int stepsPerOctave) {
        int minDim = img.getDimension(0);
        for (int d = 1; d < img.getNumDimensions(); ++d) {
            minDim = Math.min(minDim, img.getDimension(d));
        }
        int numOctaves = (int)Math.round(Util.log2(minDim) - Util.log2(minImageSize) + 0.25);
        double[] sigma = new double[numOctaves * stepsPerOctave + 3];
        for (int i = 0; i < sigma.length; ++i) {
            sigma[i] = initialSigma * Math.pow(2.0, (double)i / (double)stepsPerOctave);
        }
        return sigma;
    }

    protected boolean normImageMinMax(Image<B> image) {
        NormalizeImageMinMax<B> norm = new NormalizeImageMinMax<B>(image);
        norm.setNumThreads(this.getNumThreads());
        if (!norm.checkInput() || !norm.process()) {
            this.errorMessage = "Cannot normalize image: " + norm.getErrorMessage();
            return false;
        }
        return true;
    }

    protected Image<B> convert(Image<A> input, ImageFactory<B> processFactory, Converter<A, B> converter) {
        ImageConverter<A, B> imgConv = new ImageConverter<A, B>(this.image, processFactory, converter);
        imgConv.setNumThreads(this.getNumThreads());
        if (!imgConv.checkInput() || !imgConv.process()) {
            this.errorMessage = "Cannot convert image: " + imgConv.getErrorMessage();
            return null;
        }
        return imgConv.getResult();
    }

    protected Image<B> upSample(Image<A> input, ImageFactory<B> processFactory, Converter<A, B> converter) {
        int numDimensions = input.getNumDimensions();
        int[] dim = input.getDimensions();
        for (int d = 0; d < numDimensions; ++d) {
            dim[d] = dim[d] * 2 - 1;
        }
        Image<B> upSampled = processFactory.createImage(dim);
        LocalizableCursor<A> inCursor = input.createLocalizableCursor();
        LocalizableByDimCursor<B> outCursor = upSampled.createLocalizableByDimCursor();
        int[] tmp = new int[numDimensions];
        while (inCursor.hasNext()) {
            inCursor.fwd();
            inCursor.getPosition(tmp);
            int d = 0;
            while (d < numDimensions) {
                int n = d++;
                tmp[n] = tmp[n] * 2;
            }
            outCursor.setPosition(tmp);
            converter.convert(inCursor.getType(), outCursor.getType());
        }
        inCursor.close();
        LocalizableCursor<B> outCursor2 = upSampled.createLocalizableCursor();
        for (int d = 0; d < numDimensions; ++d) {
            outCursor2.reset();
            while (outCursor2.hasNext()) {
                outCursor2.fwd();
                int pos = outCursor2.getPosition(d);
                if (pos % 2 != 1) continue;
                outCursor.setPosition(outCursor2);
                outCursor.bck(d);
                double left = ((RealType)outCursor.getType()).getRealDouble();
                outCursor.fwd(d);
                outCursor.fwd(d);
                double right = ((RealType)outCursor.getType()).getRealDouble();
                outCursor.bck(d);
                ((RealType)outCursor.getType()).setReal((right + left) / 2.0);
            }
        }
        outCursor.close();
        outCursor2.close();
        return upSampled;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ScaleSpace: [Image<A> img] is null.";
            return false;
        }
        if (this.processFactory == null) {
            this.errorMessage = "ScaleSpace: [ImageFactory<B> processFactory] is null.";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }
}

