/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.shapelist;

import mpicbg.imglib.container.shapelist.ShapeList;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ShapeListLocalizablePlaneCursor<T extends Type<T>>
extends ShapeListLocalizableByDimCursor<T>
implements LocalizablePlaneCursor<T> {
    protected int planeDimA;
    protected int planeDimB;

    public ShapeListLocalizablePlaneCursor(ShapeList<T> container, Image<T> image) {
        super(container, image);
    }

    @Override
    public boolean hasNext() {
        int sizeB = this.dimensions[this.planeDimB] - 1;
        if (this.position[this.planeDimB] < sizeB) {
            return true;
        }
        if (this.position[this.planeDimB] > sizeB) {
            return false;
        }
        int sizeA = this.dimensions[this.planeDimA] - 1;
        return this.position[this.planeDimA] < sizeA;
    }

    @Override
    public void fwd() {
        int n = this.planeDimA;
        this.position[n] = this.position[n] + 1;
        if (this.position[n] >= this.dimensions[this.planeDimA]) {
            this.position[this.planeDimA] = 0;
            int n2 = this.planeDimB;
            this.position[n2] = this.position[n2] + 1;
        }
    }

    @Override
    public void reset(int planeDimA, int planeDimB, int[] dimensionPositions) {
        this.planeDimA = planeDimA;
        this.planeDimB = planeDimB;
        this.setPosition(dimensionPositions);
        this.position[planeDimA] = -1;
        this.position[planeDimA] = 0;
    }

    @Override
    public void reset(int planeDimA, int planeDimB) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(planeDimA, planeDimB, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
    }
}

