/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import java.util.Iterator;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.cursor.Iterable;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class HyperSphereIterator<T extends Type<T>>
implements Iterable,
LocalizableCursor<T>,
Localizable {
    protected final Image<T> image;
    protected final Localizable center;
    protected final LocalizableByDimCursor<T> cursor;
    protected int activeCursorIndex;
    protected final int radius;
    protected final int numDimensions;
    protected final int maxDim;
    final int[] r;
    final int[] s;

    public HyperSphereIterator(Image<T> image, Localizable center, int radius) {
        this(image, center, radius, null);
    }

    public HyperSphereIterator(Image<T> image, Localizable center, int radius, OutOfBoundsStrategyFactory<T> oobFactory) {
        this.image = image;
        this.center = center;
        this.radius = radius;
        this.numDimensions = image.getNumDimensions();
        this.maxDim = this.numDimensions - 1;
        this.r = new int[this.numDimensions];
        this.s = new int[this.numDimensions];
        this.cursor = oobFactory == null ? image.createLocalizableByDimCursor() : image.createLocalizableByDimCursor(oobFactory);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.s[this.maxDim] > 0;
    }

    @Override
    public void fwd() {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.s[n] = this.s[n] - 1;
            if (this.s[n] >= 0) {
                this.cursor.fwd(d);
                break;
            }
            this.r[d] = 0;
            this.s[d] = 0;
            this.cursor.setPosition(this.center.getPosition(d), d);
        }
        if (d > 0) {
            int e = d - 1;
            int rd = this.r[d];
            int pd = rd - this.s[d];
            int rad = (int)Math.sqrt(rd * rd - pd * pd);
            this.s[e] = 2 * rad;
            this.r[e] = rad;
            this.cursor.setPosition(this.center.getPosition(e) - rad, e);
        }
    }

    @Override
    public void reset() {
        int maxDim = this.numDimensions - 1;
        for (int d = 0; d < maxDim; ++d) {
            this.s[d] = 0;
            this.r[d] = 0;
            this.cursor.setPosition(this.center.getPosition(d), d);
        }
        this.cursor.setPosition(this.center.getPosition(maxDim) - this.radius - 1, maxDim);
        this.r[maxDim] = this.radius;
        this.s[maxDim] = 1 + 2 * this.radius;
    }

    @Override
    public void fwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public void getPosition(int[] position) {
        this.cursor.getPosition(position);
    }

    @Override
    public int[] getPosition() {
        return this.cursor.getPosition();
    }

    @Override
    public int getPosition(int dim) {
        return this.cursor.getPosition(dim);
    }

    @Override
    public String getPositionAsString() {
        return this.cursor.getPositionAsString();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public int[] createPositionArray() {
        return this.cursor.createPositionArray();
    }

    @Override
    public int getArrayIndex() {
        return this.cursor.getArrayIndex();
    }

    @Override
    public Image<T> getImage() {
        return this.image;
    }

    @Override
    public Container<T> getStorageContainer() {
        return this.cursor.getStorageContainer();
    }

    @Override
    public int getStorageIndex() {
        return this.cursor.getStorageIndex();
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    @Override
    public boolean isActive() {
        return this.cursor.isActive();
    }

    @Override
    public void setDebug(boolean debug) {
    }

    @Override
    public T next() {
        this.fwd();
        return this.getType();
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int[] getDimensions() {
        return this.image.getDimensions();
    }

    @Override
    public void getDimensions(int[] position) {
        this.image.getDimensions(position);
    }

    @Override
    public int getNumDimensions() {
        return this.image.getNumDimensions();
    }
}

