/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.reconstruct.ContourSet;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructProfile;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructSection;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructTranslator;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class ReconstructProfileList
implements ContourSet {
    private final int oid;
    private final int id;
    private final ReconstructTranslator translator;
    private final String name;
    private final ArrayList<ReconstructProfile> profileList;

    public ReconstructProfileList(Element e, ReconstructTranslator t, ReconstructSection sec) {
        this.translator = t;
        this.oid = this.translator.nextOID();
        this.id = this.translator.nextOID();
        this.name = e.getAttribute("name");
        this.profileList = new ArrayList();
        this.addContour(e, sec);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addContour(Element e, ReconstructSection sec) {
        ReconstructProfile rp = new ReconstructProfile(e, this.translator, sec);
        sec.addProfile(rp);
        this.profileList.add(rp);
    }

    public void appendProjectXML(StringBuilder sb) {
        sb.append("<reconstruct_open_trace id=\"").append(this.oid).append("\" title=\"").append(this.name).append("\" expanded=\"true\">\n<profile_list id=\"").append(this.id).append("\" expanded=\"true\">\n");
        for (ReconstructProfile profile : this.profileList) {
            sb.append("<profile id=\"").append(profile.getID()).append("\" oid=\"").append(profile.getOID()).append("\"/>\n");
        }
        sb.append("</profile_list>\n</reconstruct_open_trace>\n");
    }

    public boolean equals(Object o) {
        if (o instanceof ReconstructProfileList) {
            ReconstructProfileList rpl = (ReconstructProfileList)o;
            return this.name.equals(rpl.name);
        }
        if (o instanceof Element) {
            Element e = (Element)o;
            return this.name.equals(e.getAttribute("name"));
        }
        return false;
    }
}

