/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractGroupable;
import io.scif.FormatException;
import io.scif.LocationInfo;
import io.scif.Metadata;
import io.scif.MetadataLevel;
import io.scif.TypedMetadata;
import io.scif.TypedParser;
import io.scif.config.SCIFIOConfig;
import io.scif.util.SCIFIOMetadataTools;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;

public abstract class AbstractParser<M extends TypedMetadata>
extends AbstractGroupable
implements TypedParser<M> {
    private M metadata;
    @Parameter
    private DataHandleService handles;

    @Override
    public M parse(Location fileName) throws IOException, FormatException {
        return (M)this.parse(fileName, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public M parse(DataHandle<Location> stream) throws IOException, FormatException {
        return (M)this.parse((DataHandle)stream, new SCIFIOConfig(this.getContext()));
    }

    public M parse(Location loc, Metadata meta) throws IOException, FormatException {
        return (M)this.parse(loc, meta, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public M parse(DataHandle<Location> handle, Metadata meta) throws IOException, FormatException {
        return (M)this.parse((DataHandle)handle, meta, new SCIFIOConfig(this.getContext()));
    }

    public M getMetadata() {
        return this.metadata;
    }

    @Override
    public DataHandle<Location> getSource() {
        Metadata m = this.getMetadata();
        if (m == null) {
            return null;
        }
        return m.getSource();
    }

    @Override
    public Location getSourceLocation() {
        return this.getMetadata() == null ? null : this.getMetadata().getSourceLocation();
    }

    @Override
    public void updateSource(Location source) throws IOException {
        this.metadata.setSourceLocation(source);
        this.metadata.setSource((DataHandle<Location>)this.handles.readBuffer(source));
    }

    @Override
    public Location[] getUsedFiles() {
        return this.getUsedLocations(false);
    }

    @Override
    public Location[] getUsedLocations(boolean noPixels) {
        HashSet<Location> files = new HashSet<Location>();
        for (int i = 0; i < this.metadata.getImageCount(); ++i) {
            Location[] s = this.getImageUsedFiles(i, noPixels);
            if (s == null) continue;
            for (Location file : s) {
                files.add(file);
            }
        }
        return files.toArray(new Location[files.size()]);
    }

    @Override
    public Location[] getImageUsedFiles(int imageIndex) {
        return this.getImageUsedFiles(imageIndex, false);
    }

    @Override
    public Location[] getImageUsedFiles(int imageIndex, boolean noPixels) {
        Location[] locationArray;
        if (noPixels) {
            locationArray = null;
        } else {
            Location[] locationArray2 = new Location[1];
            locationArray = locationArray2;
            locationArray2[0] = this.getMetadata().getSourceLocation();
        }
        return locationArray;
    }

    @Override
    public LocationInfo[] getAdvancedUsedLocations(boolean noPixels) {
        Location[] files = this.getUsedLocations(noPixels);
        if (files == null) {
            return null;
        }
        return this.getLocationInfo(files);
    }

    @Override
    public LocationInfo[] getAdvancedImageUsedLocations(int imageIndex, boolean noPixels) {
        Location[] files = this.getImageUsedFiles(imageIndex, noPixels);
        if (files == null) {
            return null;
        }
        return this.getLocationInfo(files);
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        HashSet<MetadataLevel> supportedLevels = new HashSet<MetadataLevel>();
        supportedLevels.add(MetadataLevel.ALL);
        supportedLevels.add(MetadataLevel.NO_OVERLAYS);
        supportedLevels.add(MetadataLevel.MINIMUM);
        return supportedLevels;
    }

    @Override
    public M parse(DataHandle<Location> handle, M meta) throws IOException, FormatException {
        return this.parse(handle, meta, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public M parse(final Location loc, M meta, SCIFIOConfig config) throws IOException, FormatException {
        DataHandle handle = this.getSource();
        if (handle != null) {
            if (((Location)handle.get()).equals(loc)) {
                handle.seek(0L);
            } else {
                this.close();
                handle.close();
                handle = null;
            }
        }
        meta.setFiltered(config.parserIsFiltered());
        if (meta.getContext() == null) {
            meta.setContext(this.getContext());
        }
        meta.setDatasetName(loc.getName());
        this.metadata = meta;
        meta.setSourceLocation(loc);
        if (handle == null && (handle = this.handles.readBuffer(loc)) == null) {
            DataHandle dummyHandle;
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName() == "get" && method.getParameterCount() == 0) {
                        return loc;
                    }
                    if (method.getName() == "close" && method.getParameterCount() == 0) {
                        return null;
                    }
                    throw new UnsupportedOperationException("Trying to use methods of Location-only handle");
                }
            };
            handle = dummyHandle = (DataHandle)Proxy.newProxyInstance(Context.getClassLoader(), new Class[]{DataHandle.class}, handler);
        }
        return this.parse((DataHandle<Location>)handle, meta, config);
    }

    @Override
    public M parse(DataHandle<Location> handle, M meta, SCIFIOConfig config) throws IOException, FormatException {
        DataHandle<Location> in = this.getSource();
        if (in == null || !((Location)in.get()).equals(handle.get())) {
            this.init(handle);
            if (config.parserIsSaveOriginalMetadata()) {
                // empty if block
            }
        }
        meta.setFiltered(config.parserIsFiltered());
        if (meta.getContext() == null) {
            meta.setContext(this.getContext());
        }
        meta.setDatasetName(((Location)handle.get()).getName());
        meta.setSource(handle);
        meta.setSourceLocation((Location)handle.get());
        this.metadata = meta;
        this.typedParse(handle, meta, config);
        meta.populateImageMetadata();
        return meta;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.metadata != null) {
            this.metadata.close(fileOnly);
        }
    }

    protected abstract void typedParse(DataHandle<Location> var1, M var2, SCIFIOConfig var3) throws IOException, FormatException;

    private void init(DataHandle<Location> handle) throws IOException {
        if (this.getMetadata() != null) {
            Location[] usedFiles;
            for (Location fileName : usedFiles = this.getUsedFiles()) {
                if (!((Location)handle.get()).equals(fileName)) continue;
                return;
            }
        }
        this.close();
    }

    private LocationInfo[] getLocationInfo(Location[] locations) {
        LocationInfo[] infos = new LocationInfo[locations.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new LocationInfo();
            infos[i].locationName = locations[i].getName();
            infos[i].reader = this.getFormat().getReaderClass();
            infos[i].usedToInitialize = locations[i].equals(this.getSourceLocation());
        }
        return infos;
    }

    @Override
    public M parse(Location loc, SCIFIOConfig config) throws IOException, FormatException {
        TypedMetadata meta = (TypedMetadata)this.getFormat().createMetadata();
        return (M)this.parse(loc, (M)meta, config);
    }

    @Override
    public M parse(DataHandle<Location> stream, SCIFIOConfig config) throws IOException, FormatException {
        TypedMetadata meta = (TypedMetadata)this.getFormat().createMetadata();
        return (M)this.parse(stream, (M)meta, config);
    }

    @Override
    public M parse(Location loc, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
        return (M)this.parse(loc, (M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)), config);
    }

    @Override
    public M parse(DataHandle<Location> handle, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
        return (M)this.parse(handle, (M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)), config);
    }

    protected void setMetaData(Metadata meta) {
        this.metadata = (TypedMetadata)SCIFIOMetadataTools.castMeta(meta);
    }
}

