/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.audioengines;

public class AuralParameters {
    public static final float SPEED_OF_SOUND = 0.344f;
    public static final int NO_FILTERING = -1;
    public float rolloff = 1.0f;
    public float reflectionCoefficient = 0.0f;
    public float reverbDelay = 40.0f;
    public int reverbOrder = 0;
    public float frequencyScaleFactor = 1.0f;
    public float velocityScaleFactor = 0.0f;
    int filterType = -1;
    double[] filterDistance = new double[2];
    float[] filterCutoff = new float[2];
    public float reverbCoefficient = 1.0f;
    public float reflectionDelay = 20.0f;
    public float decayTime = 1000.0f;
    public float decayFrequencyCutoff = 5000.0f;
    public float diffusion = 1.0f;
    public float density = 1.0f;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    public void setDistanceFilter(int filterType, double[] distance, float[] filterCutoff) {
        boolean error = false;
        boolean allocate = false;
        int attenuationLength = 0;
        if (distance == null || filterCutoff == null) {
            error = true;
        } else {
            attenuationLength = distance.length;
            if (attenuationLength == 0 || filterType == -1) {
                error = true;
            }
        }
        if (error) {
            this.filterType = -1;
            this.filterDistance = null;
            this.filterCutoff = null;
            return;
        }
        this.filterType = filterType;
        if (this.filterDistance == null || filterCutoff == null) {
            allocate = true;
        } else if (attenuationLength > this.filterDistance.length) {
            allocate = true;
        }
        if (allocate) {
            this.filterDistance = new double[attenuationLength];
            this.filterCutoff = new float[attenuationLength];
        }
        System.arraycopy(distance, 0, this.filterDistance, 0, attenuationLength);
        System.arraycopy(filterCutoff, 0, this.filterCutoff, 0, attenuationLength);
    }

    public int getDistanceFilterLength() {
        if (this.filterDistance != null) {
            return this.filterDistance.length;
        }
        return 0;
    }

    public int getDistanceFilterType() {
        return this.filterType;
    }

    public void getDistanceFilter(double[] distance, float[] filterCutoff) {
        if (distance == null || filterCutoff == null) {
            return;
        }
        int attenuationLength = distance.length;
        if (attenuationLength == 0 || this.filterDistance == null || filterCutoff == null) {
            return;
        }
        if (attenuationLength > this.filterDistance.length) {
            attenuationLength = this.filterDistance.length;
        }
        System.arraycopy(this.filterDistance, 0, distance, 0, attenuationLength);
        System.arraycopy(this.filterCutoff, 0, filterCutoff, 0, attenuationLength);
    }

    protected void debugPrint(String message) {
    }
}

