/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Comparative
extends PostfixMathCommand {
    protected int id;
    double tolerance;
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LE = 2;
    public static final int GE = 3;
    public static final int NE = 4;
    public static final int EQ = 5;

    public Comparative(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        boolean res = false;
        switch (this.id) {
            case 0: {
                res = this.lt(param1, param2);
                break;
            }
            case 1: {
                res = this.gt(param1, param2);
                break;
            }
            case 2: {
                res = this.le(param1, param2);
                break;
            }
            case 3: {
                res = this.ge(param1, param2);
                break;
            }
            case 4: {
                res = this.ne(param1, param2);
                break;
            }
            case 5: {
                res = this.eq(param1, param2);
            }
        }
        if (res) {
            inStack.push(new Double(1.0));
        } else {
            inStack.push(new Double(0.0));
        }
    }

    public boolean lt(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex || param2 instanceof Complex) {
            throw new ParseException("< not defined for complex numbers");
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double y;
            double x = ((Number)param1).doubleValue();
            return x < (y = ((Number)param2).doubleValue());
        }
        throw new ParseException("< not defined for object of type " + param1.getClass().getName() + " and " + param2.getClass().getName());
    }

    public boolean gt(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex || param2 instanceof Complex) {
            throw new ParseException("> not defined for complex numbers");
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double y;
            double x = ((Number)param1).doubleValue();
            return x > (y = ((Number)param2).doubleValue());
        }
        throw new ParseException("> not defined for object of type " + param1.getClass().getName() + " and " + param2.getClass().getName());
    }

    public boolean le(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex || param2 instanceof Complex) {
            throw new ParseException("<= not defined for complex numbers");
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double y;
            double x = ((Number)param1).doubleValue();
            return x <= (y = ((Number)param2).doubleValue());
        }
        throw new ParseException("<= not defined for object of type " + param1.getClass().getName() + " and " + param2.getClass().getName());
    }

    public boolean ge(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex || param2 instanceof Complex) {
            throw new ParseException(">= not defined for complex numbers");
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double y;
            double x = ((Number)param1).doubleValue();
            return x >= (y = ((Number)param2).doubleValue());
        }
        throw new ParseException(">= not defined for object of type " + param1.getClass().getName() + " and " + param2.getClass().getName());
    }

    public boolean eq(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex && param2 instanceof Complex) {
            return ((Complex)param1).equals((Complex)param2, this.tolerance);
        }
        if (param1 instanceof Complex && param2 instanceof Number) {
            return ((Complex)param1).equals(new Complex((Number)param2), this.tolerance);
        }
        if (param2 instanceof Complex && param1 instanceof Number) {
            return ((Complex)param2).equals(new Complex((Number)param1), this.tolerance);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double y;
            double x = ((Number)param1).doubleValue();
            return x == (y = ((Number)param2).doubleValue());
        }
        if (param1 instanceof Boolean && param2 instanceof Boolean) {
            boolean y;
            boolean x = (Boolean)param1;
            return x == (y = ((Boolean)param2).booleanValue());
        }
        if (param1 instanceof Number && param2 instanceof Boolean) {
            double x = ((Number)param1).doubleValue();
            double y = (Boolean)param2 != false ? 1.0 : 0.0;
            return x == y;
        }
        if (param1 instanceof Boolean && param2 instanceof Number) {
            double x = (Boolean)param1 != false ? 1.0 : 0.0;
            double y = ((Number)param2).doubleValue();
            return x == y;
        }
        return param1.equals(param2);
    }

    public boolean ne(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex && param2 instanceof Complex) {
            return !((Complex)param1).equals((Complex)param2, this.tolerance);
        }
        if (param1 instanceof Complex && param2 instanceof Number) {
            return !((Complex)param1).equals(new Complex((Number)param2), this.tolerance);
        }
        if (param2 instanceof Complex && param1 instanceof Number) {
            return !((Complex)param2).equals(new Complex((Number)param1), this.tolerance);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double y;
            double x = ((Number)param1).doubleValue();
            return x != (y = ((Number)param2).doubleValue());
        }
        if (param1 instanceof Boolean && param2 instanceof Boolean) {
            boolean y;
            boolean x = (Boolean)param1;
            return x != (y = ((Boolean)param2).booleanValue());
        }
        if (param1 instanceof Number && param2 instanceof Boolean) {
            double x = ((Number)param1).doubleValue();
            double y = (Boolean)param2 != false ? 1.0 : 0.0;
            return x != y;
        }
        if (param1 instanceof Boolean && param2 instanceof Number) {
            double x = (Boolean)param1 != false ? 1.0 : 0.0;
            double y = ((Number)param2).doubleValue();
            return x != y;
        }
        return !param1.equals(param2);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

