/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.Type;

public class ImgLibSaver {
    public static <T extends Type<T>> boolean saveAsTiffs(Image<T> img, String directory, int type) {
        return ImgLibSaver.saveAsTiffs(img, directory, img.getName(), type);
    }

    public static <T extends Type<T>> boolean saveAsTiffs(Image<T> img, String directory, String name, int type) {
        Display display = img.getDisplay();
        boolean everythingOK = true;
        if (directory == null) {
            directory = "";
        }
        directory = directory.replace('\\', '/');
        if ((directory = directory.trim()).length() > 0 && !directory.endsWith("/")) {
            directory = directory + "/";
        }
        int numDimensions = img.getNumDimensions();
        int[] dimensionPositions = new int[numDimensions];
        boolean dimX = false;
        boolean dimY = true;
        if (numDimensions <= 2) {
            FloatProcessor ip = new FloatProcessor(img.getDimension(0), img.getDimension(1), ImgLibSaver.extractSliceFloat(img, display, 0, 1, dimensionPositions), null);
            ImagePlus slice = new ImagePlus(name + ".tif", (ImageProcessor)ip);
            FileSaver fs = new FileSaver(slice);
            everythingOK = everythingOK && fs.saveAsTiff(directory + slice.getTitle());
            slice.close();
        } else {
            int[] extraDimensions = new int[numDimensions - 2];
            int[] extraDimPos = new int[extraDimensions.length];
            for (int d = 2; d < numDimensions; ++d) {
                extraDimensions[d - 2] = img.getDimension(d);
            }
            int[] maxLengthDim = new int[extraDimensions.length];
            for (int d = 2; d < numDimensions; ++d) {
                String num = "" + (img.getDimension(d) - 1);
                maxLengthDim[d - 2] = num.length();
            }
            ArrayLocalizableCursor cursor = ArrayLocalizableCursor.createLinearCursor((int[])extraDimensions);
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.getPosition(extraDimPos);
                for (int d = 2; d < numDimensions; ++d) {
                    dimensionPositions[d] = extraDimPos[d - 2];
                }
                FloatProcessor ip = new FloatProcessor(img.getDimension(0), img.getDimension(1), ImgLibSaver.extractSliceFloat(img, display, 0, 1, dimensionPositions), null);
                String desc = "";
                for (int d = 2; d < numDimensions; ++d) {
                    String descDim = "" + dimensionPositions[d];
                    while (descDim.length() < maxLengthDim[d - 2]) {
                        descDim = "0" + descDim;
                    }
                    desc = d == 2 ? desc + "_z" + descDim : desc + "_" + descDim;
                }
                ImagePlus slice = new ImagePlus(name + desc + ".tif", (ImageProcessor)ip);
                FileSaver fs = new FileSaver(slice);
                everythingOK = everythingOK && fs.saveAsTiff(directory + slice.getTitle());
                slice.close();
            }
        }
        return everythingOK;
    }

    private static final <T extends Type<T>> float[] extractSliceFloat(Image<T> img, Display<T> display, int dimX, int dimY, int[] dimensionPositions) {
        int sizeX = img.getDimension(dimX);
        int sizeY = img.getDimension(dimY);
        LocalizablePlaneCursor cursor = img.createLocalizablePlaneCursor();
        cursor.reset(dimX, dimY, dimensionPositions);
        float[] sliceImg = new float[sizeX * sizeY];
        if (dimY < img.getNumDimensions()) {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX) + cursor.getPosition((int)dimY) * sizeX] = display.get32Bit(cursor.getType());
            }
        } else {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX)] = display.get32Bit(cursor.getType());
            }
        }
        cursor.close();
        return sliceImg;
    }
}

