/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.bead.Bead;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLFunctions {
    public static void main(String[] args) {
        XMLFunctions.parseXMLBeadFile("D:/Temp/HisYFP/registration/beads.xml", "View2", 1, "D:/Temp/HisYFP/registration/");
    }

    public static void parseXMLBeadFile(String xmlFile, String viewName, int viewID, String outputDirectory) {
        Document dom = XMLFunctions.parseXMLFile(xmlFile);
        ArrayList<Bead> beads = XMLFunctions.parseBeadXMLDocument(dom, viewName);
        IOFunctions.writeSegmentation(beads, null, viewName, viewID, outputDirectory);
    }

    protected static ArrayList<Bead> parseBeadXMLDocument(Document dom, String viewName) {
        ArrayList<Bead> beads = new ArrayList<Bead>();
        Element docEle = dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName(viewName);
        Element viewElement = (Element)nl.item(0);
        NodeList pointList = viewElement.getElementsByTagName("Points");
        Element points = (Element)pointList.item(0);
        NodeList beadList = points.getChildNodes();
        int beadIndex = 0;
        if (beadList != null && beadList.getLength() > 0) {
            for (int i = 0; i < beadList.getLength(); ++i) {
                Node a = beadList.item(i);
                if (a.getNodeType() != 1) continue;
                Element beadElement = (Element)a;
                Bead bead = XMLFunctions.getBead(beadElement, beadIndex++);
                beads.add(bead);
            }
        }
        System.out.println("Found " + beads.size() + " for " + viewName);
        return beads;
    }

    protected static Bead getBead(Element beadElement, int id) {
        double x = XMLFunctions.getDoubleValue(beadElement, "x");
        double y = XMLFunctions.getDoubleValue(beadElement, "y");
        double z = XMLFunctions.getDoubleValue(beadElement, "z");
        Bead e = new Bead(id, new double[]{x, y, z}, null);
        return e;
    }

    protected static String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    protected static double getDoubleValue(Element ele, String tagName) {
        return Double.parseDouble(XMLFunctions.getTextValue(ele, tagName));
    }

    public static Document parseXMLFile(String xmlFile) {
        Document dom = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(xmlFile);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return dom;
    }
}

