/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.vis3d;

import java.util.ArrayList;
import java.util.Collection;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.segmentation.Nucleus;
import mpicbg.spim.vis3d.VisualizationFunctions;
import spim.vecmath.Point3d;
import spim.vecmath.Point3f;
import spim.vecmath.Transform3D;

public class VisualizationSketchTikZ {
    public static String drawBeads(Collection<Bead> beads, Transform3D globalTransform, String beadType, double factor) {
        return VisualizationSketchTikZ.drawBeads(beads, globalTransform, beadType, factor, 1);
    }

    public static String drawBeads(Collection<Bead> beads, Transform3D globalTransform, String beadType, double factor, int skipBeads) {
        String template1 = "\t\tput { translate([";
        String template2 = "]) } {";
        String template3 = "}\n";
        String insert = "";
        Point3d translation = new Point3d();
        int beadCount = 0;
        for (Bead bead : beads) {
            if (bead.getRANSACCorrespondence().size() > 0 || beadCount % skipBeads == 0) {
                translation.set(bead.getL());
                globalTransform.transform(translation);
                insert = insert + "\t\tput { translate([" + translation.x * factor + "," + translation.y * factor + "," + translation.z * factor + "]) } {" + beadType + "}\n";
            }
            ++beadCount;
        }
        return insert;
    }

    public static String drawNuclei(Collection<Nucleus> nuclei, Transform3D globalTransform, double factor) {
        String template1 = "\t\tput { translate([";
        String template2 = "]) } {";
        String template3 = "}\n";
        String insert = "";
        Point3d translation = new Point3d();
        boolean j = false;
        for (Nucleus nucleus : nuclei) {
            Object nucleusType = nucleus.getRANSACCorrespondence().size() > 0 ? "TrueNucleus" : (nucleus.getICPCorrespondence().size() > 0 ? "ICPNucleus" : (nucleus.getDescriptorCorrespondence().size() > 0 && nucleus.getRANSACCorrespondence().size() == 0 ? null : "Nucleus"));
            translation.set(nucleus.getL());
            globalTransform.transform(translation);
            if (nucleusType == null) continue;
            insert = insert + "\t\tput { translate([" + translation.x * factor + "," + translation.y * factor + "," + translation.z * factor + "]) } {" + (String)nucleusType + "}\n";
        }
        return insert;
    }

    public static String drawBead(Bead bead, Transform3D globalTransform, String beadType, double factor) {
        String template1 = "\t\tput { translate([";
        String template2 = "]) } {";
        String template3 = "}\n";
        String insert = "";
        Point3d translation = new Point3d();
        translation.set(bead.getL());
        globalTransform.transform(translation);
        insert = insert + "\t\tput { translate([" + translation.x * factor + "," + translation.y * factor + "," + translation.z * factor + "]) } {" + beadType + "}\n";
        return insert;
    }

    public static String drawNucleus(Nucleus nucleus, Transform3D globalTransform, String beadType, double factor) {
        String template1 = "\t\tput { translate([";
        String template2 = "]) } {";
        String template3 = "}\n";
        String insert = "";
        Point3d translation = new Point3d();
        translation.set(nucleus.getL());
        globalTransform.transform(translation);
        StringBuffer s = new StringBuffer("\t\tput { translate([");
        s.append(translation.x * factor);
        s.append(",");
        s.append(translation.y * factor);
        s.append(",");
        s.append(translation.z * factor);
        s.append("]) } {");
        s.append(beadType);
        s.append("}\n");
        return s.toString();
    }

    public static String drawView(ViewDataBeads view, double factor) {
        ArrayList<Point3f> box = VisualizationFunctions.getTransformedBoundingBox(view);
        String template1 = "\t\tline[lineStyle](";
        String template2 = ")(";
        String template3 = ")\n";
        String insert = "";
        for (int i = 0; i < box.size() / 2; ++i) {
            Point3f from = box.get(i * 2);
            Point3f to = box.get(i * 2 + 1);
            insert = insert + "\t\tline[lineStyle](" + (double)from.x * factor + "," + (double)from.y * factor + "," + (double)from.z * factor + ")(" + (double)to.x * factor + "," + (double)to.y * factor + "," + (double)to.z * factor + ")\n";
        }
        return insert;
    }

    public static String drawViews(ViewDataBeads[] views, float factor) {
        String insert = "";
        for (int i = 0; i < views.length; ++i) {
            insert = insert + VisualizationSketchTikZ.drawView(views[i], i);
        }
        return insert;
    }
}

