/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import spim.fiji.datasetmanager.MultiViewDatasetDefinition;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.plugin.Apply_Transformation;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.imgloaders.MicroManagerImgLoader;
import spim.fiji.spimdata.imgloaders.MultipageTiffReader;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class MicroManager
implements MultiViewDatasetDefinition {
    public static String[] rotAxes = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    public static String defaultFirstFile = "";
    public static boolean defaultModifyCal = false;
    public static boolean defaultRotAxis = false;
    public static boolean defaultApplyRotAxis = true;

    @Override
    public String getTitle() {
        return "MicroManager diSPIM Dataset";
    }

    @Override
    public String getExtendedDescription() {
        return "This datset definition supports files saved by MicroManager on the diSPIM.";
    }

    @Override
    public SpimData2 createDataset() {
        File mmFile = this.queryMMFile();
        if (mmFile == null) {
            return null;
        }
        MultipageTiffReader reader = null;
        try {
            reader = new MultipageTiffReader(mmFile);
        }
        catch (IOException e) {
            IOFunctions.println("Failed to analyze file '" + mmFile.getAbsolutePath() + "': " + e);
            return null;
        }
        if (!this.showDialogs(reader)) {
            return null;
        }
        String directory = mmFile.getParent();
        TimePoints timepoints = this.createTimePoints(reader);
        ArrayList<ViewSetup> setups = this.createViewSetups(reader);
        MissingViews missingViews = null;
        SequenceDescription sequenceDescription = new SequenceDescription(timepoints, setups, null, missingViews);
        MicroManagerImgLoader imgLoader = new MicroManagerImgLoader(mmFile, (AbstractSequenceDescription<? extends BasicViewSetup, ? extends BasicViewDescription<?>, ?>)sequenceDescription);
        sequenceDescription.setImgLoader((BasicImgLoader)imgLoader);
        double minResolution = Math.min(Math.min(reader.calX(), reader.calY()), reader.calZ());
        IOFunctions.println("Minimal resolution in all dimensions is: " + minResolution);
        IOFunctions.println("(The smallest resolution in any dimension; the distance between two pixels in the output image will be that wide)");
        ViewRegistrations viewRegistrations = StackList.createViewRegistrations(sequenceDescription.getViewDescriptions(), minResolution);
        ViewInterestPoints viewInterestPoints = new ViewInterestPoints();
        viewInterestPoints.createViewInterestPoints(sequenceDescription.getViewDescriptions());
        SpimData2 spimData = new SpimData2(new File(directory), sequenceDescription, viewRegistrations, viewInterestPoints, new BoundingBoxes());
        if (reader.applyAxis()) {
            Apply_Transformation.applyAxis(spimData);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            IOFunctions.println("Could not close file '" + mmFile.getAbsolutePath() + "': " + e);
        }
        return spimData;
    }

    protected ArrayList<ViewSetup> createViewSetups(MultipageTiffReader meta) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (int c = 0; c < meta.numChannels(); ++c) {
            channels.add(new Channel(c, meta.channelName(c)));
        }
        ArrayList<Illumination> illuminations = new ArrayList<Illumination>();
        for (int i = 0; i < meta.numPositions(); ++i) {
            illuminations.add(new Illumination(i, String.valueOf(i)));
        }
        ArrayList<Angle> angles = new ArrayList<Angle>();
        for (int a = 0; a < meta.numAngles(); ++a) {
            Angle angle = new Angle(a, meta.rotationAngle(a));
            try {
                double degrees = Double.parseDouble(meta.rotationAngle(a));
                double[] axis = meta.rotationAxis();
                if (axis != null && !Double.isNaN(degrees) && !Double.isInfinite(degrees)) {
                    angle.setRotation(axis, degrees);
                }
            }
            catch (Exception degrees) {
                // empty catch block
            }
            angles.add(angle);
        }
        ArrayList<ViewSetup> viewSetups = new ArrayList<ViewSetup>();
        for (Channel c : channels) {
            for (Illumination i : illuminations) {
                for (Angle a : angles) {
                    FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(meta.calUnit(), new double[]{meta.calX(), meta.calY(), meta.calZ()});
                    FinalDimensions dim = new FinalDimensions(new long[]{meta.width(), meta.height(), meta.depth()});
                    viewSetups.add(new ViewSetup(viewSetups.size(), null, (Dimensions)dim, (VoxelDimensions)voxelSize, c, a, i));
                }
            }
        }
        return viewSetups;
    }

    protected TimePoints createTimePoints(MultipageTiffReader meta) {
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>();
        for (int t = 0; t < meta.numTimepoints(); ++t) {
            timepoints.add(new TimePoint(t));
        }
        return new TimePoints(timepoints);
    }

    protected boolean showDialogs(MultipageTiffReader meta) {
        GenericDialog gd = new GenericDialog("MicroManager diSPIM Properties");
        gd.addMessage("Angles (" + meta.numAngles() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        for (int a = 0; a < meta.numAngles(); ++a) {
            gd.addStringField("Angle_" + (a + 1) + ":", String.valueOf(meta.rotationAngle(a)));
        }
        gd.addMessage("Channels (" + meta.numChannels() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        for (int c = 0; c < meta.numChannels(); ++c) {
            gd.addStringField("Channel_" + (c + 1) + ":", meta.channelName(c));
        }
        if (meta.numPositions() > 1) {
            IOFunctions.println("WARNING: " + meta.numPositions() + " stage positions detected. This will be imported as different illumination directions.");
            gd.addMessage("");
        }
        gd.addMessage("Timepoints (" + meta.numTimepoints() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("Calibration", new Font("SansSerif", 1, 13));
        gd.addCheckbox("Modify_calibration", defaultModifyCal);
        gd.addMessage("Pixel Distance X: " + meta.calX() + " " + meta.calUnit() + "\nPixel Distance Y: " + meta.calY() + " " + meta.calUnit() + "\nPixel Distance Z: " + meta.calZ() + " " + meta.calUnit() + "\n");
        gd.addMessage("Additional Meta Data", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        gd.addCheckbox("Modify_rotation_axis", defaultRotAxis);
        gd.addCheckbox("Apply_rotation_to_dataset", defaultApplyRotAxis);
        gd.addMessage("Rotation axis: " + meta.rotationAxisName() + " axis\nPixel type: " + meta.getPixelType(), new Font("SansSerif", 2, 11));
        GUIHelper.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        ArrayList<String> angles = new ArrayList<String>();
        for (int a = 0; a < meta.numAngles(); ++a) {
            angles.add(gd.getNextString());
        }
        meta.setAngleNames(angles);
        ArrayList<String> channels = new ArrayList<String>();
        for (int c = 0; c < meta.numChannels(); ++c) {
            channels.add(gd.getNextString());
        }
        meta.setChannelNames(channels);
        boolean modifyCal = defaultModifyCal = gd.getNextBoolean();
        boolean modifyAxis = defaultRotAxis = gd.getNextBoolean();
        defaultApplyRotAxis = gd.getNextBoolean();
        meta.setApplyAxis(defaultApplyRotAxis);
        if (modifyAxis || modifyCal) {
            gd = new GenericDialog("Modify Meta Data");
            if (modifyCal) {
                gd.addNumericField("Pixel_distance_x", meta.calX(), 5);
                gd.addNumericField("Pixel_distance_y", meta.calY(), 5);
                gd.addNumericField("Pixel_distance_z", meta.calZ(), 5);
                gd.addStringField("Pixel_unit", meta.calUnit());
            }
            if (modifyAxis) {
                if (meta.rotationAxisIndex() < 0) {
                    gd.addChoice("Rotation_around", rotAxes, rotAxes[0]);
                } else {
                    gd.addChoice("Rotation_around", rotAxes, rotAxes[meta.rotationAxisIndex()]);
                }
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            if (modifyCal) {
                meta.setCalX(gd.getNextNumber());
                meta.setCalY(gd.getNextNumber());
                meta.setCalZ(gd.getNextNumber());
                meta.setCalUnit(gd.getNextString());
            }
            if (modifyAxis) {
                int axis = gd.getNextChoiceIndex();
                if (axis == 0) {
                    meta.setRotAxis(new double[]{1.0, 0.0, 0.0});
                } else if (axis == 1) {
                    meta.setRotAxis(new double[]{0.0, 1.0, 0.0});
                } else {
                    meta.setRotAxis(new double[]{0.0, 0.0, 1.0});
                }
            }
        }
        return true;
    }

    protected File queryMMFile() {
        GenericDialogPlus gd = new GenericDialogPlus("Define MicroMananger diSPIM Dataset");
        gd.addFileField("MicroManager OME TIFF file", defaultFirstFile, 50);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultFirstFile = gd.getNextString();
        File firstFile = new File(defaultFirstFile);
        if (!firstFile.exists()) {
            IOFunctions.println("File '" + firstFile.getAbsolutePath() + "' does not exist. Stopping");
            return null;
        }
        IOFunctions.println("Investigating file '" + firstFile.getAbsolutePath() + "'.");
        return firstFile;
    }

    @Override
    public MicroManager newInstance() {
        return new MicroManager();
    }

    public static void main(String[] args) {
        defaultFirstFile = "/Volumes/My Passport/Zeiss Olaf Lightsheet Z.1/multiview.czi";
        new MicroManager().createDataset();
    }
}

