/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.resave;

import bdv.export.ProgressWriter;
import fiji.util.gui.GenericDialogPlus;
import ij.plugin.PlugIn;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.ImgLoaderHints;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.TimePointsPattern;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.resave.PluginHelper;
import spim.fiji.plugin.resave.ProgressWriterIJ;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.XmlIoSpimData2;
import spim.fiji.spimdata.imgloaders.StackImgLoaderIJ;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.fusion.export.Save3dTIFF;

public class Resave_TIFF
implements PlugIn {
    public static String defaultPath = null;
    public static int defaultContainer = 0;
    public static boolean defaultCompress = false;

    public static void main(String[] args) {
        new Resave_TIFF().run(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String arg0) {
        LoadParseQueryXML lpq = new LoadParseQueryXML();
        if (!lpq.queryXML("Resaving as TIFF", "Resave", true, true, true, true)) {
            return;
        }
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        progressWriter.out().println("starting export...");
        Parameters params = Resave_TIFF.getParameters();
        if (params == null) {
            return;
        }
        SpimData2 data = (SpimData2)((Object)lpq.getData());
        ArrayList<ViewId> viewIds = SpimData2.getAllViewIdsSorted(data, lpq.getViewSetupsToProcess(), lpq.getTimePointsToProcess());
        Resave_TIFF.writeTIFF(data, viewIds, new File(params.xmlFile).getParent(), params.compress, progressWriter);
        try {
            Pair<SpimData2, List<String>> result = Resave_TIFF.createXMLObject(data, viewIds, params);
            progressWriter.setProgress(0.95);
            ((XmlIoSpimData2)((Object)lpq.getIO())).save((SpimData2)((Object)result.getA()), new File(params.xmlFile).getAbsolutePath());
            Resave_TIFF.copyInterestPoints(data.getBasePath(), new File(params.xmlFile).getParentFile(), (List)result.getB());
        }
        catch (SpimDataException e) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Could not save xml '" + params.xmlFile + "'.");
            e.printStackTrace();
        }
        finally {
            progressWriter.setProgress(1.0);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saved xml '" + params.xmlFile + "'.");
        }
    }

    public static void copyInterestPoints(File srcBase, File destBase, List<String> filesToCopy) {
        String from = srcBase.getAbsolutePath();
        String to = destBase.getAbsolutePath();
        from = from.replace("/./", "/");
        to = to.replace("/./", "/");
        if (from.endsWith("/.")) {
            from = from.substring(0, from.length() - 2);
        }
        if (to.endsWith("/.")) {
            to = to.substring(0, to.length() - 2);
        }
        if (new File(from).getAbsolutePath().equals(new File(to).getAbsolutePath())) {
            return;
        }
        File src = new File(srcBase, "interestpoints");
        if (src.exists()) {
            File target = new File(destBase, "interestpoints");
            IOFunctions.println(new Date(System.currentTimeMillis()) + ": Interestpoint directory exists. Copying '" + src + "' >>> '" + target + "'");
            try {
                Resave_TIFF.copyFolder(src, target, filesToCopy);
            }
            catch (IOException e) {
                IOFunctions.println(new Date(System.currentTimeMillis()) + ": FAILED to copying '" + src + "' >>> '" + target + "': " + e);
                e.printStackTrace();
            }
        }
    }

    public static Parameters getParameters() {
        GenericDialogPlus gd = new GenericDialogPlus("Resave dataset as TIFF");
        if (defaultPath == null) {
            defaultPath = LoadParseQueryXML.defaultXMLfilename;
        }
        PluginHelper.addSaveAsFileField(gd, "Select new XML", defaultPath, 80);
        gd.addChoice("ImgLib2_data_container", StackList.imglib2Container, StackList.imglib2Container[defaultContainer]);
        gd.addCheckbox("Lossless compression of TIFF files (ZIP)", defaultCompress);
        gd.addMessage("Use ArrayImg if -ALL- input views are smaller than ~2048x2048x500 px (2^31 px), or if the\nprogram throws an OutOfMemory exception while processing.  CellImg is slower, but more\nmemory efficient and supports much larger file sizes only limited by the RAM of the machine.", new Font("SansSerif", 2, 11));
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        Parameters params = new Parameters();
        params.xmlFile = gd.getNextString();
        if (!params.xmlFile.endsWith(".xml")) {
            params.xmlFile = params.xmlFile + ".xml";
        }
        params.compress = defaultCompress = gd.getNextBoolean();
        defaultPath = LoadParseQueryXML.defaultXMLfilename = params.xmlFile;
        defaultContainer = gd.getNextChoiceIndex();
        params.imgFactory = defaultContainer == 0 ? new ArrayImgFactory() : new CellImgFactory();
        return params;
    }

    public static void writeTIFF(SpimData spimData, List<ViewId> viewIds, String path, boolean compress, ProgressWriter progressWriter) {
        if (compress) {
            IOFunctions.println(new Date(System.currentTimeMillis()) + ": Saving compressed TIFFS to directory '" + path + "'");
        } else {
            IOFunctions.println(new Date(System.currentTimeMillis()) + ": Saving TIFFS to directory '" + path + "'");
        }
        Save3dTIFF save = new Save3dTIFF(path, compress);
        int numAngles = SpimData2.getAllAnglesSorted(spimData, viewIds).size();
        int numChannels = SpimData2.getAllChannelsSorted(spimData, viewIds).size();
        int numIlluminations = SpimData2.getAllIlluminationsSorted(spimData, viewIds).size();
        int numTimepoints = SpimData2.getAllTimePointsSorted(spimData, viewIds).size();
        int i = 0;
        for (ViewId viewId : viewIds) {
            ++i;
            ViewDescription viewDescription = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
            if (!viewDescription.isPresent()) continue;
            RandomAccessibleInterval img = ((ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader()).getSetupImgLoader(viewId.getViewSetupId()).getImage(viewId.getTimePointId(), new ImgLoaderHint[]{ImgLoaderHints.LOAD_COMPLETELY});
            String filename = "img";
            if (numTimepoints > 1) {
                filename = filename + "_TL" + viewId.getTimePointId();
            }
            if (numChannels > 1) {
                filename = filename + "_Ch" + ((ViewSetup)viewDescription.getViewSetup()).getChannel().getName();
            }
            if (numIlluminations > 1) {
                filename = filename + "_Ill" + ((ViewSetup)viewDescription.getViewSetup()).getIllumination().getName();
            }
            if (numAngles > 1) {
                filename = filename + "_Angle" + ((ViewSetup)viewDescription.getViewSetup()).getAngle().getName();
            }
            save.exportImage(img, filename);
            progressWriter.setProgress((double)(i - 1) / (double)viewIds.size() * 95.0);
        }
    }

    public static Pair<SpimData2, List<String>> createXMLObject(SpimData2 spimData, List<ViewId> viewIds, Parameters params) {
        int layoutTP = 0;
        int layoutChannels = 0;
        int layoutIllum = 0;
        int layoutAngles = 0;
        String filename = "img";
        int numAngles = SpimData2.getAllAnglesSorted(spimData, viewIds).size();
        int numChannels = SpimData2.getAllChannelsSorted(spimData, viewIds).size();
        int numIlluminations = SpimData2.getAllIlluminationsSorted(spimData, viewIds).size();
        int numTimepoints = SpimData2.getAllTimePointsSorted(spimData, viewIds).size();
        if (numTimepoints > 1) {
            filename = filename + "_TL{t}";
            layoutTP = 1;
        }
        if (numChannels > 1) {
            filename = filename + "_Ch{c}";
            layoutChannels = 1;
        }
        if (numIlluminations > 1) {
            filename = filename + "_Ill{i}";
            layoutIllum = 1;
        }
        if (numAngles > 1) {
            filename = filename + "_Angle{a}";
            layoutAngles = 1;
        }
        filename = filename + ".tif";
        if (params.compress) {
            filename = filename + ".zip";
        }
        ArrayList<String> filesToCopy = new ArrayList<String>();
        SpimData2 newSpimData = Resave_TIFF.assemblePartialSpimData2(spimData, viewIds, new File(params.xmlFile).getParentFile(), filesToCopy);
        StackImgLoaderIJ imgLoader = new StackImgLoaderIJ(new File(params.xmlFile).getParentFile(), filename, params.imgFactory, layoutTP, layoutChannels, layoutIllum, layoutAngles, newSpimData.getSequenceDescription());
        ((SequenceDescription)newSpimData.getSequenceDescription()).setImgLoader((BasicImgLoader)imgLoader);
        return new ValuePair((Object)newSpimData, filesToCopy);
    }

    public static String listAllTimePoints(List<TimePoint> timePointsToProcess) {
        String t = "" + timePointsToProcess.get(0).getId();
        for (int i = 1; i < timePointsToProcess.size(); ++i) {
            t = t + ", " + timePointsToProcess.get(i).getId();
        }
        return t;
    }

    public static void copyFolder(File src, File dest, List<String> filesToCopy) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : src.list()) {
                Resave_TIFF.copyFolder(new File(src, file), new File(dest, file), filesToCopy);
            }
        } else {
            boolean contains = false;
            for (int i = 0; i < filesToCopy.size() && !contains; ++i) {
                if (!src.getName().contains(filesToCopy.get(i))) continue;
                contains = true;
            }
            if (contains) {
                int length;
                FileInputStream in = new FileInputStream(src);
                FileOutputStream out = new FileOutputStream(dest);
                byte[] buffer = new byte[65535];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
    }

    public static SpimData2 assemblePartialSpimData2(SpimData2 spimData, List<ViewId> viewIds, File basePath, List<String> filesToCopy) {
        TimePointsPattern timepoints;
        try {
            timepoints = new TimePointsPattern(Resave_TIFF.listAllTimePoints(SpimData2.getAllTimePointsSorted(spimData, viewIds)));
        }
        catch (ParseException e) {
            IOFunctions.println("Automatically created list of timepoints failed to parse. This should not happen, really :) -- " + e);
            IOFunctions.println("Here is the list: " + Resave_TIFF.listAllTimePoints(SpimData2.getAllTimePointsSorted(spimData, viewIds)));
            e.printStackTrace();
            return null;
        }
        ArrayList<ViewSetup> setups = SpimData2.getAllViewSetupsSorted(spimData, viewIds);
        HashSet<ViewId> views = new HashSet<ViewId>();
        for (ViewId viewId : viewIds) {
            views.add(new ViewId(viewId.getTimePointId(), viewId.getViewSetupId()));
        }
        MissingViews oldMissingViews = ((SequenceDescription)spimData.getSequenceDescription()).getMissingViews();
        HashSet<ViewId> missingViews = new HashSet<ViewId>();
        if (oldMissingViews != null && oldMissingViews.getMissingViews() != null) {
            for (ViewId id : oldMissingViews.getMissingViews()) {
                if (!views.contains(id)) continue;
                missingViews.add(id);
            }
        }
        for (TimePoint t : timepoints.getTimePointsOrdered()) {
            for (ViewSetup viewSetup : setups) {
                ViewId viewId = new ViewId(t.getId(), viewSetup.getId());
                if (views.contains(viewId)) continue;
                missingViews.add(viewId);
            }
        }
        SequenceDescription sequenceDescription = new SequenceDescription((TimePoints)timepoints, setups, null, new MissingViews(missingViews));
        Map oldRegMap = spimData.getViewRegistrations().getViewRegistrations();
        HashMap newRegMap = new HashMap();
        for (ViewId viewId : oldRegMap.keySet()) {
            if (!views.contains(viewId)) continue;
            newRegMap.put(viewId, oldRegMap.get(viewId));
        }
        ViewRegistrations viewRegistrations = new ViewRegistrations(newRegMap);
        Map<ViewId, ViewInterestPointLists> oldInterestPoints = spimData.getViewInterestPoints().getViewInterestPoints();
        HashMap<ViewId, ViewInterestPointLists> newInterestPoints = new HashMap<ViewId, ViewInterestPointLists>();
        for (ViewId viewId : oldInterestPoints.keySet()) {
            if (!views.contains(viewId)) continue;
            ViewInterestPointLists ipLists = oldInterestPoints.get(viewId);
            newInterestPoints.put(viewId, ipLists);
            if (filesToCopy == null) continue;
            for (InterestPointList ipl : ipLists.getHashMap().values()) {
                filesToCopy.add(ipl.getFile().getName());
            }
        }
        ViewInterestPoints viewsInterestPoints = new ViewInterestPoints(newInterestPoints);
        SpimData2 newSpimData = new SpimData2(basePath, sequenceDescription, viewRegistrations, viewsInterestPoints, spimData.getBoundingBoxes());
        return newSpimData;
    }

    public static class Parameters {
        public ImgFactory<? extends NativeType<?>> imgFactory;
        public String xmlFile;
        public boolean compress;

        public boolean compress() {
            return this.compress;
        }

        public String getXMLFile() {
            return this.xmlFile;
        }

        public ImgFactory<? extends NativeType<?>> getImgFactory() {
            return this.imgFactory;
        }
    }
}

