/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.fiji.datasetmanager.LightSheetZ1;
import spim.fiji.datasetmanager.LightSheetZ1MetaData;
import spim.fiji.spimdata.imgloaders.AbstractImgFactoryImgLoader;
import spim.fiji.spimdata.imgloaders.LegacyStackImgLoaderLOCI;

public class LegacyLightSheetZ1ImgLoader
extends AbstractImgFactoryImgLoader {
    final File cziFile;
    final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    LightSheetZ1MetaData meta;
    boolean isClosed = true;

    public LegacyLightSheetZ1ImgLoader(File cziFile, ImgFactory<? extends NativeType<?>> imgFactory, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.cziFile = cziFile;
        this.sequenceDescription = sequenceDescription;
        this.setImgFactory(imgFactory);
    }

    public File getCZIFile() {
        return this.cziFile;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(ViewId view, boolean normalize) {
        try {
            Img<FloatType> img = this.openCZI(new FloatType(), view);
            if (img == null) {
                throw new RuntimeException("Could not load '" + this.cziFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId());
            }
            if (normalize) {
                LegacyLightSheetZ1ImgLoader.normalize(img);
            }
            return img;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load '" + this.cziFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId() + ": " + e);
        }
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        try {
            Img<UnsignedShortType> img = this.openCZI(new UnsignedShortType(), view);
            if (img == null) {
                throw new RuntimeException("Could not load '" + this.cziFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId());
            }
            return img;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load '" + this.cziFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId() + ": " + e);
        }
    }

    @Override
    protected void loadMetaData(ViewId view) {
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Loading metadata for Lightsheet Z1 imgloader not necessary.");
    }

    public void finalize() {
        IOFunctions.printlnSafe("Closing czi: " + this.cziFile);
        try {
            if (this.meta != null && this.meta.getReader() != null) {
                this.meta.getReader().close();
                this.isClosed = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected <T extends RealType<T> & NativeType<T>> Img<T> openCZI(T type, ViewId view) throws Exception {
        Img img;
        int[] dim;
        if (this.meta == null) {
            IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Investigating file '" + this.cziFile.getAbsolutePath() + "' (loading metadata).");
            this.meta = new LightSheetZ1MetaData();
            if (!this.meta.loadMetaData(this.cziFile, true)) {
                IOFunctions.printlnSafe("Failed to analyze file: '" + this.cziFile.getAbsolutePath() + "'.");
                this.meta = null;
                this.isClosed = true;
                return null;
            }
            this.isClosed = false;
        }
        BasicViewDescription vd = (BasicViewDescription)this.sequenceDescription.getViewDescriptions().get(view);
        BasicViewSetup vs = vd.getViewSetup();
        TimePoint t = vd.getTimePoint();
        Angle a = LegacyLightSheetZ1ImgLoader.getAngle(vd);
        Channel c = LegacyLightSheetZ1ImgLoader.getChannel(vd);
        Illumination i = LegacyLightSheetZ1ImgLoader.getIllumination(vd);
        if (vs.hasSize()) {
            dim = new int[vs.getSize().numDimensions()];
            for (int d = 0; d < vs.getSize().numDimensions(); ++d) {
                dim[d] = (int)vs.getSize().dimension(d);
            }
        } else {
            dim = this.meta.imageSizes().get(a.getId());
        }
        if ((img = this.imgFactory.imgFactory(type).create(dim, type)) == null) {
            throw new RuntimeException("Could not instantiate " + this.getImgFactory().getClass().getSimpleName() + " for '" + this.cziFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId() + ", most likely out of memory.");
        }
        boolean isLittleEndian = this.meta.isLittleEndian();
        boolean isArray = ArrayImg.class.isInstance(img);
        int pixelType = this.meta.pixelType();
        int width = dim[0];
        int height = dim[1];
        int depth = dim[2];
        int numPx = width * height;
        IFormatReader r = this.meta.getReader() == null ? LegacyLightSheetZ1ImgLoader.instantiateImageReader() : this.meta.getReader();
        byte[] b = new byte[numPx * this.meta.bytesPerPixel()];
        try {
            try {
                if (this.meta.getReader() == null) {
                    IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opening '" + this.cziFile.getName() + "' for reading image data.");
                    r.setId(this.cziFile.getAbsolutePath());
                }
                r.setSeries(a.getId());
            }
            catch (IllegalStateException e) {
                r.setId(this.cziFile.getAbsolutePath());
                r.setSeries(a.getId());
            }
            IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Reading image data from '" + this.cziFile.getName() + "' [" + dim[0] + "x" + dim[1] + "x" + dim[2] + " angle=" + a.getName() + " ch=" + c.getName() + " illum=" + i.getName() + " tp=" + t.getName() + " type=" + this.meta.pixelTypeString() + " img=" + img.getClass().getSimpleName() + "<" + type.getClass().getSimpleName() + ">]");
            int ch = i.getId() * this.meta.numChannels() + c.getId();
            for (int z = 0; z < depth; ++z) {
                IJ.showProgress((double)((double)z / (double)depth));
                Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)img, (int)2, (long)z)).localizingCursor();
                r.openBytes(r.getIndex(z, ch, t.getId()), b);
                if (pixelType == 1) {
                    if (isArray) {
                        LegacyLightSheetZ1ImgLoader.readBytesArray(b, cursor, numPx);
                        continue;
                    }
                    LegacyLightSheetZ1ImgLoader.readBytes(b, cursor, width);
                    continue;
                }
                if (pixelType == 3) {
                    if (isArray) {
                        LegacyLightSheetZ1ImgLoader.readUnsignedShortsArray(b, cursor, numPx, isLittleEndian);
                        continue;
                    }
                    LegacyLightSheetZ1ImgLoader.readUnsignedShorts(b, cursor, width, isLittleEndian);
                    continue;
                }
                if (pixelType == 2) {
                    if (isArray) {
                        LegacyLightSheetZ1ImgLoader.readSignedShortsArray(b, cursor, numPx, isLittleEndian);
                        continue;
                    }
                    LegacyLightSheetZ1ImgLoader.readSignedShorts(b, cursor, width, isLittleEndian);
                    continue;
                }
                if (pixelType == 5) {
                    if (isArray) {
                        LegacyLightSheetZ1ImgLoader.readUnsignedIntsArray(b, cursor, numPx, isLittleEndian);
                        continue;
                    }
                    LegacyLightSheetZ1ImgLoader.readUnsignedInts(b, cursor, width, isLittleEndian);
                    continue;
                }
                if (pixelType != 6) continue;
                if (isArray) {
                    LegacyLightSheetZ1ImgLoader.readFloatsArray(b, cursor, numPx, isLittleEndian);
                    continue;
                }
                LegacyLightSheetZ1ImgLoader.readFloats(b, cursor, width, isLittleEndian);
            }
            IJ.showProgress((double)1.0);
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("File '" + this.cziFile.getAbsolutePath() + "' could not be opened: " + e);
            IOFunctions.printlnSafe("Stopping");
            e.printStackTrace();
            try {
                r.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }
        return img;
    }

    public static final <T extends RealType<T>> void readBytes(byte[] b, Cursor<T> cursor, int width) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)(b[cursor.getIntPosition(0) + cursor.getIntPosition(1) * width] & 0xFF));
        }
    }

    public static final <T extends RealType<T>> void readBytesArray(byte[] b, Cursor<T> cursor, int numPx) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)(b[i] & 0xFF));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedShorts(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getShortValueInt(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedShortsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)LegacyStackImgLoaderLOCI.getShortValueInt(b, i * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readSignedShorts(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getShortValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readSignedShortsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)LegacyStackImgLoaderLOCI.getShortValue(b, i * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedInts(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getIntValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 4, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedIntsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)LegacyStackImgLoaderLOCI.getIntValue(b, i * 4, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readFloats(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal(LegacyStackImgLoaderLOCI.getFloatValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 4, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readFloatsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal(LegacyStackImgLoaderLOCI.getFloatValue(b, i * 4, isLittleEndian));
        }
    }

    public static IFormatReader instantiateImageReader() {
        return new ChannelSeparator();
    }

    public static boolean createOMEXMLMetadata(IFormatReader r) {
        try {
            ServiceFactory serviceFactory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
            OMEXMLMetadata omexmlMeta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)omexmlMeta);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (DependencyException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected static Angle getAngle(AbstractSequenceDescription<?, ?, ?> seqDesc, ViewId view) {
        return LegacyLightSheetZ1ImgLoader.getAngle((BasicViewDescription)seqDesc.getViewDescriptions().get(view));
    }

    protected static Angle getAngle(BasicViewDescription<?> vd) {
        BasicViewSetup vs = vd.getViewSetup();
        Angle angle = (Angle)vs.getAttribute(Angle.class);
        if (angle == null) {
            throw new RuntimeException("This XML does not have the 'Angle' attribute for their ViewSetup. Cannot continue.");
        }
        return angle;
    }

    protected static Channel getChannel(BasicViewDescription<?> vd) {
        BasicViewSetup vs = vd.getViewSetup();
        Channel channel = (Channel)vs.getAttribute(Channel.class);
        if (channel == null) {
            throw new RuntimeException("This XML does not have the 'Channel' attribute for their ViewSetup. Cannot continue.");
        }
        return channel;
    }

    protected static Illumination getIllumination(BasicViewDescription<?> vd) {
        BasicViewSetup vs = vd.getViewSetup();
        Illumination illumination = (Illumination)vs.getAttribute(Illumination.class);
        if (illumination == null) {
            throw new RuntimeException("This XML does not have the 'Illumination' attribute for their ViewSetup. Cannot continue.");
        }
        return illumination;
    }

    public String toString() {
        return new LightSheetZ1().getTitle() + ", ImgFactory=" + this.imgFactory.getClass().getSimpleName();
    }
}

