/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.fiji.datasetmanager.SlideBook6;
import spim.fiji.datasetmanager.SlideBook6MetaData;
import spim.fiji.spimdata.imgloaders.AbstractImgFactoryImgLoader;
import spim.fiji.spimdata.imgloaders.LegacyStackImgLoaderLOCI;

public class LegacySlideBook6ImgLoader
extends AbstractImgFactoryImgLoader {
    final File sldFile;
    final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    SlideBook6MetaData meta;
    boolean isClosed = true;

    public LegacySlideBook6ImgLoader(File sldFile, ImgFactory<? extends NativeType<?>> imgFactory, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.sldFile = sldFile;
        this.sequenceDescription = sequenceDescription;
        this.setImgFactory(imgFactory);
    }

    public File getSLDFile() {
        return this.sldFile;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(ViewId view, boolean normalize) {
        try {
            int[] dim = new int[3];
            float[] voxelSize = new float[3];
            Img<FloatType> img = this.openSLD(new FloatType(), view);
            if (img == null) {
                throw new RuntimeException("Could not load '" + this.sldFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId());
            }
            if (normalize) {
                LegacySlideBook6ImgLoader.normalize(img);
            }
            return img;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load '" + this.sldFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId() + ": " + e);
        }
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        try {
            int[] dim = new int[3];
            float[] voxelSize = new float[3];
            Img<UnsignedShortType> img = this.openSLD(new UnsignedShortType(), view);
            if (img == null) {
                throw new RuntimeException("Could not load '" + this.sldFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId());
            }
            return img;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load '" + this.sldFile + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId() + ": " + e);
        }
    }

    @Override
    protected void loadMetaData(ViewId view) {
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Loading metadata for SlideBook6 imgloader not necessary.");
    }

    public void finalize() {
        IOFunctions.printlnSafe("Closing sld: " + this.sldFile);
        try {
            if (this.meta != null && this.meta.getReader() != null) {
                this.meta.getReader().close();
                this.isClosed = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected <T extends RealType<T> & NativeType<T>> Img<T> openSLD(T type, ViewId view) throws Exception {
        Img img;
        int[] dim;
        if (this.meta == null) {
            IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Investigating file '" + this.sldFile.getAbsolutePath() + "' (loading metadata).");
            this.meta = new SlideBook6MetaData();
            if (!this.meta.loadMetaData(this.sldFile, true)) {
                IOFunctions.printlnSafe("Failed to analyze file: '" + this.sldFile.getAbsolutePath() + "'.");
                this.meta = null;
                this.isClosed = true;
                return null;
            }
            this.isClosed = false;
        }
        BasicViewDescription vd = (BasicViewDescription)this.sequenceDescription.getViewDescriptions().get(view);
        BasicViewSetup vs = vd.getViewSetup();
        TimePoint t = vd.getTimePoint();
        Angle a = LegacySlideBook6ImgLoader.getAngle(vd);
        Channel ch = LegacySlideBook6ImgLoader.getChannel(vd);
        Illumination i = LegacySlideBook6ImgLoader.getIllumination(vd);
        int c = i.getId() / 8;
        if (vs.hasSize()) {
            dim = new int[vs.getSize().numDimensions()];
            for (int d = 0; d < vs.getSize().numDimensions(); ++d) {
                dim[d] = (int)vs.getSize().dimension(d);
            }
        } else {
            dim = this.meta.imageSize(c);
        }
        if ((img = this.imgFactory.imgFactory(type).create(dim, type)) == null) {
            throw new RuntimeException("Could not instantiate " + this.getImgFactory().getClass().getSimpleName() + " for '" + this.sldFile + "' captureId=" + c + "' viewId=" + view.getViewSetupId() + ", tpId=" + view.getTimePointId() + ", most likely out of memory.");
        }
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opening '" + this.sldFile.getName() + "' [" + dim[0] + "x" + dim[1] + "x" + dim[2] + " angle=" + a.getName() + " ch=" + ch.getName() + " illum=" + i.getName() + " tp=" + t.getName() + " type=" + FormatTools.getPixelTypeString((int)3) + " img=" + img.getClass().getSimpleName() + "<" + type.getClass().getSimpleName() + ">]");
        boolean isLittleEndian = this.meta.isLittleEndian();
        boolean isArray = ArrayImg.class.isInstance(img);
        int pixelType = 3;
        int width = dim[0];
        int height = dim[1];
        int depth = dim[2];
        int numPx = width * height;
        IFormatReader r = this.meta.getReader() == null ? LegacySlideBook6ImgLoader.instantiateImageReader() : this.meta.getReader();
        byte[] b = new byte[numPx * FormatTools.getBytesPerPixel((int)3)];
        try {
            try {
                if (this.meta.getReader() == null) {
                    IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opening '" + this.sldFile.getName() + "' for reading image data.");
                    r.setId(this.sldFile.getAbsolutePath());
                }
                r.setSeries(c);
            }
            catch (IllegalStateException e) {
                r.setId(this.sldFile.getAbsolutePath());
                r.setSeries(c);
            }
            IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Reading image data from '" + this.sldFile.getName() + "' [" + dim[0] + "x" + dim[1] + "x" + dim[2] + " angle=" + a.getName() + " ch=" + ch.getName() + " illum=" + i.getName() + " tp=" + t.getName() + " type=" + this.meta.pixelTypeString() + " img=" + img.getClass().getSimpleName() + "<" + type.getClass().getSimpleName() + ">]");
            int chIndex = ch.getId() * 2 + a.getId();
            for (int z = 0; z < depth; ++z) {
                IJ.showProgress((double)((double)z / (double)depth));
                Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)img, (int)2, (long)z)).localizingCursor();
                r.openBytes(r.getIndex(z, chIndex, t.getId()), b);
                IOFunctions.printlnSafe("reader.readImagePlaneBuf z = " + z + ", capture = " + c + ", angle = " + a.getId() + ", channel = " + chIndex + ", channels = " + this.meta.numChannels(c) + ", timepoint = " + t.getId());
                if (isArray) {
                    LegacySlideBook6ImgLoader.readUnsignedShortsArray(b, cursor, numPx, isLittleEndian);
                    continue;
                }
                LegacySlideBook6ImgLoader.readUnsignedShorts(b, cursor, width, isLittleEndian);
            }
            IJ.showProgress((double)1.0);
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("File '" + this.sldFile.getAbsolutePath() + "' could not be opened: " + e);
            IOFunctions.printlnSafe("Stopping");
            e.printStackTrace();
            return null;
        }
        return img;
    }

    public static final <T extends RealType<T>> void readBytes(byte[] b, Cursor<T> cursor, int width) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)(b[cursor.getIntPosition(0) + cursor.getIntPosition(1) * width] & 0xFF));
        }
    }

    public static final <T extends RealType<T>> void readBytesArray(byte[] b, Cursor<T> cursor, int numPx) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)(b[i] & 0xFF));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedShorts(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getShortValueInt(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedShortsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)LegacyStackImgLoaderLOCI.getShortValueInt(b, i * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readSignedShorts(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getShortValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readSignedShortsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)LegacyStackImgLoaderLOCI.getShortValue(b, i * 2, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedInts(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getIntValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 4, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readUnsignedIntsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal((float)LegacyStackImgLoaderLOCI.getIntValue(b, i * 4, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readFloats(byte[] b, Cursor<T> cursor, int width, boolean isLittleEndian) {
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal(LegacyStackImgLoaderLOCI.getFloatValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 4, isLittleEndian));
        }
    }

    public static final <T extends RealType<T>> void readFloatsArray(byte[] b, Cursor<T> cursor, int numPx, boolean isLittleEndian) {
        for (int i = 0; i < numPx; ++i) {
            ((RealType)cursor.next()).setReal(LegacyStackImgLoaderLOCI.getFloatValue(b, i * 4, isLittleEndian));
        }
    }

    public static IFormatReader instantiateImageReader() {
        return new ChannelSeparator();
    }

    public static boolean createOMEXMLMetadata(IFormatReader r) {
        try {
            ServiceFactory serviceFactory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
            OMEXMLMetadata omexmlMeta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)omexmlMeta);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (DependencyException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected static Angle getAngle(AbstractSequenceDescription<?, ?, ?> seqDesc, ViewId view) {
        return LegacySlideBook6ImgLoader.getAngle((BasicViewDescription)seqDesc.getViewDescriptions().get(view));
    }

    protected static Angle getAngle(BasicViewDescription<?> vd) {
        BasicViewSetup vs = vd.getViewSetup();
        Angle angle = (Angle)vs.getAttribute(Angle.class);
        if (angle == null) {
            throw new RuntimeException("This XML does not have the 'Angle' attribute for their ViewSetup. Cannot continue.");
        }
        return angle;
    }

    protected static Channel getChannel(BasicViewDescription<?> vd) {
        BasicViewSetup vs = vd.getViewSetup();
        Channel channel = (Channel)vs.getAttribute(Channel.class);
        if (channel == null) {
            throw new RuntimeException("This XML does not have the 'Channel' attribute for their ViewSetup. Cannot continue.");
        }
        return channel;
    }

    protected static Illumination getIllumination(BasicViewDescription<?> vd) {
        BasicViewSetup vs = vd.getViewSetup();
        Illumination illumination = (Illumination)vs.getAttribute(Illumination.class);
        if (illumination == null) {
            throw new RuntimeException("This XML does not have the 'Illumination' attribute for their ViewSetup. Cannot continue.");
        }
        return illumination;
    }

    public String toString() {
        return new SlideBook6().getTitle() + ", ImgFactory=" + this.imgFactory.getClass().getSimpleName();
    }
}

