/*
 * Decompiled with CFR 0.152.
 */
package io.scif.convert;

import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import net.imagej.Dataset;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class FileToDatasetConverter
extends AbstractConverter<File, Dataset> {
    @Parameter(required=false)
    private DatasetIOService io;
    @Parameter
    private LogService log;

    public boolean canConvert(Class<?> src, Class<?> dest) {
        return this.io != null && super.canConvert(src, dest);
    }

    public boolean canConvert(Object src, Class<?> dest) {
        return this.io != null && src != null && super.canConvert(src, dest) && (((File)src).getName().endsWith(".fake") || ((File)src).exists()) && this.io.canOpen(((File)src).getAbsolutePath());
    }

    public boolean canConvert(Object src, Type dest) {
        return this.io != null && src != null && super.canConvert(src, dest) && (((File)src).getName().endsWith(".fake") || ((File)src).exists()) && this.io.canOpen(((File)src).getAbsolutePath());
    }

    public <T> T convert(Object src, Class<T> dest) {
        File file = (File)src;
        Dataset data = null;
        try {
            data = this.io.open(file.getAbsolutePath());
        }
        catch (IOException e) {
            this.log.error((Object)"Error loading file", (Throwable)e);
        }
        return (T)data;
    }

    public Class<Dataset> getOutputType() {
        return Dataset.class;
    }

    public Class<File> getInputType() {
        return File.class;
    }
}

