/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.Volume;
import java.awt.Polygon;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import vib.NaiveResampler;
import voltex.Mask;
import voltex.VoltexVolume;
import voltex.VolumeRenderer;

public class VoltexGroup
extends ContentNode {
    protected VolumeRenderer renderer;
    protected ContentInstant c;
    private float volume;
    private Point3d min;
    private Point3d max;
    private Point3d center;

    protected VoltexGroup() {
    }

    public VoltexGroup(Content c) {
        this(c.getCurrent());
    }

    public VoltexGroup(ContentInstant c) {
        if (c.getImage() == null) {
            throw new IllegalArgumentException("VoltexGroup can onlybe initialized from a ContentInstant that holds an image.");
        }
        this.c = c;
        ImagePlus imp = c.getResamplingFactor() == 1 ? c.getImage() : NaiveResampler.resample((ImagePlus)c.getImage(), (int)c.getResamplingFactor());
        this.renderer = new VolumeRenderer(imp, c.getColor(), c.getTransparency(), c.getChannels());
        int[] rLUT = new int[256];
        int[] gLUT = new int[256];
        int[] bLUT = new int[256];
        int[] aLUT = new int[256];
        this.renderer.volume.getRedLUT(rLUT);
        this.renderer.volume.getGreenLUT(gLUT);
        this.renderer.volume.getBlueLUT(bLUT);
        this.renderer.volume.getAlphaLUT(aLUT);
        c.setLUT(rLUT, gLUT, bLUT, aLUT);
        this.renderer.fullReload();
        this.calculateMinMaxCenterPoint();
        this.addChild((Node)this.renderer.getVolumeNode());
    }

    public void update() {
        if (this.c.getResamplingFactor() != 1) {
            return;
        }
        this.renderer.getVolume().updateData();
    }

    public VolumeRenderer getRenderer() {
        return this.renderer;
    }

    public Mask createMask() {
        return this.renderer.createMask();
    }

    @Override
    public void getMin(Tuple3d min) {
        min.set((Tuple3d)this.min);
    }

    @Override
    public void getMax(Tuple3d max) {
        max.set((Tuple3d)this.max);
    }

    @Override
    public void getCenter(Tuple3d center) {
        center.set((Tuple3d)this.center);
    }

    @Override
    public void thresholdUpdated(int threshold) {
        this.renderer.setThreshold(threshold);
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void eyePtChanged(View view) {
        this.renderer.eyePtChanged(view);
    }

    @Override
    public void channelsUpdated(boolean[] channels) {
        this.renderer.setChannels(channels);
    }

    @Override
    public void lutUpdated(int[] r, int[] g, int[] b, int[] a) {
        this.renderer.setLUTs(r, g, b, a);
    }

    @Override
    public void shadeUpdated(boolean shaded) {
    }

    @Override
    public void colorUpdated(Color3f color) {
        this.renderer.setColor(color);
    }

    @Override
    public void transparencyUpdated(float transparency) {
        this.renderer.setTransparency(transparency);
    }

    public void volumeToImagePlate(Transform3D toImagePlate) {
        Transform3D toVWorld = new Transform3D();
        this.renderer.getVolumeNode().getLocalToVworld(toVWorld);
        toImagePlate.mul(toVWorld);
    }

    public void fillRoi(Canvas3D canvas, Roi roi, byte fillValue) {
        if (roi == null) {
            return;
        }
        Polygon p = roi.getPolygon();
        Transform3D volToIP = new Transform3D();
        canvas.getImagePlateToVworld(volToIP);
        volToIP.invert();
        this.volumeToImagePlate(volToIP);
        VoltexVolume vol = this.renderer.getVolume();
        Point2d onCanvas = new Point2d();
        for (int z = 0; z < vol.zDim; ++z) {
            for (int y = 0; y < vol.yDim; ++y) {
                for (int x = 0; x < vol.xDim; ++x) {
                    this.volumePointInCanvas(canvas, volToIP, x, y, z, onCanvas);
                    if (!p.contains(onCanvas.x, onCanvas.y)) continue;
                    vol.setNoCheckNoUpdate(x, y, z, fillValue);
                }
            }
            IJ.showStatus((String)"Filling...");
            IJ.showProgress((int)z, (int)vol.zDim);
        }
        vol.updateData();
        ImagePlus image = this.c.getImage();
        int factor = this.c.getResamplingFactor();
        if (image == null || factor == 1) {
            return;
        }
        Volume volu = new Volume(image);
        for (int z = 0; z < volu.zDim; ++z) {
            for (int y = 0; y < volu.yDim; ++y) {
                for (int x = 0; x < volu.xDim; ++x) {
                    this.volumePointInCanvas(canvas, volToIP, x / factor, y / factor, z / factor, onCanvas);
                    if (!p.contains(onCanvas.x, onCanvas.y)) continue;
                    volu.set(x, y, z, fillValue);
                }
            }
            IJ.showStatus((String)"Filling...");
            IJ.showProgress((int)z, (int)volu.zDim);
        }
    }

    private void volumePointInCanvas(Canvas3D canvas, Transform3D volToIP, int x, int y, int z, Point2d ret) {
        VoltexVolume vol = this.renderer.volume;
        double px = (double)x * vol.pw;
        double py = (double)y * vol.ph;
        double pz = (double)z * vol.pd;
        Point3d locInImagePlate = new Point3d(px, py, pz);
        volToIP.transform(locInImagePlate);
        canvas.getPixelLocationFromImagePlate(locInImagePlate, ret);
    }

    protected void calculateMinMaxCenterPoint() {
        ImagePlus imp = this.c.getImage();
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getStackSize();
        Calibration cal = imp.getCalibration();
        this.min = new Point3d();
        this.max = new Point3d();
        this.center = new Point3d();
        this.min.x = (float)w * (float)cal.pixelHeight;
        this.min.y = (float)h * (float)cal.pixelHeight;
        this.min.z = (float)d * (float)cal.pixelDepth;
        this.max.x = 0.0;
        this.max.y = 0.0;
        this.max.z = 0.0;
        float vol = 0.0f;
        for (int zi = 0; zi < d; ++zi) {
            float z = (float)zi * (float)cal.pixelDepth;
            ImageProcessor ip = imp.getStack().getProcessor(zi + 1);
            int wh = w * h;
            for (int i = 0; i < wh; ++i) {
                float v = ip.getf(i);
                if (v == 0.0f) continue;
                vol += v;
                float x = (float)(i % w) * (float)cal.pixelWidth;
                float y = (float)(i / w) * (float)cal.pixelHeight;
                if ((double)x < this.min.x) {
                    this.min.x = x;
                }
                if ((double)y < this.min.y) {
                    this.min.y = y;
                }
                if ((double)z < this.min.z) {
                    this.min.z = z;
                }
                if ((double)x > this.max.x) {
                    this.max.x = x;
                }
                if ((double)y > this.max.y) {
                    this.max.y = y;
                }
                if ((double)z > this.max.z) {
                    this.max.z = z;
                }
                this.center.x += (double)(v * x);
                this.center.y += (double)(v * y);
                this.center.z += (double)(v * z);
            }
        }
        this.center.x /= (double)vol;
        this.center.y /= (double)vol;
        this.center.z /= (double)vol;
        this.volume = (float)((double)vol * cal.pixelWidth * cal.pixelHeight * cal.pixelDepth);
    }

    @Override
    public void swapDisplayedData(String path, String name) {
        this.renderer.volume.swap(path + ".tif");
        this.renderer.disableTextures();
    }

    @Override
    public void clearDisplayedData() {
        this.renderer.volume.clear();
        this.renderer.disableTextures();
    }

    @Override
    public void restoreDisplayedData(String path, String name) {
        this.renderer.volume.restore(path + ".tif");
        this.renderer.enableTextures();
    }
}

