/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.Cube;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class MedianCut {
    static final int MAXCOLORS = 256;
    static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private byte[] inverseMap;
    private long[] sumOffsetR;
    private long[] sumOffsetG;
    private long[] sumOffsetB;
    private Cube[] list;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public MedianCut(int[] pixels, int width, int height) {
        this.pixels32 = pixels;
        this.width = width;
        this.height = height;
        IJ.showProgress(0.3);
        IJ.showStatus("Building 32x32x32 RGB histogram");
        this.hist = new int[32768];
        this.sumOffsetR = new long[32768];
        this.sumOffsetG = new long[32768];
        this.sumOffsetB = new long[32768];
        for (int i = 0; i < width * height; ++i) {
            int bgr15;
            int c = this.pixels32[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            int n = bgr15 = MedianCut.bgr15(r, g, b);
            this.hist[n] = this.hist[n] + 1;
            int n2 = bgr15;
            this.sumOffsetR[n2] = this.sumOffsetR[n2] + (long)(r - (r >> 3 << 3));
            int n3 = bgr15;
            this.sumOffsetG[n3] = this.sumOffsetG[n3] + (long)(g - (g >> 3 << 3));
            int n4 = bgr15;
            this.sumOffsetB[n4] = this.sumOffsetB[n4] + (long)(b - (b >> 3 << 3));
        }
    }

    public MedianCut(ColorProcessor ip) {
        this((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
    }

    int getColorCount() {
        int count = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= 0) continue;
            ++count;
        }
        return count;
    }

    Color getModalColor() {
        int max = 0;
        int c = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= max) continue;
            max = this.hist[i];
            c = i;
        }
        return new Color(this.red(c), this.green(c), this.blue(c));
    }

    private static final int bgr15(int r, int g, int b) {
        int r5 = r >> 3;
        int g5 = g >> 3;
        int b5 = b >> 3;
        return b5 << 10 | g5 << 5 | r5;
    }

    private static final int bgr15(int c) {
        int r = (c & 0xF80000) >> 19;
        int g = (c & 0xF800) >> 6;
        int b = (c & 0xF8) << 7;
        return b | g | r;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    public Image convert(int maxcubes) {
        ImageProcessor ip = this.convertToByte(maxcubes);
        return ip.createImage();
    }

    public ImageProcessor convertToByte(int maxcubes) {
        int i;
        int longdim = 0;
        IJ.showStatus("Median cut");
        this.list = new Cube[256];
        this.histPtr = new int[32768];
        int ncubes = 0;
        Cube cube = new Cube();
        int color = 0;
        for (i = 0; i <= Short.MAX_VALUE; ++i) {
            if (this.hist[i] == 0) continue;
            this.histPtr[color++] = i;
            cube.count += this.hist[i];
        }
        cube.lower = 0;
        cube.upper = color - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.list[ncubes++] = cube;
        while (ncubes < maxcubes) {
            int level = 255;
            int splitpos = -1;
            for (int k = 0; k <= ncubes - 1; ++k) {
                if (this.list[k].lower == this.list[k].upper || this.list[k].level >= level) continue;
                level = this.list[k].level;
                splitpos = k;
            }
            if (splitpos == -1) break;
            cube = this.list[splitpos];
            int lr = cube.rmax - cube.rmin;
            int lg = cube.gmax - cube.gmin;
            int lb = cube.bmax - cube.bmin;
            if (lr >= lg && lr >= lb) {
                longdim = 0;
            }
            if (lg >= lr && lg >= lb) {
                longdim = 1;
            }
            if (lb >= lr && lb >= lg) {
                longdim = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
            int count = 0;
            for (i = cube.lower; i <= cube.upper - 1 && count < cube.count / 2; count += this.hist[color], ++i) {
                color = this.histPtr[i];
            }
            int median = i;
            Cube cubeA = new Cube();
            cubeA.lower = cube.lower;
            cubeA.upper = median - 1;
            cubeA.count = count;
            cubeA.level = cube.level + 1;
            this.Shrink(cubeA);
            this.list[splitpos] = cubeA;
            Cube cubeB = new Cube();
            cubeB.lower = median;
            cubeB.upper = cube.upper;
            cubeB.count = cube.count - count;
            cubeB.level = cube.level + 1;
            this.Shrink(cubeB);
            this.list[ncubes++] = cubeB;
            if (ncubes % 15 != 0) continue;
            IJ.showProgress(0.3 + 0.6 * (double)ncubes / (double)maxcubes);
        }
        IJ.showProgress(0.9);
        this.makeInverseMap(ncubes);
        IJ.showProgress(0.95);
        return this.makeImage();
    }

    void Shrink(Cube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int color = this.histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b > bmax) {
                bmax = b;
            }
            if (b >= bmin) continue;
            bmin = b;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.bmin = bmin;
        cube.bmax = bmax;
    }

    void makeInverseMap(int ncubes) {
        boolean changes;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        this.inverseMap = new byte[32768];
        IJ.showStatus("Making inverse map");
        this.createInverseMap(ncubes, rLUT, gLUT, bLUT);
        for (int i = 0; i < 5 && (changes = this.improveInverseMap(ncubes, rLUT, gLUT, bLUT)); ++i) {
        }
        this.cm = new IndexColorModel(8, ncubes, rLUT, gLUT, bLUT);
    }

    void createInverseMap(int ncubes, byte[] rLUT, byte[] gLUT, byte[] bLUT) {
        int k;
        for (k = 0; k <= ncubes - 1; ++k) {
            long rsum = 0L;
            long gsum = 0L;
            long bsum = 0L;
            Cube cube = this.list[k];
            int singleColor = -2;
            for (int i = cube.lower; i <= cube.upper; ++i) {
                int color15 = this.histPtr[i];
                int r = this.red(color15);
                rsum += (long)(r * this.hist[color15]) + this.sumOffsetR[color15];
                int g = this.green(color15);
                gsum += (long)(g * this.hist[color15]) + this.sumOffsetG[color15];
                int b = this.blue(color15);
                bsum += (long)(b * this.hist[color15]) + this.sumOffsetB[color15];
            }
            rLUT[k] = (byte)Math.round((double)rsum / (double)cube.count);
            gLUT[k] = (byte)Math.round((double)gsum / (double)cube.count);
            bLUT[k] = (byte)Math.round((double)bsum / (double)cube.count);
        }
        for (k = 0; k <= ncubes - 1; ++k) {
            Cube cube = this.list[k];
            for (int i = cube.lower; i <= cube.upper; ++i) {
                int color15 = this.histPtr[i];
                this.inverseMap[color15] = (byte)k;
            }
        }
    }

    boolean improveInverseMap(int ncubes, byte[] rLUT, byte[] gLUT, byte[] bLUT) {
        boolean changes = false;
        boolean[] colorChanged = new boolean[ncubes];
        double[] distanceSqr = new double[32768];
        for (int i = 0; i < this.hist.length; ++i) {
            if (this.hist[i] == 0) continue;
            int nearestColor = -1;
            double minDistanceSqr = Double.MAX_VALUE;
            double rBin = (long)this.red(i) + this.sumOffsetR[i] / (long)this.hist[i];
            double gBin = (long)this.green(i) + this.sumOffsetG[i] / (long)this.hist[i];
            double bBin = (long)this.blue(i) + this.sumOffsetB[i] / (long)this.hist[i];
            for (int k = 0; k < ncubes; ++k) {
                if (i == MedianCut.bgr15(rLUT[k] & 0xFF, gLUT[k] & 0xFF, bLUT[k] & 0xFF)) {
                    minDistanceSqr = 0.0;
                    nearestColor = k;
                    this.inverseMap[i] = (byte)k;
                    break;
                }
                double dSqr = MedianCut.getDistanceSqr(rLUT[k] & 0xFF, gLUT[k] & 0xFF, bLUT[k] & 0xFF, rBin, gBin, bBin);
                if (!(dSqr < minDistanceSqr)) continue;
                minDistanceSqr = dSqr;
                nearestColor = k;
            }
            distanceSqr[i] = minDistanceSqr;
            if (nearestColor == (this.inverseMap[i] & 0xFF)) continue;
            changes = true;
            colorChanged[nearestColor] = true;
            colorChanged[this.inverseMap[i] & 0xFF] = true;
            this.inverseMap[i] = (byte)nearestColor;
        }
        if (changes) {
            int k;
            boolean[] unused = new boolean[ncubes];
            long[] rsum = new long[ncubes];
            long[] gsum = new long[ncubes];
            long[] bsum = new long[ncubes];
            int[] nPxl = new int[ncubes];
            for (int i = 0; i < this.hist.length; ++i) {
                int k2 = this.inverseMap[i] & 0xFF;
                if (!colorChanged[k2]) continue;
                int n = k2;
                rsum[n] = rsum[n] + ((long)(this.red(i) * this.hist[i]) + this.sumOffsetR[i]);
                int n2 = k2;
                gsum[n2] = gsum[n2] + ((long)(this.green(i) * this.hist[i]) + this.sumOffsetG[i]);
                int n3 = k2;
                bsum[n3] = bsum[n3] + ((long)(this.blue(i) * this.hist[i]) + this.sumOffsetB[i]);
                int n4 = k2;
                nPxl[n4] = nPxl[n4] + this.hist[i];
            }
            for (k = 0; k <= ncubes - 1; ++k) {
                if (!colorChanged[k]) continue;
                if (nPxl[k] > 0) {
                    int r = (int)Math.round((double)rsum[k] / (double)nPxl[k]);
                    int g = (int)Math.round((double)gsum[k] / (double)nPxl[k]);
                    int b = (int)Math.round((double)bsum[k] / (double)nPxl[k]);
                    rLUT[k] = (byte)r;
                    gLUT[k] = (byte)g;
                    bLUT[k] = (byte)b;
                    continue;
                }
                unused[k] = true;
            }
            for (k = 0; k <= ncubes - 1; ++k) {
                if (!unused[k]) continue;
                double worst = 0.0;
                int iOfWorst = -1;
                for (int i = 0; i < this.hist.length; ++i) {
                    double badness = distanceSqr[i] * (double)this.hist[i];
                    if (!(badness > worst)) continue;
                    worst = badness;
                    iOfWorst = i;
                }
                this.setColorToBinCentroid(iOfWorst, rLUT, gLUT, bLUT, k);
                this.inverseMap[iOfWorst] = (byte)k;
            }
        }
        return changes;
    }

    void setColorToBinCentroid(int histIndex, byte[] rLUT, byte[] gLUT, byte[] bLUT, int lutIndex) {
        rLUT[lutIndex] = (byte)Math.round((double)this.red(histIndex) + (double)this.sumOffsetR[histIndex] * (1.0 / (double)this.hist[histIndex]));
        gLUT[lutIndex] = (byte)Math.round((double)this.green(histIndex) + (double)this.sumOffsetG[histIndex] * (1.0 / (double)this.hist[histIndex]));
        bLUT[lutIndex] = (byte)Math.round((double)this.blue(histIndex) + (double)this.sumOffsetB[histIndex] * (1.0 / (double)this.hist[histIndex]));
    }

    static double getDistanceSqr(double r1, double g1, double b1, double r2, double g2, double b2) {
        return (r2 - r1) * (r2 - r1) + (g2 - g1) * (g2 - g1) + (b2 - b1) * (b2 - b1);
    }

    void reorderColors(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    a[i] = r << 10 | c >> 5;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 5 & 0x1F;
                    int b = c >> 10;
                    a[i] = g << 10 | b << 5 | r;
                }
                break;
            }
        }
    }

    void restoreColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c >> 10;
                    a[i] = (c & 0x3FF) << 5 | r;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 10;
                    int b = c >> 5 & 0x1F;
                    a[i] = b << 10 | g << 5 | r;
                }
                break;
            }
        }
    }

    void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int t = a[lo];
                a[lo] = a[hi];
                a[hi] = t;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    ImageProcessor makeImage() {
        IJ.showStatus("Creating 8-bit image");
        byte[] pixels8 = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int color16 = MedianCut.bgr15(this.pixels32[i]);
            pixels8[i] = this.inverseMap[color16];
        }
        ByteProcessor ip = new ByteProcessor(this.width, this.height, pixels8, this.cm);
        IJ.showProgress(1.0);
        return ip;
    }
}

