/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Vector4d;

class ModelClipRetained
extends LeafRetained {
    static final int PLANE_CHANGED = 1;
    static final int PLANES_CHANGED = 2;
    static final int ENABLE_CHANGED = 4;
    static final int ENABLES_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int BOUNDINGLEAF_CHANGED = 32;
    static final int SCOPE_CHANGED = 64;
    static final int INIT_MIRROR = 128;
    static final int CLEAR_MIRROR = 256;
    static final int LAST_DEFINED_BIT = 256;
    Vector4d[] planes = new Vector4d[6];
    boolean[] enables = new boolean[6];
    Vector4d[] xformPlanes = new Vector4d[6];
    boolean enableFlag = false;
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds region = null;
    Vector<GroupRetained> scopes = new Vector();
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    boolean inImmCtx = false;
    ModelClipRetained mirrorModelClip = null;
    ModelClipRetained sgModelClip = null;
    static final int targetThreads = 4224;
    UnorderList environmentSets = new UnorderList(1, EnvironmentSet.class);
    boolean isViewScoped = false;

    ModelClipRetained() {
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        for (int i = 0; i < 6; ++i) {
            this.xformPlanes[i] = new Vector4d(this.planes[i]);
        }
        this.enables[5] = true;
        this.enables[4] = true;
        this.enables[3] = true;
        this.enables[2] = true;
        this.enables[1] = true;
        this.enables[0] = true;
    }

    void initPlanes(Vector4d[] planes) {
        if (this.staticTransform != null) {
            Transform3D xform = this.staticTransform.getNormalTransform();
            for (int i = 0; i < 6; ++i) {
                this.planes[i].set(planes[i]);
                xform.transform(this.planes[i], this.xformPlanes[i]);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.planes[i].set(planes[i]);
                this.xformPlanes[i].set(this.planes[i]);
            }
        }
    }

    void setPlanes(Vector4d[] planes) {
        Vector4d[] pl = new Vector4d[6];
        this.initPlanes(planes);
        for (int i = 0; i < 6; ++i) {
            pl[i] = new Vector4d(this.xformPlanes[i]);
        }
        this.sendMessage(2, pl, null);
    }

    void initPlane(int planeNum, Vector4d plane) {
        if (planeNum < 0 || planeNum > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        if (this.staticTransform != null) {
            Transform3D xform = this.staticTransform.getNormalTransform();
            this.planes[planeNum].set(plane);
            xform.transform(this.planes[planeNum], this.xformPlanes[planeNum]);
        } else {
            this.planes[planeNum].set(plane);
            this.xformPlanes[planeNum].set(plane);
        }
    }

    void setPlane(int planeNum, Vector4d plane) {
        this.initPlane(planeNum, plane);
        this.sendMessage(1, new Integer(planeNum), new Vector4d(this.xformPlanes[planeNum]));
    }

    void getPlanes(Vector4d[] planes) {
        for (int i = 0; i < 6; ++i) {
            planes[i].set(this.planes[i]);
        }
    }

    void getPlane(int planeNum, Vector4d plane) {
        if (planeNum < 0 || planeNum > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        plane.set(this.planes[planeNum]);
    }

    void initEnables(boolean[] enables) {
        this.enables[0] = enables[0];
        this.enables[1] = enables[1];
        this.enables[2] = enables[2];
        this.enables[3] = enables[3];
        this.enables[4] = enables[4];
        this.enables[5] = enables[5];
    }

    void setEnables(boolean[] enables) {
        Boolean[] en = new Boolean[6];
        this.initEnables(enables);
        en[0] = enables[0] ? Boolean.TRUE : Boolean.FALSE;
        en[1] = enables[1] ? Boolean.TRUE : Boolean.FALSE;
        en[2] = enables[2] ? Boolean.TRUE : Boolean.FALSE;
        en[3] = enables[3] ? Boolean.TRUE : Boolean.FALSE;
        en[4] = enables[4] ? Boolean.TRUE : Boolean.FALSE;
        en[5] = enables[5] ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(8, en, null);
    }

    void initEnable(int planeNum, boolean enable) {
        if (planeNum < 0 || planeNum > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        this.enables[planeNum] = enable;
    }

    void setEnable(int planeNum, boolean enable) {
        this.initEnable(planeNum, enable);
        this.sendMessage(4, new Integer(planeNum), enable ? Boolean.TRUE : Boolean.FALSE);
    }

    void getEnables(boolean[] enables) {
        enables[0] = this.enables[0];
        enables[1] = this.enables[1];
        enables[2] = this.enables[2];
        enables[3] = this.enables[3];
        enables[4] = this.enables[4];
        enables[5] = this.enables[5];
    }

    boolean getEnable(int planeNum) {
        if (planeNum < 0 || planeNum > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        return this.enables[planeNum];
    }

    void initInfluencingBounds(Bounds region) {
        if (region != null) {
            this.regionOfInfluence = (Bounds)region.clone();
            if (this.staticTransform != null) {
                this.regionOfInfluence.transform(this.staticTransform.transform);
            }
        } else {
            this.regionOfInfluence = null;
        }
    }

    void setInfluencingBounds(Bounds region) {
        this.initInfluencingBounds(region);
        this.sendMessage(16, region != null ? (Bounds)region.clone() : null, null);
    }

    Bounds getInfluencingBounds() {
        Bounds b = null;
        if (this.regionOfInfluence != null) {
            b = (Bounds)this.regionOfInfluence.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b.transform(invTransform);
            }
        }
        return b;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf region) {
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorModelClip);
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorModelClip);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(32, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null, null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void initScope(Group scope, int index) {
        this.scopes.setElementAt((GroupRetained)scope.retained, index);
    }

    void setScope(Group scope, int index) {
        ArrayList addScopeList = new ArrayList();
        ArrayList removeScopeList = new ArrayList();
        Object[] scopeInfo = new Object[3];
        GroupRetained group = this.scopes.get(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedModelClip(this.mirrorModelClip, removeScopeList, this.tempKey);
        group = (GroupRetained)scope.retained;
        this.initScope(scope, index);
        this.tempKey.reset();
        group.addAllNodesForScopedModelClip(this.mirrorModelClip, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, scopeInfo, null);
    }

    void initInsertScope(Node scope, int index) {
        GroupRetained group = (GroupRetained)scope.retained;
        group.setMclipScope();
        this.scopes.insertElementAt((GroupRetained)scope.retained, index);
    }

    void insertScope(Node scope, int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        this.initInsertScope(scope, index);
        GroupRetained group = (GroupRetained)scope.retained;
        this.tempKey.reset();
        group.addAllNodesForScopedModelClip(this.mirrorModelClip, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, scopeInfo, null);
    }

    void initRemoveScope(int index) {
        GroupRetained group = this.scopes.elementAt(index);
        group.removeMclipScope();
        this.scopes.removeElementAt(index);
    }

    void removeScope(int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        GroupRetained group = this.scopes.elementAt(index);
        this.initRemoveScope(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedModelClip(this.mirrorModelClip, removeScopeList, this.tempKey);
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, scopeInfo, null);
    }

    void removeScope(Group node) {
        int ind = this.indexOfScope(node);
        if (ind >= 0) {
            this.removeScope(ind);
        }
    }

    void initRemoveScope(Group node) {
        int ind = this.indexOfScope(node);
        if (ind >= 0) {
            this.initRemoveScope(ind);
        }
    }

    void removeAllScopes() {
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        int n = this.scopes.size();
        for (int index = n - 1; index >= 0; --index) {
            GroupRetained group = this.scopes.elementAt(index);
            this.initRemoveScope(index);
            this.tempKey.reset();
            group.removeAllNodesForScopedModelClip(this.mirrorModelClip, removeScopeList, this.tempKey);
        }
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = Boolean.FALSE;
        this.sendMessage(64, scopeInfo, null);
    }

    void initRemoveAllScopes() {
        int n = this.scopes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.initRemoveScope(i);
        }
    }

    Group getScope(int index) {
        return (Group)this.scopes.elementAt((int)index).source;
    }

    Iterator<Group> getAllScopes() {
        Iterator<GroupRetained> elm = this.scopes.iterator();
        Vector<Group> v = new Vector<Group>(this.scopes.size());
        while (elm.hasNext()) {
            v.add((Group)elm.next().source);
        }
        return v.iterator();
    }

    void initAddScope(Group scope) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.addElement((GroupRetained)scope.retained);
        group.setMclipScope();
    }

    void addScope(Group scope) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        GroupRetained group = (GroupRetained)scope.retained;
        this.initAddScope(scope);
        this.tempKey.reset();
        group.addAllNodesForScopedModelClip(this.mirrorModelClip, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, scopeInfo, null);
    }

    int numScopes() {
        return this.scopes.size();
    }

    int indexOfScope(Group node) {
        if (node != null) {
            return this.scopes.indexOf(node.retained);
        }
        return this.scopes.indexOf(null);
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void update(Canvas3D cv, int enableMask) {
        cv.setModelViewMatrix(cv.ctx, cv.vworldToEc.mat, this.getLastLocalToVworld());
        this.update(cv.ctx, enableMask, this.getLastLocalToVworld());
    }

    void update(Context ctx, int enableMask, Transform3D trans) {
        for (int i = 0; i < 6; ++i) {
            Vector4d v = this.xformPlanes[i];
            boolean enable = (enableMask & 1 << i) != 0;
            Pipeline.getPipeline().updateModelClip(ctx, i, enable, v.x, v.y, v.z, v.w);
        }
    }

    void initMirrorObject(Object[] args) {
        Object[] scopeInfo = (Object[])args[2];
        Boolean scoped = (Boolean)scopeInfo[0];
        ArrayList shapeList = (ArrayList)scopeInfo[1];
        BoundingLeafRetained bl = (BoundingLeafRetained)((Object[])args[4])[0];
        Bounds bnds = (Bounds)((Object[])args[4])[1];
        for (int i = 0; i < shapeList.size(); ++i) {
            Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i)).source;
            shape.addModelClip(this.mirrorModelClip);
        }
        this.mirrorModelClip.isScoped = scoped;
        if (bl != null) {
            this.mirrorModelClip.boundingLeaf = bl.mirrorBoundingLeaf;
            this.mirrorModelClip.region = this.boundingLeaf.transformedRegion;
        } else {
            this.mirrorModelClip.boundingLeaf = null;
            this.mirrorModelClip.region = null;
        }
        if (bnds != null) {
            this.mirrorModelClip.regionOfInfluence = bnds;
            if (this.mirrorModelClip.region == null) {
                this.mirrorModelClip.region = (Bounds)this.regionOfInfluence.clone();
                this.mirrorModelClip.region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
            }
        } else {
            this.mirrorModelClip.regionOfInfluence = null;
        }
        boolean[] ens = (boolean[])((Object[])args[4])[2];
        for (int i = 0; i < ens.length; ++i) {
            this.mirrorModelClip.enables[i] = ens[i];
        }
        this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        block3: {
            int component;
            block4: {
                block2: {
                    component = (Integer)objs[1];
                    if ((component & 2) == 0) break block2;
                    Vector4d[] pl = (Vector4d[])objs[2];
                    for (int i = 0; i < 6; ++i) {
                        this.mirrorModelClip.xformPlanes[i].set(pl[i]);
                    }
                    break block3;
                }
                if ((component & 1) == 0) break block4;
                int planeNum = (Integer)objs[2];
                this.mirrorModelClip.xformPlanes[planeNum].set((Vector4d)objs[3]);
                break block3;
            }
            if ((component & 0x80) == 0) break block3;
            Vector4d[] pl = (Vector4d[])objs[3];
            for (int i = 0; i < 6; ++i) {
                this.mirrorModelClip.xformPlanes[i].set(pl[i]);
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 0x20) != 0) {
            this.mirrorModelClip.boundingLeaf = (BoundingLeafRetained)objs[2];
            if (objs[2] != null) {
                this.mirrorModelClip.region = this.mirrorModelClip.boundingLeaf.transformedRegion;
            } else if (this.mirrorModelClip.regionOfInfluence != null) {
                this.mirrorModelClip.region = this.mirrorModelClip.regionOfInfluence.copy(this.mirrorModelClip.region);
                this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.getCurrentLocalToVworld());
            } else {
                this.mirrorModelClip.region = null;
            }
        }
        if ((component & 0x10) != 0) {
            this.mirrorModelClip.regionOfInfluence = (Bounds)objs[2];
            if (this.mirrorModelClip.boundingLeaf == null) {
                if (objs[2] != null) {
                    this.mirrorModelClip.region = this.mirrorModelClip.regionOfInfluence.copy(this.mirrorModelClip.region);
                    this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.getCurrentLocalToVworld());
                } else {
                    this.mirrorModelClip.region = null;
                }
            }
        }
        if ((component & 0x40) != 0) {
            Shape3DRetained obj;
            int i;
            Object[] scopeList = (Object[])objs[2];
            ArrayList addList = (ArrayList)scopeList[0];
            ArrayList removeList = (ArrayList)scopeList[1];
            boolean isScoped = (Boolean)scopeList[2];
            if (addList != null) {
                this.mirrorModelClip.isScoped = isScoped;
                for (i = 0; i < addList.size(); ++i) {
                    obj = ((GeometryAtom)addList.get((int)i)).source;
                    obj.addModelClip(this.mirrorModelClip);
                }
            }
            if (removeList != null) {
                this.mirrorModelClip.isScoped = isScoped;
                for (i = 0; i < removeList.size(); ++i) {
                    obj = ((GeometryAtom)removeList.get((int)i)).source;
                    obj.removeModelClip(this.mirrorModelClip);
                }
            }
        }
        if ((component & 8) != 0) {
            Boolean[] en = (Boolean[])objs[2];
            this.mirrorModelClip.enables[0] = en[0];
            this.mirrorModelClip.enables[1] = en[1];
            this.mirrorModelClip.enables[2] = en[2];
            this.mirrorModelClip.enables[3] = en[3];
            this.mirrorModelClip.enables[4] = en[4];
            this.mirrorModelClip.enables[5] = en[5];
            this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        } else if ((component & 4) != 0) {
            int planeNum = (Integer)objs[2];
            this.mirrorModelClip.enables[planeNum] = (Boolean)objs[3];
            this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    @Override
    void setLive(SetLiveState s) {
        super.doSetLive(s);
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ModelClipRetained1"));
        }
        if (this.mirrorModelClip == null) {
            this.mirrorModelClip = (ModelClipRetained)this.clone();
            this.mirrorModelClip.boundingLeaf = null;
            this.mirrorModelClip.sgModelClip = this;
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this.mirrorModelClip);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this.mirrorModelClip);
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorModelClip);
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorModelClip, 1);
        }
        this.mirrorModelClip.switchState = s.switchStates.get(0);
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorModelClip, 1);
            s.notifyThreads |= 0x2000;
        }
        s.notifyThreads |= 0x1080;
        super.markAsLive();
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4096;
        createMessage.universe = this.universe;
        createMessage.type = 36;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(128);
        ArrayList addScopeList = new ArrayList();
        for (int i = 0; i < this.scopes.size(); ++i) {
            GroupRetained group = this.scopes.get(i);
            this.tempKey.reset();
            group.addAllNodesForScopedModelClip(this.mirrorModelClip, addScopeList, this.tempKey);
        }
        Object[] scopeInfo = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, addScopeList};
        createMessage.args[2] = scopeInfo;
        createMessage.args[3] = this.xformPlanes.clone();
        Object[] obj = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null, this.enables.clone()};
        createMessage.args[4] = obj;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        s.notifyThreads |= 0x1080;
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this.mirrorModelClip, 1);
        }
        if (this.mirrorModelClip.boundingLeaf != null) {
            this.mirrorModelClip.boundingLeaf.removeUser(this.mirrorModelClip);
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this.mirrorModelClip);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this.mirrorModelClip);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this.mirrorModelClip, 1);
            s.notifyThreads |= 0x2000;
        }
        if (this.scopes.size() > 0) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4096;
            createMessage.universe = this.universe;
            createMessage.type = 36;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(256);
            ArrayList removeScopeList = new ArrayList();
            for (int i = 0; i < this.scopes.size(); ++i) {
                GroupRetained group = this.scopes.get(i);
                this.tempKey.reset();
                group.removeAllNodesForScopedModelClip(this.mirrorModelClip, removeScopeList, this.tempKey);
            }
            createMessage.args[2] = removeScopeList;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    void clearMirrorObject(Object[] args) {
        ArrayList shapeList = (ArrayList)args[2];
        for (int i = 0; i < shapeList.size(); ++i) {
            Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i)).source;
            shape.removeModelClip(this.mirrorModelClip);
        }
        this.mirrorModelClip.isScoped = false;
    }

    @Override
    protected Object clone() {
        ModelClipRetained mc = (ModelClipRetained)super.clone();
        mc.planes = new Vector4d[6];
        for (int i = 0; i < 6; ++i) {
            mc.planes[i] = new Vector4d(this.planes[i]);
            mc.xformPlanes[i] = new Vector4d(this.xformPlanes[i]);
        }
        mc.enables = new boolean[6];
        this.getEnables(mc.enables);
        mc.enableFlag = mc.enables[0] | mc.enables[1] | mc.enables[2] | mc.enables[3] | mc.enables[4] | mc.enables[5];
        mc.inImmCtx = false;
        mc.region = null;
        mc.sgModelClip = null;
        mc.mirrorModelClip = null;
        mc.environmentSets = new UnorderList(1, EnvironmentSet.class);
        if (this.regionOfInfluence != null) {
            mc.regionOfInfluence = (Bounds)this.regionOfInfluence.clone();
        }
        return mc;
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.sgModelClip.getCurrentLocalToVworld());
        }
    }

    void printPlane(int index, String string) {
        System.err.println(string + " : < " + this.planes[index].toString() + " > " + this.enables[index]);
    }

    void printPlanes(String string, Vector4d[] planes) {
        System.err.println(string);
        this.printPlane(0, "[0]");
        this.printPlane(1, "[1]");
        this.printPlane(2, "[2]");
        this.printPlane(3, "[3]");
        this.printPlane(4, "[4]");
        this.printPlane(5, "[5]");
    }

    void printEnables(String string, boolean[] enables) {
        System.err.println(string);
        System.err.println("[0] : < " + enables[0] + " >");
        System.err.println("[1] : < " + enables[1] + " >");
        System.err.println("[2] : < " + enables[2] + " >");
        System.err.println("[3] : < " + enables[3] + " >");
        System.err.println("[4] : < " + enables[4] + " >");
        System.err.println("[5] : < " + enables[5] + " >");
    }

    final void sendMessage(int attrMask, Object attr1, Object attr2) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 36;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr1;
        createMessage.args[3] = attr2;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained staticTransform) {
        super.mergeTransform(staticTransform);
        if (this.regionOfInfluence != null) {
            this.regionOfInfluence.transform(staticTransform.transform);
        }
        Transform3D xform = staticTransform.getNormalTransform();
        for (int i = 0; i < 6; ++i) {
            xform.transform(this.planes[i], this.xformPlanes[i]);
        }
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        leafList.add(this.mirrorModelClip);
    }
}

