/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.TriangleFanArrayRetained;

public class TriangleFanArray
extends GeometryStripArray {
    TriangleFanArray() {
    }

    public TriangleFanArray(int vertexCount, int vertexFormat, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, stripVertexCounts);
        if (vertexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArray0"));
        }
    }

    public TriangleFanArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, stripVertexCounts);
        if (vertexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArray0"));
        }
    }

    public TriangleFanArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, stripVertexCounts);
        if (vertexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new TriangleFanArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        TriangleFanArrayRetained rt = (TriangleFanArrayRetained)this.retained;
        int[] stripcounts = new int[rt.getNumStrips()];
        rt.getStripVertexCounts(stripcounts);
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        TriangleFanArray t = new TriangleFanArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, stripcounts);
        t.duplicateNodeComponent(this);
        return t;
    }
}

