/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Despeckle_
implements PlugInFilter {
    public static String ACCURATE = "Accurate";
    public static String FAST = "Fast";
    private ImagePlus image;
    private byte[] currentSlide;
    private int w;
    private int h;
    private int k_diameter;
    private String mode = ACCURATE;
    private int FG = 0;
    private int BG = 255;

    public void run(ImageProcessor ip) {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        GenericDialog gd = new GenericDialog("Despeckle");
        gd.addNumericField("Radius of largest particles to remove", 5.0, 0);
        gd.addNumericField("Foreground color", 0.0, 0);
        gd.addNumericField("Background color", 255.0, 0);
        gd.addChoice("Mode", new String[]{ACCURATE, FAST}, FAST);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.k_diameter = (int)gd.getNextNumber() + 2;
        this.FG = (int)gd.getNextNumber();
        this.BG = (int)gd.getNextNumber();
        if (this.FG < 0 || this.FG > 255 || this.BG < 0 || this.BG > 255) {
            IJ.showMessage((String)"Wrong color range");
        }
        this.despeckle();
        this.image.updateAndDraw();
    }

    public void despeckle() {
        for (int i = 0; i < this.image.getStackSize(); ++i) {
            this.currentSlide = (byte[])this.image.getStack().getProcessor(i + 1).getPixels();
            this.despeckleSlide();
        }
    }

    private void despeckleSlide() {
        for (int y = -1; y < this.h - this.k_diameter + 1; ++y) {
            for (int x = -1; x < this.w - this.k_diameter + 1; ++x) {
                this.handlePosition(x, y);
            }
        }
    }

    private void handlePosition(int x, int y) {
        if (this.isIsland(x, y)) {
            this.removeIsland(x, y);
        }
    }

    private boolean isIsland(int x, int y) {
        int i;
        for (i = 0; i < this.k_diameter; ++i) {
            if (this.get(x + i, y) != (byte)this.FG && this.get(x + i, y + this.k_diameter) != (byte)this.FG) continue;
            return false;
        }
        for (i = 1; i < this.k_diameter - 1; ++i) {
            if (this.get(x, y + i) != (byte)this.FG && this.get(x + this.k_diameter, y + i) != (byte)this.FG) continue;
            return false;
        }
        return true;
    }

    private void removeIsland(int x, int y) {
        for (int i = 1; i < this.k_diameter - 1; ++i) {
            int yPos = y + i;
            for (int j = 1; j < this.k_diameter - 1; ++j) {
                int xPos = x + j;
                this.currentSlide[yPos * this.w + xPos] = (byte)this.BG;
            }
        }
    }

    private byte get(int x, int y) {
        return x < this.w && x >= 0 && y >= 0 && y < this.h ? this.currentSlide[y * this.w + x] : (byte)this.BG;
    }

    public int setup(String arg, ImagePlus img) {
        this.image = img;
        return 1;
    }
}

