/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vib.Average_Images;

public class Average_Torsten_Results
implements PlugIn {
    public static ImagePlus averageFromDirectoryList(ArrayList<File> entries) {
        ClassLoader loader = IJ.getClassLoader();
        if (loader == null) {
            IJ.error((String)"IJ.getClassLoader() failed (!)");
            return null;
        }
        Average_Images averager = new Average_Images();
        Iterator<File> i = entries.iterator();
        while (i.hasNext()) {
            File rawImageFile = new File(i.next(), "image.bin.gz");
            ImagePlus imagePlus = null;
            try {
                Class<?> c = loader.loadClass("io.TorstenRaw_GZ_Reader");
                Object newInstance = c.newInstance();
                Class[] parameterTypes = new Class[]{String.class};
                Object[] parameters = new Object[]{rawImageFile.getAbsolutePath()};
                Method m = c.getMethod("run", parameterTypes);
                m.invoke(newInstance, parameters);
                imagePlus = (ImagePlus)newInstance;
            }
            catch (IllegalArgumentException e) {
                IJ.error((String)("There was an illegal argument when trying to invoke a method on the TorstenRaw GZ Reader plugin: " + e));
                return null;
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                IJ.error((String)("There was an exception thrown by the TorstenRaw GZ Reader plugin: " + realException));
                return null;
            }
            catch (ClassNotFoundException e) {
                IJ.error((String)("The TorstenRaw GZ Reader plugin was not found: " + e));
                return null;
            }
            catch (InstantiationException e) {
                IJ.error((String)("Failed to instantiate the TorstenRaw GZ Reader plugin: " + e));
                return null;
            }
            catch (IllegalAccessException e) {
                IJ.error((String)("IllegalAccessException when trying the TorstenRaw GZ Reader plugin: " + e));
                return null;
            }
            catch (NoSuchMethodException e) {
                IJ.error((String)("Couldn't find a method in the TorstenRaw GZ Reader plugin: " + e));
                return null;
            }
            catch (SecurityException e) {
                IJ.error((String)("There was a SecurityException when trying to invoke a method of the TorstenRaw GZ Reader plugin: " + e));
            }
            averager.add(imagePlus);
            imagePlus.close();
        }
        return averager.getAverageImage(false);
    }

    public void run(String arg) {
        File resultsRoot = new File("/Volumes/LaCie/corpus/central-complex/biorad/reformatted");
        Pattern includeDirectoryPattern = Pattern.compile("01_warp");
        Pattern excludeDirectoryPattern = Pattern.compile("\\.study$");
        ArrayList<File> directoriesToAverageFrom = new ArrayList<File>();
        File[] entries = resultsRoot.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            Matcher excludeM;
            File entry = entries[i];
            Matcher includeM = includeDirectoryPattern.matcher(entry.getName());
            if (!includeM.find() || (excludeM = excludeDirectoryPattern.matcher(entry.getName())).find()) continue;
            System.out.println("Using: " + entry);
            directoriesToAverageFrom.add(entry);
        }
        ImagePlus result = Average_Torsten_Results.averageFromDirectoryList(directoriesToAverageFrom);
        if (result != null) {
            result.show();
        }
    }
}

